/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.organizer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.services.common.clipboard.IClipboardService;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.action.AbstractAction;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenuSeparator;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractAlphanumericSortingStringColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractIntegerColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.INumberColumn;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ICustomColumn;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ITableCustomizer;
import org.eclipse.scout.rt.client.ui.basic.table.organizer.IOrganizeColumnsForm;
import org.eclipse.scout.rt.client.ui.dnd.JavaTransferObject;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractLinkButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBoxBodyGrid;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.HorizontalGroupBoxBodyGrid;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxes;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.PlatformExceptionTranslator;
import org.eclipse.scout.rt.platform.html.HTML;
import org.eclipse.scout.rt.platform.html.HtmlHelper;
import org.eclipse.scout.rt.platform.html.IHtmlElement;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="5bd26d3c-604d-4991-a246-7fff74e32faa")
public class OrganizeColumnsForm
extends AbstractForm
implements IOrganizeColumnsForm {
    private static final Logger LOG = LoggerFactory.getLogger(OrganizeColumnsForm.class);
    private static final String UNICODE_ARROW_UP = "\u2191";
    private static final String UNICODE_ARROW_DOWN = "\u2193";
    private static final String VISIBLE_DIMENSION_HIERARCHICAL = "dim_hierarchical";
    private final ITable m_organizedTable;
    protected boolean m_loading;
    private PropertyChangeListener m_organizedTablePropertyListener = new P_OrganizeColumnTablePropertyListener();

    public OrganizeColumnsForm(ITable table) {
        super(false);
        this.m_organizedTable = table;
        this.callInitializer();
    }

    @Override
    protected void execInitForm() {
        this.getOrganizedTable().addPropertyChangeListener("hierarchicalRows", this.m_organizedTablePropertyListener);
    }

    @Override
    protected void execDisposeForm() {
        this.getOrganizedTable().removePropertyChangeListener("hierarchicalRows", this.m_organizedTablePropertyListener);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.getRootGroupBox().setScrollable(true);
        this.updateGroupingMenuVisibility();
    }

    @Override
    protected String getConfiguredTitle() {
        return TEXTS.get((String)"TableOrganize");
    }

    public MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField getColumnsTableField() {
        return this.getFieldByClass(MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.class);
    }

    public MainBox.GroupBox.ProfilesBox.ProfilesTableField getProfilesTableField() {
        return this.getFieldByClass(MainBox.GroupBox.ProfilesBox.ProfilesTableField.class);
    }

    public MainBox.GroupBox getGroupBox() {
        return this.getFieldByClass(MainBox.GroupBox.class);
    }

    public MainBox getMainBox() {
        return this.getFieldByClass(MainBox.class);
    }

    public MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table.GroupAdditionalMenu getGroupAdditionalMenu() {
        return ((MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getMenuByClass(MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table.GroupAdditionalMenu.class);
    }

    public MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table.GroupMenu getGroupMenu() {
        return ((MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getMenuByClass(MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table.GroupMenu.class);
    }

    public ITable getOrganizedTable() {
        return this.m_organizedTable;
    }

    protected void updateGroupingMenuVisibility() {
        boolean hierarchicalTable = this.getOrganizedTable().isHierarchical();
        this.getGroupMenu().setVisible(!hierarchicalTable, VISIBLE_DIMENSION_HIERARCHICAL);
        this.getGroupAdditionalMenu().setVisible(!hierarchicalTable, VISIBLE_DIMENSION_HIERARCHICAL);
    }

    public void updateColumnVisibilityAndOrder() {
        List visibleColumns = ((MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getKeyColumn().getValues(((MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getCheckedRows());
        this.m_organizedTable.getColumnSet().setVisibleColumns(visibleColumns);
        ClientUIPreferences.getInstance().setAllTableColumnPreferences(this.m_organizedTable);
    }

    public void setColumnVisible(ITableRow row, Boolean visible) {
        ((MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).checkRow(row, (boolean)visible);
        this.updateColumnVisibilityAndOrder();
    }

    public void moveUp(ITableRow row) {
        this.moveUp(row, row.getRowIndex() - 1);
    }

    public void moveUp(ITableRow row, int targetIndex) {
        if (row != null && targetIndex >= 0) {
            ((MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).moveRow(row.getRowIndex(), targetIndex);
        }
        this.updateColumnVisibilityAndOrder();
        this.enableDisableMenus();
    }

    public void moveDown(ITableRow row) {
        this.moveDown(row, row.getRowIndex() + 1);
    }

    public void moveDown(ITableRow row, int targetIndex) {
        if (row != null && targetIndex < ((MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getRowCount()) {
            ((MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).moveRow(row.getRowIndex(), targetIndex);
        }
        this.updateColumnVisibilityAndOrder();
        this.enableDisableMenus();
    }

    public void enableDisableMenus() {
        boolean moveUpEnabled = false;
        boolean moveDownEnabled = false;
        boolean addEnabled = false;
        boolean modifyEnabled = false;
        boolean removeEnabled = false;
        boolean removeFilterEnabled = false;
        MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table columnsTable = (MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable();
        List<ITableRow> selectedRows = columnsTable.getSelectedRows();
        addEnabled = this.isColumnAddable();
        for (ITableRow row : selectedRows) {
            IColumn selectedColumn = (IColumn)columnsTable.getKeyColumn().getValue(row);
            if (this.isColumnMovableUp(selectedColumn)) {
                moveUpEnabled = true;
            }
            if (this.isColumnMovableDown(selectedColumn)) {
                moveDownEnabled = true;
            }
            if (this.isColumnRemovable(selectedColumn)) {
                removeEnabled = true;
            }
            if (this.isColumnModifiable(selectedColumn)) {
                modifyEnabled = true;
            }
            if (!selectedColumn.isColumnFilterActive()) continue;
            removeFilterEnabled = true;
        }
        this.setEnabledAndVisible(columnsTable, MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table.MoveUpMenu.class, moveUpEnabled);
        this.setEnabledAndVisible(columnsTable, MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table.MoveDownMenu.class, moveDownEnabled);
        this.setEnabledAndVisible(columnsTable, MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table.AddColumnMenu.class, addEnabled);
        this.setEnabledAndVisible(columnsTable, MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table.AddColumnEmptySpaceMenu.class, addEnabled && columnsTable.getSelectedRows().isEmpty());
        this.setEnabledAndVisible(columnsTable, MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table.ModifyCustomColumnMenu.class, modifyEnabled);
        this.setEnabledAndVisible(columnsTable, MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table.RemoveMenu.class, removeEnabled);
        this.setEnabledAndVisible(columnsTable, MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table.RemoveFilterMenu.class, removeFilterEnabled);
    }

    private void setEnabledAndVisible(MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table columnsTable, Class<? extends IMenu> menuType, boolean enabled) {
        IMenu menu = columnsTable.getMenuByClass(menuType);
        menu.setEnabled(enabled);
        menu.setVisible(enabled);
    }

    @Override
    public void reload() {
        this.m_loading = true;
        try {
            this.getColumnsTableField().reloadTableData();
            this.getProfilesTableField().reloadTableData();
        }
        finally {
            this.m_loading = false;
        }
    }

    @Override
    public boolean isFormLoading() {
        return super.isFormLoading() || this.m_loading;
    }

    public void storeCurrentStateAsConfig(String configName) {
        ClientUIPreferences prefs = ClientUIPreferences.getInstance();
        prefs.addTableColumnsConfig(this.m_organizedTable, configName);
        prefs.setAllTableColumnPreferences(this.m_organizedTable, configName);
        if (this.m_organizedTable.isCustomizable()) {
            prefs.setTableCustomizerData(this.m_organizedTable.getTableCustomizer(), configName);
        }
    }

    public void deleteConfig(String config) {
        ClientUIPreferences prefs = ClientUIPreferences.getInstance();
        if (prefs != null) {
            prefs.removeTableColumnsConfig(this.m_organizedTable, config);
        }
    }

    public void applyAll(String configName) {
        this.applyViewForConfig(configName);
        this.m_organizedTable.getColumnSet().applySortingAndGrouping(configName);
    }

    public void applyViewForConfig(String configName) {
        ClientUIPreferences prefs = ClientUIPreferences.getInstance();
        if (this.isCustomizable()) {
            byte[] tableCustomizerData = prefs.getTableCustomizerData(this.m_organizedTable.getTableCustomizer(), configName);
            if (tableCustomizerData != null) {
                this.m_organizedTable.getTableCustomizer().removeAllColumns();
                this.m_organizedTable.getTableCustomizer().setSerializedData(tableCustomizerData);
            }
            if (this.m_organizedTable.getReloadHandler() != null) {
                this.m_organizedTable.resetColumnConfiguration();
                this.m_organizedTable.getReloadHandler().reload("organizeColumns");
            }
        }
        for (IColumn<?> col : this.m_organizedTable.getColumnSet().getColumns()) {
            col.setVisible(prefs.getTableColumnVisible(col, col.isInitialVisible(), configName));
            col.setWidth(prefs.getTableColumnWidth(col, col.getInitialWidth(), configName));
            col.setVisibleColumnIndexHint(prefs.getTableColumnViewIndex(col, col.getInitialSortIndex(), configName));
            if (!(col instanceof INumberColumn)) continue;
            ((INumberColumn)col).setBackgroundEffect(prefs.getTableColumnBackgroundEffect(col, ((INumberColumn)col).getInitialBackgroundEffect(), configName));
        }
    }

    public void resetAll() {
        this.m_organizedTable.reset(false);
        this.getColumnsTableField().reloadTableData();
    }

    public void resetView() {
        try {
            this.m_organizedTable.setTableChanging(true);
            this.m_organizedTable.resetColumnVisibilities();
            this.m_organizedTable.resetColumnWidths();
            this.m_organizedTable.resetColumnOrder();
            ITableCustomizer cst = this.m_organizedTable.getTableCustomizer();
            if (cst != null) {
                cst.removeAllColumns();
            }
        }
        finally {
            this.m_organizedTable.setTableChanging(false);
        }
        this.getColumnsTableField().reloadTableData();
    }

    protected boolean isColumnMovableUp(IColumn<?> column) {
        if (column.isFixedPosition()) {
            return false;
        }
        List<IColumn<?>> visibleColumns = column.getTable().getColumnSet().getVisibleColumns();
        int index = visibleColumns.indexOf(column);
        if (index - 1 < 0) {
            return false;
        }
        return !visibleColumns.get(index - 1).isFixedPosition();
    }

    protected boolean isColumnMovableDown(IColumn<?> column) {
        if (column.isFixedPosition()) {
            return false;
        }
        List<IColumn<?>> visibleColumns = column.getTable().getColumnSet().getVisibleColumns();
        int index = visibleColumns.indexOf(column);
        if (index + 1 >= visibleColumns.size()) {
            return false;
        }
        return !visibleColumns.get(index + 1).isFixedPosition();
    }

    protected boolean isColumnAddable() {
        return this.isCustomizable();
    }

    protected boolean isColumnRemovable(IColumn<?> column) {
        return this.isCustomizable() && column instanceof ICustomColumn;
    }

    protected boolean isColumnModifiable(IColumn<?> column) {
        return column.isModifiable();
    }

    protected void execAddColumnAction() {
        if (this.isCustomizable()) {
            List<String> existingColumns = this.getVisibleColumnIds();
            this.m_organizedTable.getTableCustomizer().addColumn(null);
            ((MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).moveNewColumnsAfterSelection(existingColumns);
        }
    }

    protected void execRemoveColumnAction() {
        if (this.isCustomizable()) {
            MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table columnsTable = (MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable();
            for (ITableRow selectedRow : columnsTable.getSelectedRows()) {
                IColumn selectedColumn = (IColumn)columnsTable.getKeyColumn().getValue(selectedRow);
                if (!(selectedColumn instanceof ICustomColumn)) continue;
                this.m_organizedTable.getTableCustomizer().removeColumn((ICustomColumn)selectedColumn);
            }
            this.getColumnsTableField().reloadTableData();
        }
    }

    protected boolean acceptColumnForColumnsTable(IColumn<?> column) {
        return column.isDisplayable() && (column.isVisible() || column.isVisibleGranted());
    }

    protected List<ITableRow> createColumnsTableRows(MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table columnsTable) {
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        for (IColumn<?> col : this.m_organizedTable.getColumnSet().getAllColumnsInUserOrder()) {
            if (!this.acceptColumnForColumnsTable(col)) continue;
            IHeaderCell headerCell = col.getHeaderCell();
            TableRow row = new TableRow(columnsTable.getColumnSet());
            columnsTable.getKeyColumn().setValue(row, col);
            String columnTitle = headerCell.getText();
            if (StringUtility.isNullOrEmpty((CharSequence)columnTitle)) {
                columnTitle = headerCell.getTooltipText();
                row.setFont(FontSpec.parse((String)"ITALIC"));
            } else if (headerCell.isHtmlEnabled()) {
                columnTitle = ((HtmlHelper)BEANS.get(HtmlHelper.class)).toPlainText(columnTitle);
            }
            columnsTable.getTitleColumn().setValue(row, columnTitle);
            ArrayList<IHtmlElement> cellContents = new ArrayList<IHtmlElement>();
            if (col.isSortActive()) {
                cellContents.add(HTML.span((CharSequence[])new CharSequence[]{col.isSortAscending() ? UNICODE_ARROW_UP : UNICODE_ARROW_DOWN}).cssClass((CharSequence)"sort-symbol"));
                cellContents.add(HTML.span((CharSequence[])new CharSequence[]{String.valueOf(col.getSortIndex() + 1)}).cssClass((CharSequence)"sort-number"));
            }
            if (col.isGroupingActive()) {
                cellContents.add(HTML.span((CharSequence[])new CharSequence[]{TEXTS.get((String)"GroupingAbbreviation")}).cssClass((CharSequence)"group-symbol"));
            }
            if (cellContents.size() > 0) {
                columnsTable.getGroupAndSortColumn().setValue(row, HTML.fragment(cellContents).toHtml());
            }
            if (col instanceof ICustomColumn) {
                columnsTable.getCustomColumnColumn().setValue(row, TEXTS.get((String)"CustomColumAbbreviation"));
            }
            if (col.isColumnFilterActive()) {
                columnsTable.getFilterColumn().setValue(row, TEXTS.get((String)"FilterAbbreviation"));
            }
            columnsTable.getWidthColumn().setValue(row, Integer.valueOf(col.getWidth()));
            rowList.add(row);
        }
        return rowList;
    }

    protected List<String> getVisibleColumnIds() {
        List<IColumn<?>> visibleColumns = this.m_organizedTable.getColumnSet().getVisibleColumns();
        ArrayList<String> columnIds = new ArrayList<String>(visibleColumns.size());
        for (IColumn<?> column : visibleColumns) {
            columnIds.add(column.getColumnId());
        }
        return columnIds;
    }

    private boolean isCustomizable() {
        return this.m_organizedTable.isCustomizable();
    }

    public static enum ConfigType {
        DEFAULT,
        CUSTOM;

    }

    @Order(value=10.0)
    @ClassId(value="d9f2e54a-cb41-4453-8ce9-ba41b8e247bd")
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredWidthInPixel() {
            return 880;
        }

        @Order(value=80.0)
        @ClassId(value="d25a64d4-25f8-40aa-bf51-2705a5aa6bc2")
        public class CopyWidthsOfColumnsButton
        extends AbstractLinkButton {
            public static final String COLUMN_COPY_CLIPBOARD_IDENTIFIER = "dev.table.menu.column.width.copy.ident";

            @Override
            protected String getConfiguredLabel() {
                return "Dev: " + TEXTS.get((String)"CopyWidthsOfColumnsMenu");
            }

            @Override
            protected boolean getConfiguredProcessButton() {
                return false;
            }

            @Override
            protected void execInitField() {
                this.setVisibleGranted(Platform.get().inDevelopmentMode());
            }

            @Override
            protected void execClickAction() {
                try {
                    StringBuilder sb = new StringBuilder();
                    sb.append(COLUMN_COPY_CLIPBOARD_IDENTIFIER);
                    sb.append("\n");
                    for (IColumn<?> column : OrganizeColumnsForm.this.m_organizedTable.getColumnSet().getVisibleColumns()) {
                        sb.append(column.getClass().getName());
                        sb.append("\t");
                        sb.append(column.getWidth());
                        sb.append("\n");
                    }
                    IClipboardService svc = (IClipboardService)BEANS.opt(IClipboardService.class);
                    if (svc == null) {
                        LOG.info(sb.toString());
                        MessageBoxes.createOk().withBody(TEXTS.get((String)"SeeLogFileForColumnWidthsOutput")).show();
                    } else {
                        svc.setTextContents(sb.toString());
                    }
                }
                catch (RuntimeException e) {
                    throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e).withContextInfo("button", (Object)this.getLabel(), new Object[0]);
                }
            }
        }

        @Order(value=10.0)
        @ClassId(value="abaf2e0c-1c14-4b99-81dc-8b83453f5766")
        public class GroupBox
        extends AbstractGroupBox {
            @Override
            protected Class<? extends IGroupBoxBodyGrid> getConfiguredBodyGrid() {
                return HorizontalGroupBoxBodyGrid.class;
            }

            @Override
            protected int getConfiguredGridColumnCount() {
                return 5;
            }

            @Order(value=10.0)
            @ClassId(value="952e2572-c7ed-400f-a8d0-a6b445bc1e41")
            public class ColumnsGroupBox
            extends AbstractGroupBox {
                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"Columns");
                }

                @Override
                protected int getConfiguredGridW() {
                    return 3;
                }

                @Override
                protected int getConfiguredGridColumnCount() {
                    return 1;
                }

                @Override
                protected boolean getConfiguredStatusVisible() {
                    return false;
                }

                @Order(value=10.0)
                @ClassId(value="eefd05cf-b8b6-4c07-82c9-91aaafe9b8b6")
                public class ColumnsTableField
                extends AbstractTableField<Table> {
                    @Override
                    protected int getConfiguredGridH() {
                        return 6;
                    }

                    @Override
                    protected int getConfiguredGridW() {
                        return 1;
                    }

                    @Override
                    protected byte getConfiguredLabelPosition() {
                        return 4;
                    }

                    @Override
                    protected boolean getConfiguredLabelVisible() {
                        return false;
                    }

                    @Override
                    protected boolean getConfiguredStatusVisible() {
                        return false;
                    }

                    @Override
                    protected void execReloadTableData() {
                        Table columnsTable = (Table)this.getTable();
                        List<ITableRow> rowList = OrganizeColumnsForm.this.createColumnsTableRows(columnsTable);
                        try {
                            columnsTable.setTableChanging(true);
                            columnsTable.discardAllRows();
                            rowList = columnsTable.addRows(rowList);
                            for (ITableRow row : rowList) {
                                columnsTable.checkRow(row, ((IColumn)columnsTable.getKeyColumn().getValue(row)).isVisible());
                            }
                        }
                        finally {
                            columnsTable.setTableChanging(false);
                        }
                        OrganizeColumnsForm.this.enableDisableMenus();
                    }

                    @ClassId(value="76937f06-5cc2-4281-9eae-28b59d7bd770")
                    public class Table
                    extends AbstractTable {
                        @Override
                        protected int getConfiguredDropType() {
                            return 2;
                        }

                        @Override
                        protected void execDrop(ITableRow row, TransferObject transfer) {
                            ITableRow draggedRow;
                            List<ITableRow> draggedRows;
                            if (row != null && transfer instanceof JavaTransferObject && CollectionUtility.hasElements(draggedRows = ((JavaTransferObject)transfer).getLocalObjectAsList(ITableRow.class)) && (draggedRow = (ITableRow)CollectionUtility.firstElement(draggedRows)).getRowIndex() != row.getRowIndex()) {
                                try {
                                    ((Table)ColumnsTableField.this.getTable()).setTableChanging(true);
                                    if (draggedRow.getRowIndex() < row.getRowIndex()) {
                                        OrganizeColumnsForm.this.moveDown(draggedRow, row.getRowIndex());
                                    } else {
                                        OrganizeColumnsForm.this.moveUp(draggedRow, row.getRowIndex());
                                    }
                                    OrganizeColumnsForm.this.updateColumnVisibilityAndOrder();
                                }
                                finally {
                                    ((Table)ColumnsTableField.this.getTable()).setTableChanging(false);
                                }
                            }
                        }

                        @Override
                        protected boolean getConfiguredAutoResizeColumns() {
                            return true;
                        }

                        @Override
                        protected boolean getConfiguredHeaderVisible() {
                            return false;
                        }

                        public KeyColumn getKeyColumn() {
                            return this.getColumnSet().getColumnByClass(KeyColumn.class);
                        }

                        public GroupAndSortColumn getGroupAndSortColumn() {
                            return this.getColumnSet().getColumnByClass(GroupAndSortColumn.class);
                        }

                        public FilterColumn getFilterColumn() {
                            return this.getColumnSet().getColumnByClass(FilterColumn.class);
                        }

                        public CustomColumnColumn getCustomColumnColumn() {
                            return this.getColumnSet().getColumnByClass(CustomColumnColumn.class);
                        }

                        public WidthColumn getWidthColumn() {
                            return this.getColumnSet().getColumnByClass(WidthColumn.class);
                        }

                        public BehindScrollbarColumn getBehindScrollbarColumn() {
                            return this.getColumnSet().getColumnByClass(BehindScrollbarColumn.class);
                        }

                        public TitleColumn getTitleColumn() {
                            return this.getColumnSet().getColumnByClass(TitleColumn.class);
                        }

                        @Override
                        protected boolean getConfiguredCheckable() {
                            return true;
                        }

                        @Override
                        protected void execRowsChecked(Collection<? extends ITableRow> rows) {
                            if (OrganizeColumnsForm.this.isFormLoading()) {
                                return;
                            }
                            for (ITableRow iTableRow : rows) {
                                OrganizeColumnsForm.this.setColumnVisible(iTableRow, iTableRow.isChecked());
                            }
                        }

                        @Override
                        protected void execRowsSelected(List<? extends ITableRow> rows) {
                            OrganizeColumnsForm.this.enableDisableMenus();
                            this.refreshMenus();
                        }

                        @Override
                        protected void execInitTable() {
                            this.getWidthColumn().setVisible(!OrganizeColumnsForm.this.m_organizedTable.isAutoResizeColumns());
                        }

                        protected void refreshMenus() {
                            ITableRow selectedRow = ((Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow();
                            IColumn selectedCol = (IColumn)((Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getKeyColumn().getValue(selectedRow);
                            if (selectedCol == null) {
                                return;
                            }
                            if (selectedCol.isSortActive() && selectedCol.isSortAscending()) {
                                this.getMenuByClass(SortAscAdditionalMenu.class).setIconId("font:\ue01e");
                            } else {
                                this.getMenuByClass(SortAscAdditionalMenu.class).setIconId("font:\ue019");
                            }
                            if (selectedCol.isSortActive() && !selectedCol.isSortAscending()) {
                                this.getMenuByClass(SortDescAdditionalMenu.class).setIconId("font:\ue01d");
                            } else {
                                this.getMenuByClass(SortDescAdditionalMenu.class).setIconId("font:\ue018");
                            }
                            if (selectedCol.isGroupingActive()) {
                                this.getMenuByClass(GroupAdditionalMenu.class).setIconId("font:\ue009");
                            } else {
                                this.getMenuByClass(GroupAdditionalMenu.class).setIconId("font:\ue007");
                            }
                        }

                        protected void sortSelectedColumn(boolean multiSort, boolean ascending) {
                            ITableRow row = ((Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow();
                            try {
                                ((Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).setTableChanging(true);
                                IColumn selectedCol = (IColumn)((Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getKeyColumn().getValue(row);
                                if (ascending && selectedCol.isSortActive() && selectedCol.isSortAscending() || !ascending && selectedCol.isSortActive() && !selectedCol.isSortAscending()) {
                                    OrganizeColumnsForm.this.m_organizedTable.getColumnSet().removeSortColumn(selectedCol);
                                } else {
                                    OrganizeColumnsForm.this.m_organizedTable.getColumnSet().handleSortEvent(selectedCol, multiSort, ascending);
                                }
                                OrganizeColumnsForm.this.m_organizedTable.sort();
                                OrganizeColumnsForm.this.getColumnsTableField().reloadTableData();
                                ((Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).selectRow(row.getRowIndex());
                            }
                            finally {
                                ((Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).setTableChanging(false);
                            }
                            this.refreshMenus();
                        }

                        protected void groupSelectedColumn(boolean multiGroup) {
                            ITableRow row = ((Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow();
                            try {
                                ((Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).setTableChanging(true);
                                IColumn selectedCol = (IColumn)((Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getKeyColumn().getValue(row);
                                if (selectedCol.isGroupingActive()) {
                                    OrganizeColumnsForm.this.m_organizedTable.getColumnSet().removeGroupColumn(selectedCol);
                                } else {
                                    boolean ascending = true;
                                    if (selectedCol.isSortActive()) {
                                        ascending = selectedCol.isSortAscending();
                                    }
                                    OrganizeColumnsForm.this.m_organizedTable.getColumnSet().handleGroupingEvent(selectedCol, multiGroup, ascending);
                                }
                                OrganizeColumnsForm.this.m_organizedTable.sort();
                                OrganizeColumnsForm.this.getColumnsTableField().reloadTableData();
                                ((Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).selectRow(row.getRowIndex());
                            }
                            finally {
                                ((Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).setTableChanging(false);
                            }
                            this.refreshMenus();
                        }

                        public void moveNewColumnsAfterSelection(List<String> existingColumns) {
                            Table columnsTable = (Table)OrganizeColumnsForm.this.getColumnsTableField().getTable();
                            ITableRow insertAfterThisRow = columnsTable.getSelectedRow();
                            boolean insertOnTop = false;
                            if (insertAfterThisRow == null && columnsTable.getRowCount() > 0) {
                                insertOnTop = true;
                            }
                            OrganizeColumnsForm.this.getColumnsTableField().reloadTableData();
                            int insertAfterRowIndex = 0;
                            if (insertAfterThisRow != null) {
                                insertAfterRowIndex = insertAfterThisRow.getRowIndex();
                            }
                            for (ITableRow columnRow : columnsTable.getRows()) {
                                if (existingColumns.contains(((IColumn)columnsTable.getKeyColumn().getValue(columnRow)).getColumnId())) continue;
                                try {
                                    ((Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).setTableChanging(true);
                                    if (insertOnTop) {
                                        OrganizeColumnsForm.this.moveUp(columnRow, 0);
                                    } else if (columnRow.getRowIndex() <= insertAfterRowIndex) {
                                        OrganizeColumnsForm.this.moveDown(columnRow, insertAfterRowIndex + 1);
                                    } else {
                                        OrganizeColumnsForm.this.moveUp(columnRow, insertAfterRowIndex + 1);
                                    }
                                    ++insertAfterRowIndex;
                                    OrganizeColumnsForm.this.updateColumnVisibilityAndOrder();
                                    columnsTable.selectRow(columnRow);
                                }
                                finally {
                                    columnsTable.setTableChanging(false);
                                }
                            }
                        }

                        @Order(value=10.0)
                        @ClassId(value="3ffc14b8-85c5-4015-aaeb-5aa0dbb66a9f")
                        public class AddColumnEmptySpaceMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.EmptySpace);
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue01b";
                            }

                            @Override
                            protected void execAction() {
                                OrganizeColumnsForm.this.execAddColumnAction();
                            }
                        }

                        @Order(value=10.0)
                        @ClassId(value="36a172fa-c7ef-4682-9724-6cfdd950907a")
                        public class AddColumnMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object[])new IMenuType[]{TableMenuType.SingleSelection, TableMenuType.MultiSelection});
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue01b";
                            }

                            @Override
                            protected void execAction() {
                                OrganizeColumnsForm.this.execAddColumnAction();
                            }
                        }

                        @Order(value=80.0)
                        @ClassId(value="cf080377-238a-4d59-9120-e10708f17b9a")
                        public class BehindScrollbarColumn
                        extends AbstractStringColumn {
                            @Override
                            protected boolean getConfiguredFixedWidth() {
                                return true;
                            }

                            @Override
                            protected int getConfiguredWidth() {
                                return 10;
                            }

                            @Override
                            protected boolean getConfiguredVisible() {
                                return !UserAgentUtility.isTouchDevice();
                            }
                        }

                        @Order(value=60.0)
                        @ClassId(value="028a3b5b-5eda-4d7e-9490-cf12e2cf3a70")
                        public class CustomColumnColumn
                        extends AbstractStringColumn {
                            @Override
                            protected int getConfiguredWidth() {
                                return 40;
                            }

                            @Override
                            protected int getConfiguredMinWidth() {
                                return 40;
                            }

                            @Override
                            protected boolean getConfiguredFixedWidth() {
                                return true;
                            }
                        }

                        @Order(value=50.0)
                        @ClassId(value="09efa829-7f05-4e51-91e0-b4d032a5ab7c")
                        public class FilterColumn
                        extends AbstractStringColumn {
                            @Override
                            protected String getConfiguredHeaderText() {
                                return TEXTS.get((String)"ResetTableColumnFilter");
                            }

                            @Override
                            protected int getConfiguredWidth() {
                                return 40;
                            }

                            @Override
                            protected int getConfiguredMinWidth() {
                                return 40;
                            }

                            @Override
                            protected boolean getConfiguredFixedWidth() {
                                return true;
                            }
                        }

                        @Order(value=120.0)
                        @ClassId(value="fcf481fb-dc01-45ff-bf20-eab560363c44")
                        public class GroupAdditionalMenu
                        extends AbstractMenu {
                            @Override
                            protected boolean getConfiguredEnabled() {
                                return OrganizeColumnsForm.this.m_organizedTable.isSortEnabled();
                            }

                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.SingleSelection);
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue007";
                            }

                            @Override
                            protected void execAction() {
                                Table.this.groupSelectedColumn(true);
                            }
                        }

                        @Order(value=40.0)
                        @ClassId(value="23b153bc-1d74-46a2-b08b-87aecba6c1b0")
                        public class GroupAndSortColumn
                        extends AbstractStringColumn {
                            @Override
                            protected int getConfiguredWidth() {
                                return 40;
                            }

                            @Override
                            protected int getConfiguredMinWidth() {
                                return 40;
                            }

                            @Override
                            protected boolean getConfiguredFixedWidth() {
                                return true;
                            }

                            @Override
                            protected boolean getConfiguredHtmlEnabled() {
                                return true;
                            }
                        }

                        @Order(value=110.0)
                        @ClassId(value="86487770-f3c2-4c0f-ac91-82b479924453")
                        public class GroupMenu
                        extends AbstractMenu {
                            @Override
                            protected boolean getConfiguredEnabled() {
                                return OrganizeColumnsForm.this.m_organizedTable.isSortEnabled();
                            }

                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.SingleSelection);
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue006";
                            }

                            @Override
                            protected void execAction() {
                                Table.this.groupSelectedColumn(false);
                            }
                        }

                        @Order(value=10.0)
                        @ClassId(value="88b70ee3-05d8-458d-bd92-d7b4bfb22383")
                        public class KeyColumn
                        extends AbstractColumn<IColumn<?>> {
                            @Override
                            protected boolean getConfiguredPrimaryKey() {
                                return true;
                            }

                            @Override
                            protected boolean getConfiguredDisplayable() {
                                return false;
                            }
                        }

                        @Order(value=100.0)
                        @ClassId(value="6acb99fb-d66e-4699-abff-2d0bce12bb41")
                        public class MenuSeparator1
                        extends AbstractMenuSeparator {
                        }

                        @Order(value=130.0)
                        @ClassId(value="fe8106ee-1ed3-443d-bde1-02d2e440c99d")
                        public class MenuSeparator2
                        extends AbstractMenuSeparator {
                        }

                        @Order(value=50.0)
                        @ClassId(value="93fe71a1-d0d4-4f01-9dab-5cf1b68e7cc9")
                        public class MenuSeparator3
                        extends AbstractMenuSeparator {
                        }

                        @Order(value=140.0)
                        @ClassId(value="1636f632-aca4-4e96-ae9e-060c9d0c8317")
                        public class ModifyCustomColumnMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.SingleSelection);
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue04f";
                            }

                            @Override
                            protected void execAction() {
                                IColumn selectedCol;
                                Table columnsTable = (Table)OrganizeColumnsForm.this.getColumnsTableField().getTable();
                                if (OrganizeColumnsForm.this.isCustomizable() && columnsTable.getSelectedRow() != null && (selectedCol = (IColumn)columnsTable.getKeyColumn().getValue(columnsTable.getSelectedRow())) instanceof ICustomColumn) {
                                    OrganizeColumnsForm.this.m_organizedTable.getTableCustomizer().modifyColumn((ICustomColumn)selectedCol);
                                    OrganizeColumnsForm.this.getColumnsTableField().reloadTableData();
                                }
                            }
                        }

                        @Order(value=40.0)
                        @ClassId(value="8d30af92-6da2-420f-9c81-6d32928a68be")
                        public class MoveDownMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object[])new IMenuType[]{TableMenuType.SingleSelection, TableMenuType.MultiSelection});
                            }

                            @Override
                            protected String getConfiguredKeyStroke() {
                                return AbstractAction.combineKeyStrokes("alt", "down", new String[0]);
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue014";
                            }

                            @Override
                            protected void execAction() {
                                List<ITableRow> selectedRows = Table.this.getSelectedRows();
                                Collections.reverse(selectedRows);
                                for (ITableRow row : selectedRows) {
                                    if (!this.canMoveDown(row)) continue;
                                    OrganizeColumnsForm.this.moveDown(row);
                                }
                            }

                            protected boolean canMoveDown(ITableRow candidateRow) {
                                for (ITableRow row : Table.this.getSelectedRows()) {
                                    if (candidateRow == row || row.getRowIndex() != candidateRow.getRowIndex() + 1) continue;
                                    return false;
                                }
                                return true;
                            }
                        }

                        @Order(value=30.0)
                        @ClassId(value="c81f96dc-5b4c-44ed-9737-63a85b22600f")
                        public class MoveUpMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object[])new IMenuType[]{TableMenuType.SingleSelection, TableMenuType.MultiSelection});
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue015";
                            }

                            @Override
                            protected String getConfiguredKeyStroke() {
                                return AbstractAction.combineKeyStrokes("alt", "up", new String[0]);
                            }

                            @Override
                            protected void execAction() {
                                for (ITableRow row : Table.this.getSelectedRows()) {
                                    if (!this.canMoveUp(row)) continue;
                                    OrganizeColumnsForm.this.moveUp(row);
                                }
                            }

                            protected boolean canMoveUp(ITableRow candidateRow) {
                                for (ITableRow row : Table.this.getSelectedRows()) {
                                    if (candidateRow == row || row.getRowIndex() != candidateRow.getRowIndex() - 1) continue;
                                    return false;
                                }
                                return true;
                            }
                        }

                        @Order(value=150.0)
                        @ClassId(value="378519e3-c7e0-40a3-b533-b9dabab44f36")
                        public class RemoveFilterMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object[])new IMenuType[]{TableMenuType.SingleSelection, TableMenuType.MultiSelection});
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue01f";
                            }

                            @Override
                            protected void execAction() {
                                for (ITableRow selectedRow : Table.this.getSelectedRows()) {
                                    IColumn selectedCol = (IColumn)Table.this.getKeyColumn().getValue(selectedRow);
                                    if (!selectedCol.isColumnFilterActive()) continue;
                                    OrganizeColumnsForm.this.m_organizedTable.getUserFilterManager().removeFilterByKey(selectedCol.getColumnId());
                                }
                                ColumnsTableField.this.reloadTableData();
                            }
                        }

                        @Order(value=20.0)
                        @ClassId(value="da55a088-a05f-4c94-8933-c5a2a7d6ab15")
                        public class RemoveMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object[])new IMenuType[]{TableMenuType.SingleSelection, TableMenuType.MultiSelection});
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue01a";
                            }

                            @Override
                            protected String getConfiguredKeyStroke() {
                                return "delete";
                            }

                            @Override
                            protected void execAction() {
                                OrganizeColumnsForm.this.execRemoveColumnAction();
                            }
                        }

                        @Order(value=80.0)
                        @ClassId(value="730281db-2249-4d82-8e1b-8e34c3037291")
                        public class SortAscAdditionalMenu
                        extends AbstractMenu {
                            @Override
                            protected boolean getConfiguredEnabled() {
                                return OrganizeColumnsForm.this.m_organizedTable.isSortEnabled();
                            }

                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.SingleSelection);
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue019";
                            }

                            @Override
                            protected void execAction() {
                                Table.this.sortSelectedColumn(true, true);
                            }
                        }

                        @Order(value=60.0)
                        @ClassId(value="679441de-450d-44c7-97dd-2950ac704266")
                        public class SortAscMenu
                        extends AbstractMenu {
                            @Override
                            protected boolean getConfiguredEnabled() {
                                return OrganizeColumnsForm.this.m_organizedTable.isSortEnabled();
                            }

                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.SingleSelection);
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue017";
                            }

                            @Override
                            protected void execAction() {
                                Table.this.sortSelectedColumn(false, true);
                            }
                        }

                        @Order(value=90.0)
                        @ClassId(value="3cced8ae-dab0-496d-b2ba-31839accb261")
                        public class SortDescAdditionalMenu
                        extends AbstractMenu {
                            @Override
                            protected boolean getConfiguredEnabled() {
                                return OrganizeColumnsForm.this.m_organizedTable.isSortEnabled();
                            }

                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.SingleSelection);
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue018";
                            }

                            @Override
                            protected void execAction() {
                                Table.this.sortSelectedColumn(true, false);
                            }
                        }

                        @Order(value=70.0)
                        @ClassId(value="6056fd4d-6014-4455-acaa-63438b7da7bc")
                        public class SortDescMenu
                        extends AbstractMenu {
                            @Override
                            protected boolean getConfiguredEnabled() {
                                return OrganizeColumnsForm.this.m_organizedTable.isSortEnabled();
                            }

                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.SingleSelection);
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue016";
                            }

                            @Override
                            protected void execAction() {
                                Table.this.sortSelectedColumn(false, false);
                            }
                        }

                        @Order(value=30.0)
                        @ClassId(value="a5dcb98c-aca9-49e5-a80c-eb47d22041a2")
                        public class TitleColumn
                        extends AbstractStringColumn {
                            @Override
                            protected String getConfiguredHeaderText() {
                                return TEXTS.get((String)"Title");
                            }

                            @Override
                            protected int getConfiguredWidth() {
                                return 120;
                            }
                        }

                        @Order(value=70.0)
                        @ClassId(value="c0bfe89c-2402-419a-bda1-68fc61b23ec7")
                        public class WidthColumn
                        extends AbstractIntegerColumn {
                            @Override
                            protected boolean getConfiguredEditable() {
                                return true;
                            }

                            @Override
                            protected int getConfiguredWidth() {
                                return 60;
                            }

                            @Override
                            protected boolean getConfiguredFixedWidth() {
                                return true;
                            }

                            @Override
                            protected void execCompleteEdit(ITableRow row, IFormField editingField) {
                                int newWidth;
                                super.execCompleteEdit(row, editingField);
                                Integer enteredWidth = (Integer)this.getValue(row);
                                boolean updateValue = false;
                                IColumn column = (IColumn)Table.this.getKeyColumn().getValue(row);
                                if (enteredWidth == null || enteredWidth < column.getMinWidth()) {
                                    newWidth = column.getMinWidth();
                                    updateValue = true;
                                } else {
                                    newWidth = enteredWidth;
                                }
                                column.setWidth(newWidth);
                                if (updateValue) {
                                    this.setValue(row, Integer.valueOf(newWidth));
                                }
                            }
                        }
                    }
                }
            }

            @Order(value=5.0)
            @ClassId(value="698da86a-d878-439e-9a1c-da7b63d4f2e3")
            public class ProfilesBox
            extends AbstractGroupBox {
                @Override
                protected int getConfiguredGridColumnCount() {
                    return 1;
                }

                @Override
                protected int getConfiguredGridW() {
                    return 2;
                }

                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"SavedSettings");
                }

                @Override
                protected boolean getConfiguredStatusVisible() {
                    return false;
                }

                @Order(value=10.0)
                @ClassId(value="f96ddd7f-634b-486b-a4be-fbb69b5162e4")
                public class ProfilesTableField
                extends AbstractTableField<Table> {
                    @Override
                    protected int getConfiguredGridH() {
                        return 6;
                    }

                    @Override
                    protected boolean getConfiguredGridUseUiHeight() {
                        return UserAgentUtility.isMobileDevice();
                    }

                    @Override
                    protected int getConfiguredGridW() {
                        return 1;
                    }

                    @Override
                    protected byte getConfiguredLabelPosition() {
                        return 4;
                    }

                    @Override
                    protected boolean getConfiguredLabelVisible() {
                        return false;
                    }

                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"Configurations");
                    }

                    @Override
                    protected boolean getConfiguredStatusVisible() {
                        return false;
                    }

                    @Override
                    protected void execReloadTableData() {
                        List<Object> rowList = new ArrayList<TableRow>();
                        ClientUIPreferences prefs = ClientUIPreferences.getInstance();
                        TableRow row = new TableRow(((Table)this.getTable()).getColumnSet());
                        ((Table)this.getTable()).getConfigNameColumn().setValue(row, TEXTS.get((String)"DefaultSettings"));
                        ((Table)this.getTable()).getConfigTypeColumn().setValue(row, ConfigType.DEFAULT);
                        rowList.add(row);
                        if (prefs != null) {
                            Set<String> configs = prefs.getAllTableColumnsConfigs(OrganizeColumnsForm.this.m_organizedTable);
                            for (String config : configs) {
                                row = new TableRow(((Table)this.getTable()).getColumnSet());
                                ((Table)this.getTable()).getConfigNameColumn().setValue(row, config);
                                ((Table)this.getTable()).getConfigTypeColumn().setValue(row, ConfigType.CUSTOM);
                                rowList.add(row);
                            }
                        }
                        try {
                            ((Table)this.getTable()).setTableChanging(true);
                            ((Table)this.getTable()).discardAllRows();
                            rowList = ((Table)this.getTable()).addRows(rowList);
                            for (ITableRow configRow : ((Table)this.getTable()).getRows()) {
                                configRow.getCellForUpdate(((Table)this.getTable()).getConfigNameColumn()).setEditable(false);
                            }
                        }
                        finally {
                            ((Table)this.getTable()).setTableChanging(false);
                        }
                    }

                    @ClassId(value="359e1e7e-26f0-411d-baf1-2ba9f554212d")
                    public class Table
                    extends AbstractTable {
                        @Override
                        protected Class<? extends IMenu> getConfiguredDefaultMenu() {
                            return ApplyMenu.class;
                        }

                        @Override
                        protected boolean getConfiguredHeaderVisible() {
                            return false;
                        }

                        @Override
                        protected boolean getConfiguredAutoResizeColumns() {
                            return true;
                        }

                        public ConfigNameColumn getConfigNameColumn() {
                            return this.getColumnSet().getColumnByClass(ConfigNameColumn.class);
                        }

                        public ConfigTypeColumn getConfigTypeColumn() {
                            return this.getColumnSet().getColumnByClass(ConfigTypeColumn.class);
                        }

                        @Override
                        protected void execRowsSelected(List<? extends ITableRow> rows) {
                            this.getMenuByClass(DeleteMenu.class).setVisible(!this.isDefaultConfigSelected() && !rows.isEmpty());
                            this.getMenuByClass(RenameMenu.class).setVisible(!this.isDefaultConfigSelected() && !rows.isEmpty());
                            this.getMenuByClass(UpdateMenu.class).setVisible(!this.isDefaultConfigSelected() && !rows.isEmpty());
                            this.getMenuByClass(DeleteMenu.class).setEnabled(!this.isDefaultConfigSelected() && !rows.isEmpty());
                            this.getMenuByClass(RenameMenu.class).setEnabled(!this.isDefaultConfigSelected() && !rows.isEmpty());
                            this.getMenuByClass(UpdateMenu.class).setEnabled(!this.isDefaultConfigSelected() && !rows.isEmpty());
                        }

                        protected boolean isOnlyCustomConfigsSelected() {
                            for (ITableRow row : this.getSelectedRows()) {
                                if (row.getCell(this.getConfigTypeColumn()).getValue() == ConfigType.CUSTOM) continue;
                                return false;
                            }
                            return true;
                        }

                        protected String newConfigName() {
                            int profileNr = 1;
                            String baseName = String.valueOf(TEXTS.get((String)"New")) + " ";
                            while (this.getColumnSet().getColumnByClass(ConfigNameColumn.class).getValues().contains(String.valueOf(baseName) + profileNr)) {
                                ++profileNr;
                            }
                            return String.valueOf(baseName) + profileNr;
                        }

                        protected boolean isDefaultConfigSelected() {
                            for (ITableRow row : this.getSelectedRows()) {
                                if (row.getCell(this.getConfigTypeColumn()).getValue() != ConfigType.DEFAULT) continue;
                                return true;
                            }
                            return false;
                        }

                        @Order(value=20.0)
                        @ClassId(value="203277ac-846d-4781-8547-32e0530c9521")
                        public class ApplyMenu
                        extends AbstractMenu {
                            @Override
                            protected String getConfiguredText() {
                                return TEXTS.get((String)"Load");
                            }

                            @Override
                            protected String getConfiguredKeyStroke() {
                                return "enter";
                            }

                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.SingleSelection);
                            }

                            @Override
                            protected void execAction() {
                                if (Table.this.getConfigTypeColumn().getSelectedValue() == ConfigType.DEFAULT) {
                                    OrganizeColumnsForm.this.resetAll();
                                } else {
                                    String configName = (String)Table.this.getConfigNameColumn().getSelectedValue();
                                    OrganizeColumnsForm.this.applyAll(configName);
                                    OrganizeColumnsForm.this.getColumnsTableField().reloadTableData();
                                }
                                ((Table)ProfilesTableField.this.getTable()).deselectAllEnabledRows();
                            }
                        }

                        @Order(value=10.0)
                        @ClassId(value="f607ab39-e616-4b27-b7c4-f6e437b6b1a3")
                        public class ConfigNameColumn
                        extends AbstractAlphanumericSortingStringColumn {
                            @Override
                            protected boolean getConfiguredEditable() {
                                return true;
                            }

                            @Override
                            protected int getConfiguredSortIndex() {
                                return 1;
                            }

                            @Override
                            protected IFormField execPrepareEdit(ITableRow row) {
                                IStringField field = (IStringField)super.execPrepareEdit(row);
                                return field;
                            }

                            @Override
                            protected void execCompleteEdit(ITableRow row, IFormField editingField) {
                                block5: {
                                    String oldValue;
                                    block4: {
                                        oldValue = (String)Table.this.getConfigNameColumn().getValue(row);
                                        super.execCompleteEdit(row, editingField);
                                        String newValue = (String)((IStringField)editingField).getValue();
                                        if (StringUtility.isNullOrEmpty((CharSequence)newValue)) break block4;
                                        switch ((ConfigType)((Object)Table.this.getConfigTypeColumn().getValue(row))) {
                                            case CUSTOM: {
                                                ClientUIPreferences prefs = ClientUIPreferences.getInstance();
                                                prefs.renameTableColumnsConfig(OrganizeColumnsForm.this.m_organizedTable, oldValue, newValue);
                                                break block5;
                                            }
                                            default: {
                                                throw new IllegalStateException("Rows of configType " + ((ConfigType)((Object)Table.this.getConfigTypeColumn().getValue(row))).name() + " should never be editable.");
                                            }
                                        }
                                    }
                                    if (Table.this.getConfigTypeColumn().getValue(row) == ConfigType.CUSTOM) {
                                        Table.this.getConfigNameColumn().setValue(row, oldValue);
                                    }
                                }
                                row.getCellForUpdate(Table.this.getConfigNameColumn()).setEditable(false);
                                this.getTable().sort();
                            }
                        }

                        @Order(value=20.0)
                        @ClassId(value="d84a8d65-59c2-449d-b375-7a2f2da1844b")
                        public class ConfigTypeColumn
                        extends AbstractColumn<ConfigType> {
                            @Override
                            protected boolean getConfiguredDisplayable() {
                                return false;
                            }

                            @Override
                            protected int getConfiguredSortIndex() {
                                return 0;
                            }
                        }

                        @Order(value=40.0)
                        @ClassId(value="8325ee81-5ae4-4b82-b27f-26cab198c77c")
                        public class DeleteMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object[])new IMenuType[]{TableMenuType.MultiSelection, TableMenuType.SingleSelection});
                            }

                            @Override
                            protected String getConfiguredText() {
                                return TEXTS.get((String)"DeleteMenu");
                            }

                            @Override
                            protected String getConfiguredKeyStroke() {
                                return "delete";
                            }

                            @Override
                            protected void execAction() {
                                List<ITableRow> rows = Table.this.getSelectedRows();
                                Table.this.deleteRows(rows);
                                for (ITableRow row : rows) {
                                    if (Table.this.getConfigTypeColumn().getValue(row) != ConfigType.CUSTOM) continue;
                                    String config = (String)Table.this.getConfigNameColumn().getValue(row);
                                    OrganizeColumnsForm.this.deleteConfig(config);
                                }
                            }
                        }

                        @Order(value=10.0)
                        @ClassId(value="f830ba85-1629-407e-9935-e241713a35c7")
                        public class NewMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.EmptySpace);
                            }

                            @Override
                            protected String getConfiguredText() {
                                return TEXTS.get((String)"New");
                            }

                            @Override
                            protected void execAction() {
                                String newConfigName = Table.this.newConfigName();
                                OrganizeColumnsForm.this.storeCurrentStateAsConfig(newConfigName);
                                ITableRow newRow = new TableRow(((Table)ProfilesTableField.this.getTable()).getColumnSet());
                                ((Table)ProfilesTableField.this.getTable()).getConfigTypeColumn().setValue(newRow, ConfigType.CUSTOM);
                                ((Table)ProfilesTableField.this.getTable()).getConfigNameColumn().setValue(newRow, newConfigName);
                                try {
                                    ((Table)ProfilesTableField.this.getTable()).setTableChanging(true);
                                    newRow = ((Table)ProfilesTableField.this.getTable()).addRow(newRow);
                                    ((Table)ProfilesTableField.this.getTable()).selectRow(newRow);
                                    Table.this.getMenuByClass(RenameMenu.class).rename();
                                }
                                finally {
                                    ((Table)ProfilesTableField.this.getTable()).setTableChanging(false);
                                }
                            }
                        }

                        @Order(value=50.0)
                        @ClassId(value="1ae293da-528c-4e37-abfa-497e9c1892a6")
                        public class RenameMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.SingleSelection);
                            }

                            @Override
                            protected String getConfiguredText() {
                                return TEXTS.get((String)"Rename");
                            }

                            @Override
                            protected String getConfiguredKeyStroke() {
                                return RenameMenu.combineKeyStrokes("control", "enter", new String[0]);
                            }

                            @Override
                            protected void execAction() {
                                this.rename();
                            }

                            protected void rename() {
                                Table.this.getSelectedRow().getCellForUpdate(Table.this.getConfigNameColumn()).setEditable(true);
                                ((Table)ProfilesTableField.this.getTable()).requestFocusInCell(Table.this.getConfigNameColumn(), Table.this.getSelectedRow());
                            }
                        }

                        @Order(value=30.0)
                        @ClassId(value="d0415e79-3f85-49f8-ab64-f87bc3a8363b")
                        public class UpdateMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.SingleSelection);
                            }

                            @Override
                            protected String getConfiguredText() {
                                return TEXTS.get((String)"Update");
                            }

                            @Override
                            protected void execAction() {
                                List<ITableRow> rows = Table.this.getSelectedRows();
                                for (ITableRow row : rows) {
                                    if (Table.this.getConfigTypeColumn().getValue(row) != ConfigType.CUSTOM) continue;
                                    String config = (String)Table.this.getConfigNameColumn().getValue(row);
                                    OrganizeColumnsForm.this.deleteConfig(config);
                                    OrganizeColumnsForm.this.storeCurrentStateAsConfig(config);
                                }
                                ((Table)ProfilesTableField.this.getTable()).deselectAllEnabledRows();
                            }
                        }
                    }
                }
            }
        }
    }

    private class P_OrganizeColumnTablePropertyListener
    implements PropertyChangeListener {
        private P_OrganizeColumnTablePropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            OrganizeColumnsForm.this.updateGroupingMenuVisibility();
        }
    }
}

