/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.organizer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.IDisplayParent;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.organizer.IShowInvisibleColumnsForm;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCancelButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractOkButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.html.HtmlHelper;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;

@ClassId(value="2d5554d8-68f1-49ab-a0aa-638f3de3e1fe")
public class ShowInvisibleColumnsForm
extends AbstractForm
implements IShowInvisibleColumnsForm {
    private ITable m_table = null;
    private IColumn<?> m_insertAfterColumn = null;

    public ShowInvisibleColumnsForm(ITable table) {
        this.m_table = table;
    }

    @Override
    protected String getConfiguredTitle() {
        return TEXTS.get((String)"ShowColumns");
    }

    @Override
    public void startModify() {
        this.startInternal(new ModifyHandler());
    }

    public MainBox getMainBox() {
        return this.getFieldByClass(MainBox.class);
    }

    public MainBox.GroupBox.ColumnsTableField getColumnsTableField() {
        return this.getFieldByClass(MainBox.GroupBox.ColumnsTableField.class);
    }

    protected boolean getConfiguredAllowMultiAttributeSelect() {
        return true;
    }

    protected int getConfiguredMainBoxGridColumnCount() {
        return 1;
    }

    @Override
    protected IDisplayParent getConfiguredDisplayParent() {
        return this.getDesktop();
    }

    @Override
    public IShowInvisibleColumnsForm withInsertAfterColumn(IColumn<?> insertAfterColumn) {
        this.m_insertAfterColumn = insertAfterColumn;
        return this;
    }

    @Order(value=10.0)
    @ClassId(value="60f3556f-6252-4933-9c35-342a7e0684ae")
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredGridColumnCount() {
            return ShowInvisibleColumnsForm.this.getConfiguredMainBoxGridColumnCount();
        }

        @Override
        protected void execInitField() {
            super.execInitField();
            this.setStatusVisible(false);
        }

        @Order(value=20.0)
        @ClassId(value="f6b3f35e-f935-4cd3-94cf-a085ab5dd6b2")
        public class CancelButton
        extends AbstractCancelButton {
        }

        @Order(value=10.0)
        @ClassId(value="ee038f0e-bd8a-4ab5-9af6-fbb2e6a7ff00")
        public class GroupBox
        extends AbstractGroupBox {

            @Order(value=10.0)
            @ClassId(value="9aa78206-cbf3-406f-a8c5-0783bfd1de9b")
            public class ColumnsTableField
            extends AbstractTableField<Table> {
                @Override
                protected int getConfiguredGridH() {
                    return 6;
                }

                @Override
                protected int getConfiguredGridW() {
                    return 1;
                }

                @Override
                protected byte getConfiguredLabelPosition() {
                    return 4;
                }

                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected boolean getConfiguredStatusVisible() {
                    return false;
                }

                @Override
                protected void execReloadTableData() {
                    List<Object> rowList = new ArrayList();
                    for (IColumn<?> col : ShowInvisibleColumnsForm.this.m_table.getColumnSet().getAllColumnsInUserOrder()) {
                        if (!col.isDisplayable() || !col.isVisibleGranted() || col.isVisible()) continue;
                        IHeaderCell headerCell = col.getHeaderCell();
                        TableRow row = new TableRow(((Table)this.getTable()).getColumnSet());
                        ((Table)this.getTable()).getKeyColumn().setValue(row, col);
                        String columnTitle = headerCell.getText();
                        if (StringUtility.isNullOrEmpty((CharSequence)columnTitle)) {
                            columnTitle = headerCell.getTooltipText();
                            row.setFont(FontSpec.parse((String)"ITALIC"));
                        } else if (headerCell.isHtmlEnabled()) {
                            columnTitle = ((HtmlHelper)BEANS.get(HtmlHelper.class)).toPlainText(columnTitle);
                        }
                        ((Table)this.getTable()).getTitleColumn().setValue(row, columnTitle);
                        rowList.add(row);
                    }
                    try {
                        ((Table)this.getTable()).setTableChanging(true);
                        ((Table)this.getTable()).discardAllRows();
                        rowList = ((Table)this.getTable()).addRows(rowList);
                    }
                    finally {
                        ((Table)this.getTable()).setTableChanging(false);
                    }
                }

                @ClassId(value="251571e3-58b2-4711-91ae-3d438988481e")
                public class Table
                extends AbstractTable {
                    @Override
                    protected boolean getConfiguredCheckable() {
                        return true;
                    }

                    @Override
                    protected boolean getConfiguredHeaderVisible() {
                        return false;
                    }

                    @Override
                    protected boolean getConfiguredAutoResizeColumns() {
                        return true;
                    }

                    public KeyColumn getKeyColumn() {
                        return this.getColumnSet().getColumnByClass(KeyColumn.class);
                    }

                    public TitleColumn getTitleColumn() {
                        return this.getColumnSet().getColumnByClass(TitleColumn.class);
                    }

                    @Order(value=10.0)
                    @ClassId(value="da373e46-147f-4298-99ff-34c5f83c4029")
                    public class KeyColumn
                    extends AbstractColumn<IColumn<?>> {
                        @Override
                        protected boolean getConfiguredPrimaryKey() {
                            return true;
                        }

                        @Override
                        protected boolean getConfiguredDisplayable() {
                            return false;
                        }
                    }

                    @Order(value=20.0)
                    @ClassId(value="fdef9323-d352-4802-9069-d6a3005a8f15")
                    public class TitleColumn
                    extends AbstractStringColumn {
                        @Override
                        protected int getConfiguredWidth() {
                            return 200;
                        }
                    }
                }
            }
        }

        @Order(value=15.0)
        @ClassId(value="44339c5f-8885-4f3a-bd6d-8996ad9900a9")
        public class OkButton
        extends AbstractOkButton {
        }
    }

    public class ModifyHandler
    extends AbstractFormHandler {
        @Override
        protected void execStore() {
            ArrayList<IColumn> newCols = new ArrayList<IColumn>();
            for (ITableRow row : ((MainBox.GroupBox.ColumnsTableField.Table)ShowInvisibleColumnsForm.this.getColumnsTableField().getTable()).getCheckedRows()) {
                IColumn col = (IColumn)((MainBox.GroupBox.ColumnsTableField.Table)ShowInvisibleColumnsForm.this.getColumnsTableField().getTable()).getKeyColumn().getValue(row);
                newCols.add(col);
                col.setVisible(true);
            }
            if (ShowInvisibleColumnsForm.this.m_insertAfterColumn == null || newCols.isEmpty()) {
                return;
            }
            ColumnSet colSet = ((IColumn)newCols.get(0)).getTable().getColumnSet();
            ArrayList newOrder = new ArrayList();
            List<IColumn<?>> visibleColumns = colSet.getVisibleColumns();
            int position = 0;
            int posInsertAfter = -1;
            int newPosFirst = -1;
            int newPosLast = -1;
            for (IColumn<?> col : visibleColumns) {
                if (newCols.contains(col)) {
                    if (posInsertAfter != -1 && posInsertAfter < newOrder.size() - 1) {
                        newPosFirst = newPosFirst == -1 ? posInsertAfter + 1 : newPosFirst;
                        newPosLast = newPosLast == -1 ? posInsertAfter + 1 : newPosLast + 1;
                        newOrder.add(newPosLast, col);
                    } else {
                        newOrder.add(col);
                        newPosLast = position;
                        newPosFirst = newPosFirst == -1 ? position : newPosFirst;
                    }
                } else if (newPosFirst != -1 && posInsertAfter == -1) {
                    newOrder.add(newPosFirst, col);
                    posInsertAfter = ShowInvisibleColumnsForm.this.m_insertAfterColumn.equals(col) ? newPosFirst : posInsertAfter;
                    ++newPosFirst;
                    ++newPosLast;
                } else {
                    newOrder.add(col);
                    posInsertAfter = ShowInvisibleColumnsForm.this.m_insertAfterColumn.equals(col) ? position : posInsertAfter;
                }
                ++position;
            }
            int i = 0;
            for (IColumn iColumn : newOrder) {
                iColumn.setVisibleColumnIndexHint(i);
                ++i;
            }
            colSet.setVisibleColumns(newOrder);
            ClientUIPreferences.getInstance().setAllTableColumnPreferences(((IColumn)newCols.get(0)).getTable());
        }

        @Override
        protected void execLoad() {
            ShowInvisibleColumnsForm.this.getColumnsTableField().reloadTableData();
        }
    }
}

