/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.security.Permission;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.AbstractEventBuffer;
import org.eclipse.scout.rt.client.ui.IAppLinkCapable;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.IStyleable;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenuOwner;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITreeContextMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.CheckableStyle;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNodeFilter;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeUIFacade;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListeners;
import org.eclipse.scout.rt.client.ui.dnd.IDNDSupport;
import org.eclipse.scout.rt.platform.util.visitor.IDepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.AbstractTreeFieldData;

public interface ITree
extends IWidget,
IDNDSupport,
IStyleable,
IAppLinkCapable,
IContextMenuOwner {
    public static final String PROP_TITLE = "title";
    public static final String PROP_DRAG_ENABLED = "dragEnabled";
    public static final String PROP_ICON_ID = "iconId";
    public static final String PROP_DEFAULT_ICON_ID = "defaultIconId";
    public static final String PROP_MULTI_SELECT = "multiSelect";
    public static final String PROP_MULTI_CHECK = "multiCheck";
    public static final String PROP_CHECKABLE = "checkable";
    public static final String PROP_AUTO_CHECK_CHILDREN = "autoCheckChildren";
    public static final String PROP_LAZY_EXPANDING_ENABLED = "lazyExpandingEnabled";
    public static final String PROP_NODE_HEIGHT_HINT = "propNodeHeightHint";
    public static final String PROP_ROOT_NODE_VISIBLE = "rootNodeVisible";
    public static final String PROP_ROOT_HANDLES_VISIBLE = "rootHandlesVisible";
    public static final String PROP_KEY_STROKES = "keyStrokes";
    public static final String PROP_SCROLL_TO_SELECTION = "scrollToSelection";
    public static final String PROP_DISPLAY_STYLE = "displayStyle";
    public static final String PROP_TOGGLE_BREADCRUMB_STYLE_ENABLED = "toggleBreadcrumbStyleEnabled";
    public static final String PROP_CHECKABLE_STYLE = "checkableStyle";
    public static final String DISPLAY_STYLE_DEFAULT = "default";
    public static final String DISPLAY_STYLE_BREADCRUMB = "breadcrumb";
    public static final String PROP_CONTEXT_MENU = "contextMenu";

    public AbstractEventBuffer<TreeEvent> createEventBuffer();

    public void requestFocus();

    @Override
    public ITreeContextMenu getContextMenu();

    public boolean isScrollToSelection();

    public void setScrollToSelection(boolean var1);

    public void scrollToSelection();

    public List<ITreeNodeFilter> getNodeFilters();

    public boolean hasNodeFilters();

    public void addNodeFilter(ITreeNodeFilter var1);

    public void removeNodeFilter(ITreeNodeFilter var1);

    public void applyNodeFilters();

    public ITreeNode getRootNode();

    public void setRootNode(ITreeNode var1);

    public String getTitle();

    public void setTitle(String var1);

    public String getIconId();

    public void setIconId(String var1);

    public String getDefaultIconId();

    public void setDefaultIconId(String var1);

    public String getPathText(ITreeNode var1);

    public String getPathText(ITreeNode var1, String var2);

    public boolean isAutoTitle();

    public void setAutoTitle(boolean var1);

    public boolean isDragEnabled();

    public void setDragEnabled(boolean var1);

    public ITreeNode findNode(Object var1);

    public List<ITreeNode> findNodes(Collection<?> var1);

    public boolean isRootNodeVisible();

    public void setRootNodeVisible(boolean var1);

    public boolean isRootHandlesVisible();

    public void setRootHandlesVisible(boolean var1);

    public void ensureVisible(ITreeNode var1);

    public void expandAll(ITreeNode var1);

    public void collapseAll(ITreeNode var1);

    public boolean isLazyExpandingEnabled();

    public void setLazyExpandingEnabled(boolean var1);

    public int getSelectedNodeCount();

    public ITreeNode getSelectedNode();

    public Set<ITreeNode> getSelectedNodes();

    public boolean isAutoCheckChildNodes();

    public void setAutoCheckChildNodes(boolean var1);

    public boolean isSelectedNode(ITreeNode var1);

    public void selectNode(ITreeNode var1);

    public void selectNode(ITreeNode var1, boolean var2);

    public void selectNodes(Collection<? extends ITreeNode> var1, boolean var2);

    public void deselectNode(ITreeNode var1);

    public void deselectNodes(Collection<? extends ITreeNode> var1);

    public void selectPreviousNode();

    public void selectNextNode();

    public ITreeNode selectFirstNode();

    public void selectLastNode();

    public void selectNextChildNode();

    public void selectPreviousParentNode();

    public Set<ITreeNode> getCheckedNodes();

    public int getCheckedNodesCount();

    public boolean isAncestorNodeOf(ITreeNode var1, ITreeNode var2);

    public TreeListeners treeListeners();

    default public void addTreeListener(TreeListener listener, Integer ... eventTypes) {
        this.treeListeners().add(listener, false, eventTypes);
    }

    default public void removeTreeListener(TreeListener listener, Integer ... eventTypes) {
        this.treeListeners().remove(listener, eventTypes);
    }

    default public void addUITreeListener(TreeListener listener, Integer ... eventTypes) {
        this.treeListeners().addLastCalled(listener, false, eventTypes);
    }

    public IEventHistory<TreeEvent> getEventHistory();

    public boolean isMultiSelect();

    public void setMultiSelect(boolean var1);

    public boolean isMultiCheck();

    public void setMultiCheck(boolean var1);

    public boolean isCheckable();

    public void setCheckable(boolean var1);

    public CheckableStyle getCheckableStyle();

    public void setCheckableStyle(CheckableStyle var1);

    public int getNodeHeightHint();

    public void setNodeHeightHint(int var1);

    public boolean isAutoDiscardOnDelete();

    public void setAutoDiscardOnDelete(boolean var1);

    public boolean isTreeChanging();

    public void setTreeChanging(boolean var1);

    public boolean isNodeExpanded(ITreeNode var1);

    public void setNodeExpanded(ITreeNode var1, boolean var2);

    public void setNodeExpanded(ITreeNode var1, boolean var2, boolean var3);

    public void setNodeExpandedInternal(ITreeNode var1, boolean var2, boolean var3);

    public void setNodeEnabledPermission(ITreeNode var1, Permission var2);

    public boolean isNodeEnabled(ITreeNode var1);

    public void setNodeEnabled(ITreeNode var1, boolean var2);

    public boolean isNodeEnabledGranted(ITreeNode var1);

    public void setNodeEnabledGranted(ITreeNode var1, boolean var2);

    public void setNodeVisiblePermission(ITreeNode var1, Permission var2);

    public boolean isNodeVisible(ITreeNode var1);

    public void setNodeVisible(ITreeNode var1, boolean var2);

    public boolean isNodeVisibleGranted(ITreeNode var1);

    public void setNodeVisibleGranted(ITreeNode var1, boolean var2);

    public boolean isNodeLeaf(ITreeNode var1);

    public void setNodeLeaf(ITreeNode var1, boolean var2);

    public void setNodeChecked(ITreeNode var1, boolean var2);

    public void setNodeChecked(ITreeNode var1, boolean var2, boolean var3);

    public void setNodesChecked(List<ITreeNode> var1, boolean var2);

    public void setNodesChecked(List<ITreeNode> var1, boolean var2, boolean var3);

    public boolean isNodeChecked(ITreeNode var1);

    public int getNodeStatus(ITreeNode var1);

    public void setNodeStatus(ITreeNode var1, int var2);

    public List<IKeyStroke> getKeyStrokes();

    public void setKeyStrokes(List<? extends IKeyStroke> var1);

    public void addChildNode(ITreeNode var1, ITreeNode var2);

    public void addChildNodes(ITreeNode var1, List<? extends ITreeNode> var2);

    public void addChildNode(int var1, ITreeNode var2, ITreeNode var3);

    public void addChildNodes(int var1, ITreeNode var2, List<? extends ITreeNode> var3);

    public void updateNode(ITreeNode var1);

    public void updateChildNodes(ITreeNode var1, Collection<? extends ITreeNode> var2);

    public void updateChildNodeOrder(ITreeNode var1, List<? extends ITreeNode> var2);

    public void removeChildNode(ITreeNode var1, ITreeNode var2);

    public void removeChildNodes(ITreeNode var1, Collection<? extends ITreeNode> var2);

    public void removeAllChildNodes(ITreeNode var1);

    public void removeNode(ITreeNode var1);

    public void clearDeletedNodes();

    public void disposeDeletedNode(ITreeNode var1);

    public void disposeDeletedNodes(Collection<ITreeNode> var1);

    public void discardDeletedNode(ITreeNode var1);

    public void discardDeletedNodes(Collection<ITreeNode> var1);

    public int getDeletedNodeCount();

    public Set<ITreeNode> getDeletedNodes();

    public int getInsertedNodeCount();

    public Set<ITreeNode> getInsertedNodes();

    public int getUpdatedNodeCount();

    public Set<ITreeNode> getUpdatedNodes();

    public TreeVisitResult visitTree(IDepthFirstTreeVisitor<ITreeNode> var1);

    public TreeVisitResult visitVisibleTree(IDepthFirstTreeVisitor<ITreeNode> var1);

    public TreeVisitResult visitNode(ITreeNode var1, IDepthFirstTreeVisitor<ITreeNode> var2);

    public void unloadNode(ITreeNode var1);

    public void exportTreeData(AbstractTreeFieldData var1);

    public void importTreeData(AbstractTreeFieldData var1);

    public ITreeUIFacade getUIFacade();

    public boolean isSaveAndRestoreScrollbars();

    public void setSaveAndRestoreScrollbars(boolean var1);

    public String getDisplayStyle();

    public void setDisplayStyle(String var1);

    public boolean isToggleBreadcrumbStyleEnabled();

    public void setToggleBreadcrumbStyleEnabled(boolean var1);

    public void fireNodeChanged(ITreeNode var1);
}

