/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.AbstractEventBuffer;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public class TreeEventBuffer
extends AbstractEventBuffer<TreeEvent> {
    @Override
    protected List<TreeEvent> coalesce(List<TreeEvent> events) {
        this.removeObsolete(events);
        this.removeNodesContainedInPreviousInsertEvents(events, CollectionUtility.hashSet((Object[])new Integer[]{100, 102, 101, 103, 850, 20, 10}));
        this.removeEmptyEvents(events);
        this.removeIdenticalEvents(events);
        this.coalesceSameType(events);
        return events;
    }

    protected void removeObsolete(List<TreeEvent> events) {
        if (events.size() < 2) {
            return;
        }
        HashSet<Integer> typesToDelete = new HashSet<Integer>();
        LinkedList<DeletedNodesRemover> deletedNodesRemoverList = new LinkedList<DeletedNodesRemover>();
        HashSet<ITreeNode> newNodes = null;
        ListIterator<TreeEvent> it = events.listIterator(events.size());
        while (it.hasPrevious()) {
            TreeEvent event = it.previous();
            int type = event.getType();
            if (!deletedNodesRemoverList.isEmpty()) {
                Iterator removerIt = deletedNodesRemoverList.iterator();
                while (removerIt.hasNext()) {
                    DeletedNodesRemover remover = (DeletedNodesRemover)removerIt.next();
                    boolean finished = remover.removeDeletedNodes(event);
                    if (!finished) continue;
                    remover.complete();
                    removerIt.remove();
                }
            }
            if (typesToDelete.contains(type)) {
                it.remove();
                continue;
            }
            if (this.isIgnorePrevious(type)) {
                typesToDelete.add(type);
                continue;
            }
            if (type == 102 || type == 103) {
                typesToDelete.addAll(this.getExpansionRelatedEvents());
                continue;
            }
            if (type != 30 && type != 31 || !event.hasNodes()) continue;
            if (newNodes == null) {
                newNodes = new HashSet<ITreeNode>();
                for (TreeEvent e : events) {
                    if (e == event) break;
                    if (e.getType() != 10) continue;
                    LinkedList<ITreeNode> toProcess = new LinkedList<ITreeNode>(e.getChildNodes());
                    while (!toProcess.isEmpty()) {
                        ITreeNode node = (ITreeNode)toProcess.remove(0);
                        newNodes.add(node);
                        toProcess.addAll(node.getChildNodes());
                    }
                }
            }
            deletedNodesRemoverList.add(new DeletedNodesRemover(event, newNodes));
        }
        for (DeletedNodesRemover remover : deletedNodesRemoverList) {
            remover.complete();
        }
    }

    protected void removeNodesContainedInPreviousInsertEvents(List<TreeEvent> events, Set<Integer> newTypes) {
        if (events.size() < 2) {
            return;
        }
        HashSet<ITreeNode> insertedTreeNodes = new HashSet<ITreeNode>();
        for (TreeEvent event : events) {
            int type = event.getType();
            if (!event.hasNodes()) continue;
            if (newTypes.contains(type) && !insertedTreeNodes.isEmpty()) {
                event.removeNodes(insertedTreeNodes, null);
            }
            if (type != 10 || !event.hasNodes()) continue;
            Collection<ITreeNode> nodes = event.getNodes();
            for (ITreeNode node : nodes) {
                if (node == null || !insertedTreeNodes.add(node)) continue;
                node.collectChildNodes(insertedTreeNodes, true);
            }
        }
    }

    protected void coalesceSameType(List<TreeEvent> events) {
        if (events.size() < 2) {
            return;
        }
        HashMap<ITreeNode, TreeEvent> initialEventByParentNode = new HashMap<ITreeNode, TreeEvent>();
        HashMap<ITreeNode, TreeEventMerger> eventMergerByParent = new HashMap<ITreeNode, TreeEventMerger>();
        int previousEventType = -1;
        ListIterator<TreeEvent> it = events.listIterator(events.size());
        while (it.hasPrevious()) {
            TreeEvent event = it.previous();
            int type = event.getType();
            if (previousEventType != type && !initialEventByParentNode.isEmpty()) {
                for (TreeEventMerger merger : eventMergerByParent.values()) {
                    merger.complete();
                }
                initialEventByParentNode.clear();
                eventMergerByParent.clear();
            }
            if (!this.isCoalesceConsecutivePrevious(type)) continue;
            previousEventType = type;
            ITreeNode parentNode = event.getCommonParentNode();
            TreeEvent initialEvent = (TreeEvent)initialEventByParentNode.get(event.getCommonParentNode());
            if (initialEvent == null) {
                initialEventByParentNode.put(parentNode, event);
                continue;
            }
            TreeEventMerger eventMerger = eventMergerByParent.computeIfAbsent(parentNode, k -> new TreeEventMerger(initialEvent));
            eventMerger.merge(event);
            it.remove();
        }
        for (TreeEventMerger eventMerger : eventMergerByParent.values()) {
            eventMerger.complete();
        }
    }

    protected void removeEmptyEvents(List<TreeEvent> events) {
        events.removeIf(event -> this.isNodesRequired(event.getType()) && !event.hasNodes() || this.isCommonParentNodeRequired(event.getType()) && event.getCommonParentNode() == null);
    }

    protected void removeIdenticalEvents(List<TreeEvent> events) {
        if (events.size() < 2) {
            return;
        }
        HashMap<Integer, ArrayList<TreeEvent>> predecessorEventsOfSameType = new HashMap<Integer, ArrayList<TreeEvent>>();
        int currentEventGroupType = -1;
        ListIterator<TreeEvent> it = events.listIterator();
        while (it.hasNext()) {
            TreeEvent event = it.next();
            if (event.getType() != currentEventGroupType) {
                currentEventGroupType = event.getType();
                predecessorEventsOfSameType.clear();
                if (this.lookAheadEventType(it) != currentEventGroupType) continue;
                predecessorEventsOfSameType.put(this.identicalEventHashCode(event), CollectionUtility.arrayList((Object)event));
                continue;
            }
            boolean removed = false;
            int treeEventHashCode = this.identicalEventHashCode(event);
            ArrayList<TreeEvent> identicalEventList = (ArrayList<TreeEvent>)predecessorEventsOfSameType.get(treeEventHashCode);
            if (identicalEventList != null) {
                for (TreeEvent predecessorEvent : identicalEventList) {
                    if (!this.isIdenticalEvent(event, predecessorEvent)) continue;
                    it.remove();
                    removed = true;
                    break;
                }
            }
            if (removed) continue;
            if (identicalEventList == null && this.lookAheadEventType(it) == currentEventGroupType) {
                identicalEventList = new ArrayList<TreeEvent>();
                predecessorEventsOfSameType.put(treeEventHashCode, identicalEventList);
            }
            if (identicalEventList == null) continue;
            identicalEventList.add(event);
        }
    }

    protected int lookAheadEventType(ListIterator<TreeEvent> it) {
        if (!it.hasNext()) {
            return -1;
        }
        try {
            int n = it.next().getType();
            return n;
        }
        finally {
            it.previous();
        }
    }

    protected int identicalEventHashCode(TreeEvent event) {
        int result = 1;
        result = 31 * result + event.getType();
        result = 31 * result + (event.isConsumed() ? 1231 : 1237);
        ITreeNode commonParentNode = event.getCommonParentNode();
        result = 31 * result + (commonParentNode == null ? 0 : commonParentNode.hashCode());
        Collection<ITreeNode> nodes = event.getNodes();
        result = 31 * result + (nodes == null ? 0 : ((Object)nodes).hashCode());
        Collection<ITreeNode> deselectedNodes = event.getDeselectedNodes();
        result = 31 * result + (deselectedNodes == null ? 0 : ((Object)deselectedNodes).hashCode());
        Collection<ITreeNode> newSelectedNodes = event.getNewSelectedNodes();
        result = 31 * result + (newSelectedNodes == null ? 0 : ((Object)newSelectedNodes).hashCode());
        TransferObject dragObject = event.getDragObject();
        result = 31 * result + (dragObject == null ? 0 : dragObject.hashCode());
        List<IMenu> popupMenus = event.getPopupMenus();
        result = 31 * result + (popupMenus == null ? 0 : ((Object)popupMenus).hashCode());
        TransferObject dropObject = event.getDropObject();
        result = 31 * result + (dropObject == null ? 0 : dropObject.hashCode());
        return result;
    }

    @Override
    protected boolean isIdenticalEvent(TreeEvent event1, TreeEvent event2) {
        if (event1 == null && event2 == null) {
            return true;
        }
        if (event1 == null || event2 == null) {
            return false;
        }
        boolean identical = event1.getType() == event2.getType() && event1.isConsumed() == event2.isConsumed() && event1.getNodeCount() == event2.getNodeCount() && ObjectUtility.equals((Object)event1.getCommonParentNode(), (Object)event2.getCommonParentNode()) && CollectionUtility.equalsCollection(event1.getNodes(), event2.getNodes(), (boolean)true) && CollectionUtility.equalsCollection(event1.getDeselectedNodes(), event2.getDeselectedNodes(), (boolean)true) && CollectionUtility.equalsCollection(event1.getNewSelectedNodes(), event2.getNewSelectedNodes(), (boolean)true) && CollectionUtility.equalsCollection(event1.getPopupMenus(), event2.getPopupMenus()) && ObjectUtility.equals((Object)event1.getDragObject(), (Object)event2.getDragObject()) && ObjectUtility.equals((Object)event1.getDropObject(), (Object)event2.getDropObject());
        return identical;
    }

    protected Set<Integer> getExpansionRelatedEvents() {
        HashSet<Integer> res = new HashSet<Integer>();
        res.add(100);
        res.add(102);
        res.add(101);
        res.add(103);
        return res;
    }

    protected boolean isIgnorePrevious(int type) {
        switch (type) {
            case 35: 
            case 40: 
            case 830: {
                return true;
            }
        }
        return false;
    }

    protected boolean isCoalesceConsecutivePrevious(int type) {
        switch (type) {
            case 10: 
            case 20: 
            case 30: 
            case 870: {
                return true;
            }
        }
        return false;
    }

    protected boolean isNodesRequired(int type) {
        switch (type) {
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 50: 
            case 730: {
                return true;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 300: 
            case 400: 
            case 705: 
            case 740: 
            case 820: 
            case 850: 
            case 860: {
                return true;
            }
        }
        return false;
    }

    protected boolean isCommonParentNodeRequired(int type) {
        switch (type) {
            case 31: {
                return true;
            }
        }
        return false;
    }

    protected static class DeletedNodesRemover {
        private final TreeEvent m_deleteEvent;
        private final Set<ITreeNode> m_newNodes;
        private Map<ITreeNode, Set<ITreeNode>> m_childNodesByNodeToRemove;
        private Set<ITreeNode> m_nodesToRemove;
        private Set<ITreeNode> m_allNodesToRemove;
        private Set<ITreeNode> m_removedNodesCollector;

        public DeletedNodesRemover(TreeEvent deleteEvent, Set<ITreeNode> newNodes) {
            this.m_deleteEvent = deleteEvent;
            this.m_newNodes = newNodes;
        }

        public boolean removeDeletedNodes(TreeEvent event) {
            boolean deleteEvent;
            this.ensureInitialized();
            if (this.m_allNodesToRemove.isEmpty()) {
                return true;
            }
            int type = event.getType();
            boolean insertEvent = type == 10;
            boolean bl = deleteEvent = type == 31 || type == 30;
            if (deleteEvent) {
                HashSet<ITreeNode> additionalNodesToRemoveCollector = new HashSet<ITreeNode>();
                event.removeNodes(this.m_allNodesToRemove, additionalNodesToRemoveCollector);
                for (ITreeNode node : additionalNodesToRemoveCollector) {
                    this.registerNodeToRemoveWithAllChildren(node);
                }
                return false;
            }
            if (!insertEvent) {
                Set<ITreeNode> nodesToRemove = this.m_allNodesToRemove;
                if (type == 50) {
                    nodesToRemove = new HashSet<ITreeNode>(this.m_allNodesToRemove);
                    nodesToRemove.retainAll(this.m_newNodes);
                }
                event.removeNodes(nodesToRemove, null);
                return false;
            }
            event.removeNodes(this.m_allNodesToRemove, this.m_removedNodesCollector);
            Iterator<ITreeNode> it = this.m_nodesToRemove.iterator();
            block1: while (it.hasNext()) {
                ITreeNode nodeToRemove = it.next();
                if (this.m_removedNodesCollector.contains(nodeToRemove)) {
                    it.remove();
                    this.updateNodesToRemove(nodeToRemove);
                    continue;
                }
                ITreeNode parentToCheck = nodeToRemove.getParentNode();
                while (parentToCheck != null) {
                    if (event.containsNode(parentToCheck)) {
                        it.remove();
                        this.m_removedNodesCollector.add(nodeToRemove);
                        this.updateNodesToRemove(nodeToRemove);
                        continue block1;
                    }
                    parentToCheck = parentToCheck.getParentNode();
                }
            }
            return this.m_allNodesToRemove.isEmpty();
        }

        protected void updateNodesToRemove(ITreeNode nodeToRemove) {
            this.m_allNodesToRemove.remove(nodeToRemove);
            Set<ITreeNode> childNodesToRemove = this.m_childNodesByNodeToRemove.remove(nodeToRemove);
            if (childNodesToRemove != null) {
                this.m_allNodesToRemove.removeAll(childNodesToRemove);
            }
        }

        protected void ensureInitialized() {
            if (this.m_removedNodesCollector != null) {
                return;
            }
            this.m_nodesToRemove = new HashSet<ITreeNode>();
            this.m_allNodesToRemove = new HashSet<ITreeNode>();
            this.m_childNodesByNodeToRemove = new HashMap<ITreeNode, Set<ITreeNode>>();
            for (ITreeNode node : this.m_deleteEvent.getNodesSet()) {
                this.registerNodeToRemoveWithAllChildren(node);
            }
            this.m_removedNodesCollector = new HashSet<ITreeNode>();
        }

        protected void registerNodeToRemoveWithAllChildren(ITreeNode node) {
            if (node == null) {
                return;
            }
            this.m_nodesToRemove.add(node);
            this.m_allNodesToRemove.add(node);
            if (node.getChildNodeCount() > 0) {
                HashSet<ITreeNode> collector = new HashSet<ITreeNode>();
                node.collectChildNodes(collector, true);
                this.m_childNodesByNodeToRemove.put(node, collector);
                this.m_allNodesToRemove.addAll(collector);
            }
        }

        public void complete() {
            if (CollectionUtility.isEmpty(this.m_removedNodesCollector)) {
                return;
            }
            ArrayList<ITreeNode> remainingNodes = new ArrayList<ITreeNode>();
            for (ITreeNode node : this.m_deleteEvent.getNodes()) {
                if (this.m_removedNodesCollector.contains(node)) continue;
                remainingNodes.add(node);
            }
            this.m_deleteEvent.setNodes(remainingNodes);
        }
    }

    protected static class TreeEventMerger {
        private final TreeEvent m_targetEvent;
        private Collection<ITreeNode> m_targetNodes;
        private Set<ITreeNode> m_targetNodeSet;
        private List<ITreeNode> m_mergedNodes;

        public TreeEventMerger(TreeEvent targetEvent) {
            this.m_targetEvent = (TreeEvent)Assertions.assertNotNull((Object)targetEvent, (String)"targetEvent must not be null", (Object[])new Object[0]);
            this.m_mergedNodes = new LinkedList<ITreeNode>();
        }

        public void merge(TreeEvent event) {
            if (this.m_mergedNodes == null) {
                throw new IllegalStateException("Invocations of merge is not allowed after complete has been invoked.");
            }
            if (!event.hasNodes()) {
                return;
            }
            this.ensureInitialized();
            this.mergeCollections(event.getNodes(), this.m_mergedNodes, this.m_targetNodeSet);
        }

        protected void ensureInitialized() {
            if (this.m_targetNodes != null) {
                return;
            }
            this.m_targetNodes = this.m_targetEvent.getNodes();
            this.m_targetNodeSet = new HashSet<ITreeNode>(this.m_targetNodes);
        }

        public void complete() {
            if (this.m_mergedNodes == null) {
                return;
            }
            if (this.m_targetNodes != null) {
                this.m_mergedNodes.addAll(this.m_targetNodes);
                this.m_targetEvent.setNodes(this.m_mergedNodes);
            }
            this.m_mergedNodes = null;
        }

        protected <TYPE> void mergeCollections(Collection<TYPE> source, List<TYPE> target, Set<TYPE> targetSet) {
            source.removeIf(sourceElement -> !targetSet.add(sourceElement));
            target.addAll(0, source);
        }
    }
}

