/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.scout.rt.platform.job.IBlockingCondition;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.util.concurrent.TimedOutError;

public class ClientCallback<T>
implements Future<T> {
    private boolean m_cancelled = false;
    private boolean m_done = false;
    private T m_result;
    private ExecutionException m_failure;
    private final IBlockingCondition m_blockingCondition = Jobs.newBlockingCondition((boolean)true);

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean alreadyCancelled = this.m_cancelled;
        boolean bl = this.m_cancelled = !this.m_done;
        return !alreadyCancelled && this.m_cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.m_cancelled;
    }

    @Override
    public boolean isDone() {
        return this.m_done;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.m_blockingCondition.waitFor(new String[]{"ui.interaction.required"});
        return this.report();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            this.m_blockingCondition.waitFor(timeout, unit, new String[]{"ui.interaction.required"});
        }
        catch (TimedOutError timedOutError) {
            this.timedOut();
            throw new TimeoutException();
        }
        return this.report();
    }

    protected void timedOut() {
    }

    public void done(T result) {
        if (this.m_cancelled || this.m_done) {
            return;
        }
        this.m_done = true;
        this.m_result = result;
        this.m_blockingCondition.setBlocking(false);
    }

    public void failed(Throwable t) {
        if (this.m_cancelled || this.m_done) {
            return;
        }
        this.m_done = true;
        this.m_failure = new ExecutionException(t);
        this.m_blockingCondition.setBlocking(false);
    }

    private T report() throws InterruptedException, ExecutionException {
        if (!this.m_done) {
            throw new InterruptedException();
        }
        if (this.m_failure != null) {
            throw this.m_failure;
        }
        return this.m_result;
    }
}

