/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.desktop.AbstractDisplayParentViewIndex;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.IDisplayParent;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.index.AbstractMultiValueIndex;
import org.eclipse.scout.rt.platform.index.IIndex;
import org.eclipse.scout.rt.platform.index.IndexedStore;

@Bean
public class FormStore
extends IndexedStore<IForm> {
    private final P_TypeIndex m_typeIndex = (P_TypeIndex)this.registerIndex((IIndex)new P_TypeIndex());
    private final P_DisplayParentIndex m_displayParentIndex = (P_DisplayParentIndex)this.registerIndex((IIndex)new P_DisplayParentIndex());
    private final P_DisplayParentViewIndex m_displayParentViewIndex = (P_DisplayParentViewIndex)this.registerIndex(new P_DisplayParentViewIndex());
    private final P_DisplayParentDialogIndex m_displayParentDialogIndex = (P_DisplayParentDialogIndex)this.registerIndex((IIndex)new P_DisplayParentDialogIndex());
    private final P_DisplayHintIndex m_displayHintIndex = (P_DisplayHintIndex)this.registerIndex((IIndex)new P_DisplayHintIndex());
    private final P_ClassIndex m_clazzIndex = (P_ClassIndex)this.registerIndex((IIndex)new P_ClassIndex());
    private final P_ExclusiveKeyViewIndex m_exclusiveKeyIndex = (P_ExclusiveKeyViewIndex)this.registerIndex((IIndex)new P_ExclusiveKeyViewIndex());
    private final P_ApplicationModalDialogIndex m_applicationModalDialogIndex = (P_ApplicationModalDialogIndex)this.registerIndex((IIndex)new P_ApplicationModalDialogIndex());

    public List<IForm> getViews() {
        return this.m_typeIndex.get((Object)FormType.VIEW);
    }

    public List<IForm> getDialogs() {
        return this.m_typeIndex.get((Object)FormType.DIALOG);
    }

    public List<IForm> getByDisplayParent(IDisplayParent displayParent) {
        return this.m_displayParentIndex.get(displayParent);
    }

    public List<IForm> getViewsByDisplayParent(IDisplayParent displayParent) {
        return this.m_displayParentViewIndex.get(displayParent);
    }

    public List<IForm> getDialogsByDisplayParent(IDisplayParent displayParent) {
        return this.m_displayParentDialogIndex.get(displayParent);
    }

    public List<IForm> getByDisplayHint(int displayHint) {
        return this.m_displayHintIndex.get(displayHint);
    }

    public List<IForm> getByClass(Class<? extends IForm> clazz) {
        return this.m_clazzIndex.get(clazz);
    }

    public List<IForm> getFormsByExclusiveKey(Object key) {
        return this.m_exclusiveKeyIndex.get(key);
    }

    public boolean containsApplicationModalDialogs() {
        return !this.getApplicationModalDialogs().isEmpty();
    }

    public List<IForm> getApplicationModalDialogs() {
        return this.m_applicationModalDialogIndex.get(Boolean.TRUE);
    }

    private static enum FormType {
        VIEW,
        DIALOG;

    }

    private class P_ApplicationModalDialogIndex
    extends AbstractMultiValueIndex<Boolean, IForm> {
        private P_ApplicationModalDialogIndex() {
        }

        protected Boolean calculateIndexFor(IForm form) {
            if (form.getDisplayHint() != 20 && form.isModal() && form.getDisplayParent() == ClientSessionProvider.currentSession().getDesktop()) {
                return true;
            }
            return false;
        }
    }

    private class P_ClassIndex
    extends AbstractMultiValueIndex<Class<? extends IForm>, IForm> {
        private P_ClassIndex() {
        }

        protected Class<? extends IForm> calculateIndexFor(IForm form) {
            return form.getClass();
        }
    }

    private class P_DisplayHintIndex
    extends AbstractMultiValueIndex<Integer, IForm> {
        private P_DisplayHintIndex() {
        }

        protected Integer calculateIndexFor(IForm form) {
            return form.getDisplayHint();
        }
    }

    private class P_DisplayParentDialogIndex
    extends AbstractMultiValueIndex<IDisplayParent, IForm> {
        private P_DisplayParentDialogIndex() {
        }

        protected IDisplayParent calculateIndexFor(IForm form) {
            if (form.getDisplayHint() != 20) {
                return form.getDisplayParent();
            }
            return null;
        }
    }

    private class P_DisplayParentIndex
    extends AbstractMultiValueIndex<IDisplayParent, IForm> {
        private P_DisplayParentIndex() {
        }

        protected IDisplayParent calculateIndexFor(IForm form) {
            return form.getDisplayParent();
        }
    }

    private class P_DisplayParentViewIndex
    extends AbstractDisplayParentViewIndex {
        private P_DisplayParentViewIndex() {
        }

        @Override
        protected IDisplayParent calculateIndexFor(IForm form) {
            if (form.getDisplayHint() == 20) {
                return form.getDisplayParent();
            }
            return null;
        }

        @Override
        protected int calculatePositionForElement(IForm element) {
            IForm activeForm = ClientSessionProvider.currentSession().getDesktop().getActiveForm();
            List<IForm> formsOnThisDisplayParent = FormStore.this.getViewsByDisplayParent(this.calculateIndexFor(element));
            int position = formsOnThisDisplayParent.indexOf(activeForm);
            if (position == -1) {
                return 0;
            }
            return position + 1;
        }
    }

    private class P_ExclusiveKeyViewIndex
    extends AbstractMultiValueIndex<Object, IForm> {
        private P_ExclusiveKeyViewIndex() {
        }

        protected Object calculateIndexFor(IForm form) {
            try {
                return form.computeExclusiveKey();
            }
            catch (ProcessingException e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
                return null;
            }
        }
    }

    private class P_TypeIndex
    extends AbstractMultiValueIndex<FormType, IForm> {
        private P_TypeIndex() {
        }

        protected FormType calculateIndexFor(IForm form) {
            return form.getDisplayHint() == 20 ? FormType.VIEW : FormType.DIALOG;
        }
    }
}

