/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.client.ui.IDisplayParent;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCancelButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractOkButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxes;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardContainerForm;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

@ClassId(value="b5783a42-9fd8-4043-afc1-6e744dad9c8f")
public class UnsavedFormChangesForm
extends AbstractForm {
    private final List<IForm> m_forms;
    private boolean m_isStopSession;

    public UnsavedFormChangesForm(List<IForm> forms, boolean isStopSession) {
        this.m_forms = forms;
        this.m_isStopSession = isStopSession;
    }

    @Override
    protected String getConfiguredTitle() {
        return TEXTS.get((String)"SaveChangesOfSelectedItems");
    }

    @Override
    protected boolean getConfiguredAskIfNeedSave() {
        return false;
    }

    @Override
    protected IDisplayParent getConfiguredDisplayParent() {
        return this.getDesktop();
    }

    public void startNew() {
        this.startInternal(new NewHandler());
    }

    public MainBox getMainBox() {
        return this.getFieldByClass(MainBox.class);
    }

    public MainBox.UnsavedChangesBox getUnsavedChangesBox() {
        return this.getFieldByClass(MainBox.UnsavedChangesBox.class);
    }

    public MainBox.UnsavedChangesBox.OpenFormsField getOpenFormsField() {
        return this.getFieldByClass(MainBox.UnsavedChangesBox.OpenFormsField.class);
    }

    public List<IForm> getUnsavedForms() {
        return CollectionUtility.arrayList(this.m_forms);
    }

    protected static String getFormDisplayName(IForm f) {
        return StringUtility.join((String)" - ", (Object[])new Object[]{ObjectUtility.nvl((Object)f.getTitle(), (Object)f.getClass().getName()), f.getSubTitle()});
    }

    protected static IForm getTopDisplayParent(IForm f) {
        if (!(f.getDisplayParent() instanceof IDesktop) && f.getDisplayParent() instanceof IForm) {
            return UnsavedFormChangesForm.getTopDisplayParent((IForm)f.getDisplayParent());
        }
        return f;
    }

    @Order(value=10.0)
    @ClassId(value="7c89cc91-2c09-472b-af3b-ee93b50caaad")
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredGridColumnCount() {
            return 2;
        }

        @Order(value=30.0)
        @ClassId(value="50c8526a-333f-4878-9876-b48f2b583d88")
        public class CancelButton
        extends AbstractCancelButton {
            @Override
            protected String getConfiguredTooltipText() {
                if (UnsavedFormChangesForm.this.m_isStopSession) {
                    return TEXTS.get((String)"CancelShutdownAndReturnToTheApplication");
                }
                return null;
            }
        }

        @Order(value=20.0)
        @ClassId(value="caca3d68-b8cc-4cb0-a35c-5b8ccbcc3745")
        public class OkButton
        extends AbstractOkButton {
            @Override
            protected String getConfiguredTooltipText() {
                if (UnsavedFormChangesForm.this.m_isStopSession) {
                    return TEXTS.get((String)"SaveCheckedFormsAndShutdown");
                }
                return null;
            }
        }

        @Order(value=10.0)
        @ClassId(value="51908aa1-6409-44fd-9aeb-a92cec73baaa")
        public class UnsavedChangesBox
        extends AbstractGroupBox {
            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected String getConfiguredBorderDecoration() {
                return "line";
            }

            @Override
            protected int getConfiguredGridColumnCount() {
                return 1;
            }

            @Order(value=20.0)
            @ClassId(value="84f2a9cf-bce5-4379-aede-11d07b21d3fb")
            public class OpenFormsField
            extends AbstractListBox<ArrayDeque<IForm>> {
                @Override
                protected void execInitField() {
                    this.checkAllKeys();
                }

                public List<IForm> getInvalidForms() {
                    LinkedList<IForm> invalidForms = new LinkedList<IForm>();
                    Iterator iterator = this.getValue().iterator();
                    while (iterator.hasNext()) {
                        ArrayDeque deque = (ArrayDeque)iterator.next();
                        for (IForm f : deque) {
                            try {
                                f.validateForm();
                            }
                            catch (RuntimeException runtimeException) {
                                invalidForms.add(f);
                            }
                        }
                    }
                    return invalidForms;
                }

                @Override
                protected Class<? extends ILookupCall<ArrayDeque<IForm>>> getConfiguredLookupCall() {
                    return UnsavedFormsLookupCall.class;
                }

                @Override
                protected void execPrepareLookup(ILookupCall<ArrayDeque<IForm>> call) {
                    UnsavedFormsLookupCall unsavedFormsLookupCall = (UnsavedFormsLookupCall)call;
                    unsavedFormsLookupCall.setUnsavedForms(UnsavedFormChangesForm.this.getUnsavedForms());
                }

                @Override
                protected int getConfiguredGridH() {
                    return 5;
                }

                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected boolean getConfiguredStatusVisible() {
                    return false;
                }

                @ClassId(value="ee7f1455-7da5-402b-98c0-c9d75a221595")
                public class Tree
                extends AbstractListBox.DefaultListBoxTable {

                    @Order(value=10.0)
                    @ClassId(value="00ee88b2-be05-418c-8b21-ad0b324ab78e")
                    public class CheckAllMenu
                    extends AbstractMenu {
                        @Override
                        protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                            return CollectionUtility.hashSet((Object)TableMenuType.EmptySpace);
                        }

                        @Override
                        protected String getConfiguredText() {
                            return TEXTS.get((String)"CheckAll");
                        }

                        @Override
                        protected void execAction() {
                            OpenFormsField.this.checkAllKeys();
                        }
                    }

                    @Order(value=20.0)
                    @ClassId(value="94666a06-2f50-4242-b3ba-5a75252eaf44")
                    public class UncheckAllMenu
                    extends AbstractMenu {
                        @Override
                        protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                            return CollectionUtility.hashSet((Object)TableMenuType.EmptySpace);
                        }

                        @Override
                        protected String getConfiguredText() {
                            return TEXTS.get((String)"UncheckAll");
                        }

                        @Override
                        protected void execAction() {
                            OpenFormsField.this.uncheckAllKeys();
                        }
                    }
                }
            }
        }
    }

    public class NewHandler
    extends AbstractFormHandler {
        @Override
        protected void execPostLoad() {
            UnsavedFormChangesForm.this.touch();
        }

        @Override
        protected boolean execValidate() {
            List<IForm> invalidForms = UnsavedFormChangesForm.this.getOpenFormsField().getInvalidForms();
            if (!invalidForms.isEmpty()) {
                StringBuilder msg = new StringBuilder(TEXTS.get((String)"FormsCannotBeSaved"));
                msg.append("\n\n");
                for (IForm f : invalidForms) {
                    msg.append("- ").append(UnsavedFormChangesForm.getFormDisplayName(f)).append("\n");
                }
                MessageBoxes.createOk().withHeader(TEXTS.get((String)"NotAllCheckedFormsCanBeSaved")).withBody(msg.toString()).show();
                return false;
            }
            return true;
        }

        @Override
        protected void execStore() {
            Set formsToStore = UnsavedFormChangesForm.this.getOpenFormsField().getValue().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            IDesktop desktop = UnsavedFormChangesForm.this.getDesktop();
            for (IForm f2 : formsToStore) {
                desktop.activateForm(f2);
                if (this.isWizardContainerForm(f2)) {
                    f2.getWizard().doSuspend();
                    continue;
                }
                f2.doOk();
            }
            UnsavedFormChangesForm.this.m_forms.stream().filter(f -> !formsToStore.contains(f) && this.isWizardContainerForm((IForm)f)).map(IForm::getWizard).forEach(this::closeWizard);
        }

        protected boolean isWizardContainerForm(IForm form) {
            return form instanceof IWizardContainerForm;
        }

        protected void closeWizard(IWizard wizard) {
            wizard.doSuspend();
        }
    }

    @ClassId(value="70052229-e6e5-43f3-bac5-cabe6e4525d3")
    public static class UnsavedFormsLookupCall
    extends LocalLookupCall<ArrayDeque<IForm>> {
        private List<IForm> m_unsavedForms;
        private HashMap<IForm, ArrayDeque<IForm>> m_unsavedFormsStructured;

        public void setUnsavedForms(List<IForm> unsavedForms) {
            this.m_unsavedForms = unsavedForms;
            this.m_unsavedFormsStructured = new HashMap();
            for (IForm f : unsavedForms) {
                IForm topDisplayParent = UnsavedFormChangesForm.getTopDisplayParent(f);
                ArrayDeque<IForm> deque = this.m_unsavedFormsStructured.get(topDisplayParent);
                if (deque == null) {
                    deque = new ArrayDeque();
                }
                deque.add(f);
                this.m_unsavedFormsStructured.put(topDisplayParent, deque);
            }
        }

        protected List<? extends ILookupRow<ArrayDeque<IForm>>> execCreateLookupRows() {
            ArrayList<LookupRow> formRows = new ArrayList<LookupRow>();
            for (Map.Entry<IForm, ArrayDeque<IForm>> e : this.m_unsavedFormsStructured.entrySet()) {
                String text = UnsavedFormChangesForm.getFormDisplayName(e.getKey());
                formRows.add(new LookupRow(e.getValue(), text).withTooltipText(text));
            }
            return formRows;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.m_unsavedForms == null ? 0 : this.m_unsavedForms.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            UnsavedFormsLookupCall other = (UnsavedFormsLookupCall)((Object)obj);
            return !(this.m_unsavedForms == null ? other.m_unsavedForms != null : !this.m_unsavedForms.equals(other.m_unsavedForms));
        }
    }
}

