/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bench.layout;

import java.util.Arrays;
import org.eclipse.scout.rt.client.ui.desktop.bench.layout.BenchColumnData;

public class BenchLayoutData {
    public static final int WEST = 0;
    public static final int CENTER = 1;
    public static final int EAST = 2;
    private String m_cacheKey;
    private final BenchColumnData[] m_columns = new BenchColumnData[]{new BenchColumnData(), new BenchColumnData(), new BenchColumnData()};

    public BenchLayoutData withCacheKey(String cacheKey) {
        this.m_cacheKey = cacheKey;
        return this;
    }

    public String getCacheKey() {
        return this.m_cacheKey;
    }

    public BenchColumnData[] getColumns() {
        return this.m_columns;
    }

    public BenchLayoutData withWest(BenchColumnData data) {
        this.m_columns[0] = data;
        return this;
    }

    public BenchColumnData getWest() {
        return this.m_columns[0];
    }

    public BenchLayoutData withCenter(BenchColumnData data) {
        this.m_columns[1] = data;
        return this;
    }

    public BenchColumnData getCenter() {
        return this.m_columns[1];
    }

    public BenchLayoutData withEast(BenchColumnData data) {
        this.m_columns[2] = data;
        return this;
    }

    public BenchColumnData getEast() {
        return this.m_columns[2];
    }

    public BenchLayoutData copy() {
        return this.copyValues(new BenchLayoutData());
    }

    protected BenchLayoutData copyValues(BenchLayoutData copy) {
        copy.withCacheKey(this.getCacheKey());
        if (this.getCenter() != null) {
            copy.withCenter(this.getCenter().copy());
        }
        if (this.getEast() != null) {
            copy.withEast(this.getEast().copy());
        }
        if (this.getWest() != null) {
            copy.withWest(this.getWest().copy());
        }
        return copy;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.m_cacheKey == null ? 0 : this.m_cacheKey.hashCode());
        result = 31 * result + Arrays.hashCode(this.m_columns);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BenchLayoutData other = (BenchLayoutData)obj;
        if (this.m_cacheKey == null ? other.m_cacheKey != null : !this.m_cacheKey.equals(other.m_cacheKey)) {
            return false;
        }
        return Arrays.equals(this.m_columns, other.m_columns);
    }
}

