/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bench.layout;

public class FlexboxLayoutData {
    private boolean m_relative = true;
    private double m_grow = 1.0;
    private double m_shrink = 1.0;
    private double m_initial = 33.333333333333336;

    public FlexboxLayoutData withRelative(boolean relative) {
        this.m_relative = relative;
        return this;
    }

    public boolean isRelative() {
        return this.m_relative;
    }

    public FlexboxLayoutData withGrow(double grow) {
        this.m_grow = grow;
        return this;
    }

    public double getGrow() {
        return this.m_grow;
    }

    public FlexboxLayoutData withShrink(double shrink) {
        this.m_shrink = shrink;
        return this;
    }

    public double getShrink() {
        return this.m_shrink;
    }

    public FlexboxLayoutData withInitial(double initial) {
        this.m_initial = initial;
        return this;
    }

    public double getInitial() {
        return this.m_initial;
    }

    public FlexboxLayoutData copy() {
        return this.copyValues(new FlexboxLayoutData());
    }

    protected FlexboxLayoutData copyValues(FlexboxLayoutData copy) {
        copy.withInitial(this.getInitial()).withRelative(this.isRelative()).withGrow(this.getGrow()).withShrink(this.getShrink());
        return copy;
    }

    public int hashCode() {
        int result = 1;
        long temp = Double.doubleToLongBits(this.m_initial);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.m_relative ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.m_grow);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m_shrink);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlexboxLayoutData other = (FlexboxLayoutData)obj;
        if (Double.doubleToLongBits(this.m_initial) != Double.doubleToLongBits(other.m_initial)) {
            return false;
        }
        if (this.m_relative != other.m_relative) {
            return false;
        }
        if (Double.doubleToLongBits(this.m_grow) != Double.doubleToLongBits(other.m_grow)) {
            return false;
        }
        return Double.doubleToLongBits(this.m_shrink) == Double.doubleToLongBits(other.m_shrink);
    }
}

