/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bookmark;

import java.security.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.rt.client.services.common.bookmark.IBookmarkService;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenuSeparator;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TreeMenuType;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.BookmarkFolderForm;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.BookmarkForm;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.IBookmarkForm;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.IBookmarkNode;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.view.IOpenBookmarkCommand;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.view.IPublishBookmarkCommand;
import org.eclipse.scout.rt.client.ui.dnd.JavaTransferObject;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.treefield.AbstractTreeField;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxes;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.visitor.DepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.IDepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.security.PublishUserBookmarkPermission;
import org.eclipse.scout.rt.shared.services.common.bookmark.AbstractPageState;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.eclipse.scout.rt.shared.services.common.bookmark.TablePageState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="bf0f76a0-fa75-43bf-a1c1-21839934aa7c")
public abstract class AbstractBookmarkTreeField
extends AbstractTreeField {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBookmarkTreeField.class);
    private BookmarkFolder m_bookmarkRootFolder;
    private IPublishBookmarkCommand m_publishBookmarkCommand;
    private IOpenBookmarkCommand m_openBookmarkCommand;

    public AbstractBookmarkTreeField() {
        this(true);
    }

    public AbstractBookmarkTreeField(boolean callInitializer) {
        super(callInitializer);
    }

    public BookmarkFolder getBookmarkRootFolder() {
        return this.m_bookmarkRootFolder;
    }

    public void setBookmarkRootFolder(BookmarkFolder bookmarkRootFolder) {
        this.m_bookmarkRootFolder = bookmarkRootFolder;
    }

    private static boolean isBookmarkNode(ITreeNode node) {
        return node instanceof BookmarkNode;
    }

    private static boolean isFolderNode(ITreeNode node) {
        return node instanceof FolderNode;
    }

    public void injectPublishBookmarkCommand(IPublishBookmarkCommand command) {
        this.m_publishBookmarkCommand = command;
    }

    public void injectOpenBookmarkCommand(IOpenBookmarkCommand command) {
        this.m_openBookmarkCommand = command;
    }

    private BookmarkFolder getParentBookmarkFolder(ITreeNode node) {
        BookmarkFolder folder = this.getBookmarkRootFolder();
        ITreeNode parentNode = node.getParentNode();
        if (AbstractBookmarkTreeField.isFolderNode(parentNode)) {
            folder = (BookmarkFolder)parentNode.getCell().getValue();
        }
        return folder;
    }

    @Override
    protected int getConfiguredGridW() {
        return 1;
    }

    @Override
    protected int getConfiguredGridH() {
        return 8;
    }

    @Override
    protected boolean getConfiguredAutoLoad() {
        return false;
    }

    @Override
    protected boolean getConfiguredLabelVisible() {
        return false;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    protected String getConfiguredGlobalBookmarkLabel() {
        return TEXTS.get((String)"GlobalBookmarks");
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    protected String getConfiguredPrivateBookmarkLabel() {
        return TEXTS.get((String)"PrivateBookmarks");
    }

    @ConfigProperty(value="FORM")
    @Order(value=30.0)
    protected Class<? extends IBookmarkForm> getConfiguredBookmarkForm() {
        return BookmarkForm.class;
    }

    protected Permission getDeletePermission(List<Bookmark> bookmarks) {
        return this.getDeletePermission();
    }

    protected Permission getUpdatePermission(List<Bookmark> bookmarks) {
        return this.getUpdatePermission();
    }

    protected Permission getPublishPermission(Bookmark bookmark) {
        return this.getPublishPermission();
    }

    protected Permission getDeletePermission() {
        return null;
    }

    protected Permission getUpdatePermission() {
        return null;
    }

    protected Permission getPublishPermission() {
        return new PublishUserBookmarkPermission();
    }

    public void populateTree() {
        block5: {
            try {
                try {
                    this.getTree().setTreeChanging(true);
                    this.getTree().removeAllChildNodes(this.getTree().getRootNode());
                    this.populateFolderContentRec(this.getTree().getRootNode(), this.getBookmarkRootFolder());
                }
                catch (RuntimeException | PlatformError e) {
                    LOG.error(null, e);
                    this.getTree().setTreeChanging(false);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.getTree().setTreeChanging(false);
                throw throwable;
            }
            this.getTree().setTreeChanging(false);
        }
        this.getTree().expandAll(this.getTree().getRootNode());
    }

    private void populateFolderContentRec(ITreeNode parent, BookmarkFolder newParent) {
        AbstractTreeNode newNode;
        for (BookmarkFolder newFolder : newParent.getFolders()) {
            newNode = new FolderNode(newFolder);
            this.getTree().addChildNode(parent, newNode);
            this.populateFolderContentRec(newNode, newFolder);
        }
        for (Bookmark b : newParent.getBookmarks()) {
            newNode = new BookmarkNode();
            newNode.getCellForUpdate().setValue(b);
            this.getTree().addChildNode(parent, newNode);
        }
    }

    private void rebuildBookmarkModel() {
        DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

            public TreeVisitResult preVisit(ITreeNode node, int level, int index) {
                BookmarkFolder bmFolder = null;
                if (node == AbstractBookmarkTreeField.this.getTree().getRootNode()) {
                    bmFolder = AbstractBookmarkTreeField.this.getBookmarkRootFolder();
                } else if (AbstractBookmarkTreeField.isFolderNode(node)) {
                    bmFolder = (BookmarkFolder)node.getCell().getValue();
                }
                if (bmFolder != null) {
                    bmFolder.getFolders().clear();
                    bmFolder.getBookmarks().clear();
                    ArrayList<BookmarkFolder> folderList = new ArrayList<BookmarkFolder>();
                    for (ITreeNode n : node.getChildNodes()) {
                        if (!AbstractBookmarkTreeField.isFolderNode(n)) continue;
                        BookmarkFolder f = (BookmarkFolder)n.getCell().getValue();
                        folderList.add(f);
                    }
                    folderList.sort((f1, f2) -> StringUtility.compareIgnoreCase((String)f1.getTitle(), (String)f2.getTitle()));
                    bmFolder.getFolders().addAll(folderList);
                    for (ITreeNode n : node.getChildNodes()) {
                        if (!AbstractBookmarkTreeField.isBookmarkNode(n)) continue;
                        bmFolder.getBookmarks().add((Bookmark)n.getCell().getValue());
                    }
                }
                return TreeVisitResult.CONTINUE;
            }
        };
        this.getTree().visitTree((IDepthFirstTreeVisitor<ITreeNode>)v);
        ((IBookmarkService)BEANS.get(IBookmarkService.class)).storeBookmarks();
    }

    private void refreshBookmarkModel() {
        DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

            public TreeVisitResult preVisit(ITreeNode node, int level, int index) {
                BookmarkFolder bmFolder = null;
                if (node == AbstractBookmarkTreeField.this.getTree().getRootNode()) {
                    bmFolder = AbstractBookmarkTreeField.this.getBookmarkRootFolder();
                } else if (AbstractBookmarkTreeField.isFolderNode(node)) {
                    bmFolder = (BookmarkFolder)node.getCell().getValue();
                }
                if (bmFolder != null) {
                    bmFolder.getFolders().clear();
                    bmFolder.getBookmarks().clear();
                    for (ITreeNode n : node.getChildNodes()) {
                        if (AbstractBookmarkTreeField.isFolderNode(n)) {
                            bmFolder.getFolders().add((BookmarkFolder)n.getCell().getValue());
                            continue;
                        }
                        if (!AbstractBookmarkTreeField.isBookmarkNode(n)) continue;
                        bmFolder.getBookmarks().add((Bookmark)n.getCell().getValue());
                    }
                }
                return TreeVisitResult.CONTINUE;
            }
        };
        this.getTree().visitTree((IDepthFirstTreeVisitor<ITreeNode>)v);
        ((IBookmarkService)BEANS.get(IBookmarkService.class)).storeBookmarks();
    }

    private class BookmarkNode
    extends AbstractTreeNode
    implements IBookmarkNode {
        private BookmarkNode() {
        }

        @Override
        protected boolean getConfiguredLeaf() {
            return true;
        }

        @Override
        protected void execDecorateCell(Cell cell) {
            Bookmark bm = (Bookmark)cell.getValue();
            if (bm != null) {
                if (bm.getKeyStroke() != null) {
                    cell.setText(String.valueOf(bm.getTitle()) + " [" + bm.getKeyStroke() + "]");
                } else {
                    cell.setText(bm.getTitle());
                }
                cell.setTooltipText(bm.getText());
                if (!StringUtility.isNullOrEmpty((CharSequence)bm.getIconId())) {
                    cell.setIconId(bm.getIconId());
                }
                if (bm.isNew()) {
                    cell.setFont(new FontSpec(null, 1, 0));
                }
            }
        }

        @Override
        public Bookmark getBookmark() {
            BookmarkNode node = this;
            return (Bookmark)node.getCell().getValue();
        }

        @Override
        public BookmarkFolder getParentFolder() {
            BookmarkNode node = this;
            return (BookmarkFolder)node.getParentNode().getCell().getValue();
        }

        @Order(value=100.0)
        @ClassId(value="cb7bf775-860c-47db-a000-3e8066459eb5")
        public class ApplyToSearchMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return TEXTS.get((String)"BookmarksApplyToCurrentSearch");
            }

            @Override
            protected void execAction() {
                IForm searchForm;
                BookmarkNode node = BookmarkNode.this;
                Bookmark bm = (Bookmark)node.getCell().getValue();
                IDesktop desktop = ClientSessionProvider.currentSession().getDesktop();
                Boolean success = null;
                if (desktop != null && (searchForm = desktop.getPageSearchForm()) != null) {
                    for (AbstractPageState state : bm.getPath()) {
                        if (!(state instanceof TablePageState)) continue;
                        TablePageState tablePageState = (TablePageState)state;
                        try {
                            searchForm.loadFromXmlString(tablePageState.getSearchFormState());
                            searchForm.doSaveWithoutMarkerChange();
                            success = true;
                            break;
                        }
                        catch (RuntimeException | PlatformError throwable) {
                            success = false;
                        }
                    }
                }
                if (success != null && !success.booleanValue()) {
                    MessageBoxes.createOk().withBody(TEXTS.get((String)"ApplyBookmarkToSearchFailedMessage")).show();
                }
            }
        }

        @Order(value=70.0)
        @ClassId(value="f35613ce-57f5-4507-9fe6-e7c47ee83ea6")
        public class DeleteMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return TEXTS.get((String)"DeleteBookmarkMenu");
            }

            @Override
            protected String getConfiguredKeyStroke() {
                return "delete";
            }

            @Override
            protected void execOwnerValueChanged(Object newOwnerValue) {
                ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>();
                ITree tree = BookmarkNode.this.getTree();
                for (ITreeNode node : tree.getSelectedNodes()) {
                    if (!AbstractBookmarkTreeField.isBookmarkNode(node)) continue;
                    bookmarks.add((Bookmark)node.getCell().getValue());
                }
                this.setEnabledPermission(AbstractBookmarkTreeField.this.getDeletePermission(bookmarks));
            }

            @Override
            protected void execAction() {
                ArrayList<String> items = new ArrayList<String>();
                ArrayList<ITreeNode> filteredNodes = new ArrayList<ITreeNode>();
                ITree tree = BookmarkNode.this.getTree();
                for (ITreeNode node : tree.getSelectedNodes()) {
                    if (!AbstractBookmarkTreeField.isBookmarkNode(node)) continue;
                    items.add(node.getCell().toPlainText());
                    filteredNodes.add(node);
                }
                if (items.size() <= 1 || MessageBoxes.showDeleteConfirmationMessage(items.toArray(new String[0]))) {
                    for (ITreeNode node : filteredNodes) {
                        tree.removeNode(node);
                    }
                    AbstractBookmarkTreeField.this.rebuildBookmarkModel();
                }
            }
        }

        @Order(value=50.0)
        @ClassId(value="1aa820d0-7dff-4007-a840-0ce266b94c1e")
        public class EditMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return TEXTS.get((String)"EditBookmarkMenu");
            }

            @Override
            protected void execOwnerValueChanged(Object newOwnerValue) {
                ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>();
                ITree tree = BookmarkNode.this.getTree();
                for (ITreeNode node : tree.getSelectedNodes()) {
                    if (!AbstractBookmarkTreeField.isBookmarkNode(node)) continue;
                    bookmarks.add((Bookmark)node.getCell().getValue());
                }
                this.setEnabledPermission(AbstractBookmarkTreeField.this.getUpdatePermission(bookmarks));
            }

            @Override
            protected void execAction() {
                BookmarkNode node = BookmarkNode.this;
                Bookmark bm = (Bookmark)node.getCell().getValue();
                IBookmarkForm form = null;
                if (AbstractBookmarkTreeField.this.getConfiguredBookmarkForm() != null) {
                    try {
                        form = AbstractBookmarkTreeField.this.getConfiguredBookmarkForm().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating instance of class '" + AbstractBookmarkTreeField.this.getConfiguredBookmarkForm().getName() + "'.", new Object[]{e}));
                    }
                }
                if (form == null) {
                    form = new BookmarkForm();
                }
                form.setBookmark(bm);
                form.setBookmarkRootFolder(AbstractBookmarkTreeField.this.getBookmarkRootFolder());
                BookmarkFolder oldBmFolder = AbstractBookmarkTreeField.this.getParentBookmarkFolder(BookmarkNode.this);
                boolean oldIsNew = bm.isNew();
                if (oldBmFolder != form.getBookmarkRootFolder()) {
                    form.setFolder(oldBmFolder);
                }
                form.startModify();
                form.waitFor();
                if (form.isFormStored()) {
                    BookmarkFolder newBmFolder;
                    ITree tree = BookmarkNode.this.getTree();
                    bm.setTitle(form.getBookmark().getTitle());
                    bm.setKeyStroke(form.getBookmark().getKeyStroke());
                    bm.setKind(form.getBookmark().getKind());
                    bm.setIconId(form.getBookmark().getIconId());
                    bm.setOrder(form.getBookmark().getOrder());
                    BookmarkFolder bookmarkFolder = newBmFolder = form.getFolder() != null ? form.getFolder() : form.getBookmarkRootFolder();
                    if (ObjectUtility.notEquals((Object)oldBmFolder, (Object)newBmFolder)) {
                        final AtomicReference<ITreeNode> newContainerNode = new AtomicReference<ITreeNode>(BookmarkNode.this.getTree().getRootNode());
                        DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

                            public TreeVisitResult preVisit(ITreeNode n, int level, int index) {
                                if (AbstractBookmarkTreeField.isFolderNode(n) && newBmFolder.equals(n.getCell().getValue())) {
                                    newContainerNode.set(n);
                                    return TreeVisitResult.TERMINATE;
                                }
                                return TreeVisitResult.CONTINUE;
                            }
                        };
                        tree.visitTree((IDepthFirstTreeVisitor<ITreeNode>)v);
                        tree.removeNode(node);
                        tree.addChildNode(newContainerNode.get(), node);
                        AbstractBookmarkTreeField.this.rebuildBookmarkModel();
                    } else {
                        tree.updateNode(node);
                        AbstractBookmarkTreeField.this.refreshBookmarkModel();
                    }
                } else if (oldIsNew != form.getBookmark().isNew()) {
                    AbstractBookmarkTreeField.this.refreshBookmarkModel();
                }
            }
        }

        @Order(value=40.0)
        @ClassId(value="47ef0581-37b2-45e7-839e-513d77bb94a1")
        public class OpenMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return TEXTS.get((String)"ActivateBookmarkMenu");
            }

            @Override
            protected void execAction() {
                BookmarkNode node = BookmarkNode.this;
                Bookmark bm = (Bookmark)node.getCell().getValue();
                if (AbstractBookmarkTreeField.this.m_openBookmarkCommand != null) {
                    AbstractBookmarkTreeField.this.m_openBookmarkCommand.openBookmark(bm);
                } else {
                    ClientSessionProvider.currentSession().getDesktop().activateBookmark(bm);
                }
            }
        }

        @Order(value=90.0)
        @ClassId(value="7962bd36-8f6e-420e-a493-586ddfda83f4")
        public class PublishMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return TEXTS.get((String)"BookmarksPublishMenu");
            }

            @Override
            protected void execOwnerValueChanged(Object newOwnerValue) {
                Bookmark bookmark = null;
                ITreeNode selectedNode = BookmarkNode.this.getTree().getSelectedNode();
                if (AbstractBookmarkTreeField.isBookmarkNode(selectedNode)) {
                    bookmark = (Bookmark)selectedNode.getCell().getValue();
                }
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getPublishPermission(bookmark));
            }

            @Override
            protected void execAction() {
                if (AbstractBookmarkTreeField.this.m_publishBookmarkCommand != null) {
                    BookmarkNode node = BookmarkNode.this;
                    Bookmark bm = (Bookmark)node.getCell().getValue();
                    BookmarkFolder spoolFolder = new BookmarkFolder();
                    spoolFolder.getBookmarks().add(bm);
                    AbstractBookmarkTreeField.this.m_publishBookmarkCommand.publishBookmark(spoolFolder);
                }
            }
        }

        @Order(value=80.0)
        @ClassId(value="a8c515ec-457e-42b9-af4d-82996573df01")
        public class SeparatorMenu1
        extends AbstractMenuSeparator {
        }

        @Order(value=60.0)
        @ClassId(value="fe15adbb-b0fc-49ac-81cd-aac2806fa28e")
        public class UpdateWithCurrentMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return TEXTS.get((String)"UpdateBookmarkMenu");
            }

            @Override
            protected void execOwnerValueChanged(Object newOwnerValue) {
                ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>();
                ITree tree = BookmarkNode.this.getTree();
                for (ITreeNode node : tree.getSelectedNodes()) {
                    if (!AbstractBookmarkTreeField.isBookmarkNode(node)) continue;
                    bookmarks.add((Bookmark)node.getCell().getValue());
                }
                this.setEnabledPermission(AbstractBookmarkTreeField.this.getDeletePermission(bookmarks));
            }

            @Override
            protected void execAction() {
                BookmarkNode node = BookmarkNode.this;
                Bookmark bm = (Bookmark)node.getCell().getValue();
                IBookmarkService service = (IBookmarkService)BEANS.get(IBookmarkService.class);
                service.updateBookmark(bm);
                service.storeBookmarks();
            }
        }
    }

    protected class FolderNode
    extends AbstractTreeNode {
        protected FolderNode(BookmarkFolder bookmarkFolder) {
            super(false);
            this.getCellForUpdate().setValue(bookmarkFolder);
            this.callInitializer();
        }

        @Override
        protected void execDecorateCell(Cell cell) {
            BookmarkFolder bmFolder = (BookmarkFolder)this.getCell().getValue();
            String title = bmFolder.getTitle();
            if ("[INBOX]".equals(title)) {
                title = AbstractBookmarkTreeField.this.getConfiguredGlobalBookmarkLabel();
            }
            cell.setText(title);
        }

        private boolean isProtected() {
            BookmarkFolder bmFolder = (BookmarkFolder)this.getCell().getValue();
            return "[INBOX]".equals(bmFolder.getTitle()) || "[SPOOL]".equals(bmFolder.getTitle());
        }

        @Order(value=40.0)
        @ClassId(value="a47a34fe-72ce-4964-8552-1711d5f63036")
        public class DeleteMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return TEXTS.get((String)"DeleteFolderMenu");
            }

            @Override
            protected String getConfiguredKeyStroke() {
                return "delete";
            }

            @Override
            protected void execInitAction() {
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getDeletePermission());
                this.setEnabled(!FolderNode.this.isProtected());
                this.setText(this.getConfiguredText());
            }

            @Override
            protected void execOwnerValueChanged(Object newOwnerValue) {
                for (ITreeNode node : FolderNode.this.getTree().getSelectedNodes()) {
                    if (node instanceof FolderNode) continue;
                    this.setText(TEXTS.get((String)"DeleteMenu"));
                }
            }

            @Override
            protected void execAction() {
                ITree tree = FolderNode.this.getTree();
                HashSet<ITreeNode> folders = new HashSet<ITreeNode>();
                HashSet<ITreeNode> bookmarks = new HashSet<ITreeNode>();
                for (ITreeNode node : tree.getSelectedNodes()) {
                    this.addNodeFoldersToSet(folders, node);
                    this.addNodeBookmarksToSet(bookmarks, node);
                }
                ArrayList<String> names = new ArrayList<String>();
                for (ITreeNode folder : folders) {
                    names.add(((BookmarkFolder)folder.getCell().getValue()).getTitle());
                }
                for (ITreeNode bookmark : bookmarks) {
                    ArrayList<Bookmark> check = new ArrayList<Bookmark>();
                    check.add((Bookmark)bookmark.getCell().getValue());
                    if (!ACCESS.check((Permission)AbstractBookmarkTreeField.this.getDeletePermission(check))) continue;
                    names.add(((Bookmark)bookmark.getCell().getValue()).getTitle());
                }
                if (MessageBoxes.showDeleteConfirmationMessage(names.toArray(new String[0]))) {
                    for (ITreeNode bookmark : bookmarks) {
                        tree.removeNode(bookmark);
                    }
                    for (ITreeNode bookmark : folders) {
                        tree.removeNode(bookmark);
                    }
                    AbstractBookmarkTreeField.this.refreshBookmarkModel();
                }
            }

            private void addNodeBookmarksToSet(Set<ITreeNode> items, ITreeNode node) {
                if (AbstractBookmarkTreeField.isFolderNode(node)) {
                    for (ITreeNode child : node.getChildNodes()) {
                        this.addNodeBookmarksToSet(items, child);
                    }
                } else if (AbstractBookmarkTreeField.isBookmarkNode(node)) {
                    items.add(node);
                }
            }

            private void addNodeFoldersToSet(Set<ITreeNode> items, ITreeNode node) {
                if (AbstractBookmarkTreeField.isFolderNode(node)) {
                    items.add(node);
                    for (ITreeNode child : node.getChildNodes()) {
                        this.addNodeFoldersToSet(items, child);
                    }
                }
            }
        }

        @Order(value=30.0)
        @ClassId(value="f5760597-fd46-4859-aaef-40a024685495")
        public class RenameMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return TEXTS.get((String)"RenameBookmarkFolderMenu");
            }

            @Override
            protected void execInitAction() {
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getUpdatePermission());
                this.setEnabled(!FolderNode.this.isProtected());
            }

            @Override
            protected void execAction() {
                FolderNode node = FolderNode.this;
                BookmarkFolder bmFolder = (BookmarkFolder)node.getCell().getValue();
                BookmarkFolderForm form = new BookmarkFolderForm();
                form.getNameField().setValue(bmFolder.getTitle());
                form.startModify();
                form.waitFor();
                if (form.isFormStored()) {
                    bmFolder.setTitle((String)form.getNameField().getValue());
                    FolderNode.this.getTree().updateNode(node);
                    AbstractBookmarkTreeField.this.refreshBookmarkModel();
                }
            }
        }
    }

    @ClassId(value="bdd00c51-0678-4fcd-b1ff-be172832a196")
    public class Tree
    extends AbstractTree {
        @Override
        protected boolean getConfiguredDragEnabled() {
            return true;
        }

        @Override
        protected int getConfiguredDropType() {
            return 2;
        }

        @Override
        protected void execNodeAction(ITreeNode node) {
            if (AbstractBookmarkTreeField.isBookmarkNode(node)) {
                Bookmark bm = (Bookmark)node.getCell().getValue();
                ClientSessionProvider.currentSession().getDesktop().activateBookmark(bm);
            }
        }

        @Override
        protected void execDrop(ITreeNode dropNode, TransferObject transfer) {
            if (transfer instanceof JavaTransferObject) {
                block19: {
                    try {
                        try {
                            AbstractBookmarkTreeField.this.getTree().setTreeChanging(true);
                            List<ITreeNode> elements = ((JavaTransferObject)transfer).getLocalObjectAsList(ITreeNode.class);
                            if (CollectionUtility.hasElements(elements)) {
                                boolean updateTree = false;
                                HashSet<ITreeNode> draggedFolders = new HashSet<ITreeNode>();
                                for (ITreeNode source : elements) {
                                    if (source == dropNode || source.getTree() != AbstractBookmarkTreeField.this.getTree()) continue;
                                    ITreeNode target = dropNode;
                                    if (AbstractBookmarkTreeField.isFolderNode(source) && AbstractBookmarkTreeField.isBookmarkNode(target)) {
                                        target = target.getParentNode();
                                    }
                                    if (AbstractBookmarkTreeField.isBookmarkNode(source) && AbstractBookmarkTreeField.isFolderNode(target)) {
                                        AbstractBookmarkTreeField.this.getTree().removeNode(source);
                                        AbstractBookmarkTreeField.this.getTree().addChildNode(target, source);
                                        updateTree = true;
                                        continue;
                                    }
                                    if (AbstractBookmarkTreeField.isBookmarkNode(source) && AbstractBookmarkTreeField.isBookmarkNode(target)) {
                                        AbstractBookmarkTreeField.this.getTree().removeNode(source);
                                        int pos = target.getChildNodeIndex();
                                        AbstractBookmarkTreeField.this.getTree().addChildNode(pos, target.getParentNode(), source);
                                        continue;
                                    }
                                    if (AbstractBookmarkTreeField.isFolderNode(source) && target == null) {
                                        AbstractBookmarkTreeField.this.getTree().removeNode(source);
                                        AbstractBookmarkTreeField.this.getTree().addChildNode(AbstractBookmarkTreeField.this.getTree().getRootNode(), source);
                                        continue;
                                    }
                                    if (!AbstractBookmarkTreeField.isFolderNode(source) || !AbstractBookmarkTreeField.isFolderNode(target)) continue;
                                    boolean parentWasDragged = false;
                                    for (ITreeNode parent : draggedFolders) {
                                        if (!AbstractBookmarkTreeField.this.getTree().isAncestorNodeOf(parent, source)) continue;
                                        parentWasDragged = true;
                                        draggedFolders.add(source);
                                    }
                                    if (parentWasDragged) continue;
                                    if (AbstractBookmarkTreeField.this.getTree().isAncestorNodeOf(source, target)) {
                                        ITreeNode sourceParent = source.getParentNode();
                                        if (sourceParent == null) continue;
                                        int dragPos = source.getChildNodeIndex();
                                        ITreeNode targetAncestor = target;
                                        ITreeNode targetAncestorWalkThrough = target;
                                        while (targetAncestorWalkThrough.getParentNode() != source) {
                                            if (!elements.contains(targetAncestor.getParentNode())) {
                                                targetAncestor = targetAncestorWalkThrough.getParentNode();
                                            }
                                            targetAncestorWalkThrough = targetAncestorWalkThrough.getParentNode();
                                        }
                                        AbstractBookmarkTreeField.this.getTree().removeNode(targetAncestor);
                                        AbstractBookmarkTreeField.this.getTree().removeNode(source);
                                        AbstractBookmarkTreeField.this.getTree().addChildNode(dragPos, sourceParent, targetAncestor);
                                        AbstractBookmarkTreeField.this.getTree().addChildNode(target, source);
                                        continue;
                                    }
                                    AbstractBookmarkTreeField.this.getTree().removeNode(source);
                                    AbstractBookmarkTreeField.this.getTree().addChildNode(target, source);
                                }
                                if (updateTree) {
                                    AbstractBookmarkTreeField.this.refreshBookmarkModel();
                                }
                            }
                        }
                        catch (RuntimeException | PlatformError e) {
                            LOG.error(null, e);
                            AbstractBookmarkTreeField.this.getTree().setTreeChanging(false);
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        AbstractBookmarkTreeField.this.getTree().setTreeChanging(false);
                        throw throwable;
                    }
                    AbstractBookmarkTreeField.this.getTree().setTreeChanging(false);
                }
                try {
                    AbstractBookmarkTreeField.this.rebuildBookmarkModel();
                }
                catch (RuntimeException | PlatformError e) {
                    LOG.error(null, e);
                }
            }
        }

        private void addNewFolder(ITreeNode parentNode) {
            if (parentNode == null) {
                parentNode = this.getRootNode();
            }
            BookmarkFolderForm form = new BookmarkFolderForm();
            form.startModify();
            form.waitFor();
            if (form.isFormStored()) {
                BookmarkFolder bmFolder = new BookmarkFolder();
                bmFolder.setTitle((String)form.getNameField().getValue());
                FolderNode newNode = new FolderNode(bmFolder);
                ITreeNode lastFolderNode = null;
                for (ITreeNode tmp : parentNode.getChildNodes()) {
                    if (!AbstractBookmarkTreeField.isFolderNode(tmp)) break;
                    lastFolderNode = tmp;
                }
                int pos = lastFolderNode != null ? lastFolderNode.getChildNodeIndex() + 1 : 0;
                AbstractBookmarkTreeField.this.getTree().addChildNode(pos, parentNode, newNode);
                AbstractBookmarkTreeField.this.rebuildBookmarkModel();
            }
        }

        @Order(value=11.0)
        @ClassId(value="7d9a535d-3961-4c3c-8156-b006f3dc2af8")
        public class NewChildFolderMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return TEXTS.get((String)"NewBookmarkFolderMenu");
            }

            @Override
            protected void execInitAction() {
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getUpdatePermission());
            }

            @Override
            protected void execOwnerValueChanged(Object newOwnerValue) {
                ITreeNode node = Tree.this.getSelectedNode();
                this.setVisible(!AbstractBookmarkTreeField.isBookmarkNode(node));
            }

            @Override
            protected void execAction() {
                Tree.this.addNewFolder(Tree.this.getSelectedNode());
            }
        }

        @Order(value=10.0)
        @ClassId(value="f4256720-a11d-448f-87b0-21c3fae8f89f")
        public class NewRootFolderMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return TEXTS.get((String)"NewBookmarkFolderMenu");
            }

            @Override
            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                return CollectionUtility.hashSet((Object)TreeMenuType.EmptySpace);
            }

            @Override
            protected void execInitAction() {
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getUpdatePermission());
            }

            @Override
            protected void execAction() {
                Tree.this.addNewFolder(null);
            }
        }

        @Order(value=20.0)
        @ClassId(value="8a421dd6-be94-4071-9acc-675f59efb491")
        public class Separator1Menu
        extends AbstractMenuSeparator {
        }
    }
}

