/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bookmark;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkVisitor;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

@ClassId(value="a6df6454-6752-43ea-8624-26c691a1145b")
public class BookmarkFolderLookupCall
extends LocalLookupCall<BookmarkFolder> {
    private static final long serialVersionUID = 1L;
    private BookmarkFolder m_rootFolder;

    public BookmarkFolder getRootFolder() {
        return this.m_rootFolder;
    }

    public void setRootFolder(BookmarkFolder rootFolder) {
        this.m_rootFolder = rootFolder;
    }

    protected List<ILookupRow<BookmarkFolder>> execCreateLookupRows() {
        final ArrayList<ILookupRow<BookmarkFolder>> rows = new ArrayList<ILookupRow<BookmarkFolder>>();
        if (this.m_rootFolder != null) {
            this.m_rootFolder.visit(new IBookmarkVisitor(){

                public boolean visitFolder(List<BookmarkFolder> path) {
                    BookmarkFolder f;
                    if (path.size() >= 2 && !"[INBOX]".equals((f = path.get(path.size() - 1)).getTitle())) {
                        BookmarkFolder parent = null;
                        if (path.size() >= 3) {
                            parent = path.get(path.size() - 2);
                        }
                        rows.add(new LookupRow((Object)f, f.getTitle()).withParentKey((Object)parent));
                    }
                    return true;
                }

                public boolean visitBookmark(List<BookmarkFolder> path, Bookmark b) {
                    return true;
                }
            });
        }
        return rows;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_rootFolder == null ? 0 : this.m_rootFolder.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BookmarkFolderLookupCall other = (BookmarkFolderLookupCall)((Object)obj);
        return !(this.m_rootFolder == null ? other.m_rootFolder != null : !this.m_rootFolder.equals((Object)other.m_rootFolder));
    }
}

