/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bookmark.menu;

import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.services.common.bookmark.IBookmarkService;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenuSeparator;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuSeparator;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.BookmarkForm;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.IBookmarkForm;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.internal.ManageBookmarksForm;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.menu.ActivateBookmarkMenu;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.shared.security.CreateGlobalBookmarkPermission;
import org.eclipse.scout.rt.shared.security.CreateUserBookmarkPermission;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=1.0)
@ClassId(value="91003d66-44f8-44de-8740-7f15e31fad5f")
public abstract class AbstractBookmarkMenu
extends AbstractMenu {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBookmarkMenu.class);

    public AbstractBookmarkMenu() {
    }

    public AbstractBookmarkMenu(IDesktop desktop) {
    }

    @Override
    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    protected String getConfiguredText() {
        return TEXTS.get((String)"BookmarksMainMenu");
    }

    @Override
    @ConfigOperation
    @Order(value=10.0)
    protected void execInitAction() {
        ((IBookmarkService)BEANS.get(IBookmarkService.class)).addBookmarkServiceListener(e -> this.handleBookmarksChanged());
        this.handleBookmarksChanged();
    }

    @ConfigProperty(value="FORM")
    @Order(value=20.0)
    protected Class<? extends IBookmarkForm> getConfiguredBookmarkForm() {
        return BookmarkForm.class;
    }

    protected void createNewBookmark(int kind) {
        Bookmark b = ClientSessionProvider.currentSession().getDesktop().createBookmark();
        if (b != null) {
            IBookmarkService service = (IBookmarkService)BEANS.get(IBookmarkService.class);
            b.setKind(kind);
            IBookmarkForm form = null;
            if (this.getConfiguredBookmarkForm() != null) {
                try {
                    form = this.getConfiguredBookmarkForm().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating instance of class '" + this.getConfiguredBookmarkForm().getName() + "'.", new Object[]{e}));
                }
            }
            if (form == null) {
                form = new BookmarkForm();
            }
            if (kind == 2) {
                form.setBookmarkRootFolder(service.getBookmarkData().getGlobalBookmarks());
            } else if (kind == 1) {
                form.setBookmarkRootFolder(service.getBookmarkData().getUserBookmarks());
            }
            form.setBookmark(b);
            form.startNew();
            form.waitFor();
            if (form.isFormStored()) {
                b.setTitle(form.getBookmark().getTitle());
                b.setKeyStroke(form.getBookmark().getKeyStroke());
                b.setOrder(form.getBookmark().getOrder());
                BookmarkFolder folder = form.getFolder();
                if (folder == null) {
                    folder = form.getBookmarkRootFolder();
                }
                folder.getBookmarks().add(b);
                service.storeBookmarks();
            }
        }
    }

    protected void handleBookmarksChanged() {
        IBookmarkService service = (IBookmarkService)BEANS.get(IBookmarkService.class);
        List oldList = this.getChildActions();
        ArrayList<IMenu> newList = new ArrayList<IMenu>();
        for (IMenu m : oldList) {
            if (m.getClass() == AddUserBookmarkMenu.class) {
                newList.add(m);
                continue;
            }
            if (m.getClass() == AddGlobalBookmarkMenu.class) {
                newList.add(m);
                continue;
            }
            if (m.getClass() == ManageBookmarksMenu.class) {
                newList.add(m);
                continue;
            }
            if (m.getClass() == StartBookmarkMenu.class) {
                newList.add(m);
                continue;
            }
            if (m.getClass() != Separator1Menu.class) break;
            newList.add(m);
        }
        newList.add(new MenuSeparator());
        this.addBookmarkTreeInternal(service.getBookmarkData().getGlobalBookmarks(), newList);
        newList.add(new MenuSeparator());
        this.addBookmarkTreeInternal(service.getBookmarkData().getUserBookmarks(), newList);
        this.setChildActions(newList);
    }

    protected void addBookmarkTreeInternal(BookmarkFolder folder, List<IMenu> actionList) {
        for (BookmarkFolder f : folder.getFolders()) {
            MenuSeparator group = new MenuSeparator();
            group.setSeparator(false);
            group.setText(f.getTitle());
            group.setIconId(f.getIconId());
            ArrayList<IMenu> childActionList = new ArrayList<IMenu>();
            this.addBookmarkTreeInternal(f, childActionList);
            group.setChildActions(childActionList);
            actionList.add(group);
        }
        ArrayList<ActivateBookmarkMenu> newActions = new ArrayList<ActivateBookmarkMenu>();
        for (Bookmark b : folder.getBookmarks()) {
            ActivateBookmarkMenu menu = new ActivateBookmarkMenu(b);
            menu.init();
            newActions.add(menu);
        }
        actionList.addAll(newActions);
    }

    @Order(value=2.0)
    @ClassId(value="f0c60ee8-e2ff-44ee-8eac-63032801efc9")
    public class AddGlobalBookmarkMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return TEXTS.get((String)"GlobalBookmarksAddMenu");
        }

        @Override
        protected void execInitAction() {
            this.setVisiblePermission((Permission)new CreateGlobalBookmarkPermission());
        }

        @Override
        protected void execAction() {
            ((IBookmarkService)BEANS.get(IBookmarkService.class)).loadBookmarks();
            AbstractBookmarkMenu.this.createNewBookmark(2);
        }
    }

    @Order(value=1.0)
    @ClassId(value="42aecebe-fee7-4149-aec3-b90df48f3f52")
    public class AddUserBookmarkMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return TEXTS.get((String)"BookmarksAddMenu");
        }

        @Override
        protected void execInitAction() {
            this.setVisiblePermission((Permission)new CreateUserBookmarkPermission());
        }

        @Override
        protected void execAction() {
            AbstractBookmarkMenu.this.createNewBookmark(1);
        }
    }

    @Order(value=3.0)
    @ClassId(value="6acccba1-83e0-4ee2-8b5d-c2a69f65217b")
    public class ManageBookmarksMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return TEXTS.get((String)"BookmarksManageMenu");
        }

        @Override
        protected void execAction() {
            ManageBookmarksForm form = new ManageBookmarksForm();
            form.startModify();
        }
    }

    @Order(value=5.0)
    @ClassId(value="9dba06d9-a3a7-4c78-bc9a-b654ea6ee5c0")
    public class Separator1Menu
    extends AbstractMenuSeparator {
    }

    @Order(value=4.0)
    @ClassId(value="3d85d9fe-2518-4a7e-8ddd-f8bb71cef646")
    public class StartBookmarkMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return TEXTS.get((String)"BookmarksStartPageMenu");
        }

        @Order(value=1.0)
        @ClassId(value="402b47ba-2116-48f4-8c6c-fe024d3ea91e")
        public class ActivateStartBookmarkMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return TEXTS.get((String)"BookmarksStartPageMenuGoto");
            }

            @Override
            protected void execAction() {
                IBookmarkService service = (IBookmarkService)BEANS.get(IBookmarkService.class);
                Bookmark b = service.getStartBookmark();
                if (b != null) {
                    try {
                        ClientSessionProvider.currentSession().getDesktop().activateBookmark(b);
                    }
                    catch (Exception e) {
                        LOG.error("Error activating bookmark", (Throwable)e);
                    }
                }
            }
        }

        @Order(value=4.0)
        @ClassId(value="6d0a7507-57c4-4d93-8552-79ba4f66eb35")
        public class DeleteStartBookmarkMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return TEXTS.get((String)"BookmarksStartPageMenuClear");
            }

            @Override
            protected void execAction() {
                IBookmarkService service = (IBookmarkService)BEANS.get(IBookmarkService.class);
                service.deleteStartBookmark();
                service.storeBookmarks();
            }
        }

        @Order(value=2.0)
        @ClassId(value="a4d4f9bc-cc5f-4d7a-a80c-bf5888f99566")
        public class Separator1Menu
        extends AbstractMenu {
            @Override
            protected boolean getConfiguredSeparator() {
                return true;
            }
        }

        @Order(value=3.0)
        @ClassId(value="2c7eca51-4a19-4825-9f45-697bacd47409")
        public class SetStartBookmarkMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return TEXTS.get((String)"BookmarksStartPageMenuSet");
            }

            @Override
            protected void execAction() {
                IBookmarkService service = (IBookmarkService)BEANS.get(IBookmarkService.class);
                service.setStartBookmark();
                service.storeBookmarks();
            }
        }
    }
}

