/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bookmark.menu;

import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="24d7ddcd-7656-487b-af5a-caf7b5d3791b")
public class ActivateBookmarkMenu
extends AbstractMenu {
    private static final Logger LOG = LoggerFactory.getLogger(ActivateBookmarkMenu.class);
    private final Bookmark m_bookmark;

    public ActivateBookmarkMenu(Bookmark b) {
        super(false);
        this.m_bookmark = b;
        this.callInitializer();
    }

    public Bookmark getBookmark() {
        return this.m_bookmark;
    }

    @Override
    protected void execInitAction() {
        if (this.m_bookmark != null) {
            this.setText(this.m_bookmark.getTitle());
            this.setIconId(this.m_bookmark.getIconId());
            this.setKeyStroke(this.m_bookmark.getKeyStroke());
        } else {
            this.setText("...");
        }
    }

    @Override
    protected void execAction() {
        if (this.m_bookmark != null) {
            try {
                ClientSessionProvider.currentSession().getDesktop().activateBookmark(this.m_bookmark);
            }
            catch (Exception t) {
                LOG.error("Could not activate bookmark {}", (Object)this.m_bookmark, (Object)t);
            }
        }
    }
}

