/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.notification;

import java.util.function.Consumer;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.notification.IDesktopNotification;
import org.eclipse.scout.rt.client.ui.notification.INotificationUIFacade;
import org.eclipse.scout.rt.client.ui.notification.Notification;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.status.Status;

@ClassId(value="cd82392d-609d-44c2-ac41-87fca7a78646")
public class DesktopNotification
extends Notification
implements IDesktopNotification {
    private final long m_duration;
    private final INotificationUIFacade m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());

    public DesktopNotification(String text) {
        this((IStatus)new Status(text, 256));
    }

    public DesktopNotification(IStatus status) {
        this(status, DEFAULT_DURATION, true);
    }

    public DesktopNotification(IStatus status, long duration, boolean closable) {
        this(status, duration, closable, false, null);
    }

    public DesktopNotification(IStatus status, long duration, boolean closable, boolean htmlEnabled, Consumer<String> appLinkConsumer) {
        super(status, closable, htmlEnabled, appLinkConsumer);
        this.m_duration = duration;
    }

    @Override
    public long getDuration() {
        return this.m_duration;
    }

    @Override
    public INotificationUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected class P_UIFacade
    implements INotificationUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void fireClosedFromUI() {
            IDesktop.CURRENT.get().getUIFacade().removedNotificationFromUI(DesktopNotification.this);
        }

        @Override
        public void fireAppLinkActionFromUI(String ref) {
            if (DesktopNotification.this.getAppLinkConsumer() != null) {
                DesktopNotification.this.getAppLinkConsumer().accept(ref);
            }
        }
    }
}

