/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionUIFacade;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.IReadOnlyMenu;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ClassId(value="28ec2113-6461-4810-9527-253d0bf68788")
public class OutlineMenuWrapper
extends AbstractWidget
implements IReadOnlyMenu {
    private final IMenu m_wrappedMenu;
    private final PropertyChangeListener m_wrappedMenuPropertyChangeListener;
    private final Set<IMenuType> m_menuTypes;
    private final Predicate<IAction> m_menuFilter;
    private final IMenuTypeMapper m_menuTypeMapper;
    public static final Predicate<IAction> ACCEPT_ALL_FILTER = action -> true;
    public static final IMenuTypeMapper AUTO_MENU_TYPE_MAPPER = menuType -> menuType;

    protected OutlineMenuWrapper(IMenu wrappedMenu) {
        this(wrappedMenu, AUTO_MENU_TYPE_MAPPER, ACCEPT_ALL_FILTER);
    }

    protected OutlineMenuWrapper(IMenu wrappedMenu, IMenuTypeMapper mapper) {
        this(wrappedMenu, mapper, ACCEPT_ALL_FILTER);
    }

    protected OutlineMenuWrapper(IMenu menu, IMenuTypeMapper menuTypeMapper, Predicate<IAction> menuFilter) {
        this.m_wrappedMenu = menu;
        this.m_menuTypeMapper = menuTypeMapper;
        this.m_menuFilter = menuFilter;
        this.m_menuTypes = this.mapMenuTypes(menu, menuTypeMapper);
        this.m_wrappedMenuPropertyChangeListener = new P_WrappedMenuPropertyChangeListener();
        this.setup(menuTypeMapper);
    }

    protected Set<IMenuType> mapMenuTypes(IMenu menu, IMenuTypeMapper mapper) {
        Set<IMenuType> originalTypes = menu.getMenuTypes();
        HashSet<IMenuType> mappedTypes = new HashSet<IMenuType>(originalTypes.size());
        for (IMenuType menuType : originalTypes) {
            mappedTypes.add(mapper.map(menuType));
        }
        return mappedTypes;
    }

    protected void setup(IMenuTypeMapper mapper) {
        this.wrapChildActions();
        this.m_wrappedMenu.addPropertyChangeListener(this.m_wrappedMenuPropertyChangeListener);
    }

    protected void wrapChildActions() {
        List childActions = this.m_wrappedMenu.getChildActions();
        ArrayList<OutlineMenuWrapper> wrappedChildActions = new ArrayList<OutlineMenuWrapper>(childActions.size());
        for (IAction a : ActionUtility.getActions(childActions, this.m_menuFilter)) {
            if (!(a instanceof IMenu)) continue;
            wrappedChildActions.add(new OutlineMenuWrapper((IMenu)a, this.m_menuTypeMapper, this.m_menuFilter));
        }
        this.propertySupport.setProperty("childActions", wrappedChildActions);
    }

    @Override
    public IMenu getWrappedMenu() {
        return this.m_wrappedMenu;
    }

    @Override
    public Object getOwnerValue() {
        return this.m_wrappedMenu.getOwnerValue();
    }

    @Override
    public void handleOwnerValueChanged(Object newValue) {
    }

    @Override
    public IWidget getParent() {
        return this.m_wrappedMenu.getParent();
    }

    @Override
    public boolean setParentInternal(IWidget parent) {
        this.unsupported();
        return false;
    }

    private void unsupported() {
        throw new UnsupportedOperationException("Method unsupported by menu-wrapper, you should change the state of the original menu instead");
    }

    private List<IMenu> getChildActionsInternal() {
        return this.propertySupport.getPropertyList("childActions");
    }

    @Override
    public boolean hasChildActions() {
        return CollectionUtility.hasElements(this.getChildActionsInternal());
    }

    @Override
    public int getChildActionCount() {
        return CollectionUtility.size(this.getChildActionsInternal());
    }

    @Override
    public List<IMenu> getChildActions() {
        return CollectionUtility.arrayList(this.getChildActionsInternal());
    }

    @Override
    public void setChildActions(Collection<? extends IMenu> actionList) {
        this.unsupported();
    }

    @Override
    public void addChildAction(IMenu action) {
        this.unsupported();
    }

    @Override
    public void addChildActions(Collection<? extends IMenu> actionList) {
        this.unsupported();
    }

    @Override
    public void removeChildAction(IMenu action) {
        this.unsupported();
    }

    @Override
    public void removeChildActions(Collection<? extends IMenu> actionList) {
        this.unsupported();
    }

    @Override
    protected void initConfig() {
    }

    @Override
    protected void disposeInternal() {
        this.m_wrappedMenu.removePropertyChangeListener(this.m_wrappedMenuPropertyChangeListener);
        super.disposeInternal();
    }

    @Override
    public void doAction() {
        this.m_wrappedMenu.doAction();
    }

    @Override
    public Object getProperty(String name) {
        return this.m_wrappedMenu.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.m_wrappedMenu.setProperty(name, value);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.m_wrappedMenu.hasProperty(name);
    }

    @Override
    public String getActionId() {
        return this.m_wrappedMenu.getActionId();
    }

    @Override
    public String getIconId() {
        return this.m_wrappedMenu.getIconId();
    }

    @Override
    public void setIconId(String iconId) {
        this.unsupported();
    }

    @Override
    public String getText() {
        return this.m_wrappedMenu.getText();
    }

    @Override
    public void setText(String text) {
        this.unsupported();
    }

    @Override
    public String getTextPosition() {
        return this.m_wrappedMenu.getTextPosition();
    }

    @Override
    public void setTextPosition(String position) {
        this.unsupported();
    }

    @Override
    public int getActionStyle() {
        return this.m_wrappedMenu.getActionStyle();
    }

    @Override
    public void setActionStyle(int actionStyle) {
        this.unsupported();
    }

    @Override
    public String getKeyStroke() {
        return this.m_wrappedMenu.getKeyStroke();
    }

    @Override
    public void setKeyStroke(String text) {
        this.unsupported();
    }

    @Override
    public int getKeyStrokeFirePolicy() {
        return this.m_wrappedMenu.getKeyStrokeFirePolicy();
    }

    @Override
    public void setKeyStrokeFirePolicy(int keyStrokeFirePolicy) {
        this.m_wrappedMenu.setKeyStrokeFirePolicy(keyStrokeFirePolicy);
    }

    @Override
    public String getTooltipText() {
        return this.m_wrappedMenu.getTooltipText();
    }

    @Override
    public void setTooltipText(String text) {
        this.m_wrappedMenu.setTooltipText(text);
    }

    @Override
    public boolean isSeparator() {
        return this.m_wrappedMenu.isSeparator();
    }

    @Override
    public void setSeparator(boolean b) {
        this.unsupported();
    }

    @Override
    public boolean isSelected() {
        return this.m_wrappedMenu.isSelected();
    }

    @Override
    public void setSelected(boolean b) {
        this.unsupported();
    }

    @Override
    public boolean isEnabled() {
        return this.m_wrappedMenu.isEnabled();
    }

    @Override
    public boolean isVisible() {
        return this.m_wrappedMenu.isVisible();
    }

    @Override
    public void setVisible(boolean b) {
        this.unsupported();
    }

    @Override
    public boolean isInheritAccessibility() {
        return this.m_wrappedMenu.isInheritAccessibility();
    }

    @Override
    public void setInheritAccessibility(boolean b) {
        this.unsupported();
    }

    @Override
    public boolean isEnabledGranted() {
        return this.m_wrappedMenu.isEnabledGranted();
    }

    @Override
    public void setVisiblePermission(Permission p) {
        this.unsupported();
    }

    @Override
    public boolean isVisibleGranted() {
        return this.m_wrappedMenu.isVisibleGranted();
    }

    @Override
    public void setVisibleGranted(boolean b) {
        this.unsupported();
    }

    @Override
    public boolean isToggleAction() {
        return this.m_wrappedMenu.isToggleAction();
    }

    @Override
    public void setToggleAction(boolean b) {
        this.unsupported();
    }

    @Override
    public IActionUIFacade getUIFacade() {
        return this.m_wrappedMenu.getUIFacade();
    }

    @Override
    public boolean isEnabledIncludingParents() {
        return this.m_wrappedMenu.isEnabledIncludingParents();
    }

    @Override
    public boolean isVisibleIncludingParents() {
        return this.m_wrappedMenu.isVisibleIncludingParents();
    }

    @Override
    public IWidget getContainer() {
        return this.m_wrappedMenu.getContainer();
    }

    @Override
    public void setContainerInternal(IWidget container) {
        this.unsupported();
    }

    public double getOrder() {
        return this.m_wrappedMenu.getOrder();
    }

    public void setOrder(double order) {
        this.m_wrappedMenu.setOrder(order);
    }

    @Override
    public String classId() {
        return this.m_wrappedMenu.classId();
    }

    @Override
    public Set<IMenuType> getMenuTypes() {
        return CollectionUtility.hashSet(this.m_menuTypes);
    }

    @Override
    public byte getHorizontalAlignment() {
        return this.m_wrappedMenu.getHorizontalAlignment();
    }

    @Override
    public void setHorizontalAlignment(byte horizontalAlignment) {
        this.m_wrappedMenu.setHorizontalAlignment(horizontalAlignment);
    }

    @Override
    public String getCssClass() {
        return this.m_wrappedMenu.getCssClass();
    }

    @Override
    public void setCssClass(String cssClass) {
        this.m_wrappedMenu.setCssClass(cssClass);
    }

    @Override
    public void setView(boolean visible, boolean enabled) {
        this.unsupported();
    }

    public void setVisible(boolean visible, String dimension) {
        this.unsupported();
    }

    public boolean isVisible(String dimension) {
        return this.m_wrappedMenu.isVisible(dimension);
    }

    @Override
    public void setEnabled(boolean enabled, boolean updateParents, boolean updateChildren, String dimension) {
    }

    @Override
    public boolean isEnabled(String dimension) {
        return this.m_wrappedMenu.isEnabled(dimension);
    }

    @Override
    public boolean isEnabled(Predicate<String> filter) {
        return this.m_wrappedMenu.isEnabled(filter);
    }

    @Override
    public boolean isPreventDoubleClick() {
        return this.m_wrappedMenu.isPreventDoubleClick();
    }

    @Override
    public void setPreventDoubleClick(boolean preventDoubleClick) {
        this.unsupported();
    }

    @Override
    public boolean isStackable() {
        return this.m_wrappedMenu.isStackable();
    }

    @Override
    public void setStackable(boolean stackable) {
        this.unsupported();
    }

    @Override
    public boolean isShrinkable() {
        return this.m_wrappedMenu.isShrinkable();
    }

    @Override
    public void setShrinkable(boolean shrinkable) {
        this.unsupported();
    }

    @Override
    public String getSubMenuVisibility() {
        return this.m_wrappedMenu.getSubMenuVisibility();
    }

    @Override
    public void setSubMenuVisibility(String subMenuVisibility) {
        this.unsupported();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[wrappedMenu=" + this.m_wrappedMenu.getClass().getSimpleName() + " text='" + this.getText() + "'" + " enabled=" + this.isEnabled() + " enabledGranted=" + this.isEnabledGranted() + " inheritAccessibility=" + this.isInheritAccessibility() + " visible=" + this.isVisible() + " visibleGranted=" + this.isVisibleGranted() + "]";
    }

    @FunctionalInterface
    public static interface IMenuTypeMapper {
        public IMenuType map(IMenuType var1);
    }

    private class P_WrappedMenuPropertyChangeListener
    implements PropertyChangeListener {
        private P_WrappedMenuPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("childActions".equals(evt.getPropertyName())) {
                OutlineMenuWrapper.this.wrapChildActions();
            } else {
                PropertyChangeEvent copy = new PropertyChangeEvent(OutlineMenuWrapper.this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                OutlineMenuWrapper.this.propertySupport.firePropertyChange(copy);
            }
        }
    }
}

