/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline.pages;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.rt.client.extension.ui.basic.tree.ITreeNodeExtension;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.pages.IPageWithTableExtension;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.pages.PageWithTableChains;
import org.eclipse.scout.rt.client.services.common.search.ISearchFilterService;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.controls.AggregateTableControl;
import org.eclipse.scout.rt.client.ui.basic.table.controls.ITableControl;
import org.eclipse.scout.rt.client.ui.basic.table.controls.SearchFormTableControl;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineMediator;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AutoLeafPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.PageReloadHandler;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.status.Status;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.concurrent.FutureCancelledError;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldBeanData;
import org.eclipse.scout.rt.shared.data.page.AbstractTablePageData;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="b131ace3-9d63-46d9-9659-e288ca26b367")
public abstract class AbstractPageWithTable<T extends ITable>
extends AbstractPage<T>
implements IPageWithTable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPageWithTable.class);
    private ISearchForm m_searchForm;
    private FormListener m_searchFormListener;

    public AbstractPageWithTable() {
        this(true, null);
    }

    public AbstractPageWithTable(boolean callInitializer) {
        this(callInitializer, null);
    }

    public AbstractPageWithTable(String userPreferenceContext) {
        this(true, userPreferenceContext);
    }

    public AbstractPageWithTable(boolean callInitializer, String userPreferenceContext) {
        super(callInitializer, userPreferenceContext);
        if (!callInitializer) {
            this.callMinimalInitializer();
        }
    }

    protected void callMinimalInitializer() {
        this.setChildrenDirty(true);
        this.setLeafInternal(this.getConfiguredLeaf());
        this.setEnabled(this.getConfiguredEnabled(), "ENABLED");
        this.setExpandedInternal(this.getConfiguredExpanded());
    }

    @Override
    protected boolean isCalculateVisibleLate() {
        return true;
    }

    @ConfigProperty(value="SEARCH_FORM")
    @Order(value=90.0)
    protected Class<? extends ISearchForm> getConfiguredSearchForm() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredSearchRequired() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=130.0)
    protected boolean getConfiguredTableStatusVisible() {
        return true;
    }

    @Override
    protected boolean getConfiguredLazyExpandingEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=140.0)
    protected boolean getConfiguredAlwaysCreateChildPage() {
        return false;
    }

    @ConfigOperation
    @Order(value=85.0)
    protected void execLoadData(SearchFilter filter) {
    }

    @ConfigOperation
    @Order(value=100.0)
    protected void execPopulateTable() {
        if (this.isSearchActive()) {
            SearchFilter filter = this.getSearchFilter();
            if (filter.isCompleted() || !this.isSearchRequired()) {
                filter = filter.copy();
                this.interceptLoadData(filter);
            }
        } else {
            this.interceptLoadData(new SearchFilter());
        }
        if (this.isSearchActive() && this.getSearchFilter() != null && !this.getSearchFilter().isCompleted() && this.isSearchRequired()) {
            this.setTableStatus((IStatus)new Status(TEXTS.get((String)"TooManyRows"), 65536));
        } else {
            this.setTableStatus(null);
        }
        Status status = this.createPopulateTableStatus();
        if (status != null) {
            this.setTableStatus((IStatus)status);
        }
    }

    protected Status createPopulateTableStatus() {
        T table = this.getTable();
        if (table == null) {
            return null;
        }
        boolean limited = this.isLimitedResult();
        if (!limited) {
            return null;
        }
        long estimatedRowCount = table.getEstimatedRowCount();
        String showingRowCountText = NumberFormat.getIntegerInstance(NlsLocale.get()).format(table.getRowCount());
        String estimatedRowCountText = NumberFormat.getIntegerInstance(NlsLocale.get()).format(estimatedRowCount);
        String message = UserAgentUtility.isTouchDevice() ? (estimatedRowCount > 0L ? TEXTS.get((String)"MaxOutlineRowWarningMobileWithEstimatedRowCount", (String[])new String[]{showingRowCountText, estimatedRowCountText}) : TEXTS.get((String)"MaxOutlineRowWarningMobile", (String[])new String[]{showingRowCountText})) : (estimatedRowCount > 0L ? TEXTS.get((String)"MaxOutlineRowWarningWithEstimatedRowCount", (String[])new String[]{showingRowCountText, estimatedRowCountText}) : TEXTS.get((String)"MaxOutlineRowWarning", (String[])new String[]{showingRowCountText}));
        return new Status(message, 65536);
    }

    @ConfigOperation
    @Order(value=110.0)
    protected IPage<?> execCreateChildPage(ITableRow row) {
        return null;
    }

    protected List<IMenu> execComputeTableEmptySpaceMenus() {
        T table = this.getTable();
        if (table == null) {
            return CollectionUtility.emptyArrayList();
        }
        return ActionUtility.getActions(table.getMenus(), ActionUtility.createMenuFilterMenuTypes(CollectionUtility.hashSet((Object)TableMenuType.EmptySpace), false));
    }

    protected IPage<?> createDefaultChildPage(ITableRow row) {
        return new AutoLeafPageWithNodes(row);
    }

    protected IPage<?> createChildPageInternalInRunContext(ITableRow row) {
        IPage<?> childPage = this.interceptCreateChildPage(row);
        if (childPage == null && this.isAlwaysCreateChildPage()) {
            childPage = this.createDefaultChildPage(row);
        }
        return childPage;
    }

    private Class<? extends ITable> getConfiguredTable() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClass((Class[])dca, ITable.class);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setSearchActive(true);
        this.setSearchRequired(this.getConfiguredSearchRequired());
        this.setAlwaysCreateChildPage(this.getConfiguredAlwaysCreateChildPage());
    }

    @Override
    protected T createTable() {
        List contributedFields = this.m_contributionHolder.getContributionsByClass(ITable.class);
        ITable table = (ITable)CollectionUtility.firstElement((List)contributedFields);
        if (table == null) {
            Class<ITable> tableClass = this.getConfiguredTable();
            if (tableClass != null) {
                table = (ITable)ConfigurationUtility.newInnerInstance((Object)this, tableClass);
            } else {
                LOG.warn("there is no inner class of type ITable in {}", (Object)this.getClass().getName());
            }
        }
        if (table != null) {
            if (table instanceof AbstractTable) {
                ((AbstractTable)table).setContainerInternal(this);
            }
            table.addTableListener(new P_TableListener(), 104, 105, 102, 100, 101, 200, 210);
            table.setEnabled(this.isEnabled());
            table.setAutoDiscardOnDelete(true);
            table.setUserPreferenceContext(this.getUserPreferenceContext());
            table.setTableStatusVisible(this.getConfiguredTableStatusVisible());
            table.setReloadHandler(new PageReloadHandler(this));
        }
        return (T)table;
    }

    protected void ensureSearchFormCreated() {
        if (this.m_searchForm == null) {
            try {
                this.setSearchForm(this.createSearchForm());
            }
            catch (Exception e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating search form for '" + this.getClass().getName() + "'.", new Object[]{e}));
            }
        }
    }

    protected ISearchForm createSearchForm() {
        Class<ISearchForm> configuredSearchForm = this.getConfiguredSearchForm();
        if (configuredSearchForm == null) {
            return null;
        }
        try {
            return (ISearchForm)this.createDisplayParentRunContext().call(() -> (ISearchForm)configuredSearchForm.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating instance of class '" + configuredSearchForm.getName() + "'.", new Object[]{e}));
            return null;
        }
    }

    protected void ensureSearchFormStarted() {
        if (this.m_searchForm != null && this.m_searchForm.isFormStartable()) {
            try {
                this.m_searchForm.start();
                this.fireAfterSearchFormStart();
                this.ensureSearchControlSelected();
            }
            catch (Exception e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating search form '" + this.m_searchForm.getClass().getName() + "' for page '" + this.getClass().getName() + "'.", new Object[]{e}));
            }
        }
    }

    protected void ensureSearchControlSelected() {
        SearchFormTableControl control;
        SearchFormTableControl table;
        if (this.isSearchRequired() && !this.getSearchFilter().isCompleted() && (table = this.getTable()) != null && (control = table.getTableControl(SearchFormTableControl.class)) != null) {
            control.setSelected(true);
        }
    }

    private void attachToSearchFormInternal() {
        if (this.m_searchForm == null) {
            return;
        }
        this.m_searchForm.setDisplayHint(20);
        if (this.m_searchForm.getDisplayViewId() == null) {
            this.m_searchForm.setDisplayViewId("PAGE_SEARCH");
        }
        this.m_searchForm.setShowOnStart(false);
        this.m_searchFormListener = e -> {
            switch (e.getType()) {
                case 3020: {
                    try {
                        if (this.isSearchRequired()) {
                            Object table = this.getTable(false);
                            if (table == null) break;
                            table.discardAllRows();
                            break;
                        }
                        this.reloadPage("search");
                    }
                    catch (RuntimeException | PlatformError ex) {
                        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(ex);
                    }
                    break;
                }
                case 2020: {
                    try {
                        this.reloadPage("search");
                        break;
                    }
                    catch (RuntimeException | PlatformError ex) {
                        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(ex);
                    }
                }
            }
        };
        this.m_searchForm.addFormListener(this.m_searchFormListener, new Integer[0]);
        try {
            this.interceptInitSearchForm();
        }
        catch (Exception e2) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating search form '" + this.m_searchForm.getClass().getName() + "' for page '" + this.getClass().getName() + "'.", new Object[]{e2}));
        }
    }

    @Override
    protected void addDefaultTableControls() {
        T table = this.getTable();
        if (table == null) {
            return;
        }
        ITableControl control = this.createSearchFormTableControl();
        if (control != null) {
            table.addTableControl(control);
            this.linkSearchFormWithTableControl();
        }
        if ((control = this.createAggregateTableControl()) != null) {
            table.addTableControl(control);
        }
    }

    protected void linkSearchFormWithTableControl() {
        SearchFormTableControl table = this.getTable(false);
        if (table == null) {
            return;
        }
        SearchFormTableControl tableControl = table.getTableControl(SearchFormTableControl.class);
        if (tableControl != null) {
            tableControl.setForm(this.m_searchForm);
        }
    }

    protected SearchFormTableControl createSearchFormTableControl() {
        return new SearchFormTableControl();
    }

    protected ITableControl createAggregateTableControl() {
        return new AggregateTableControl();
    }

    private void detachFromSearchFormInternal() {
        if (this.m_searchForm == null) {
            return;
        }
        if (this.m_searchFormListener != null) {
            this.m_searchForm.removeFormListener(this.m_searchFormListener, new Integer[0]);
            this.m_searchFormListener = null;
        }
        this.detachSearchTableControl();
    }

    private void detachSearchTableControl() {
        SearchFormTableControl table = this.getTable(false);
        if (table == null) {
            return;
        }
        SearchFormTableControl searchControl = table.getTableControl(SearchFormTableControl.class);
        if (searchControl != null) {
            table.removeTableControl(searchControl);
        }
    }

    protected void disposeSearchForm() {
        if (this.m_searchForm != null) {
            this.m_searchForm.doClose();
            this.setSearchForm(null);
        }
    }

    @ConfigOperation
    @Order(value=120.0)
    protected void execInitSearchForm() {
    }

    @Override
    public final T getTable() {
        Object table = super.getTable();
        if (table == null) {
            this.callInitializer();
        }
        return table;
    }

    @Override
    public ISearchForm getSearchFormInternal() {
        this.ensureSearchFormCreated();
        return this.m_searchForm;
    }

    public void setSearchForm(ISearchForm searchForm) {
        if (this.m_searchForm == searchForm) {
            return;
        }
        this.detachFromSearchFormInternal();
        this.m_searchForm = searchForm;
        this.attachToSearchFormInternal();
        this.linkSearchFormWithTableControl();
    }

    @Override
    public SearchFilter getSearchFilter() {
        this.ensureSearchFormCreated();
        this.ensureSearchFormStarted();
        if (this.getSearchFormInternal() != null) {
            return this.getSearchFormInternal().getSearchFilter();
        }
        ISearchFilterService sfs = (ISearchFilterService)BEANS.get(ISearchFilterService.class);
        if (sfs != null) {
            return sfs.createNewSearchFilter();
        }
        return new SearchFilter();
    }

    @Override
    public boolean isSearchRequired() {
        return FLAGS_BIT_HELPER.isBitSet("SEARCH_REQUIRED", this.m_flags);
    }

    @Override
    public void setSearchRequired(boolean searchRequired) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit("SEARCH_REQUIRED", searchRequired, this.m_flags);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        Object table = this.getTable(false);
        if (table != null) {
            table.setEnabled(this.isEnabled());
        }
    }

    @Override
    public boolean isSearchActive() {
        return FLAGS_BIT_HELPER.isBitSet("SEARCH_ACTIVE", this.m_flags);
    }

    @Override
    public void setSearchActive(boolean searchActive) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit("SEARCH_ACTIVE", searchActive, this.m_flags);
        if (this.isSelectedNode()) {
            this.getOutline().setSearchForm(searchActive ? this.getSearchFormInternal() : null);
        }
    }

    protected boolean isLimitedResult() {
        return FLAGS_BIT_HELPER.isBitSet("LIMITED_RESULT", this.m_flags);
    }

    @Override
    public boolean isAlwaysCreateChildPage() {
        return FLAGS_BIT_HELPER.isBitSet("ALWAYS_CREATE_CHILD_PAGE", this.m_flags);
    }

    @Override
    public void setAlwaysCreateChildPage(boolean alwaysCreateChildPage) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit("ALWAYS_CREATE_CHILD_PAGE", alwaysCreateChildPage, this.m_flags);
    }

    @Override
    public void pageActivatedNotify() {
        this.callInitializer();
        this.ensureSearchFormCreated();
        this.ensureSearchFormStarted();
        super.pageActivatedNotify();
    }

    @Override
    public void disposeInternal() {
        super.disposeInternal();
        try {
            this.disposeSearchForm();
        }
        catch (RuntimeException | PlatformError e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
        }
    }

    protected void importPageData(AbstractTablePageData tablePageData) {
        T table = this.getTable();
        if (table == null) {
            return;
        }
        table.importFromTableBeanData((AbstractTableFieldBeanData)tablePageData);
        this.m_flags = FLAGS_BIT_HELPER.changeBit("LIMITED_RESULT", tablePageData.isLimitedResult(), this.m_flags);
        table.setEstimatedRowCount(tablePageData.getEstimatedRowCount());
        table.setMaxRowCount(tablePageData.getMaxRowCount());
    }

    protected void importTableData(Object[][] data) {
        T table = this.getTable();
        if (table == null) {
            return;
        }
        table.replaceRowsByMatrix(new AtomicReference<Object[][]>(data));
    }

    protected void loadTableDataImpl() {
        T table = this.getTable();
        if (table == null) {
            return;
        }
        try {
            try {
                table.setTableChanging(true);
                this.ensureSearchFormCreated();
                this.ensureSearchFormStarted();
                this.interceptPopulateTable();
            }
            catch (FutureCancelledError | ThreadInterruptedError e) {
                table.discardAllRows();
                this.setTableStatus((IStatus)new Status(TEXTS.get((String)"SearchWasCanceled"), 0x1000000));
                throw e;
            }
            catch (VetoException e) {
                table.discardAllRows();
                this.setTableStatus((IStatus)new Status((String)ObjectUtility.nvl((Object)e.getDisplayMessage(), (Object)TEXTS.get((String)"ErrorWhileLoadingData")), 0x1000000));
                throw e;
            }
            catch (RuntimeException | PlatformError e) {
                table.discardAllRows();
                this.setTableStatus((IStatus)new Status(TEXTS.get((String)"ErrorWhileLoadingData"), 0x1000000));
                throw e;
            }
        }
        finally {
            table.setTableChanging(false);
        }
    }

    @Override
    protected final void loadChildrenImpl() {
        ITree tree = this.getTree();
        try {
            List<Object> oldSelectedRowKeys;
            ITreeNode oldSelectedNode;
            int oldSelectionDirectChildIndex;
            boolean oldSelectionOwned;
            block17: {
                if (tree != null) {
                    tree.setTreeChanging(true);
                }
                oldSelectionOwned = false;
                oldSelectionDirectChildIndex = -1;
                oldSelectedNode = null;
                if (tree != null) {
                    oldSelectedNode = tree.getSelectedNode();
                }
                oldSelectedRowKeys = null;
                if (oldSelectedNode != null) {
                    ITreeNode t = oldSelectedNode;
                    while (t != null && t.getParentNode() != null) {
                        if (t.getParentNode() == this) {
                            oldSelectionOwned = true;
                            oldSelectedRowKeys = this.getTableRowFor(t).getKeyValues();
                            oldSelectionDirectChildIndex = t.getChildNodeIndex();
                            break;
                        }
                        t = t.getParentNode();
                    }
                }
                this.setChildrenLoaded(false);
                this.fireBeforeDataLoaded();
                try {
                    try {
                        this.loadTableDataImpl();
                    }
                    catch (FutureCancelledError | ThreadInterruptedError throwable) {
                        this.fireAfterDataLoaded();
                        break block17;
                    }
                }
                catch (Throwable t) {
                    this.fireAfterDataLoaded();
                    throw t;
                }
                this.fireAfterDataLoaded();
            }
            this.setChildrenLoaded(true);
            this.setChildrenDirty(false);
            T table = this.getTable();
            if (tree != null && table != null && oldSelectionOwned && tree.getSelectedNode() == null) {
                int index;
                ITreeNode newSelectedNode = null;
                ITableRow row = table.getSelectedRow();
                newSelectedNode = row != null ? this.getTreeNodeFor(row) : ((row = table.getRowByKey(oldSelectedRowKeys)) != null ? this.getTreeNodeFor(row) : (oldSelectedNode != null && oldSelectedNode.getTree() == tree ? oldSelectedNode : ((index = Math.max(-1, Math.min(oldSelectionDirectChildIndex, this.getChildNodeCount() - 1))) >= 0 && index < this.getChildNodeCount() ? this.getChildNode(index) : this)));
                if (newSelectedNode != null) {
                    tree.selectNode(newSelectedNode);
                }
            }
        }
        finally {
            if (tree != null) {
                tree.setTreeChanging(false);
            }
        }
        IDesktop desktop = ClientSessionProvider.currentSession().getDesktop();
        if (desktop != null) {
            desktop.afterTablePageLoaded(this);
        }
    }

    @Override
    public List<IPage<?>> getUpdatedChildPagesFor(List<? extends ITableRow> tableRows) {
        return this.getChildPagesFor(tableRows, true);
    }

    @Override
    public List<IMenu> computeTableEmptySpaceMenus() {
        return this.interceptComputeTableEmptySpaceMenus();
    }

    private List<IPage<?>> getChildPagesFor(List<? extends ITableRow> tableRows, boolean updateChildPageCells) {
        ArrayList result = new ArrayList();
        try {
            for (ITableRow iTableRow : tableRows) {
                IPage<?> page = this.getPageFor(iTableRow);
                if (page == null) continue;
                result.add(page);
                if (!updateChildPageCells) continue;
                page.setEnabled(iTableRow.isEnabled(), "ENABLED");
                T table = this.getTable();
                if (table == null) continue;
                ICell tableCell = table.getSummaryCell(iTableRow);
                page.getCellForUpdate().updateFrom(tableCell);
            }
        }
        catch (RuntimeException | PlatformError throwable) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(throwable);
        }
        return result;
    }

    protected void updateCellFromTableCell(Cell pageCell, ICell summaryCell) {
        pageCell.updateFrom(summaryCell);
    }

    protected void fireAfterSearchFormStart() {
        IOutline outline = this.getOutline();
        if (outline != null) {
            outline.fireAfterSearchFormStart(this);
        }
    }

    protected final void interceptLoadData(SearchFilter filter) {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageWithTableChains.PageWithTableLoadDataChain chain = new PageWithTableChains.PageWithTableLoadDataChain(extensions);
        chain.execLoadData(filter);
    }

    protected final IPage<?> interceptCreateChildPage(ITableRow row) {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageWithTableChains.PageWithTableCreateChildPageChain chain = new PageWithTableChains.PageWithTableCreateChildPageChain(extensions);
        return chain.execCreateChildPage(row);
    }

    protected final void interceptPopulateTable() {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageWithTableChains.PageWithTablePopulateTableChain chain = new PageWithTableChains.PageWithTablePopulateTableChain(extensions);
        chain.execPopulateTable();
    }

    protected final void interceptInitSearchForm() {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageWithTableChains.PageWithTableInitSearchFormChain chain = new PageWithTableChains.PageWithTableInitSearchFormChain(extensions);
        chain.execInitSearchForm();
    }

    protected final List<IMenu> interceptComputeTableEmptySpaceMenus() {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageWithTableChains.PageWithTableComputeTableEmptySpaceMenusChain chain = new PageWithTableChains.PageWithTableComputeTableEmptySpaceMenusChain(extensions);
        return chain.execComputeTableEmptySpaceMenus();
    }

    @Override
    protected IPageWithTableExtension<T, ? extends AbstractPageWithTable<T>> createLocalExtension() {
        return new LocalPageWithTableExtension(this);
    }

    protected static class LocalPageWithTableExtension<T extends ITable, OWNER extends AbstractPageWithTable<T>>
    extends AbstractPage.LocalPageExtension<OWNER>
    implements IPageWithTableExtension<T, OWNER> {
        public LocalPageWithTableExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execLoadData(PageWithTableChains.PageWithTableLoadDataChain<? extends ITable> chain, SearchFilter filter) {
            ((AbstractPageWithTable)this.getOwner()).execLoadData(filter);
        }

        @Override
        public IPage<?> execCreateChildPage(PageWithTableChains.PageWithTableCreateChildPageChain<? extends ITable> chain, ITableRow row) {
            return ((AbstractPageWithTable)this.getOwner()).execCreateChildPage(row);
        }

        @Override
        public void execPopulateTable(PageWithTableChains.PageWithTablePopulateTableChain<? extends ITable> chain) {
            ((AbstractPageWithTable)this.getOwner()).execPopulateTable();
        }

        @Override
        public void execInitSearchForm(PageWithTableChains.PageWithTableInitSearchFormChain<? extends ITable> chain) {
            ((AbstractPageWithTable)this.getOwner()).execInitSearchForm();
        }

        @Override
        public List<IMenu> execComputeTableEmptySpaceMenus(PageWithTableChains.PageWithTableComputeTableEmptySpaceMenusChain<? extends ITable> chain) {
            return ((AbstractPageWithTable)this.getOwner()).execComputeTableEmptySpaceMenus();
        }
    }

    private class P_TableListener
    extends TableAdapter {
        private P_TableListener() {
        }

        private Optional<OutlineMediator> getOutlineMediator() {
            return Optional.ofNullable(AbstractPageWithTable.this.getOutline()).map(IOutline::getOutlineMediator);
        }

        private void onRowsInserted(TableEvent e) {
            List<ITableRow> tableRows = e.getRows();
            ArrayList childPageList = new ArrayList(tableRows.size());
            for (ITableRow element : tableRows) {
                try {
                    IPage<?> childPage = AbstractPageWithTable.this.createChildPageInternalInRunContext(element);
                    if (childPage == null) continue;
                    childPage.setRejectedByUser(element.isRejectedByUser());
                    childPage.setFilterAccepted(element.isFilterAccepted());
                    childPage.setEnabled(element.isEnabled(), "ENABLED");
                    Object table = AbstractPageWithTable.this.getTable();
                    if (table != null) {
                        ICell tableCell = table.getSummaryCell(element);
                        AbstractPageWithTable.this.updateCellFromTableCell(childPage.getCellForUpdate(), tableCell);
                    }
                    AbstractPageWithTable.this.linkTableRowWithPage(element, childPage);
                    childPageList.add(childPage);
                }
                catch (RuntimeException | PlatformError ex) {
                    ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(ex);
                }
            }
            this.getOutlineMediator().ifPresent(mediator -> mediator.mediateTableRowsInserted(tableRows, childPageList, AbstractPageWithTable.this));
            for (ITableRow tableRow : tableRows) {
                IPage<?> page = AbstractPageWithTable.this.getPageFor(tableRow);
                if (page == null || page.getParentNode() != null) continue;
                AbstractPageWithTable.this.unlinkTableRowWithPage(tableRow);
            }
        }

        @Override
        public void tableChanged(TableEvent e) {
            switch (e.getType()) {
                case 104: {
                    this.getOutlineMediator().ifPresent(mediator -> mediator.mediateTableRowAction(e, AbstractPageWithTable.this));
                    break;
                }
                case 102: 
                case 105: {
                    if (AbstractPageWithTable.this.isLeaf()) break;
                    List<ITableRow> tableRows = e.getRows();
                    List childNodes = AbstractPageWithTable.this.getChildPagesFor(e.getRows(), false);
                    for (ITableRow row : tableRows) {
                        AbstractPageWithTable.this.unlinkTableRowWithPage(row);
                    }
                    this.getOutlineMediator().ifPresent(mediator -> mediator.mediateTableRowsDeleted(childNodes, AbstractPageWithTable.this));
                    break;
                }
                case 100: {
                    if (AbstractPageWithTable.this.isLeaf()) break;
                    AbstractPageWithTable.this.createDisplayParentRunContext().run(() -> this.onRowsInserted(e));
                    break;
                }
                case 101: {
                    this.getOutlineMediator().ifPresent(mediator -> mediator.mediateTableRowsUpdated(e, AbstractPageWithTable.this));
                    break;
                }
                case 200: {
                    this.getOutlineMediator().ifPresent(mediator -> mediator.mediateTableRowOrderChanged(e, AbstractPageWithTable.this));
                    break;
                }
                case 210: {
                    this.getOutlineMediator().ifPresent(mediator -> mediator.mediateTableRowFilterChanged(AbstractPageWithTable.this));
                }
            }
        }
    }
}

