/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.dto.Data;
import org.eclipse.scout.rt.client.dto.FormData;
import org.eclipse.scout.rt.client.extension.ui.form.AbstractFormExtension;
import org.eclipse.scout.rt.client.extension.ui.form.FormChains;
import org.eclipse.scout.rt.client.extension.ui.form.IFormExtension;
import org.eclipse.scout.rt.client.extension.ui.form.MoveFormFieldsHandler;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.services.common.search.ISearchFilterService;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.IDisplayParent;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.basic.filechooser.FileChooser;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.IOpenUriAction;
import org.eclipse.scout.rt.client.ui.desktop.OpenUriAction;
import org.eclipse.scout.rt.client.ui.desktop.datachange.IDataChangeListener;
import org.eclipse.scout.rt.client.ui.form.DefaultFormEventHistory;
import org.eclipse.scout.rt.client.ui.form.DefaultFormFieldInjection;
import org.eclipse.scout.rt.client.ui.form.DisplayParentResolver;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormFieldInjectionThreadLocal;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.FormListeners;
import org.eclipse.scout.rt.client.ui.form.FormUtility;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormHandler;
import org.eclipse.scout.rt.client.ui.form.IFormUIFacade;
import org.eclipse.scout.rt.client.ui.form.NullFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormFieldFilter;
import org.eclipse.scout.rt.client.ui.form.fields.IValidateContentDescriptor;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonEvent;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonListener;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.client.ui.form.fields.wrappedform.IWrappedFormField;
import org.eclipse.scout.rt.client.ui.form.internal.FindFieldByFormDataIdVisitor;
import org.eclipse.scout.rt.client.ui.form.internal.FindFieldByXmlIdsVisitor;
import org.eclipse.scout.rt.client.ui.form.internal.FormDataPropertyFilter;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxes;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStep;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.exception.PlatformExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.holders.Holder;
import org.eclipse.scout.rt.platform.holders.IHolder;
import org.eclipse.scout.rt.platform.html.HTML;
import org.eclipse.scout.rt.platform.html.IHtmlContent;
import org.eclipse.scout.rt.platform.html.IHtmlElement;
import org.eclipse.scout.rt.platform.html.IHtmlListElement;
import org.eclipse.scout.rt.platform.job.IBlockingCondition;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.reflect.IPropertyFilter;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.status.IMultiStatus;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.status.MultiStatus;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.BeanUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.PreferredValue;
import org.eclipse.scout.rt.platform.util.XmlUtility;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;
import org.eclipse.scout.rt.platform.util.visitor.CollectingVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.shared.data.basic.NamedBitMaskHelper;
import org.eclipse.scout.rt.shared.data.form.AbstractFormData;
import org.eclipse.scout.rt.shared.data.form.IPropertyHolder;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ClassId(value="cec05259-9e6f-480c-94fa-f02f56e777f7")
@FormData(value=AbstractFormData.class, sdkCommand=FormData.SdkCommand.USE)
public abstract class AbstractForm
extends AbstractWidget
implements IForm,
IExtensibleObject,
IContributionOwner {
    private static final String CACHE_BOUNDS = "CACHE_BOUNDS";
    private static final String ASK_IF_NEED_SAVE = "ASK_IF_NEED_SAVE";
    private static final String BUTTONS_ARMED = "BUTTONS_ARMED";
    private static final String CLOSE_TIMER_ARMED = "CLOSE_TIMER_ARMED";
    private static final String SHOW_ON_START = "SHOW_ON_START";
    private static final String FORM_STORED = "FORM_STORED";
    private static final String FORM_LOADING = "FORM_LOADING";
    private static final String FORM_STARTED = "FORM_STARTED";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractForm.class);
    private static final NamedBitMaskHelper FLAGS_BIT_HELPER = new NamedBitMaskHelper(new String[]{"CACHE_BOUNDS", "ASK_IF_NEED_SAVE", "BUTTONS_ARMED", "CLOSE_TIMER_ARMED", "SHOW_ON_START"});
    private static final NamedBitMaskHelper STATE_BIT_HELPER = new NamedBitMaskHelper(new String[]{"FORM_STORED", "FORM_LOADING", "FORM_STARTED"});
    private final PreferredValue<IDisplayParent> m_displayParent;
    private final FormListeners m_listenerList = new FormListeners();
    private final PreferredValue<Boolean> m_modal = new PreferredValue((Object)false, false);
    private final IBlockingCondition m_blockingCondition;
    private final ObjectExtensions<AbstractForm, IFormExtension<? extends AbstractForm>> m_objectExtensions;
    private final IEventHistory<FormEvent> m_eventHistory;
    private byte m_flags;
    private byte m_states;
    private IFormUIFacade m_uiFacade;
    private IWizardStep m_wizardStep;
    private int m_displayHint;
    private String m_displayViewId;
    private int m_closeType = 0;
    private String m_cancelVerificationText;
    private IGroupBox m_mainBox;
    private ButtonListener m_systemButtonListener;
    private String m_classId;
    private ModelContextProxy.ModelContext m_callingModelContext;
    private IFormHandler m_handler;
    private SearchFilter m_searchFilter;
    private IFuture<?> m_closeTimerFuture;
    private Map<String, IFuture<Void>> m_timerFutureMap;
    private IDataChangeListener m_internalDataChangeListener;
    private Map<Class<?>, Class<? extends IFormField>> m_fieldReplacements;
    private IContributionOwner m_contributionHolder;
    private Predicate<IFormField> m_storeToXmlFieldFilter;

    public AbstractForm() {
        this(true);
    }

    public AbstractForm(boolean callInitializer) {
        super(false);
        this.m_displayParent = new PreferredValue(null, false);
        this.m_eventHistory = this.createEventHistory();
        this.m_storeToXmlFieldFilter = this.createDefaultStoreToXmlFieldFilter();
        this.setHandler(new NullFormHandler());
        this.setFormLoading(true);
        this.m_blockingCondition = Jobs.newBlockingCondition((boolean)false);
        this.m_objectExtensions = new ObjectExtensions((Object)this, true);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    public final List<? extends IFormExtension<? extends AbstractForm>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    public final <T> T optContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.optContribution(contribution);
    }

    public Predicate<IFormField> getStoreToXmlFieldFilter() {
        return this.m_storeToXmlFieldFilter;
    }

    public void setStoreToXmlFieldFilter(Predicate<IFormField> storeToXmlFieldFilter) {
        this.m_storeToXmlFieldFilter = storeToXmlFieldFilter != null ? storeToXmlFieldFilter : this.createDefaultStoreToXmlFieldFilter();
    }

    protected Predicate<IFormField> createDefaultStoreToXmlFieldFilter() {
        return field -> true;
    }

    @Override
    protected void initConfigInternal() {
        this.m_callingModelContext = ModelContextProxy.ModelContext.copyCurrent();
        ClientRunContexts.copyCurrent().withForm(this).run(() -> this.m_objectExtensions.initConfig(this.createLocalExtension(), this::initConfig));
        FormUtility.rebuildFieldGrid(this, true);
    }

    protected IFormExtension<? extends AbstractForm> createLocalExtension() {
        return new LocalFormExtension<AbstractForm>(this);
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    protected String getConfiguredSubTitle() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=25.0)
    protected Boolean getConfiguredHeaderVisible() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=30.0)
    protected String getConfiguredCancelVerificationText() {
        return TEXTS.get((String)"FormSaveChangesQuestion");
    }

    @ConfigProperty(value="FORM_DISPLAY_HINT")
    @Order(value=40.0)
    protected int getConfiguredDisplayHint() {
        return 0;
    }

    @ConfigProperty(value="OBJECT")
    @Order(value=50.0)
    protected IDisplayParent getConfiguredDisplayParent() {
        return null;
    }

    @ConfigProperty(value="FORM_VIEW_ID")
    @Order(value=60.0)
    protected String getConfiguredDisplayViewId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    protected boolean getConfiguredMaximizeEnabled() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    protected boolean getConfiguredMinimized() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredMaximized() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=110.0)
    protected int getConfiguredModalityHint() {
        return 0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=120.0)
    protected boolean getConfiguredShowOnStart() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=130.0)
    protected boolean getConfiguredCacheBounds() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=140.0)
    protected boolean getConfiguredAskIfNeedSave() {
        return true;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=150.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=170.0)
    protected int getConfiguredCloseTimer() {
        return 0;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=180.0)
    protected int getConfiguredCustomTimer() {
        return 0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=190.0)
    protected boolean getConfiguredClosable() {
        return this.getDisplayHint() == 0 && this.hasCloseOrCancelButton();
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    protected boolean getConfiguredSaveNeededVisible() {
        return false;
    }

    @Override
    public Object computeExclusiveKey() {
        return null;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitForm() {
    }

    @ConfigOperation
    @Order(value=11.0)
    protected void execFormActivated() {
    }

    @ConfigOperation
    @Order(value=13.0)
    protected void execDataChanged(Object ... dataTypes) {
    }

    @ConfigOperation
    @Order(value=13.0)
    protected boolean execCheckFields() {
        return true;
    }

    @ConfigOperation
    @Order(value=14.0)
    protected boolean execValidate() {
        return true;
    }

    @ConfigOperation
    @Order(value=16.0)
    protected void execStored() {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected boolean execIsSaveNeeded() {
        return this.getRootGroupBox().isSaveNeeded();
    }

    @ConfigOperation
    @Order(value=17.0)
    protected void execOnVetoException(VetoException e, int code) {
        throw e;
    }

    @ConfigOperation
    @Order(value=18.0)
    protected void execOnCloseRequest(boolean kill, Set<Integer> enabledButtonSystemTypes) {
        if (kill || enabledButtonSystemTypes.contains(2)) {
            this.doClose();
        } else {
            this.doCancel();
        }
    }

    @ConfigOperation
    @Order(value=19.0)
    protected void execDisposeForm() {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execCloseTimer() {
        this.doClose();
    }

    @ConfigOperation
    @Order(value=30.0)
    protected void execInactivityTimer() {
        this.doClose();
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execTimer(String timerId) {
        LOG.info("execTimer {}", (Object)timerId);
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execAddSearchTerms(SearchFilter search) {
    }

    protected boolean hasCloseOrCancelButton() {
        for (IFormField f : this.getAllFields()) {
            if (!f.isEnabled() || !f.isVisible() || !(f instanceof IButton)) continue;
            switch (((IButton)f).getSystemType()) {
                case 1: 
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    private Class<? extends IGroupBox> getConfiguredMainBox() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClassIgnoringInjectFieldAnnotation((Class[])dca, IGroupBox.class);
    }

    private List<Class<IFormField>> getConfiguredInjectedFields() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClassesWithInjectFieldAnnotation((Class[])dca, IFormField.class);
    }

    @Override
    protected void initConfig() {
        IDisplayParent displayParent;
        super.initConfig();
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent().withForm(this));
        this.m_timerFutureMap = new HashMap<String, IFuture<Void>>();
        this.setShowOnStart(this.getConfiguredShowOnStart());
        this.m_contributionHolder = new ContributionComposite((Object)this);
        List<Class<IFormField>> fieldArray = this.getConfiguredInjectedFields();
        DefaultFormFieldInjection injectedFields = null;
        IGroupBox rootBox = this.getRootGroupBox();
        try {
            if (!fieldArray.isEmpty()) {
                injectedFields = new DefaultFormFieldInjection(this);
                injectedFields.addFields(fieldArray);
                FormFieldInjectionThreadLocal.push(injectedFields);
            }
            if (rootBox == null) {
                Class<? extends IGroupBox> mainBoxClass;
                List contributedFields = this.m_contributionHolder.getContributionsByClass(IGroupBox.class);
                rootBox = (IGroupBox)CollectionUtility.firstElement((List)contributedFields);
                if (rootBox == null && (mainBoxClass = this.getConfiguredMainBox()) != null) {
                    rootBox = (IGroupBox)ConfigurationUtility.newInnerInstance((Object)this, mainBoxClass);
                }
                this.m_mainBox = rootBox;
            }
        }
        finally {
            if (injectedFields != null) {
                this.m_fieldReplacements = injectedFields.getReplacementMapping();
                FormFieldInjectionThreadLocal.pop(injectedFields);
            }
        }
        if (rootBox != null) {
            rootBox.setParentInternal(this);
            rootBox.setMainBox(true);
            rootBox.updateKeyStrokes();
            if (rootBox.isScrollable().isUndefined()) {
                rootBox.setScrollable(true);
            }
            if (rootBox.isResponsive().isUndefined()) {
                rootBox.setResponsive(true);
            }
        }
        new MoveFormFieldsHandler(this).moveFields();
        if (this.getConfiguredCloseTimer() > 0) {
            this.setCloseTimer(this.getConfiguredCloseTimer());
        }
        if (this.getConfiguredCustomTimer() > 0) {
            this.setTimer("custom", this.getConfiguredCustomTimer());
        }
        if (this.getConfiguredCancelVerificationText() != null) {
            this.setCancelVerificationText(this.getConfiguredCancelVerificationText());
        }
        if (this.getConfiguredTitle() != null) {
            this.setTitle(this.getConfiguredTitle());
        }
        if (this.getConfiguredSubTitle() != null) {
            this.setSubTitle(this.getConfiguredSubTitle());
        }
        this.setHeaderVisible(this.getConfiguredHeaderVisible());
        this.setMaximized(this.getConfiguredMaximized());
        this.setCacheBounds(this.getConfiguredCacheBounds());
        this.setAskIfNeedSave(this.getConfiguredAskIfNeedSave());
        this.setIconId(this.getConfiguredIconId());
        this.setCssClass(this.getConfiguredCssClass());
        int modalityHint = this.getConfiguredModalityHint();
        if (modalityHint != 0) {
            this.m_modal.set((Object)(modalityHint == 10 ? 1 : 0), true);
        }
        if ((displayParent = this.getConfiguredDisplayParent()) != null) {
            this.m_displayParent.set((Object)displayParent, true);
        } else {
            this.m_displayParent.set((Object)this.getDesktop(), false);
        }
        this.setDisplayHint(this.getConfiguredDisplayHint());
        this.setDisplayViewId(this.getConfiguredDisplayViewId());
        this.setClosable(this.getConfiguredClosable());
        this.setSaveNeededVisible(this.getConfiguredSaveNeededVisible());
        this.m_systemButtonListener = new P_SystemButtonListener();
        Consumer<IButton> v2 = button -> {
            if (button.getSystemType() != 0) {
                button.addButtonListener(this.m_systemButtonListener);
            }
        };
        this.visit(v2, IButton.class);
        this.getRootGroupBox().addPropertyChangeListener(new P_MainBoxPropertyChangeProxy());
        this.setButtonsArmed(true);
    }

    @Override
    public void setVisiblePermission(Permission p) {
        boolean b = true;
        if (p != null) {
            b = ACCESS.check((Permission)p);
        }
        this.setVisibleGranted(b);
    }

    @Override
    public boolean isVisibleGranted() {
        IGroupBox box = this.getRootGroupBox();
        if (box == null) {
            return false;
        }
        return box.isVisibleGranted();
    }

    @Override
    public void setVisibleGranted(boolean visible) {
        IGroupBox box = this.getRootGroupBox();
        if (box != null) {
            box.setVisibleGranted(visible);
        }
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String iconId) {
        this.propertySupport.setPropertyString("iconId", iconId);
    }

    @Override
    public boolean isClosable() {
        return this.propertySupport.getPropertyBool("closable");
    }

    @Override
    public void setClosable(boolean closable) {
        this.propertySupport.setPropertyBool("closable", closable);
    }

    @Override
    public boolean isSaveNeededVisible() {
        return this.propertySupport.getPropertyBool("saveNeededVisible");
    }

    @Override
    public void setSaveNeededVisible(boolean saveNeededVisible) {
        this.propertySupport.setPropertyBool("saveNeededVisible", saveNeededVisible);
    }

    @Override
    public IMultiStatus getStatus() {
        MultiStatus ms = this.getStatusInternal();
        return ms == null ? null : new MultiStatus((IMultiStatus)ms);
    }

    @Override
    public boolean hasStatus(IStatus status) {
        MultiStatus ms = this.getStatusInternal();
        if (ms != null) {
            return ms.equals(status) || ms.containsStatus(status);
        }
        return false;
    }

    protected MultiStatus getStatusInternal() {
        return (MultiStatus)this.propertySupport.getProperty("status");
    }

    @Override
    public void setStatus(IMultiStatus status) {
        this.setStatusInternal(new MultiStatus(status));
    }

    protected void setStatusInternal(MultiStatus status) {
        this.propertySupport.setProperty("status", (Object)status);
    }

    @Override
    public void clearStatus() {
        this.propertySupport.setProperty("status", null);
    }

    @Override
    public void addStatus(IStatus newStatus) {
        MultiStatus status = this.ensureMultiStatus((IStatus)this.getStatusInternal());
        MultiStatus copy = new MultiStatus((IMultiStatus)status);
        copy.add(newStatus);
        this.setStatus((IMultiStatus)copy);
    }

    @Override
    public void removeStatus(IStatus status) {
        MultiStatus ms = this.getStatusInternal();
        if (ms != null) {
            if (ms.equals((Object)status)) {
                this.clearStatus();
            } else if (ms.containsStatus(status)) {
                MultiStatus copy = new MultiStatus((IMultiStatus)ms);
                copy.removeAll(status);
                if (copy.getChildren().isEmpty()) {
                    this.clearStatus();
                } else {
                    this.setStatusInternal(copy);
                }
            }
        }
    }

    private MultiStatus ensureMultiStatus(IStatus s) {
        if (s instanceof MultiStatus) {
            return (MultiStatus)s;
        }
        MultiStatus ms = new MultiStatus();
        if (s != null) {
            ms.add(s);
        }
        return ms;
    }

    @Override
    public void registerDataChangeListener(Object ... dataTypes) {
        if (this.m_internalDataChangeListener == null) {
            this.m_internalDataChangeListener = event -> this.interceptDataChanged(event.getDataType());
        }
        this.getDesktop().dataChangeListeners().add(this.m_internalDataChangeListener, true, dataTypes);
    }

    @Override
    public void unregisterDataChangeListener(Object ... dataTypes) {
        if (this.m_internalDataChangeListener != null) {
            this.getDesktop().removeDataChangeListener(this.m_internalDataChangeListener, dataTypes);
        }
    }

    protected IForm startInternalExclusive(IFormHandler handler) {
        if (this.m_blockingCondition.isBlocking()) {
            throw new ProcessingException("The form " + this.getFormId() + " has already been started", new Object[0]);
        }
        for (IForm simCandidate : this.getDesktop().getSimilarForms(this)) {
            if (handler == null || simCandidate.getHandler() == null || !handler.getClass().getName().equals(simCandidate.getHandler().getClass().getName()) || !simCandidate.getHandler().isOpenExclusive() || !handler.isOpenExclusive()) continue;
            this.getDesktop().activateForm(simCandidate);
            return simCandidate;
        }
        return this.startInternal(handler);
    }

    @Override
    public void start() {
        this.startInternal(this.getHandler());
    }

    protected IForm startInternal(IFormHandler handler) {
        ClientRunContexts.copyCurrent().withForm(this).run(() -> {
            if (this.isBlockingInternal()) {
                throw new IllegalStateException("The form " + this.getFormId() + " has already been started");
            }
            this.setFormLoading(true);
            this.setHandler(handler);
            this.m_closeType = 0;
            this.m_blockingCondition.setBlocking(true);
            try {
                this.init();
                this.loadStateInternal();
                if (!this.isBlockingInternal()) {
                    return;
                }
                if (this.getHandler().isGuiLess()) {
                    this.storeStateInternal();
                    this.markSaved();
                    this.doFinally();
                    this.dispose();
                    return;
                }
            }
            catch (RuntimeException | PlatformError e) {
                this.dispose();
                PlatformException pe = ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate(e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]);
                if (pe instanceof VetoException) {
                    VetoException ve = (VetoException)pe;
                    this.interceptOnVetoException(ve, ve.getStatus().getCode());
                }
                throw pe;
            }
            this.setButtonsArmed(true);
            this.setCloseTimerArmed(true);
            this.setFormStarted(true);
            if (this.isShowOnStart()) {
                IDesktop desktop = this.getDesktop();
                if (desktop == null || !desktop.isOpened()) {
                    throw new ProcessingException("There is no desktop or it is not open in the UI.", new Object[0]);
                }
                desktop.showForm(this);
            }
        });
        return this;
    }

    @Override
    public void startWizardStep(IWizardStep wizardStep, Class<? extends IFormHandler> handlerType) {
        if (handlerType != null) {
            IFormHandler formHandler = (IFormHandler)ConfigurationUtility.newInnerInstance((Object)this, handlerType);
            this.setHandler(formHandler);
        }
        this.m_wizardStep = wizardStep;
        this.setShowOnStart(false);
        this.setAskIfNeedSave(false);
        for (IFormField f : this.getRootGroupBox().getFields()) {
            IButton b;
            if (!(f instanceof IButton) || (b = (IButton)f).getSystemType() == 0) continue;
            b.setVisible(false, "systemButtonHiddenInWizard");
        }
        this.start();
    }

    @Override
    public void startWizardStep(IWizardStep<?> wizardStep) {
        this.startWizardStep(wizardStep, null);
    }

    @Override
    public void waitFor() {
        this.m_blockingCondition.waitFor(new String[]{"ui.interaction.required"});
    }

    protected static Class<?> getDataAnnotationValue(Class<?> clazz) {
        while (clazz != null && !Object.class.equals(clazz)) {
            Class<?> value;
            Data annotation = clazz.getAnnotation(Data.class);
            if (annotation != null && (value = annotation.value()) != null && !Object.class.equals(value)) {
                return value;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private void exportExtensionProperties(Object o, IPropertyHolder target) {
        if (!(o instanceof IExtensibleObject)) {
            return;
        }
        for (IExtension ex : ((IExtensibleObject)o).getAllExtensions()) {
            Class<?> dto = AbstractForm.getDataAnnotationValue(ex.getClass());
            if (dto == null || Object.class.equals(dto)) continue;
            Object propertyTarget = target.getContribution(dto);
            Map fieldProperties = BeanUtility.getProperties((Object)ex, AbstractFormField.class, (IPropertyFilter)new FormDataPropertyFilter());
            BeanUtility.setProperties((Object)propertyTarget, (Map)fieldProperties, (boolean)false, null);
        }
    }

    @Override
    public AbstractFormData createFormData() {
        return this.interceptCreateFormData();
    }

    @Override
    public void exportFormData(AbstractFormData target) {
        Map properties = BeanUtility.getProperties((Object)this, AbstractForm.class, (IPropertyFilter)new FormDataPropertyFilter());
        BeanUtility.setProperties((Object)target, (Map)properties, (boolean)false, null);
        this.exportExtensionProperties(this, (IPropertyHolder)target);
        HashSet<IFormField> exportedFields = new HashSet<IFormField>();
        Map breadthFirstMap = target.getAllFieldsRec();
        for (Map targetMap : breadthFirstMap.values()) {
            for (Map.Entry e : targetMap.entrySet()) {
                String fieldQId = (String)e.getKey();
                AbstractFormFieldData data = (AbstractFormFieldData)e.getValue();
                FindFieldByFormDataIdVisitor v = new FindFieldByFormDataIdVisitor(fieldQId, this);
                this.visit(v, IFormField.class);
                IFormField f = v.getField();
                if (f != null) {
                    properties = BeanUtility.getProperties((Object)f, AbstractFormField.class, (IPropertyFilter)new FormDataPropertyFilter());
                    BeanUtility.setProperties((Object)data, (Map)properties, (boolean)false, null);
                    this.exportExtensionProperties(f, (IPropertyHolder)data);
                    f.exportFormFieldData(data);
                    exportedFields.add(f);
                    continue;
                }
                LOG.warn("Cannot find field with id '{}' in form '{}' for DTO '{}'.", new Object[]{fieldQId, this.getClass().getName(), data.getClass().getName()});
            }
        }
        this.visit((T field) -> {
            if (exportedFields.contains(field)) {
                return;
            }
            IForm formOfField = field.getForm();
            if (formOfField == null) {
                LOG.info("Extension properties are not exported for fields on which getForm() returns null. Ensure that the form is initialized and that the field's parent invokes field.setFormInternal(IForm) [exportingForm={}, field={}]", (Object)this.getClass().getName(), (Object)field.getClass().getName());
                return;
            }
            if (formOfField != this) {
                return;
            }
            this.exportExtensionProperties(field, (IPropertyHolder)target);
        }, IFormField.class);
    }

    @Override
    public void importFormData(AbstractFormData source) {
        this.importFormData(source, false, null);
    }

    @Override
    public void importFormData(AbstractFormData source, boolean valueChangeTriggersEnabled) {
        this.importFormData(source, valueChangeTriggersEnabled, null);
    }

    @Override
    public void importFormData(AbstractFormData source, boolean valueChangeTriggersEnabled, IPropertyFilter filter) {
        this.importFormData(source, valueChangeTriggersEnabled, filter, null);
    }

    private void removeNotSetProperties(IPropertyHolder dto, Map<String, Object> properties) {
        Iterator<String> it = properties.keySet().iterator();
        while (it.hasNext()) {
            String propertyId = it.next();
            AbstractPropertyData pd = dto.getPropertyById(propertyId);
            if (pd == null || pd.isValueSet()) continue;
            it.remove();
        }
    }

    private void importProperties(IPropertyHolder source, Object target, Class<?> stopClass, IPropertyFilter filter) {
        List allContributions;
        Map properties = BeanUtility.getProperties((Object)source, stopClass, (IPropertyFilter)filter);
        if (!properties.isEmpty()) {
            this.removeNotSetProperties(source, properties);
            BeanUtility.setProperties((Object)target, (Map)properties, (boolean)false, null);
        }
        if (!(allContributions = source.getAllContributions()).isEmpty()) {
            for (Object con : allContributions) {
                IPropertyHolder data;
                Map extensionProperties;
                if (!(con instanceof IPropertyHolder) || (extensionProperties = BeanUtility.getProperties((Object)(data = (IPropertyHolder)con), stopClass, (IPropertyFilter)filter)).isEmpty()) continue;
                Object clientPart = this.getClientPartOfExtensionOrContributionRec(data, target);
                if (clientPart != null) {
                    this.removeNotSetProperties(data, extensionProperties);
                    BeanUtility.setProperties((Object)clientPart, (Map)extensionProperties, (boolean)false, null);
                    continue;
                }
                LOG.warn("cannot find extension for property data '{}' in form '{}'.", (Object)data.getClass().getName(), (Object)this.getClass().getName());
            }
        }
    }

    private Object getClientPartOfExtensionOrContribution(Object extToSearch, Object owner) {
        if (owner instanceof IExtensibleObject) {
            IExtensibleObject exOwner = (IExtensibleObject)owner;
            for (IExtension ex : exOwner.getAllExtensions()) {
                Class<?> dto = AbstractForm.getDataAnnotationValue(ex.getClass());
                if (!extToSearch.getClass().equals(dto)) continue;
                return ex;
            }
        }
        if (owner instanceof IContributionOwner) {
            IContributionOwner compOwner = (IContributionOwner)owner;
            for (Object o : compOwner.getAllContributions()) {
                FormData annotation = o.getClass().getAnnotation(FormData.class);
                if (annotation == null || !annotation.value().equals(extToSearch.getClass())) continue;
                return o;
            }
        }
        return null;
    }

    private Object getClientPartOfExtensionOrContributionRec(Object extToSearch, Object owner) {
        Object ext = this.getClientPartOfExtensionOrContribution(extToSearch, owner);
        if (ext != null) {
            return ext;
        }
        Holder result = new Holder(Object.class);
        Function<IFormField, TreeVisitResult> visitor = arg_0 -> this.lambda$7((IHolder)result, extToSearch, arg_0);
        if (owner instanceof IWidget) {
            ((IWidget)owner).visit(visitor, IFormField.class);
        }
        return result.getValue();
    }

    private static Class<?> getFieldStopClass(Object data) {
        if (data instanceof AbstractFormFieldData) {
            return ((AbstractFormFieldData)data).getFieldStopClass();
        }
        return AbstractFormFieldData.class;
    }

    @Override
    public void importFormData(AbstractFormData source, boolean valueChangeTriggersEnabled, IPropertyFilter filter, IFormFieldFilter formFieldFilter) {
        Assertions.assertNotNull((Object)source, (String)"source form data must not be null", (Object[])new Object[0]);
        if (filter == null) {
            filter = new FormDataPropertyFilter();
        }
        this.importProperties((IPropertyHolder)source, this, AbstractFormData.class, filter);
        LinkedList<IFormField> masterList = new LinkedList<IFormField>();
        LinkedList<IFormField> slaveList = new LinkedList<IFormField>();
        HashMap<IFormField, AbstractFormFieldData> dataMap = new HashMap<IFormField, AbstractFormFieldData>();
        Map breadthFirstMap = source.getAllFieldsRec();
        for (Map sourceMap : breadthFirstMap.values()) {
            for (Map.Entry e : sourceMap.entrySet()) {
                String fieldQId = (String)e.getKey();
                AbstractFormFieldData data = (AbstractFormFieldData)e.getValue();
                FindFieldByFormDataIdVisitor v = new FindFieldByFormDataIdVisitor(fieldQId, this);
                this.visit(v, IFormField.class);
                IFormField f = v.getField();
                if (f != null) {
                    if (formFieldFilter != null && !formFieldFilter.accept(f)) continue;
                    dataMap.put(f, data);
                    if (f.getMasterField() != null) {
                        int index = slaveList.indexOf(f.getMasterField());
                        if (index >= 0) {
                            slaveList.add(index + 1, f);
                            continue;
                        }
                        slaveList.addFirst(f);
                        continue;
                    }
                    masterList.add(f);
                    continue;
                }
                LOG.warn("cannot find field data for '{}' in form '{}'.", (Object)fieldQId, (Object)this.getClass().getName());
            }
        }
        for (IFormField f : masterList) {
            this.importFormField(f, dataMap, valueChangeTriggersEnabled, filter);
        }
        for (IFormField f : slaveList) {
            this.importFormField(f, dataMap, valueChangeTriggersEnabled, filter);
        }
    }

    private void importFormField(IFormField f, Map<IFormField, AbstractFormFieldData> dataMap, boolean valueChangeTriggersEnabled, IPropertyFilter filter) {
        AbstractFormFieldData data = dataMap.get(f);
        this.importProperties((IPropertyHolder)data, f, AbstractForm.getFieldStopClass(data), filter);
        f.importFormFieldData(data, valueChangeTriggersEnabled);
    }

    public static String parseFormId(String className) {
        String s = className;
        int i = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
        s = s.substring(i + 1);
        return s;
    }

    @Override
    public String getFormId() {
        return AbstractForm.parseFormId(this.getClass().getName());
    }

    @Override
    public String classId() {
        if (this.m_classId != null) {
            return this.m_classId;
        }
        return super.classId();
    }

    public void setClassId(String classId) {
        this.m_classId = classId;
    }

    @Override
    public IFormHandler getHandler() {
        return this.m_handler;
    }

    @Override
    public void setHandler(IFormHandler handler) {
        if (handler != this.m_handler) {
            if (this.m_handler != null) {
                this.m_handler.setFormInternal(null);
            }
            if (handler == null) {
                handler = new NullFormHandler();
            }
            this.m_handler = handler;
            this.m_handler.setFormInternal(this);
        }
    }

    @Override
    public IWizard getWizard() {
        return this.getWizardStep() != null ? this.getWizardStep().getWizard() : null;
    }

    @Override
    public IWizardStep getWizardStep() {
        return this.m_wizardStep;
    }

    @Override
    public List<IFormField> getAllFields() {
        CollectingVisitor v = new CollectingVisitor();
        this.visit(v, IFormField.class);
        return v.getCollection();
    }

    protected IDesktop getDesktop() {
        return IDesktop.CURRENT.get();
    }

    @Override
    public final SearchFilter getSearchFilter() {
        if (this.m_searchFilter == null) {
            this.resetSearchFilter();
        }
        return this.m_searchFilter;
    }

    @Override
    public final void setSearchFilter(SearchFilter searchFilter) {
        this.m_searchFilter = searchFilter;
    }

    public void rebuildSearchFilter() {
        this.resetSearchFilter();
    }

    @Override
    public void resetSearchFilter() {
        if (this.m_searchFilter == null) {
            ISearchFilterService sfs = (ISearchFilterService)BEANS.get(ISearchFilterService.class);
            SearchFilter filter = sfs != null ? sfs.createNewSearchFilter() : new SearchFilter();
            this.m_searchFilter = filter;
        }
        try {
            this.interceptResetSearchFilter(this.m_searchFilter);
        }
        catch (Exception e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
        }
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execResetSearchFilter(SearchFilter searchFilter) {
        searchFilter.clear();
        this.getRootGroupBox().applySearch(searchFilter);
        this.interceptAddSearchTerms(searchFilter);
        AbstractFormData data = this.createFormData();
        if (data != null) {
            this.exportFormData(data);
            this.getSearchFilter().setFormData(data);
        }
    }

    @ConfigOperation
    @Order(value=11.0)
    protected AbstractFormData execCreateFormData() {
        Class<? extends AbstractFormData> formDataClass = this.getFormDataClass();
        if (formDataClass == null) {
            return null;
        }
        try {
            return formDataClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating instance of class '" + formDataClass.getName() + "'.", new Object[]{e}));
            return null;
        }
    }

    protected Class<? extends AbstractFormData> getFormDataClass() {
        FormData formDataAnnotation = this.getClass().getAnnotation(FormData.class);
        Class<?> superclazz = this.getClass().getSuperclass();
        while (formDataAnnotation == null && superclazz != null) {
            formDataAnnotation = superclazz.getAnnotation(FormData.class);
            superclazz = superclazz.getSuperclass();
        }
        if (formDataAnnotation == null) {
            return null;
        }
        Class formDataClass = formDataAnnotation.value();
        if (formDataClass == null) {
            return null;
        }
        if (AbstractFormData.class.isAssignableFrom(formDataClass) && !Modifier.isAbstract(formDataClass.getModifiers())) {
            return formDataClass;
        }
        return null;
    }

    @Override
    public boolean isFormStored() {
        return STATE_BIT_HELPER.isBitSet(FORM_STORED, this.m_states);
    }

    @Override
    public void setFormStored(boolean b) {
        this.m_states = STATE_BIT_HELPER.changeBit(FORM_STORED, b, this.m_states);
    }

    @Override
    public boolean isFormLoading() {
        return STATE_BIT_HELPER.isBitSet(FORM_LOADING, this.m_states);
    }

    private void setFormLoading(boolean b) {
        this.m_states = STATE_BIT_HELPER.changeBit(FORM_LOADING, b, this.m_states);
    }

    @Override
    public IGroupBox getRootGroupBox() {
        return this.m_mainBox;
    }

    @Override
    public IForm getOuterForm() {
        IWrappedFormField outerFormField = this.getOuterFormField();
        return outerFormField != null ? outerFormField.getForm() : null;
    }

    @Override
    public IWrappedFormField getOuterFormField() {
        return this.getParentOfType(IWrappedFormField.class);
    }

    @Override
    public IFormField getFieldById(String id) {
        return this.getRootGroupBox().getFieldById(id);
    }

    @Override
    public <T extends IFormField> T getFieldById(String id, Class<T> type) {
        return this.getRootGroupBox().getFieldById(id, type);
    }

    @Override
    public <T extends IFormField> T getFieldByClass(Class<T> c) {
        return this.getRootGroupBox().getFieldByClass(c);
    }

    @Override
    protected void initInternal() {
        super.initInternal();
        this.initFormInternal();
        this.interceptInitForm();
    }

    protected void initFormInternal() {
        this.calculateSaveNeeded();
    }

    @Override
    public int getCloseSystemType() {
        return this.m_closeType;
    }

    @Override
    public void setCloseSystemType(int type) {
        this.m_closeType = type;
    }

    protected void loadStateInternal() {
        this.fireFormLoadBefore();
        if (!this.isBlockingInternal()) {
            return;
        }
        this.getHandler().onLoad();
        if (!this.isBlockingInternal()) {
            return;
        }
        this.fireFormLoadAfter();
        if (!this.isBlockingInternal()) {
            return;
        }
        this.markSaved();
        this.rebuildSearchFilter();
        this.setFormLoading(false);
        this.getHandler().onPostLoad();
        if (!this.isBlockingInternal()) {
            return;
        }
        if (this.getHandler().isGuiLess()) {
            this.touch();
        }
        this.fireFormLoadComplete();
    }

    protected void storeStateInternal() {
        if (!this.m_blockingCondition.isBlocking()) {
            String msg = TEXTS.get((String)"FormDisposedMessage", (String[])new String[]{this.getTitle()});
            LOG.error(msg);
            throw new VetoException(msg, new Object[0]);
        }
        this.fireFormStoreBefore();
        this.setFormStored(true);
        try {
            this.rebuildSearchFilter();
            this.m_searchFilter.setCompleted(true);
            this.getHandler().onStore();
            this.interceptStored();
            if (!this.isFormStored()) {
                ProcessingException e = new ProcessingException("Form was marked as not stored.", new Object[0]);
                e.consume();
                throw e;
            }
        }
        catch (RuntimeException | PlatformError e) {
            if (this.m_searchFilter != null) {
                this.m_searchFilter.clear();
            }
            this.setFormStored(false);
            if (e instanceof RuntimeException) {
                this.throwVetoExceptionInternal((RuntimeException)e);
            } else if (e instanceof PlatformError) {
                throw e;
            }
            this.setFormStored(true);
        }
        this.fireFormStoreAfter();
    }

    protected void discardStateInternal() {
        this.fireFormDiscarded();
        this.getHandler().onDiscard();
    }

    @Override
    public void setCloseTimer(int seconds) {
        this.removeCloseTimer();
        if (seconds > 0) {
            this.setCloseTimerArmed(true);
            this.m_closeTimerFuture = this.installFormCloseTimer(seconds);
        }
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Collections.singletonList(this.getRootGroupBox())});
    }

    protected void throwVetoExceptionInternal(RuntimeException e) {
        PlatformException pe = ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]);
        if (pe instanceof VetoException && !pe.isConsumed()) {
            VetoException ve = (VetoException)pe;
            this.interceptOnVetoException(ve, ve.getStatus().getCode());
            ve.consume();
        }
        throw e;
    }

    @Override
    public void removeCloseTimer() {
        this.setCloseTimerArmed(false);
        this.setSubTitle(null);
    }

    @Override
    public void validateForm() {
        if (!this.interceptCheckFields()) {
            VetoException veto = new VetoException("Validate " + this.getClass().getSimpleName(), new Object[0]);
            veto.consume();
            throw veto;
        }
        if (!this.getHandler().onCheckFields()) {
            VetoException veto = new VetoException("Validate " + this.getClass().getSimpleName(), new Object[0]);
            veto.consume();
            throw veto;
        }
        ArrayList<String> invalidTexts = new ArrayList<String>();
        ArrayList<String> mandatoryTexts = new ArrayList<String>();
        AtomicReference firstProblemRef = new AtomicReference();
        Consumer<IFormField> v = f -> {
            IValidateContentDescriptor desc = f.validateContent();
            if (desc != null) {
                if (desc.getErrorStatus() != null) {
                    invalidTexts.add(String.valueOf(desc.getDisplayText()) + ": " + desc.getErrorStatus().getMessage());
                } else {
                    mandatoryTexts.add(desc.getDisplayText());
                }
                firstProblemRef.compareAndSet(null, desc);
            }
        };
        this.visit(v, IFormField.class);
        IValidateContentDescriptor firstProblem = (IValidateContentDescriptor)firstProblemRef.get();
        if (firstProblem != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("there are fields with errors");
            }
            firstProblem.activateProblemLocation();
            throw new VetoException().withHtmlMessage(this.createValidationMessageBoxHtml(invalidTexts, mandatoryTexts));
        }
        if (!this.interceptValidate()) {
            VetoException veto = new VetoException("Validate " + this.getClass().getSimpleName(), new Object[0]);
            veto.consume();
            throw veto;
        }
        if (!this.getHandler().onValidate()) {
            VetoException veto = new VetoException("Validate " + this.getClass().getSimpleName(), new Object[0]);
            veto.consume();
            throw veto;
        }
    }

    protected IHtmlContent createValidationMessageBoxHtml(List<String> invalidTexts, List<String> mandatoryTexts) {
        ArrayList<IHtmlElement> content = new ArrayList<IHtmlElement>();
        if (!mandatoryTexts.isEmpty()) {
            content.add(HTML.bold((CharSequence[])new CharSequence[]{TEXTS.get((String)"FormEmptyMandatoryFieldsMessage")}));
            ArrayList<IHtmlListElement> mandatoryTextElements = new ArrayList<IHtmlListElement>();
            for (String e : mandatoryTexts) {
                mandatoryTextElements.add(HTML.li((CharSequence)e));
            }
            content.add(HTML.ul(mandatoryTextElements));
            content.add(HTML.br());
        }
        if (!invalidTexts.isEmpty()) {
            content.add(HTML.bold((CharSequence[])new CharSequence[]{TEXTS.get((String)"FormInvalidFieldsMessage")}));
            ArrayList<IHtmlListElement> invalidTextElements = new ArrayList<IHtmlListElement>();
            for (String e : invalidTexts) {
                invalidTextElements.add(HTML.li((CharSequence)e));
            }
            content.add(HTML.ul(invalidTextElements));
        }
        return HTML.fragment(content);
    }

    @Override
    public void setTimer(String timerId, int seconds) {
        this.removeTimer(timerId);
        if (seconds > 0) {
            IFuture<Void> future = this.startTimer(seconds, timerId);
            this.m_timerFutureMap.put(timerId, future);
        }
    }

    @Override
    public void removeTimer(String timerId) {
        IFuture<Void> future = this.m_timerFutureMap.remove(timerId);
        if (future != null) {
            future.cancel(false);
        }
    }

    @Override
    public void doClose() {
        if (!this.isBlockingInternal()) {
            return;
        }
        try {
            this.m_closeType = 2;
            this.discardStateInternal();
            this.doFinally();
            this.dispose();
        }
        catch (RuntimeException | PlatformError e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate(e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]);
        }
    }

    @Override
    public void doCancel() {
        if (!this.isBlockingInternal()) {
            return;
        }
        this.m_closeType = 1;
        try {
            this.checkSaveNeeded();
            if (this.isSaveNeeded() && this.isAskIfNeedSave()) {
                int result = MessageBoxes.createYesNoCancel().withHeader(this.getCancelVerificationText()).withSeverity(256).show();
                if (result == 0) {
                    this.doOk();
                    return;
                }
                if (result == 1) {
                    this.doClose();
                    return;
                }
                VetoException e = new VetoException(TEXTS.get((String)"UserCancelledOperation"), new Object[0]);
                e.consume();
                throw e;
            }
            this.discardStateInternal();
            this.doFinally();
            this.dispose();
        }
        catch (RuntimeException | PlatformError e) {
            this.m_closeType = 0;
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate(e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]);
        }
    }

    @Override
    public void doReset() {
        this.setFormLoading(true);
        Consumer<IFormField> v = field -> {
            if (field instanceof IValueField) {
                IValueField f = (IValueField)field;
                f.resetValue();
            } else if (field instanceof IComposerField) {
                IComposerField f = (IComposerField)field;
                f.resetValue();
            }
        };
        try {
            this.visit(v, IFormField.class);
            this.reinit();
            this.loadStateInternal();
        }
        catch (RuntimeException | PlatformError e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate(e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]);
        }
        this.fireFormResetComplete();
    }

    @Override
    public void doOk() {
        if (!this.isBlockingInternal()) {
            return;
        }
        try {
            this.m_closeType = 0;
            this.checkSaveNeeded();
            this.validateForm();
            this.m_closeType = 3;
            if (this.isSaveNeeded()) {
                this.storeStateInternal();
                this.markSaved();
            }
            this.doFinally();
            this.dispose();
        }
        catch (RuntimeException e) {
            this.m_closeType = 0;
            this.throwVetoExceptionInternal(e);
        }
        catch (PlatformError e) {
            this.m_closeType = 0;
            throw e;
        }
    }

    @Override
    public void doSaveWithoutMarkerChange() {
        if (!this.isBlockingInternal()) {
            return;
        }
        try {
            this.m_closeType = 0;
            this.checkSaveNeeded();
            this.validateForm();
            this.m_closeType = 6;
            this.storeStateInternal();
        }
        catch (RuntimeException e) {
            this.m_closeType = 0;
            this.throwVetoExceptionInternal(e);
        }
        catch (PlatformError e) {
            this.m_closeType = 0;
            throw e;
        }
    }

    @Override
    public void doSave() {
        if (!this.isBlockingInternal()) {
            return;
        }
        try {
            this.m_closeType = 0;
            this.checkSaveNeeded();
            this.validateForm();
            this.m_closeType = 5;
            if (this.isSaveNeeded()) {
                this.storeStateInternal();
                this.markSaved();
            }
        }
        catch (RuntimeException e) {
            this.m_closeType = 0;
            this.throwVetoExceptionInternal(e);
        }
        catch (PlatformError e) {
            this.m_closeType = 0;
            throw e;
        }
    }

    @Override
    public void setAllEnabled(boolean b) {
        IGroupBox box = this.getRootGroupBox();
        if (box != null) {
            box.setEnabled(b, false, true);
        }
    }

    @Override
    public void doFinally() {
        try {
            this.getHandler().onFinally();
        }
        catch (RuntimeException | PlatformError e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate(e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]);
        }
    }

    @Override
    public String getCancelVerificationText() {
        return this.m_cancelVerificationText;
    }

    @Override
    public void setCancelVerificationText(String text) {
        this.m_cancelVerificationText = text;
    }

    @Override
    public List<? extends IFormField> getInvalidFields() {
        CollectingVisitor<IFormField> v = new CollectingVisitor<IFormField>(){

            protected boolean accept(IFormField field) {
                return !field.isContentValid();
            }
        };
        this.visit(v, IFormField.class);
        return v.getCollection();
    }

    @Override
    public final void checkSaveNeeded() {
        this.visit(IFormField::checkSaveNeeded, IFormField.class);
        this.calculateSaveNeeded();
    }

    private boolean checkForVerifyingFields() {
        Function<IValueField, TreeVisitResult> v = f -> {
            if (f.isValueChanging() || f.isValueParsing()) {
                return TreeVisitResult.TERMINATE;
            }
            return TreeVisitResult.CONTINUE;
        };
        return this.visit(v, IValueField.class) != TreeVisitResult.TERMINATE;
    }

    private void closeFormInternal(boolean kill) {
        if (this.isBlockingInternal()) {
            try {
                HashSet<Integer> enabledSystemTypes = new HashSet<Integer>();
                Consumer<IButton> v = b -> {
                    if (b.isEnabled() && b.isVisible()) {
                        enabledSystemTypes.add(b.getSystemType());
                    }
                };
                this.visit(v, IButton.class);
                this.interceptOnCloseRequest(kill, enabledSystemTypes);
            }
            catch (RuntimeException | PlatformError e) {
                throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate(e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]);
            }
        }
    }

    @Override
    public void touch() {
        this.getRootGroupBox().touch();
    }

    protected void calculateSaveNeeded() {
        this.propertySupport.setPropertyBool("saveNeeded", this.interceptIsSaveNeeded());
    }

    @Override
    public boolean isSaveNeeded() {
        return this.propertySupport.getPropertyBool("saveNeeded");
    }

    @Override
    public void markSaved() {
        this.getRootGroupBox().markSaved();
    }

    @Override
    public boolean isEmpty() {
        return this.getRootGroupBox().isEmpty();
    }

    @Override
    protected final void disposeInternal() {
        this.disposeFormInternal();
        super.disposeInternal();
    }

    protected void disposeFormInternal() {
        if (!this.isBlockingInternal()) {
            return;
        }
        try {
            this.setButtonsArmed(false);
            this.setCloseTimerArmed(false);
            this.setFormStarted(false);
            Iterator<IFuture<Void>> iterator = this.m_timerFutureMap.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().cancel(false);
                iterator.remove();
            }
            try {
                this.interceptDisposeForm();
                this.unregisterDataChangeListener(new Object[0]);
            }
            catch (Exception t) {
                LOG.warn("Failed to dispose Form {}", (Object)this.getClass().getName(), (Object)t);
            }
            this.getDesktop().hideForm(this);
            List<IForm> forms = this.getDesktop().getForms(this);
            for (IForm childForm : forms) {
                childForm.setDisplayParent(this.getDesktop());
            }
        }
        finally {
            this.m_blockingCondition.setBlocking(false);
            this.fireFormClosed();
        }
    }

    @Override
    public boolean isShowing() {
        return this.getDesktop().isShowing(this);
    }

    @Override
    public boolean isFormClosed() {
        return !this.isBlockingInternal();
    }

    @Override
    public boolean isFormStartable() {
        return !this.isFormStarted() && !this.isBlockingInternal();
    }

    @Override
    public boolean isFormStarted() {
        return STATE_BIT_HELPER.isBitSet(FORM_STARTED, this.m_states);
    }

    private void setFormStarted(boolean started) {
        this.m_states = STATE_BIT_HELPER.changeBit(FORM_STARTED, started, this.m_states);
    }

    protected boolean isBlockingInternal() {
        return this.m_blockingCondition.isBlocking();
    }

    @Override
    public void loadFromXmlString(String xml) {
        if (xml == null) {
            return;
        }
        Document xmlDocument = XmlUtility.getXmlDocument((String)xml);
        this.loadFromXml(xmlDocument.getDocumentElement());
    }

    @Override
    public String storeToXmlString() {
        try {
            Document e = this.storeToXml();
            return XmlUtility.wellformDocument((Document)e);
        }
        catch (RuntimeException e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]);
        }
    }

    @Override
    public Document storeToXml() {
        Document doc = XmlUtility.createNewXmlDocument((String)"form-state");
        this.storeToXml(doc.getDocumentElement());
        return doc;
    }

    @Override
    public void storeToXml(Element root) {
        root.setAttribute("formId", this.getFormId());
        root.setAttribute("formQname", this.getClass().getName());
        Element xProps = root.getOwnerDocument().createElement("properties");
        root.appendChild(xProps);
        IPropertyFilter filter = descriptor -> {
            if (descriptor.getPropertyType().isInstance(IFormField.class)) {
                return false;
            }
            if (!descriptor.getPropertyType().isPrimitive() && !Serializable.class.isAssignableFrom(descriptor.getPropertyType())) {
                return false;
            }
            return descriptor.getReadMethod() != null && descriptor.getWriteMethod() != null;
        };
        Map props = BeanUtility.getProperties((Object)this, AbstractForm.class, (IPropertyFilter)filter);
        this.storePropertiesToXml(xProps, props);
        for (IExtension iExtension : this.getAllExtensions()) {
            Map extensionProps = BeanUtility.getProperties((Object)iExtension, AbstractFormExtension.class, (IPropertyFilter)filter);
            if (extensionProps.isEmpty()) continue;
            Element xExtension = root.getOwnerDocument().createElement("extension");
            xProps.appendChild(xExtension);
            xExtension.setAttribute("extensionId", iExtension.getClass().getSimpleName());
            xExtension.setAttribute("extensionQname", iExtension.getClass().getName());
            this.storePropertiesToXml(xExtension, extensionProps);
        }
        Element element = root.getOwnerDocument().createElement("fields");
        root.appendChild(element);
        Function<IFormField, TreeVisitResult> v = field -> {
            if (field.getForm() != this || !this.getStoreToXmlFieldFilter().test((IFormField)field)) {
                return TreeVisitResult.CONTINUE;
            }
            Element xField = xFields.getOwnerDocument().createElement("field");
            field.storeToXml(xField);
            xFields.appendChild(xField);
            return TreeVisitResult.CONTINUE;
        };
        this.visit(v, IFormField.class);
    }

    protected void storePropertiesToXml(Element parent, Map<String, Object> props) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            try {
                Element xProp = parent.getOwnerDocument().createElement("property");
                parent.appendChild(xProp);
                xProp.setAttribute("name", entry.getKey());
                XmlUtility.setObjectAttribute((Element)xProp, (String)"value", (Object)entry.getValue());
            }
            catch (Exception e) {
                throw new ProcessingException("property " + entry.getKey() + " with value " + entry.getValue(), new Object[]{e});
            }
        }
    }

    @Override
    public void loadFromXml(Element root) {
        Element xFields;
        Element xProps = XmlUtility.getFirstChildElement((Element)root, (String)"properties");
        if (xProps != null) {
            Map<String, Object> props = this.loadPropertiesFromXml(xProps);
            BeanUtility.setProperties((Object)this, props, (boolean)true, null);
            for (Element xExtension : XmlUtility.getChildElements((Element)xProps, (String)"extension")) {
                String extensionId = xExtension.getAttribute("extensionId");
                String extensionQname = xExtension.getAttribute("extensionQname");
                IFormExtension<? extends AbstractForm> extension = this.findFormExtensionById(extensionQname, extensionId);
                if (extension == null) continue;
                Map<String, Object> extensionProps = this.loadPropertiesFromXml(xExtension);
                BeanUtility.setProperties((Object)extension, extensionProps, (boolean)true, null);
            }
        }
        if ((xFields = XmlUtility.getFirstChildElement((Element)root, (String)"fields")) != null) {
            for (Element xField : XmlUtility.getChildElements((Element)xFields, (String)"field")) {
                LinkedList<String> xmlFieldIds = new LinkedList<String>();
                for (Element element : XmlUtility.getChildElements((Element)xField, (String)"enclosingField")) {
                    xmlFieldIds.add(element.getAttribute("fieldId"));
                }
                xmlFieldIds.add(xField.getAttribute("fieldId"));
                FindFieldByXmlIdsVisitor v = new FindFieldByXmlIdsVisitor(xmlFieldIds.toArray(new String[0]));
                this.visit(v, IFormField.class);
                IFormField f = v.getField();
                if (f == null) continue;
                f.loadFromXml(xField);
            }
        }
        this.getRootGroupBox().visit((T tabBox) -> {
            IGroupBox selbox = tabBox.getSelectedTab();
            if (selbox == null || !selbox.isSaveNeeded()) {
                for (IGroupBox g : tabBox.getGroupBoxes()) {
                    if (!g.isSaveNeeded() || !g.isVisible()) continue;
                    tabBox.setSelectedTab(g);
                    break;
                }
            }
        }, ITabBox.class);
    }

    protected IFormExtension<? extends AbstractForm> findFormExtensionById(String extensionQname, String extensionId) {
        IFormExtension<? extends AbstractForm> candidate = null;
        for (IFormExtension<? extends AbstractForm> iFormExtension : this.getAllExtensions()) {
            if (iFormExtension.getClass().getName().equals(extensionQname)) {
                return iFormExtension;
            }
            if (candidate != null || !iFormExtension.getClass().getSimpleName().equals(extensionId)) continue;
            candidate = iFormExtension;
        }
        return candidate;
    }

    protected Map<String, Object> loadPropertiesFromXml(Element xProps) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (Element xProp : XmlUtility.getChildElements((Element)xProps, (String)"property")) {
            String name = xProp.getAttribute("name");
            try {
                Object o = XmlUtility.getObjectAttribute((Element)xProp, (String)"value");
                props.put(name, o);
            }
            catch (Exception e) {
                LOG.warn("Could not load XML property {}", (Object)name, (Object)e);
            }
        }
        return props;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doExportXml(boolean saveAs) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);){
                        XmlUtility.wellformDocument((Document)this.storeToXml(), (Writer)w);
                        BinaryResource res = new BinaryResource("form.xml", bos.toByteArray());
                        this.getDesktop().openUri(res, (IOpenUriAction)OpenUriAction.DOWNLOAD);
                    }
                    if (bos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bos == null) throw throwable;
                    bos.close();
                    throw throwable;
                }
                bos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException(String.valueOf(TEXTS.get((String)"FormExportXml")) + " " + this.getTitle(), new Object[]{e}));
        }
    }

    @Override
    public void doImportXml() {
        block13: {
            try {
                List<BinaryResource> a = new FileChooser(Collections.singletonList("xml"), false).startChooser();
                if (a.size() != 1) break block13;
                BinaryResource newPath = a.get(0);
                try {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (ByteArrayInputStream in = new ByteArrayInputStream(newPath.getContent());){
                        Document doc = XmlUtility.getXmlDocument((InputStream)in);
                        this.loadFromXml(doc.getDocumentElement());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    LOG.warn("Could not load XML from file: {}", (Object)newPath, (Object)e);
                    MessageBoxes.createOk().withDisplayParent(this).withHeader(TEXTS.get((String)"LoadFormXmlFailedText")).show();
                }
            }
            catch (Exception e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
            }
        }
    }

    @Override
    public void activate() {
        this.getDesktop().activateForm(this);
    }

    @Override
    public void requestFocus(IFormField f) {
        if (f == null || f.getForm() != this) {
            return;
        }
        this.fireRequestEvent(6020, f);
    }

    @Override
    public void requestInput(IFormField f) {
        if (f == null || f.getForm() != this) {
            return;
        }
        this.fireRequestEvent(6030, f);
    }

    public Map<Class<?>, Class<? extends IFormField>> getFormFieldReplacementsInternal() {
        return this.m_fieldReplacements;
    }

    public void registerFormFieldReplacementsInternal(Map<Class<?>, Class<? extends IFormField>> replacements) {
        if (replacements == null || replacements.isEmpty()) {
            return;
        }
        if (this.m_fieldReplacements == null) {
            this.m_fieldReplacements = new HashMap();
        }
        this.m_fieldReplacements.putAll(replacements);
    }

    @Override
    public FormListeners formListeners() {
        return this.m_listenerList;
    }

    protected IEventHistory<FormEvent> createEventHistory() {
        return new DefaultFormEventHistory(5000L);
    }

    @Override
    public IEventHistory<FormEvent> getEventHistory() {
        return this.m_eventHistory;
    }

    private void fireFormLoadBefore() {
        this.fireFormEvent(new FormEvent(this, 1000));
    }

    private void fireFormLoadAfter() {
        this.fireFormEvent(new FormEvent(this, 1010));
    }

    private void fireFormLoadComplete() {
        this.fireFormEvent(new FormEvent(this, 1020));
    }

    private void fireFormStoreBefore() {
        this.fireFormEvent(new FormEvent(this, 2010));
    }

    private void fireFormResetComplete() {
        this.fireFormEvent(new FormEvent(this, 3020));
    }

    private void fireFormDiscarded() {
        try {
            this.fireFormEvent(new FormEvent(this, 3000));
        }
        catch (RuntimeException | PlatformError e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate(e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]);
        }
    }

    private void fireFormStoreAfter() {
        this.fireFormEvent(new FormEvent(this, 2020));
    }

    private void fireFormActivated() {
        try {
            this.interceptFormActivated();
            this.fireFormEvent(new FormEvent(this, 510));
        }
        catch (RuntimeException | PlatformError e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate(e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]);
        }
    }

    private void fireFormClosed() {
        try {
            this.fireFormEvent(new FormEvent(this, 3010));
        }
        catch (RuntimeException | PlatformError e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate(e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]);
        }
    }

    protected void fireFormEvent(FormEvent e) {
        RuntimeException pe = null;
        for (FormListener listener : this.formListeners().list(e.getType())) {
            try {
                listener.formChanged(e);
            }
            catch (RuntimeException ex) {
                if (pe != null) continue;
                pe = ex;
            }
        }
        if (pe != null) {
            throw pe;
        }
        IEventHistory<FormEvent> h = this.getEventHistory();
        if (h != null) {
            h.notifyEvent(e);
        }
    }

    @Override
    public void structureChanged(IFormField causingField) {
        this.fireFormStructureChanged(causingField);
    }

    private void fireFormStructureChanged(IFormField causingField) {
        try {
            this.fireFormEvent(new FormEvent(this, 5000, causingField));
        }
        catch (RuntimeException | PlatformError e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate(e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]).withContextInfo("field", (Object)(causingField == null ? "<null>" : causingField.getClass().getName()), new Object[0]);
        }
    }

    private void fireFormToFront() {
        try {
            this.fireFormEvent(new FormEvent(this, 6000));
        }
        catch (RuntimeException | PlatformError e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate(e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]);
        }
    }

    private void fireFormToBack() {
        try {
            this.fireFormEvent(new FormEvent(this, 6010));
        }
        catch (RuntimeException | PlatformError e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate(e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]);
        }
    }

    private void fireRequestEvent(int eventType, IFormField f) {
        try {
            this.fireFormEvent(new FormEvent(this, eventType, f));
        }
        catch (RuntimeException | PlatformError e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate(e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]).withContextInfo("field", (Object)(f == null ? "<null>" : f.getClass().getName()), new Object[0]);
        }
    }

    @Override
    public void setHeaderVisible(Boolean visible) {
        this.propertySupport.setProperty("headerVisible", (Object)visible);
    }

    @Override
    public Boolean isHeaderVisible() {
        return (Boolean)this.propertySupport.getProperty("headerVisible");
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String title) {
        this.propertySupport.setPropertyString("title", title);
    }

    @Override
    public String getSubTitle() {
        return this.propertySupport.getPropertyString("subTitle");
    }

    @Override
    public void setSubTitle(String subTitle) {
        this.propertySupport.setPropertyString("subTitle", subTitle);
    }

    @Override
    public boolean isMaximized() {
        return this.propertySupport.getPropertyBool("maximized");
    }

    @Override
    public void setMaximized(boolean maximized) {
        this.propertySupport.setPropertyBool("maximized", maximized);
    }

    @Override
    public boolean isShowOnStart() {
        return FLAGS_BIT_HELPER.isBitSet(SHOW_ON_START, this.m_flags);
    }

    @Override
    public void setShowOnStart(boolean showOnStart) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(SHOW_ON_START, showOnStart, this.m_flags);
    }

    @Override
    public boolean isModal() {
        return (Boolean)this.m_modal.get();
    }

    @Override
    public void setModal(boolean modal) {
        Assertions.assertFalse((boolean)this.getDesktop().isShowing(this), (String)"Property 'modal' cannot be changed because Form is already showing [form={}]", (Object[])new Object[]{this});
        this.m_modal.set((Object)modal, true);
    }

    @Override
    public void setCacheBounds(boolean cacheBounds) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(CACHE_BOUNDS, cacheBounds, this.m_flags);
    }

    @Override
    public boolean isCacheBounds() {
        return FLAGS_BIT_HELPER.isBitSet(CACHE_BOUNDS, this.m_flags);
    }

    @Override
    public String computeCacheBoundsKey() {
        return this.getClass().getName();
    }

    @Override
    public int getDisplayHint() {
        return this.m_displayHint;
    }

    @Override
    public void setDisplayHint(int displayHint) {
        Assertions.assertFalse((boolean)this.getDesktop().isShowing(this), (String)"Property 'displayHint' cannot be changed because Form is already showing [form={}]", (Object[])new Object[]{this});
        switch (displayHint) {
            case 0: 
            case 10: 
            case 20: {
                this.m_displayHint = displayHint;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported displayHint " + displayHint);
            }
        }
        boolean modal = displayHint == 0;
        this.m_modal.set((Object)modal, false);
        this.m_displayParent.set((Object)this.resolveDisplayParent(), false);
    }

    @Override
    public IDisplayParent getDisplayParent() {
        return (IDisplayParent)this.m_displayParent.get();
    }

    @Override
    public void setDisplayParent(IDisplayParent displayParent) {
        IForm rootForm;
        if (displayParent == null) {
            displayParent = this.resolveDisplayParent();
        }
        if ((displayParent = (IDisplayParent)Assertions.assertNotNull((Object)displayParent, (String)"'displayParent' must not be null", (Object[])new Object[0])) instanceof IForm && (rootForm = FormUtility.findRootForm((IForm)displayParent)).getDisplayHint() == 20) {
            displayParent = rootForm;
        }
        if (this.m_displayParent.get() == displayParent) {
            this.m_displayParent.markAsPreferredValue();
            return;
        }
        if (!this.getDesktop().isShowing(this) || ClientSessionProvider.currentSession().isStopping()) {
            this.m_displayParent.set((Object)displayParent, true);
        } else {
            this.getDesktop().hideForm(this);
            this.m_displayParent.set((Object)displayParent, true);
            this.getDesktop().showForm(this);
        }
    }

    @Override
    public String getDisplayViewId() {
        return this.m_displayViewId;
    }

    @Override
    public void setDisplayViewId(String viewId) {
        this.m_displayViewId = viewId;
    }

    @Override
    public boolean isAskIfNeedSave() {
        return FLAGS_BIT_HELPER.isBitSet(ASK_IF_NEED_SAVE, this.m_flags);
    }

    @Override
    public void setAskIfNeedSave(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(ASK_IF_NEED_SAVE, b, this.m_flags);
    }

    @Override
    public void toFront() {
        this.fireFormToFront();
    }

    @Override
    public void toBack() {
        this.fireFormToBack();
    }

    @Override
    public boolean isButtonsArmed() {
        return FLAGS_BIT_HELPER.isBitSet(BUTTONS_ARMED, this.m_flags);
    }

    @Override
    public void setButtonsArmed(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(BUTTONS_ARMED, b, this.m_flags);
    }

    @Override
    public boolean isCloseTimerArmed() {
        return FLAGS_BIT_HELPER.isBitSet(CLOSE_TIMER_ARMED, this.m_flags);
    }

    @Override
    public void setCloseTimerArmed(boolean closeTimerArmed) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(CLOSE_TIMER_ARMED, closeTimerArmed, this.m_flags);
        if (!closeTimerArmed && this.m_closeTimerFuture != null) {
            this.m_closeTimerFuture.cancel(false);
            this.m_closeTimerFuture = null;
        }
    }

    public String toString() {
        return "Form " + this.getFormId();
    }

    @Override
    public IFormUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected void handleSystemButtonEventInternal(ButtonEvent e) {
        switch (e.getType()) {
            case 1: {
                this.setCloseTimerArmed(false);
                if (!this.isButtonsArmed() || !this.checkForVerifyingFields()) break;
                try {
                    IButton src = (IButton)e.getSource();
                    switch (src.getSystemType()) {
                        case 1: {
                            this.doCancel();
                            break;
                        }
                        case 2: {
                            this.doClose();
                            break;
                        }
                        case 3: {
                            this.doOk();
                            break;
                        }
                        case 4: {
                            this.doReset();
                            break;
                        }
                        case 5: {
                            this.doSave();
                            break;
                        }
                        case 6: {
                            this.doSaveWithoutMarkerChange();
                        }
                    }
                    break;
                }
                catch (RuntimeException | PlatformError ex) {
                    ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate(ex).withContextInfo("button", (Object)e.getButton().getClass().getName(), new Object[0]));
                }
            }
        }
    }

    protected IDisplayParent resolveDisplayParent() {
        return (IDisplayParent)ClientRunContexts.copyCurrent().withDesktop(this.m_callingModelContext.getDesktop()).withOutline(this.m_callingModelContext.getOutline(), false).withForm(this.m_callingModelContext.getForm()).call(() -> ((DisplayParentResolver)BEANS.get(DisplayParentResolver.class)).resolve(this));
    }

    protected IFuture<Void> startTimer(int intervalSeconds, final String timerId) {
        return ModelJobs.schedule(new IRunnable(){

            public void run() {
                try {
                    LOG.info("timer {}", (Object)timerId);
                    AbstractForm.this.interceptTimer(timerId);
                }
                catch (RuntimeException | PlatformError e) {
                    throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate(e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]).withContextInfo("timerId", (Object)timerId, new Object[0]);
                }
            }
        }, ModelJobs.newInput(ClientRunContexts.copyCurrent()).withName("Form timer", new Object[0]).withExecutionTrigger(Jobs.newExecutionTrigger().withStartIn((long)intervalSeconds, TimeUnit.SECONDS).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)intervalSeconds))));
    }

    private IFuture<?> installFormCloseTimer(long seconds) {
        final long startMillis = System.currentTimeMillis();
        final long delayMillis = TimeUnit.SECONDS.toMillis(seconds);
        return ModelJobs.schedule(new IRunnable(){

            public void run() {
                long elapsedMillis = System.currentTimeMillis() - startMillis;
                long remainingSeconds = TimeUnit.MILLISECONDS.toSeconds(delayMillis - elapsedMillis);
                if (!AbstractForm.this.isCloseTimerArmed()) {
                    AbstractForm.this.setSubTitle(null);
                } else if (remainingSeconds > 0L) {
                    AbstractForm.this.setSubTitle("" + remainingSeconds);
                } else {
                    AbstractForm.this.setCloseTimerArmed(false);
                    try {
                        AbstractForm.this.interceptCloseTimer();
                    }
                    catch (RuntimeException | PlatformError e) {
                        throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate(e).withContextInfo("form", (Object)this.getClass().getName(), new Object[0]);
                    }
                }
            }
        }, ModelJobs.newInput(ClientRunContexts.copyCurrent()).withName("Close timer", new Object[0]).withExceptionHandling(null, false).withExecutionTrigger(Jobs.newExecutionTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever())));
    }

    protected final void interceptCloseTimer() {
        List<? extends IFormExtension<? extends AbstractForm>> extensions = this.getAllExtensions();
        FormChains.FormCloseTimerChain chain = new FormChains.FormCloseTimerChain(extensions);
        chain.execCloseTimer();
    }

    protected final void interceptInactivityTimer() {
        List<? extends IFormExtension<? extends AbstractForm>> extensions = this.getAllExtensions();
        FormChains.FormInactivityTimerChain chain = new FormChains.FormInactivityTimerChain(extensions);
        chain.execInactivityTimer();
    }

    protected final void interceptStored() {
        List<? extends IFormExtension<? extends AbstractForm>> extensions = this.getAllExtensions();
        FormChains.FormStoredChain chain = new FormChains.FormStoredChain(extensions);
        chain.execStored();
    }

    protected final boolean interceptIsSaveNeeded() {
        List<? extends IFormExtension<? extends AbstractForm>> extensions = this.getAllExtensions();
        FormChains.IsSaveNeededFieldsChain chain = new FormChains.IsSaveNeededFieldsChain(extensions);
        return chain.execIsSaveNeeded();
    }

    protected final boolean interceptCheckFields() {
        List<? extends IFormExtension<? extends AbstractForm>> extensions = this.getAllExtensions();
        FormChains.FormCheckFieldsChain chain = new FormChains.FormCheckFieldsChain(extensions);
        return chain.execCheckFields();
    }

    protected final void interceptResetSearchFilter(SearchFilter searchFilter) {
        List<? extends IFormExtension<? extends AbstractForm>> extensions = this.getAllExtensions();
        FormChains.FormResetSearchFilterChain chain = new FormChains.FormResetSearchFilterChain(extensions);
        chain.execResetSearchFilter(searchFilter);
    }

    protected final void interceptAddSearchTerms(SearchFilter search) {
        List<? extends IFormExtension<? extends AbstractForm>> extensions = this.getAllExtensions();
        FormChains.FormAddSearchTermsChain chain = new FormChains.FormAddSearchTermsChain(extensions);
        chain.execAddSearchTerms(search);
    }

    protected final void interceptOnVetoException(VetoException e, int code) {
        List<? extends IFormExtension<? extends AbstractForm>> extensions = this.getAllExtensions();
        FormChains.FormOnVetoExceptionChain chain = new FormChains.FormOnVetoExceptionChain(extensions);
        chain.execOnVetoException(e, code);
    }

    protected final void interceptFormActivated() {
        List<? extends IFormExtension<? extends AbstractForm>> extensions = this.getAllExtensions();
        FormChains.FormFormActivatedChain chain = new FormChains.FormFormActivatedChain(extensions);
        chain.execFormActivated();
    }

    protected final void interceptDisposeForm() {
        List<? extends IFormExtension<? extends AbstractForm>> extensions = this.getAllExtensions();
        FormChains.FormDisposeFormChain chain = new FormChains.FormDisposeFormChain(extensions);
        chain.execDisposeForm();
    }

    protected final void interceptTimer(String timerId) {
        List<? extends IFormExtension<? extends AbstractForm>> extensions = this.getAllExtensions();
        FormChains.FormTimerChain chain = new FormChains.FormTimerChain(extensions);
        chain.execTimer(timerId);
    }

    protected final AbstractFormData interceptCreateFormData() {
        List<? extends IFormExtension<? extends AbstractForm>> extensions = this.getAllExtensions();
        FormChains.FormCreateFormDataChain chain = new FormChains.FormCreateFormDataChain(extensions);
        return chain.execCreateFormData();
    }

    protected final void interceptInitForm() {
        List<? extends IFormExtension<? extends AbstractForm>> extensions = this.getAllExtensions();
        FormChains.FormInitFormChain chain = new FormChains.FormInitFormChain(extensions);
        chain.execInitForm();
    }

    protected final boolean interceptValidate() {
        List<? extends IFormExtension<? extends AbstractForm>> extensions = this.getAllExtensions();
        FormChains.FormValidateChain chain = new FormChains.FormValidateChain(extensions);
        return chain.execValidate();
    }

    protected final void interceptOnCloseRequest(boolean kill, Set<Integer> enabledButtonSystemTypes) {
        List<? extends IFormExtension<? extends AbstractForm>> extensions = this.getAllExtensions();
        FormChains.FormOnCloseRequestChain chain = new FormChains.FormOnCloseRequestChain(extensions);
        chain.execOnCloseRequest(kill, enabledButtonSystemTypes);
    }

    protected final void interceptDataChanged(Object ... dataTypes) {
        List<? extends IFormExtension<? extends AbstractForm>> extensions = this.getAllExtensions();
        FormChains.FormDataChangedChain chain = new FormChains.FormDataChangedChain(extensions);
        chain.execDataChanged(dataTypes);
    }

    private /* synthetic */ TreeVisitResult lambda$7(IHolder iHolder, Object object, IFormField field) {
        iHolder.setValue(this.getClientPartOfExtensionOrContribution(object, field));
        return iHolder.getValue() == null ? TreeVisitResult.CONTINUE : TreeVisitResult.TERMINATE;
    }

    protected static class LocalFormExtension<FORM extends AbstractForm>
    extends AbstractExtension<FORM>
    implements IFormExtension<FORM> {
        public LocalFormExtension(FORM owner) {
            super(owner);
        }

        @Override
        public void execCloseTimer(FormChains.FormCloseTimerChain chain) {
            ((AbstractForm)this.getOwner()).execCloseTimer();
        }

        @Override
        public void execInactivityTimer(FormChains.FormInactivityTimerChain chain) {
            ((AbstractForm)this.getOwner()).execInactivityTimer();
        }

        @Override
        public void execStored(FormChains.FormStoredChain chain) {
            ((AbstractForm)this.getOwner()).execStored();
        }

        @Override
        public boolean execIsSaveNeeded(FormChains.IsSaveNeededFieldsChain chain) {
            return ((AbstractForm)this.getOwner()).execIsSaveNeeded();
        }

        @Override
        public boolean execCheckFields(FormChains.FormCheckFieldsChain chain) {
            return ((AbstractForm)this.getOwner()).execCheckFields();
        }

        @Override
        public void execResetSearchFilter(FormChains.FormResetSearchFilterChain chain, SearchFilter searchFilter) {
            ((AbstractForm)this.getOwner()).execResetSearchFilter(searchFilter);
        }

        @Override
        public void execAddSearchTerms(FormChains.FormAddSearchTermsChain chain, SearchFilter search) {
            ((AbstractForm)this.getOwner()).execAddSearchTerms(search);
        }

        @Override
        public void execOnVetoException(FormChains.FormOnVetoExceptionChain chain, VetoException e, int code) {
            ((AbstractForm)this.getOwner()).execOnVetoException(e, code);
        }

        @Override
        public void execFormActivated(FormChains.FormFormActivatedChain chain) {
            ((AbstractForm)this.getOwner()).execFormActivated();
        }

        @Override
        public void execDisposeForm(FormChains.FormDisposeFormChain chain) {
            ((AbstractForm)this.getOwner()).execDisposeForm();
        }

        @Override
        public void execTimer(FormChains.FormTimerChain chain, String timerId) {
            ((AbstractForm)this.getOwner()).execTimer(timerId);
        }

        @Override
        public AbstractFormData execCreateFormData(FormChains.FormCreateFormDataChain chain) {
            return ((AbstractForm)this.getOwner()).execCreateFormData();
        }

        @Override
        public void execInitForm(FormChains.FormInitFormChain chain) {
            ((AbstractForm)this.getOwner()).execInitForm();
        }

        @Override
        public boolean execValidate(FormChains.FormValidateChain chain) {
            return ((AbstractForm)this.getOwner()).execValidate();
        }

        @Override
        public void execOnCloseRequest(FormChains.FormOnCloseRequestChain chain, boolean kill, Set<Integer> enabledButtonSystemTypes) {
            ((AbstractForm)this.getOwner()).execOnCloseRequest(kill, enabledButtonSystemTypes);
        }

        @Override
        public void execDataChanged(FormChains.FormDataChangedChain chain, Object ... dataTypes) {
            ((AbstractForm)this.getOwner()).execDataChanged(dataTypes);
        }
    }

    private class P_MainBoxPropertyChangeProxy
    implements PropertyChangeListener {
        private P_MainBoxPropertyChangeProxy() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("saveNeeded".equals(e.getPropertyName())) {
                AbstractForm.this.calculateSaveNeeded();
            } else if ("empty".equals(e.getPropertyName())) {
                AbstractForm.this.propertySupport.firePropertyChange("empty", e.getOldValue(), e.getNewValue());
            }
        }
    }

    private class P_SystemButtonListener
    implements ButtonListener {
        private P_SystemButtonListener() {
        }

        @Override
        public void buttonChanged(ButtonEvent e) {
            if (AbstractForm.this.m_systemButtonListener != this) {
                ((IButton)e.getSource()).removeButtonListener(this);
                return;
            }
            AbstractForm.this.handleSystemButtonEventInternal(e);
        }
    }

    protected class P_UIFacade
    implements IFormUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void fireFormActivatedFromUI() {
            AbstractForm.this.fireFormActivated();
        }

        @Override
        public void fireFormClosingFromUI() {
            if (!AbstractForm.this.checkForVerifyingFields()) {
                return;
            }
            AbstractForm.this.closeFormInternal(false);
        }

        @Override
        public void fireFormKilledFromUI() {
            AbstractForm.this.closeFormInternal(true);
        }
    }
}

