/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.EventObject;
import org.eclipse.scout.rt.client.ui.IModelEvent;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;

public class FormEvent
extends EventObject
implements IModelEvent {
    public static final int TYPE_ACTIVATED = 510;
    public static final int TYPE_LOAD_BEFORE = 1000;
    public static final int TYPE_LOAD_AFTER = 1010;
    public static final int TYPE_LOAD_COMPLETE = 1020;
    public static final int TYPE_STORE_BEFORE = 2010;
    public static final int TYPE_STORE_AFTER = 2020;
    public static final int TYPE_DISCARDED = 3000;
    public static final int TYPE_CLOSED = 3010;
    public static final int TYPE_RESET_COMPLETE = 3020;
    public static final int TYPE_STRUCTURE_CHANGED = 5000;
    public static final int TYPE_TO_FRONT = 6000;
    public static final int TYPE_TO_BACK = 6010;
    public static final int TYPE_REQUEST_FOCUS = 6020;
    public static final int TYPE_REQUEST_INPUT = 6030;
    private final int m_type;
    private final IFormField m_formField;

    public FormEvent(IForm form, int type) {
        this(form, type, null);
    }

    public FormEvent(IForm form, int type, IFormField causingField) {
        super(form);
        this.m_type = type;
        this.m_formField = causingField;
    }

    public IForm getForm() {
        return (IForm)this.getSource();
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    public IFormField getFormField() {
        return this.m_formField;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("DialogEvent[");
        try {
            Field[] f;
            Field[] fieldArray = f = this.getClass().getDeclaredFields();
            int n = f.length;
            int n2 = 0;
            while (n2 < n) {
                Field aF = fieldArray[n2];
                if (Modifier.isPublic(aF.getModifiers()) && Modifier.isStatic(aF.getModifiers()) && aF.getName().startsWith("TYPE_") && ((Number)aF.get(null)).intValue() == this.m_type) {
                    buf.append(aF.getName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            buf.append("#").append(this.m_type);
        }
        if (this.getForm() != null) {
            buf.append(" ").append(this.getForm().getFormId());
        }
        buf.append("]");
        return buf.toString();
    }
}

