/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.rt.client.dto.FormData;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IValueFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.ValueFieldChains;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.IValueFieldContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.ValueFieldContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IStatusMenuMapping;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.MasterListener;
import org.eclipse.scout.rt.client.ui.form.fields.ParsingFailedStatus;
import org.eclipse.scout.rt.client.ui.form.fields.ValidationFailedStatus;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.holders.IHolder;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.eclipse.scout.rt.platform.util.VerboseUtility;
import org.eclipse.scout.rt.platform.util.XmlUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@ClassId(value="dfc4615d-a38d-450a-8592-e4d2c536d7cb")
@FormData(value=AbstractValueFieldData.class, defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.CREATE, sdkCommand=FormData.SdkCommand.USE, genericOrdinal=0)
public abstract class AbstractValueField<VALUE>
extends AbstractFormField
implements IValueField<VALUE> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractValueField.class);
    private int m_valueChanging;
    private int m_valueParsing;
    private int m_valueValidating;
    private VALUE m_initValue;
    private FastListenerList<MasterListener> m_listeningSlaves;

    public AbstractValueField() {
        this(true);
    }

    public AbstractValueField(boolean callInitializer) {
        super(callInitializer);
        this.propertySupport.setPropertyNoFire("displayText", (Object)"");
    }

    protected IValueFieldExtension<VALUE, ? extends AbstractValueField<VALUE>> createLocalExtension() {
        return new LocalValueFieldExtension(this);
    }

    @Order(value=210.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredAutoAddDefaultMenus() {
        return true;
    }

    @Order(value=220.0)
    @ConfigProperty(value="STRING")
    protected String getConfiguredClearable() {
        return "focused";
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setClearable(this.getConfiguredClearable());
        this.m_listeningSlaves = new FastListenerList();
        this.setAutoAddDefaultMenus(this.getConfiguredAutoAddDefaultMenus());
        List<Class<IMenu>> declaredMenus = this.getDeclaredMenus();
        List contributedMenus = this.m_contributionHolder.getContributionsByClass(IMenu.class);
        OrderedCollection menus = new OrderedCollection();
        for (Class<IMenu> menuClazz : declaredMenus) {
            menus.addOrdered((IOrdered)((IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuClazz)));
        }
        menus.addAllOrdered((Collection)contributedMenus);
        try {
            this.injectMenusInternal((OrderedCollection<IMenu>)menus);
        }
        catch (Exception e) {
            LOG.error("Error occurred while dynamically contributing menus.", (Throwable)e);
        }
        new MoveActionNodesHandler(menus).moveModelObjects();
        this.setContextMenu(this.createContextMenu((OrderedCollection<IMenu>)menus));
        this.setStatusMenuMappings(this.createStatusMenuMappings());
    }

    protected List<IStatusMenuMapping> createStatusMenuMappings() {
        List<Class<IStatusMenuMapping>> configuredMappings = this.getConfiguredStatusMenuMappings();
        ArrayList<IStatusMenuMapping> mappings = new ArrayList<IStatusMenuMapping>();
        for (Class<IStatusMenuMapping> clazz : configuredMappings) {
            IStatusMenuMapping mapping = (IStatusMenuMapping)ConfigurationUtility.newInnerInstance((Object)this, clazz);
            mappings.add(mapping);
        }
        for (IStatusMenuMapping mapping : mappings) {
            mapping.setParentFieldInternal(this);
        }
        return mappings;
    }

    protected List<Class<IStatusMenuMapping>> getConfiguredStatusMenuMappings() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, IStatusMenuMapping.class);
    }

    protected IValueFieldContextMenu createContextMenu(OrderedCollection<IMenu> menus) {
        return new ValueFieldContextMenu(this, (List<? extends IMenu>)menus.getOrderedList());
    }

    protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
    }

    protected void setContextMenu(IValueFieldContextMenu contextMenu) {
        this.propertySupport.setProperty("contextMenu", (Object)contextMenu);
    }

    @Override
    public IValueFieldContextMenu getContextMenu() {
        return (IValueFieldContextMenu)this.propertySupport.getProperty("contextMenu");
    }

    @Override
    public List<IMenu> getMenus() {
        return this.getContextMenu().getChildActions();
    }

    @Override
    public <T extends IMenu> T getMenuByClass(Class<T> menuType) {
        return MenuUtility.getMenuByClass(this, menuType);
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), this.getMenus()});
    }

    @Override
    protected void initFieldInternal() {
        super.initFieldInternal();
        for (IStatusMenuMapping mapping : this.getStatusMenuMappings()) {
            mapping.init();
        }
        for (IStatusMenuMapping mapping : this.getStatusMenuMappings()) {
            mapping.init();
        }
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    @Override
    public void setStatusMenuMappings(List<IStatusMenuMapping> mappings) {
        this.propertySupport.setProperty("statusMenuMappings", new ArrayList<IStatusMenuMapping>(mappings));
    }

    @Override
    public List<IStatusMenuMapping> getStatusMenuMappings() {
        return (List)this.propertySupport.getProperty("statusMenuMappings");
    }

    @Override
    public void exportFormFieldData(AbstractFormFieldData target) {
        AbstractValueFieldData v = (AbstractValueFieldData)target;
        v.setValue(this.getValue());
    }

    @Override
    public void importFormFieldData(AbstractFormFieldData source, boolean valueChangeTriggersEnabled) {
        Assertions.assertNotNull((Object)source);
        AbstractValueFieldData v = (AbstractValueFieldData)source;
        if (v.isValueSet()) {
            try {
                Class<VALUE> castType;
                Object o;
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(false);
                }
                Object newValue = (o = v.getValue()) != null ? ((castType = this.getHolderType()).isAssignableFrom(o.getClass()) ? o : TypeCastUtility.castValue((Object)o, castType)) : null;
                this.setValue(newValue);
            }
            finally {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(true);
                }
            }
        }
    }

    @Override
    public void storeToXml(Element x) {
        block2: {
            super.storeToXml(x);
            VALUE value = this.getValue();
            try {
                XmlUtility.setObjectAttribute((Element)x, (String)"value", value);
            }
            catch (IOException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info("not serializable value in field {}/{}", new Object[]{this.getClass().getName(), this.getLabel(), e});
            }
        }
    }

    @Override
    public void loadFromXml(Element x) {
        super.loadFromXml(x);
        try {
            Object value = TypeCastUtility.castValue((Object)XmlUtility.getObjectAttribute((Element)x, (String)"value"), this.getHolderType());
            this.setValue(value);
        }
        catch (Exception e) {
            LOG.warn("Could not load form XML [{}]", (Object)this.getClass().getName(), (Object)e);
        }
    }

    @Override
    public void resetValue() {
        VALUE newValue = this.getInitValue();
        this.setValue(newValue);
        this.checkSaveNeeded();
        this.checkEmpty();
    }

    @Override
    public IFastListenerList<MasterListener> masterListeners() {
        return this.m_listeningSlaves;
    }

    private void fireMasterChanged() {
        List listeners = this.masterListeners().list();
        if (!listeners.isEmpty()) {
            Object masterValue = this.getValue();
            listeners.forEach(listener -> listener.masterChanged(masterValue));
        }
    }

    @Override
    public void setInitValue(VALUE initValue) {
        this.m_initValue = initValue;
    }

    @Override
    public VALUE getInitValue() {
        return this.m_initValue;
    }

    @Override
    protected boolean execIsSaveNeeded() {
        boolean saveNeeded = super.execIsSaveNeeded();
        if (saveNeeded) {
            return true;
        }
        return ObjectUtility.notEquals(this.getValue(), this.getInitValue());
    }

    @Override
    protected void execMarkSaved() {
        super.execMarkSaved();
        VALUE value = this.getValue();
        this.setInitValue(value);
    }

    @Override
    protected boolean execIsEmpty() {
        if (!this.areChildrenEmpty()) {
            return false;
        }
        return this.getValue() == null;
    }

    @Override
    public VALUE getValue() {
        return (VALUE)this.propertySupport.getProperty("value");
    }

    protected void handleValidationFailed(ProcessingException e, VALUE rawValue) {
        this.addErrorStatus(new ValidationFailedStatus<VALUE>(e, rawValue));
        this.updateDisplayText(rawValue);
    }

    /*
     * Loose catch block
     */
    @Override
    public final void setValue(VALUE rawValue) {
        block13: {
            if (this.isValueChanging()) {
                LOG.warn("Loop detection in {} with value {}", new Object[]{this.getClass().getName(), rawValue, new Exception()});
                return;
            }
            try {
                this.setFieldChanging(true);
                this.setValueChanging(true);
                this.removeErrorStatus(ParsingFailedStatus.class);
                this.removeErrorStatus(ValidationFailedStatus.class);
                VALUE validatedValue = null;
                try {
                    validatedValue = this.validateValue(rawValue);
                }
                catch (ProcessingException v) {
                    this.handleValidationFailed(v, rawValue);
                    this.setValueChanging(false);
                    this.setFieldChanging(false);
                    return;
                }
                catch (Exception e) {
                    String message = TEXTS.get((String)"InvalidValueMessageX", (String[])new String[]{StringUtility.emptyIfNull(rawValue)});
                    ProcessingException pe = new ProcessingException(message, new Object[]{e});
                    LOG.warn("Unexpected Error: ", (Throwable)pe);
                    this.handleValidationFailed(pe, rawValue);
                    this.setValueChanging(false);
                    this.setFieldChanging(false);
                    return;
                }
                VALUE oldValue = this.getValue();
                boolean changed = this.propertySupport.setPropertyNoFire("value", validatedValue);
                this.updateDisplayText(validatedValue);
                if (changed) {
                    this.propertySupport.firePropertyChange("value", oldValue, validatedValue);
                    this.valueChangedInternal();
                    this.checkSaveNeeded();
                    this.checkEmpty();
                    this.fireMasterChanged();
                    if (this.isValueChangeTriggerEnabled()) {
                        try {
                            this.interceptChangedValue();
                        }
                        catch (RuntimeException | PlatformError ex) {
                            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(ex);
                        }
                    }
                }
                break block13;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.setValueChanging(false);
                this.setFieldChanging(false);
            }
        }
    }

    @Override
    public void refreshDisplayText() {
        if (this.isInitConfigDone()) {
            this.updateDisplayText(this.getValue());
        }
    }

    private void updateDisplayText(VALUE rawValue) {
        this.setDisplayText(this.interceptFormatValue(rawValue));
    }

    protected void valueChangedInternal() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {}", (Object)this.getLabel(), (Object)VerboseUtility.dumpObject(this.getValue()));
        }
    }

    @Override
    public boolean isValueChanging() {
        return this.m_valueChanging > 0;
    }

    private void setValueChanging(boolean b) {
        this.m_valueChanging = b ? ++this.m_valueChanging : --this.m_valueChanging;
    }

    @Override
    public boolean isValueParsing() {
        return this.m_valueParsing > 0;
    }

    private void setValueParsing(boolean b) {
        this.m_valueParsing = b ? ++this.m_valueParsing : --this.m_valueParsing;
    }

    @Override
    public boolean isValueValidating() {
        return this.m_valueValidating > 0;
    }

    private void setValueValidating(boolean b) {
        this.m_valueValidating = b ? ++this.m_valueValidating : --this.m_valueValidating;
    }

    @Override
    public final void fireValueChanged() {
        try {
            this.setValueChanging(true);
            try {
                this.interceptChangedValue();
            }
            catch (RuntimeException | PlatformError ex) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(ex);
            }
            this.fireMasterChanged();
        }
        finally {
            this.setValueChanging(false);
        }
    }

    private VALUE validateValue(VALUE rawValue) {
        try {
            this.setValueValidating(true);
            VALUE o = rawValue;
            o = this.validateValueInternal(o);
            VALUE VALUE = o = this.interceptValidateValue(o);
            return VALUE;
        }
        finally {
            this.setValueValidating(false);
        }
    }

    protected VALUE validateValueInternal(VALUE rawValue) {
        return rawValue;
    }

    @ConfigOperation
    @Order(value=190.0)
    protected VALUE execValidateValue(VALUE rawValue) {
        return rawValue;
    }

    @ConfigOperation
    @Order(value=220.0)
    protected void execChangedValue() {
    }

    @Override
    public final void parseAndSetValue(String text) {
        if (this.isValueParsing()) {
            LOG.warn("Loop detection in [{}] with text {}", (Object)this.getClass().getName(), (Object)text);
            return;
        }
        try {
            this.setFieldChanging(true);
            this.setValueParsing(true);
            this.setDisplayText(text);
            this.removeErrorStatus(ParsingFailedStatus.class);
            VALUE parsedValue = this.interceptParseValue(text);
            this.setValue(parsedValue);
            return;
        }
        catch (ProcessingException pe) {
            this.addErrorStatus(new ParsingFailedStatus(pe, text));
            return;
        }
        catch (Exception e) {
            LOG.error("Unexpected Error: ", (Throwable)e);
            ProcessingException pe = new ProcessingException(TEXTS.get((String)"InvalidValueMessageX", (String[])new String[]{text}), new Object[]{e});
            this.addErrorStatus(new ParsingFailedStatus(pe, text));
            return;
        }
        finally {
            this.setValueParsing(false);
            this.setFieldChanging(false);
        }
    }

    protected VALUE parseValueInternal(String text) {
        throw new ProcessingException("Not implemented", new Object[0]);
    }

    @ConfigOperation
    @Order(value=200.0)
    protected VALUE execParseValue(String text) {
        return this.parseValueInternal(text);
    }

    @ConfigOperation
    @Order(value=210.0)
    protected String execFormatValue(VALUE value) {
        return this.formatValueInternal(value);
    }

    protected String formatValueInternal(VALUE value) {
        return value != null ? value.toString() : "";
    }

    @Override
    public String getDisplayText() {
        return this.propertySupport.getPropertyString("displayText");
    }

    @Override
    public void setDisplayText(String s) {
        this.propertySupport.setPropertyString("displayText", s);
    }

    @Override
    public boolean isAutoAddDefaultMenus() {
        return this.propertySupport.getPropertyBool("autoAddDefaultMenus");
    }

    @Override
    public void setAutoAddDefaultMenus(boolean b) {
        this.propertySupport.setPropertyBool("autoAddDefaultMenus", b);
    }

    @Override
    public void setClearable(String clearableStyle) {
        this.propertySupport.setPropertyString("clearable", clearableStyle);
    }

    @Override
    public String getClearable() {
        return this.propertySupport.getPropertyString("clearable");
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) {
        this.setValue(null);
    }

    public Class<VALUE> getHolderType() {
        return TypeCastUtility.getGenericsParameterClass(this.getClass(), IHolder.class);
    }

    public void updateFrom(IHolder<VALUE> other) {
        this.setValue(other.getValue());
    }

    protected final VALUE interceptValidateValue(VALUE rawValue) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ValueFieldChains.ValueFieldValidateValueChain<VALUE> chain = new ValueFieldChains.ValueFieldValidateValueChain<VALUE>(extensions);
        return chain.execValidateValue(rawValue);
    }

    protected final String interceptFormatValue(VALUE validValue) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ValueFieldChains.ValueFieldFormatValueChain<VALUE> chain = new ValueFieldChains.ValueFieldFormatValueChain<VALUE>(extensions);
        return chain.execFormatValue(validValue);
    }

    protected final void interceptChangedValue() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ValueFieldChains.ValueFieldChangedValueChain chain = new ValueFieldChains.ValueFieldChangedValueChain(extensions);
        chain.execChangedValue();
    }

    protected final VALUE interceptParseValue(String text) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ValueFieldChains.ValueFieldParseValueChain chain = new ValueFieldChains.ValueFieldParseValueChain(extensions);
        return chain.execParseValue(text);
    }

    protected static class LocalValueFieldExtension<VALUE, OWNER extends AbstractValueField<VALUE>>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements IValueFieldExtension<VALUE, OWNER> {
        public LocalValueFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public VALUE execValidateValue(ValueFieldChains.ValueFieldValidateValueChain<VALUE> chain, VALUE rawValue) {
            return ((AbstractValueField)this.getOwner()).execValidateValue(rawValue);
        }

        @Override
        public String execFormatValue(ValueFieldChains.ValueFieldFormatValueChain<VALUE> chain, VALUE value) {
            return ((AbstractValueField)this.getOwner()).execFormatValue(value);
        }

        @Override
        public void execChangedValue(ValueFieldChains.ValueFieldChangedValueChain<VALUE> chain) {
            ((AbstractValueField)this.getOwner()).execChangedValue();
        }

        @Override
        public VALUE execParseValue(ValueFieldChains.ValueFieldParseValueChain<VALUE> chain, String text) {
            return ((AbstractValueField)this.getOwner()).execParseValue(text);
        }
    }
}

