/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

public final class GridData {
    public int x;
    public int y;
    public int w;
    public int h;
    public double weightX;
    public double weightY;
    public boolean useUiWidth;
    public boolean useUiHeight;
    public int horizontalAlignment;
    public int verticalAlignment;
    public boolean fillHorizontal;
    public boolean fillVertical;
    public int widthInPixel;
    public int heightInPixel;

    public GridData(GridData g) {
        this(g.x, g.y, g.w, g.h, g.weightX, g.weightY, g.useUiWidth, g.useUiHeight, g.horizontalAlignment, g.verticalAlignment, g.fillHorizontal, g.fillVertical, g.widthInPixel, g.heightInPixel);
    }

    public GridData(int x, int y, int w, int h, double weightX, double weightY) {
        this(x, y, w, h, weightX, weightY, false, false, -1, -1, true, true, 0, 0);
    }

    public GridData(int x, int y, int w, int h, double weightX, double weightY, boolean useUiWidth, boolean useUiHeight, int horizontalAlignment, int verticalAlignment, boolean fillHorizontal, boolean fillVertical, int widthInPixel, int heightInPixel) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.weightX = weightX;
        this.weightY = weightY;
        this.useUiWidth = useUiWidth;
        this.useUiHeight = useUiHeight;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.fillHorizontal = fillHorizontal;
        this.fillVertical = fillVertical;
        this.widthInPixel = widthInPixel;
        this.heightInPixel = heightInPixel;
    }

    public GridData withX(int newX) {
        this.x = newX;
        return this;
    }

    public GridData withY(int newY) {
        this.y = newY;
        return this;
    }

    public GridData withW(int newW) {
        this.w = newW;
        return this;
    }

    public GridData withH(int newH) {
        this.h = newH;
        return this;
    }

    public GridData withWeightX(double newWeightX) {
        this.weightX = newWeightX;
        return this;
    }

    public GridData withWeightY(double newWeightY) {
        this.weightY = newWeightY;
        return this;
    }

    public GridData withUseUiWidth(boolean newUseUiWidth) {
        this.useUiWidth = newUseUiWidth;
        return this;
    }

    public GridData withUseUiHeight(boolean newUseUiHeight) {
        this.useUiHeight = newUseUiHeight;
        return this;
    }

    public GridData withHorizontalAlignment(int newHorizontalAlignment) {
        this.horizontalAlignment = newHorizontalAlignment;
        return this;
    }

    public GridData withVerticalAlignment(int newVerticalAlignment) {
        this.verticalAlignment = newVerticalAlignment;
        return this;
    }

    public GridData withFillHorizontal(boolean newFillHorizontal) {
        this.fillHorizontal = newFillHorizontal;
        return this;
    }

    public GridData withFillVertical(boolean newFillVertical) {
        this.fillVertical = newFillVertical;
        return this;
    }

    public GridData withWidthInPixel(int newWidthInPixel) {
        this.widthInPixel = newWidthInPixel;
        return this;
    }

    public GridData withHeightInPixel(int newHeightInPixel) {
        this.heightInPixel = newHeightInPixel;
        return this;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fillHorizontal ? 1231 : 1237);
        result = 31 * result + (this.fillVertical ? 1231 : 1237);
        result = 31 * result + this.h;
        result = 31 * result + this.heightInPixel;
        result = 31 * result + this.horizontalAlignment;
        result = 31 * result + (this.useUiHeight ? 1231 : 1237);
        result = 31 * result + (this.useUiWidth ? 1231 : 1237);
        result = 31 * result + this.verticalAlignment;
        result = 31 * result + this.w;
        long temp = Double.doubleToLongBits(this.weightX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.weightY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.widthInPixel;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GridData other = (GridData)obj;
        if (this.fillHorizontal != other.fillHorizontal) {
            return false;
        }
        if (this.fillVertical != other.fillVertical) {
            return false;
        }
        if (this.h != other.h) {
            return false;
        }
        if (this.heightInPixel != other.heightInPixel) {
            return false;
        }
        if (this.horizontalAlignment != other.horizontalAlignment) {
            return false;
        }
        if (this.useUiHeight != other.useUiHeight) {
            return false;
        }
        if (this.useUiWidth != other.useUiWidth) {
            return false;
        }
        if (this.verticalAlignment != other.verticalAlignment) {
            return false;
        }
        if (this.w != other.w) {
            return false;
        }
        if (Double.doubleToLongBits(this.weightX) != Double.doubleToLongBits(other.weightX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.weightY) != Double.doubleToLongBits(other.weightY)) {
            return false;
        }
        if (this.widthInPixel != other.widthInPixel) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[x=" + this.x + ", y=" + this.y + ", w=" + this.w + ", h=" + this.h + ", weightX=" + this.weightX + ", weightY=" + this.weightY + ", useUiWidth=" + this.useUiWidth + ", useUiHeight=" + this.useUiHeight + "]";
    }

    public GridData copy() {
        return new GridData(this);
    }
}

