/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.booleanfield;

import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.form.fields.booleanfield.IBooleanFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanFieldUIFacade;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.text.TEXTS;

@ClassId(value="3f14b55f-b49b-428a-92c4-05745d6d48c4")
public abstract class AbstractBooleanField
extends AbstractValueField<Boolean>
implements IBooleanField {
    private IBooleanFieldUIFacade m_uiFacade;

    public AbstractBooleanField() {
        this(true);
    }

    public AbstractBooleanField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(this.createUIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        super.initConfig();
        this.setTriStateEnabled(this.getConfiguredTriStateEnabled());
        this.setKeyStroke(this.getConfiguredKeyStroke());
        this.setWrapText(this.getConfiguredWrapText());
        this.propertySupport.setProperty("value", (Object)false);
        this.propertySupport.setProperty("displayText", (Object)this.interceptFormatValue((Boolean)this.getValue()));
    }

    protected IBooleanFieldUIFacade createUIFacade() {
        return new P_UIFacade();
    }

    @Override
    @Order(value=210.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredAutoAddDefaultMenus() {
        return false;
    }

    @Order(value=220.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredTriStateEnabled() {
        return false;
    }

    @Order(value=230.0)
    @ConfigProperty(value="STRING")
    protected String getConfiguredKeyStroke() {
        return null;
    }

    @Order(value=240.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredWrapText() {
        return false;
    }

    @Override
    public void setTriStateEnabled(boolean triStateEnabled) {
        this.propertySupport.setPropertyBool("triStateEnabled", triStateEnabled);
        if (!triStateEnabled) {
            this.setValue((Boolean)this.getValue());
        }
    }

    @Override
    public boolean isTriStateEnabled() {
        return this.propertySupport.getPropertyBool("triStateEnabled");
    }

    @Override
    public String getKeyStroke() {
        return this.propertySupport.getPropertyString("keyStroke");
    }

    @Override
    public void setKeyStroke(String keyStroke) {
        this.propertySupport.setPropertyString("keyStroke", keyStroke);
    }

    @Override
    public void setChecked(boolean checked) {
        this.setValue(checked);
    }

    @Override
    public boolean isChecked() {
        return this.getValue() != null && (Boolean)this.getValue() != false;
    }

    @Override
    public void setWrapText(boolean wrapText) {
        this.propertySupport.setProperty("wrapText", (Object)wrapText);
    }

    @Override
    public boolean isWrapText() {
        return this.propertySupport.getPropertyBool("wrapText");
    }

    @Override
    public void toggleValue() {
        if (this.isTriStateEnabled()) {
            if (Boolean.FALSE.equals(this.getValue())) {
                this.setValue(true);
            } else if (Boolean.TRUE.equals(this.getValue())) {
                this.setValue(null);
            } else {
                this.setValue(false);
            }
        } else if (Boolean.FALSE.equals(this.getValue())) {
            this.setValue(true);
        } else {
            this.setValue(false);
        }
    }

    @Override
    protected String formatValueInternal(Boolean validValue) {
        if (validValue == null) {
            return "";
        }
        return validValue != false ? TEXTS.get((String)"Yes") : TEXTS.get((String)"No");
    }

    @Override
    protected Boolean validateValueInternal(Boolean rawValue) {
        rawValue = super.validateValueInternal(rawValue);
        if (!this.isTriStateEnabled() && rawValue == null) {
            rawValue = Boolean.FALSE;
        }
        return rawValue;
    }

    @Override
    protected Boolean parseValueInternal(String text) {
        Boolean retVal = null;
        if (text != null && text.isEmpty()) {
            text = null;
        }
        if (text != null) {
            retVal = "1".equals(text) ? Boolean.valueOf(true) : ("true".equalsIgnoreCase(text) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return retVal;
    }

    @Override
    protected boolean execIsEmpty() {
        if (!this.areChildrenEmpty()) {
            return false;
        }
        return !this.isChecked();
    }

    @Override
    public IBooleanFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    protected IBooleanFieldExtension<? extends AbstractBooleanField> createLocalExtension() {
        return new LocalBooleanFieldExtension<AbstractBooleanField>(this);
    }

    protected static class LocalBooleanFieldExtension<OWNER extends AbstractBooleanField>
    extends AbstractValueField.LocalValueFieldExtension<Boolean, OWNER>
    implements IBooleanFieldExtension<OWNER> {
        public LocalBooleanFieldExtension(OWNER owner) {
            super(owner);
        }
    }

    protected class P_UIFacade
    implements IBooleanFieldUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void setValueFromUI(Boolean value) {
            if (!AbstractBooleanField.this.isEnabledIncludingParents() || !AbstractBooleanField.this.isVisibleIncludingParents()) {
                return;
            }
            AbstractBooleanField.this.setValue(value);
        }
    }
}

