/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.clipboardfield;

import java.util.Collection;
import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.form.fields.clipboardfield.IClipboardFieldExtension;
import org.eclipse.scout.rt.client.ui.dnd.ResourceListTransferObject;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.clipboardfield.IClipboardField;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.resource.MimeType;
import org.eclipse.scout.rt.platform.text.TEXTS;

@ClassId(value="288fbdae-2af3-485c-8dec-529b557550f5")
public abstract class AbstractClipboardField
extends AbstractValueField<Collection<BinaryResource>>
implements IClipboardField {
    public AbstractClipboardField() {
        this(true);
    }

    public AbstractClipboardField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setAllowedMimeTypes(this.getConfiguredAllowedMimeTypes());
        this.setMaximumSize(this.getConfiguredMaximumSize());
        this.setReadOnly(this.getConfiguredReadOnly());
        this.setDropType(this.getConfiguredDropType());
        this.setDragType(this.getConfiguredDragType());
    }

    @ConfigProperty(value="LONG")
    @Order(value=10.0)
    protected long getConfiguredMaximumSize() {
        return 0xA00000L;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=30.0)
    protected int getConfiguredDropType() {
        return 1;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=40.0)
    protected final int getConfiguredDragType() {
        return 0;
    }

    @ConfigProperty(value="MIME_TYPES")
    @Order(value=50.0)
    protected List<String> getConfiguredAllowedMimeTypes() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=60.0)
    protected boolean getConfiguredReadOnly() {
        return false;
    }

    @ConfigOperation
    @Order(value=70.0)
    protected final TransferObject execDragRequest() {
        return null;
    }

    @ConfigOperation
    @Order(value=80.0)
    protected void execDropRequest(TransferObject transferObject) {
        if (transferObject instanceof ResourceListTransferObject) {
            ResourceListTransferObject resourceListTransferObject = (ResourceListTransferObject)transferObject;
            this.setValue(resourceListTransferObject.getResources());
        }
    }

    @Override
    protected IClipboardFieldExtension<? extends AbstractClipboardField> createLocalExtension() {
        return new LocalClipboardFieldExtension<AbstractClipboardField>(this);
    }

    @Override
    public List<String> getAllowedMimeTypes() {
        return this.propertySupport.getPropertyList("allowedMimeTypes");
    }

    @Override
    public void setAllowedMimeTypes(List<String> allowedMimeTypes) {
        this.propertySupport.setPropertyList("allowedMimeTypes", allowedMimeTypes);
    }

    @Override
    public long getMaximumSize() {
        return this.propertySupport.getPropertyLong("maximumSize");
    }

    @Override
    public void setMaximumSize(long maximumSize) {
        this.propertySupport.setPropertyLong("maximumSize", maximumSize);
    }

    @Override
    public boolean isReadOnly() {
        return this.propertySupport.getPropertyBool("readOnly");
    }

    @Override
    public void setReadOnly(boolean b) {
        this.propertySupport.setPropertyBool("readOnly", b);
    }

    @Override
    protected String formatValueInternal(Collection<BinaryResource> value) {
        return this.formatValueAsText(value);
    }

    protected String formatValueAsText(Collection<BinaryResource> value) {
        if (value != null && !value.isEmpty()) {
            for (BinaryResource res : value) {
                if (!MimeType.TXT.getType().equals(res.getContentType())) continue;
                return res.getContentAsString();
            }
            return TEXTS.get((String)"ElementsInserted");
        }
        return "";
    }

    @Override
    public void setDragType(int dragType) {
        this.propertySupport.setPropertyInt("dragType", dragType);
    }

    @Override
    public int getDragType() {
        return this.propertySupport.getPropertyInt("dragType");
    }

    @Override
    public void setDropType(int dropType) {
        this.propertySupport.setPropertyInt("dropType", dropType);
    }

    @Override
    public int getDropType() {
        return this.propertySupport.getPropertyInt("dropType");
    }

    @Override
    public void setDropMaximumSize(long dropMaximumSize) {
        this.setMaximumSize(dropMaximumSize);
    }

    @Override
    public long getDropMaximumSize() {
        return this.getMaximumSize();
    }

    protected static class LocalClipboardFieldExtension<OWNER extends AbstractClipboardField>
    extends AbstractValueField.LocalValueFieldExtension<Collection<BinaryResource>, OWNER>
    implements IClipboardFieldExtension<OWNER> {
        public LocalClipboardFieldExtension(OWNER owner) {
            super(owner);
        }
    }
}

