/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.dto.FormData;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.composer.ComposerFieldChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.composer.IComposerFieldExtension;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.ComposerFieldDataModel;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerFieldUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AbstractComposerNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AttributeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EitherOrNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EntityNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.RootNode;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.XmlUtility;
import org.eclipse.scout.rt.platform.util.visitor.DepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.IDepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.composer.AbstractComposerData;
import org.eclipse.scout.rt.shared.data.form.fields.composer.ComposerAttributeNodeData;
import org.eclipse.scout.rt.shared.data.form.fields.composer.ComposerEitherOrNodeData;
import org.eclipse.scout.rt.shared.data.form.fields.composer.ComposerEntityNodeData;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.AbstractTreeFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.TreeNodeData;
import org.eclipse.scout.rt.shared.data.model.AttributePath;
import org.eclipse.scout.rt.shared.data.model.DataModelAttributeOp;
import org.eclipse.scout.rt.shared.data.model.DataModelUtility;
import org.eclipse.scout.rt.shared.data.model.EntityPath;
import org.eclipse.scout.rt.shared.data.model.IDataModel;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ClassId(value="8e7f7eb8-be18-48e5-9efe-8a5b3459e247")
@FormData(value=AbstractComposerData.class, sdkCommand=FormData.SdkCommand.USE, defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.CREATE)
public abstract class AbstractComposerField
extends AbstractFormField
implements IComposerField {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractComposerField.class);
    private IComposerFieldUIFacade m_uiFacade;
    private ITree m_tree;
    private Element m_initValue;
    private IDataModel m_dataModel;

    public AbstractComposerField() {
        this(true);
    }

    public AbstractComposerField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    public IDataModel getDataModel() {
        return this.m_dataModel;
    }

    @Override
    public void setDataModel(IDataModel dm) {
        this.m_dataModel = dm;
    }

    @ConfigOperation
    @Order(value=97.0)
    protected IDataModel execCreateDataModel() {
        ComposerFieldDataModel m = new ComposerFieldDataModel(this);
        m.init();
        return m;
    }

    @ConfigOperation
    @Order(value=98.0)
    protected void execResolveRootPathForTopLevelEntity(IDataModelEntity e, List<IDataModelEntity> lifeList) {
        IDataModelEntity tmp = e != null ? e.getParentEntity() : null;
        while (tmp != null) {
            lifeList.add(0, tmp);
            tmp = tmp.getParentEntity();
        }
    }

    @ConfigOperation
    @Order(value=98.0)
    protected void execResolveRootPathForTopLevelAttribute(IDataModelAttribute a, List<IDataModelEntity> lifeList) {
        IDataModelEntity tmp = a != null ? a.getParentEntity() : null;
        while (tmp != null) {
            lifeList.add(0, tmp);
            tmp = tmp.getParentEntity();
        }
    }

    @ConfigOperation
    @Order(value=99.0)
    protected EntityPath execResolveEntityPath(EntityNode node) {
        LinkedList<IDataModelEntity> list = new LinkedList<IDataModelEntity>();
        EntityNode tmp = node;
        while (tmp != null) {
            if (tmp.getEntity() != null) {
                list.add(0, tmp.getEntity());
            }
            tmp = tmp.getAncestorNode(EntityNode.class);
        }
        if (!list.isEmpty()) {
            this.interceptResolveRootPathForTopLevelEntity((IDataModelEntity)list.get(0), list);
        }
        return new EntityPath(list);
    }

    @ConfigOperation
    @Order(value=99.0)
    protected AttributePath execResolveAttributePath(AttributeNode node) {
        LinkedList<IDataModelEntity> list = new LinkedList<IDataModelEntity>();
        if (node == null) {
            return null;
        }
        EntityNode tmp = node.getAncestorNode(EntityNode.class);
        while (tmp != null) {
            if (tmp.getEntity() != null) {
                list.add(0, tmp.getEntity());
            }
            tmp = tmp.getAncestorNode(EntityNode.class);
        }
        if (!list.isEmpty()) {
            this.interceptResolveRootPathForTopLevelEntity((IDataModelEntity)list.get(0), list);
        } else {
            this.interceptResolveRootPathForTopLevelAttribute(node.getAttribute(), list);
        }
        return new AttributePath(list, node.getAttribute());
    }

    private Class<? extends ITree> getConfiguredTree() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List f = ConfigurationUtility.filterClasses((Class[])dca, ITree.class);
        if (f.size() == 1) {
            return (Class)CollectionUtility.firstElement((List)f);
        }
        for (Class c : f) {
            if (c.getDeclaringClass() == AbstractComposerField.class) continue;
            return c;
        }
        return null;
    }

    @ConfigOperation
    @Order(value=100.0)
    protected RootNode execCreateRootNode() {
        return new RootNode(this);
    }

    @ConfigOperation
    @Order(value=110.0)
    protected EntityNode execCreateEntityNode(ITreeNode parentNode, IDataModelEntity e, boolean negated, List<?> values, List<String> texts) {
        EntityNode node = this.createEntityNode(e);
        node.setValues(values);
        node.setTexts(texts);
        node.setNegative(negated);
        node.setStatus(1);
        return node;
    }

    protected EntityNode createEntityNode(IDataModelEntity entity) {
        return new EntityNode((IComposerField)this, entity);
    }

    @ConfigOperation
    @Order(value=120.0)
    protected AttributeNode execCreateAttributeNode(ITreeNode parentNode, IDataModelAttribute a, Integer aggregationType, IDataModelAttributeOp op, List<?> values, List<String> texts) {
        if (aggregationType != null && aggregationType == 0) {
            aggregationType = null;
        }
        AttributeNode node = this.createAttributeNode(a);
        node.setAggregationType(aggregationType);
        node.setOp(op);
        node.setValues(values);
        node.setTexts(texts);
        node.setStatus(1);
        return node;
    }

    protected AttributeNode createAttributeNode(IDataModelAttribute attribute) {
        return new AttributeNode((IComposerField)this, attribute);
    }

    @ConfigOperation
    @Order(value=130.0)
    protected EitherOrNode execCreateEitherNode(ITreeNode parentNode, boolean negated) {
        EitherOrNode node = this.createEitherOrNode(true);
        node.setNegative(negated);
        node.setStatus(1);
        return node;
    }

    protected EitherOrNode createEitherOrNode(boolean beginEitherOr) {
        return new EitherOrNode(this, beginEitherOr);
    }

    @ConfigOperation
    @Order(value=140.0)
    protected EitherOrNode execCreateAdditionalOrNode(ITreeNode eitherOrNode, boolean negated) {
        EitherOrNode node = this.createEitherOrNode(false);
        node.setNegative(negated);
        node.setStatus(1);
        return node;
    }

    @Override
    protected void initConfig() {
        Class<? extends ITree> configuredTree;
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        super.initConfig();
        this.m_dataModel = this.interceptCreateDataModel();
        List contributedTrees = this.m_contributionHolder.getContributionsByClass(ITree.class);
        this.m_tree = (ITree)CollectionUtility.firstElement((List)contributedTrees);
        if (this.m_tree == null && (configuredTree = this.getConfiguredTree()) != null) {
            this.m_tree = (ITree)ConfigurationUtility.newInnerInstance((Object)this, configuredTree);
        }
        if (this.m_tree != null) {
            RootNode rootNode = this.interceptCreateRootNode();
            rootNode.getCellForUpdate().setText(this.getLabel());
            this.m_tree.setRootNode(rootNode);
            this.m_tree.setNodeExpanded(rootNode, true);
            this.m_tree.setParentInternal(this);
            this.m_tree.addTreeListener(e -> {
                this.checkSaveNeeded();
                this.checkEmpty();
            }, 30, 31, 10, 20, 870);
        } else {
            LOG.warn("there is no inner class of type ITree in {}", (Object)this.getClass().getName());
        }
    }

    @Override
    protected void initFieldInternal() {
        super.initFieldInternal();
        DepthFirstTreeVisitor<ITreeNode> visitor = new DepthFirstTreeVisitor<ITreeNode>(){

            public TreeVisitResult preVisit(ITreeNode element, int level, int index) {
                AbstractComposerField.this.initNodeMenus(element);
                return TreeVisitResult.CONTINUE;
            }
        };
        this.getTree().visitTree((IDepthFirstTreeVisitor<ITreeNode>)visitor);
    }

    protected void initNodeMenus(ITreeNode node) {
        for (IMenu menu : node.getMenus()) {
            menu.init();
        }
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Collections.singletonList(this.getTree())});
    }

    @Override
    public final ITree getTree() {
        return this.m_tree;
    }

    @Override
    public void exportFormFieldData(AbstractFormFieldData target) {
        if (this.m_tree != null) {
            AbstractTreeFieldData treeFieldData = (AbstractTreeFieldData)target;
            this.m_tree.exportTreeData(treeFieldData);
        }
    }

    @Override
    public void importFormFieldData(AbstractFormFieldData source, boolean valueChangeTriggersEnabled) {
        Assertions.assertNotNull((Object)source);
        AbstractTreeFieldData treeFieldData = (AbstractTreeFieldData)source;
        if (treeFieldData.isValueSet() && this.m_tree != null) {
            try {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(false);
                }
                this.m_tree.importTreeData(treeFieldData);
            }
            finally {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(true);
                }
            }
        }
    }

    @Override
    public List<IDataModelAttribute> getAttributes() {
        return this.m_dataModel.getAttributes();
    }

    @Override
    public List<IDataModelEntity> getEntities() {
        return this.m_dataModel.getEntities();
    }

    @Override
    public void loadFromXml(Element x) {
        super.loadFromXml(x);
        ITree tree = this.getTree();
        try {
            tree.setTreeChanging(true);
            this.getTree().removeAllChildNodes(this.getTree().getRootNode());
            this.loadXMLRec(x, this.getTree().getRootNode());
        }
        finally {
            tree.setTreeChanging(false);
        }
    }

    private void loadXMLRec(Element x, ITreeNode parent) {
        for (Element xmlElem : XmlUtility.getChildElements((Element)x)) {
            boolean negated;
            if ("attribute".equals(xmlElem.getTagName())) {
                IDataModelAttribute foundAtt;
                IDataModelAttributeOp op;
                Integer aggregationType;
                String id;
                block21: {
                    id = xmlElem.getAttribute("id");
                    aggregationType = 0;
                    try {
                        int operator = 20;
                        String opAttribName = "op";
                        if (xmlElem.hasAttribute(opAttribName)) {
                            operator = Integer.parseInt(xmlElem.getAttribute(opAttribName));
                        }
                        op = DataModelAttributeOp.create((int)operator);
                        String aggregTypeName = "aggregationType";
                        if (xmlElem.hasAttribute(aggregTypeName)) {
                            aggregationType = Integer.parseInt(xmlElem.getAttribute(aggregTypeName));
                        }
                        if (aggregationType != 0) break block21;
                        aggregationType = null;
                    }
                    catch (Exception e) {
                        LOG.warn("read op", (Throwable)e);
                        continue;
                    }
                }
                ArrayList<Object> valueList = new ArrayList<Object>();
                try {
                    int i = 1;
                    while (i <= 5) {
                        String valueName;
                        String string = valueName = i == 1 ? "value" : "value" + i;
                        if (xmlElem.hasAttribute(valueName)) {
                            valueList.add(XmlUtility.getObjectAttribute((Element)xmlElem, (String)valueName));
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    LOG.warn("read value for attribute {}", (Object)id, (Object)e);
                    continue;
                }
                ArrayList<String> displayValueList = new ArrayList<String>();
                int i = 1;
                while (i <= 5) {
                    String displayValueName;
                    String string = displayValueName = i == 1 ? "displayValue" : "displayValue" + i;
                    if (xmlElem.hasAttribute(displayValueName)) {
                        String val = null;
                        if (xmlElem.hasAttribute(displayValueName)) {
                            val = xmlElem.getAttribute(displayValueName);
                        }
                        displayValueList.add(val);
                    }
                    ++i;
                }
                AttributePath attPath = DataModelUtility.externalIdToAttributePath((IDataModel)this.getDataModel(), (String)id);
                IDataModelAttribute iDataModelAttribute = foundAtt = attPath != null ? attPath.getAttribute() : null;
                if (foundAtt == null) {
                    LOG.warn("cannot find attribute with id={}", (Object)id);
                    continue;
                }
                AttributeNode node = this.addAttributeNode(parent, foundAtt, aggregationType, op, valueList, displayValueList);
                if (node == null) continue;
                this.loadXMLRec(xmlElem, node);
                continue;
            }
            if ("entity".equals(xmlElem.getTagName())) {
                EntityPath entityPath;
                IDataModelEntity foundEntity;
                String id = xmlElem.getAttribute("id");
                negated = Boolean.parseBoolean(xmlElem.getAttribute("negated"));
                String text = null;
                if (xmlElem.hasAttribute("displayValues")) {
                    text = xmlElem.getAttribute("displayValues");
                }
                IDataModelEntity iDataModelEntity = foundEntity = (entityPath = DataModelUtility.externalIdToEntityPath((IDataModel)this.getDataModel(), (String)id)) != null ? entityPath.lastElement() : null;
                if (foundEntity == null) {
                    LOG.warn("cannot find entity with id={}", (Object)id);
                    continue;
                }
                EntityNode node = this.addEntityNode(parent, foundEntity, negated, null, text != null ? Collections.singletonList(text) : null);
                if (node == null) continue;
                this.loadXMLRec(xmlElem, node);
                continue;
            }
            if (!"or".equals(xmlElem.getTagName())) continue;
            boolean beginning = Boolean.parseBoolean(xmlElem.getAttribute("begin"));
            negated = Boolean.parseBoolean(xmlElem.getAttribute("negated"));
            EitherOrNode node = null;
            if (beginning) {
                node = this.addEitherNode(parent, negated);
            } else {
                EitherOrNode orNode = null;
                for (ITreeNode n : parent.getChildNodes()) {
                    if (!(n instanceof EitherOrNode) || !((EitherOrNode)n).isEndOfEitherOr()) continue;
                    orNode = (EitherOrNode)n;
                }
                if (orNode != null) {
                    node = this.addAdditionalOrNode(orNode, negated);
                }
            }
            if (node == null) continue;
            this.loadXMLRec(xmlElem, node);
        }
    }

    @Override
    public void storeToXml(Element x) {
        super.storeToXml(x);
        this.storeXMLRec(x, this.getTree().getRootNode());
    }

    private void storeXMLRec(Element x, ITreeNode parent) {
        for (ITreeNode node : parent.getChildNodes()) {
            if (node instanceof EntityNode) {
                EntityNode entityNode = (EntityNode)node;
                Element xEntity = x.getOwnerDocument().createElement("entity");
                xEntity.setAttribute("id", DataModelUtility.entityPathToExternalId((IDataModel)this.getDataModel(), (EntityPath)this.interceptResolveEntityPath(entityNode)));
                xEntity.setAttribute("negated", entityNode.isNegative() ? "true" : "false");
                List<String> texts = entityNode.getTexts();
                xEntity.setAttribute("displayValues", CollectionUtility.hasElements(texts) ? StringUtility.emptyIfNull((Object)CollectionUtility.firstElement(texts)) : null);
                x.appendChild(xEntity);
                this.storeXMLRec(xEntity, node);
                continue;
            }
            if (node instanceof AttributeNode) {
                List<Object> values;
                int i;
                List<String> texts;
                AttributeNode attNode = (AttributeNode)node;
                Element xAtt = x.getOwnerDocument().createElement("attribute");
                xAtt.setAttribute("id", DataModelUtility.attributePathToExternalId((IDataModel)this.getDataModel(), (AttributePath)this.interceptResolveAttributePath(attNode)));
                IDataModelAttributeOp op = attNode.getOp();
                try {
                    xAtt.setAttribute("op", String.valueOf(op.getOperator()));
                    if (attNode.getAggregationType() != null) {
                        xAtt.setAttribute("aggregationType", "" + attNode.getAggregationType());
                    }
                }
                catch (Exception e) {
                    LOG.warn("write op {}", (Object)op, (Object)e);
                }
                if (CollectionUtility.hasElements(texts = attNode.getTexts())) {
                    Iterator<String> it = texts.iterator();
                    xAtt.setAttribute("displayValue", StringUtility.emptyIfNull((Object)it.next()));
                    i = 2;
                    while (it.hasNext()) {
                        xAtt.setAttribute("displayValue" + i, StringUtility.emptyIfNull((Object)it.next()));
                        ++i;
                    }
                }
                if ((values = attNode.getValues()) != null) {
                    i = 0;
                    for (Object value : values) {
                        String valueName = i == 0 ? "value" : "value" + (i + 1);
                        try {
                            XmlUtility.setObjectAttribute((Element)xAtt, (String)valueName, (Object)value);
                        }
                        catch (Exception e) {
                            LOG.warn("write value[{}] for attribute {}: {}", new Object[]{i, attNode.getAttribute(), value, e});
                        }
                        ++i;
                    }
                }
                x.appendChild(xAtt);
                continue;
            }
            if (!(node instanceof EitherOrNode)) continue;
            EitherOrNode orNode = (EitherOrNode)node;
            Element xOr = x.getOwnerDocument().createElement("or");
            xOr.setAttribute("begin", "" + orNode.isBeginOfEitherOr());
            xOr.setAttribute("negated", orNode.isNegative() ? "true" : "false");
            x.appendChild(xOr);
            this.storeXMLRec(xOr, node);
        }
    }

    @Override
    public void resetValue() {
        if (this.m_initValue == null) {
            this.getTree().removeAllChildNodes(this.getTree().getRootNode());
        } else {
            try {
                this.loadFromXml(this.m_initValue);
            }
            catch (RuntimeException e) {
                LOG.error("Unexpected error occurred while restoring initial value", (Throwable)e);
                this.getTree().removeAllChildNodes(this.getTree().getRootNode());
            }
        }
        this.checkSaveNeeded();
        this.checkEmpty();
    }

    @Override
    public EntityNode addEntityNode(ITreeNode parentNode, IDataModelEntity e, boolean negated, List<?> values, List<String> texts) {
        EntityNode node = this.interceptCreateEntityNode(parentNode, e, negated, values, texts);
        if (node != null) {
            this.initNodeMenus(node);
            this.getTree().addChildNode(parentNode, node);
            this.getTree().setNodeExpanded(node, true);
        }
        return node;
    }

    @Override
    public EitherOrNode addEitherNode(ITreeNode parentNode, boolean negated) {
        EitherOrNode node = this.interceptCreateEitherNode(parentNode, negated);
        if (node != null) {
            this.initNodeMenus(node);
            this.getTree().addChildNode(parentNode, node);
            this.getTree().setNodeExpanded(node, true);
        }
        return node;
    }

    @Override
    public EitherOrNode addAdditionalOrNode(ITreeNode eitherOrNode, boolean negated) {
        EitherOrNode node = this.interceptCreateAdditionalOrNode(eitherOrNode, negated);
        if (node != null) {
            this.initNodeMenus(node);
            this.getTree().addChildNode(eitherOrNode.getChildNodeIndex() + 1, eitherOrNode.getParentNode(), node);
            this.getTree().setNodeExpanded(node, true);
        }
        return node;
    }

    @Override
    public AttributeNode addAttributeNode(ITreeNode parentNode, IDataModelAttribute a, Integer aggregationType, IDataModelAttributeOp op, List<?> values, List<String> texts) {
        AttributeNode node = this.interceptCreateAttributeNode(parentNode, a, aggregationType, op, values, texts);
        if (node != null) {
            this.initNodeMenus(node);
            this.getTree().addChildNode(parentNode, node);
        }
        return node;
    }

    public void updateInitialValue() {
        try {
            Document x = XmlUtility.createNewXmlDocument((String)"field");
            Element element = x.getDocumentElement();
            this.storeToXml(element);
            this.m_initValue = element;
        }
        catch (RuntimeException e) {
            LOG.warn("Unexpected error occurred while storing initial value", (Throwable)e);
        }
    }

    @Override
    protected boolean execIsSaveNeeded() {
        boolean saveNeeded = super.execIsSaveNeeded();
        if (saveNeeded) {
            return true;
        }
        if (this.m_tree == null) {
            return false;
        }
        return this.m_tree.getDeletedNodeCount() > 0 || this.m_tree.getInsertedNodeCount() > 0 || this.m_tree.getUpdatedNodeCount() > 0;
    }

    @Override
    protected void execMarkSaved() {
        try {
            this.m_tree.setTreeChanging(true);
            DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

                public TreeVisitResult preVisit(ITreeNode node, int level, int index) {
                    if (!node.isStatusNonchanged()) {
                        node.setStatusInternal(0);
                        AbstractComposerField.this.m_tree.updateNode(node);
                    }
                    return TreeVisitResult.CONTINUE;
                }
            };
            this.m_tree.visitNode(this.m_tree.getRootNode(), (IDepthFirstTreeVisitor<ITreeNode>)v);
            this.m_tree.clearDeletedNodes();
            this.updateInitialValue();
        }
        finally {
            this.m_tree.setTreeChanging(false);
        }
    }

    @Override
    protected boolean execIsEmpty() {
        if (!super.execIsEmpty()) {
            return false;
        }
        return this.m_tree.getRootNode() == null || this.m_tree.getRootNode().getChildNodeCount() <= 0;
    }

    @Override
    public IComposerFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected final EntityPath interceptResolveEntityPath(EntityNode node) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldResolveEntityPathChain chain = new ComposerFieldChains.ComposerFieldResolveEntityPathChain(extensions);
        return chain.execResolveEntityPath(node);
    }

    protected final void interceptResolveRootPathForTopLevelEntity(IDataModelEntity e, List<IDataModelEntity> lifeList) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldResolveRootPathForTopLevelEntityChain chain = new ComposerFieldChains.ComposerFieldResolveRootPathForTopLevelEntityChain(extensions);
        chain.execResolveRootPathForTopLevelEntity(e, lifeList);
    }

    protected final RootNode interceptCreateRootNode() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldCreateRootNodeChain chain = new ComposerFieldChains.ComposerFieldCreateRootNodeChain(extensions);
        return chain.execCreateRootNode();
    }

    protected final AttributePath interceptResolveAttributePath(AttributeNode node) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldResolveAttributePathChain chain = new ComposerFieldChains.ComposerFieldResolveAttributePathChain(extensions);
        return chain.execResolveAttributePath(node);
    }

    protected final AttributeNode interceptCreateAttributeNode(ITreeNode parentNode, IDataModelAttribute a, Integer aggregationType, IDataModelAttributeOp op, List<?> values, List<String> texts) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldCreateAttributeNodeChain chain = new ComposerFieldChains.ComposerFieldCreateAttributeNodeChain(extensions);
        return chain.execCreateAttributeNode(parentNode, a, aggregationType, op, values, texts);
    }

    protected final IDataModel interceptCreateDataModel() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldCreateDataModelChain chain = new ComposerFieldChains.ComposerFieldCreateDataModelChain(extensions);
        return chain.execCreateDataModel();
    }

    protected final EitherOrNode interceptCreateEitherNode(ITreeNode parentNode, boolean negated) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldCreateEitherNodeChain chain = new ComposerFieldChains.ComposerFieldCreateEitherNodeChain(extensions);
        return chain.execCreateEitherNode(parentNode, negated);
    }

    protected final void interceptResolveRootPathForTopLevelAttribute(IDataModelAttribute a, List<IDataModelEntity> lifeList) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldResolveRootPathForTopLevelAttributeChain chain = new ComposerFieldChains.ComposerFieldResolveRootPathForTopLevelAttributeChain(extensions);
        chain.execResolveRootPathForTopLevelAttribute(a, lifeList);
    }

    protected final EitherOrNode interceptCreateAdditionalOrNode(ITreeNode eitherOrNode, boolean negated) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldCreateAdditionalOrNodeChain chain = new ComposerFieldChains.ComposerFieldCreateAdditionalOrNodeChain(extensions);
        return chain.execCreateAdditionalOrNode(eitherOrNode, negated);
    }

    protected final EntityNode interceptCreateEntityNode(ITreeNode parentNode, IDataModelEntity e, boolean negated, List<?> values, List<String> texts) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldCreateEntityNodeChain chain = new ComposerFieldChains.ComposerFieldCreateEntityNodeChain(extensions);
        return chain.execCreateEntityNode(parentNode, e, negated, values, texts);
    }

    protected IComposerFieldExtension<? extends AbstractComposerField> createLocalExtension() {
        return new LocalComposerFieldExtension<AbstractComposerField>(this);
    }

    protected static class LocalComposerFieldExtension<OWNER extends AbstractComposerField>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements IComposerFieldExtension<OWNER> {
        public LocalComposerFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public EntityPath execResolveEntityPath(ComposerFieldChains.ComposerFieldResolveEntityPathChain chain, EntityNode node) {
            return ((AbstractComposerField)this.getOwner()).execResolveEntityPath(node);
        }

        @Override
        public void execResolveRootPathForTopLevelEntity(ComposerFieldChains.ComposerFieldResolveRootPathForTopLevelEntityChain chain, IDataModelEntity e, List<IDataModelEntity> lifeList) {
            ((AbstractComposerField)this.getOwner()).execResolveRootPathForTopLevelEntity(e, lifeList);
        }

        @Override
        public RootNode execCreateRootNode(ComposerFieldChains.ComposerFieldCreateRootNodeChain chain) {
            return ((AbstractComposerField)this.getOwner()).execCreateRootNode();
        }

        @Override
        public AttributePath execResolveAttributePath(ComposerFieldChains.ComposerFieldResolveAttributePathChain chain, AttributeNode node) {
            return ((AbstractComposerField)this.getOwner()).execResolveAttributePath(node);
        }

        @Override
        public AttributeNode execCreateAttributeNode(ComposerFieldChains.ComposerFieldCreateAttributeNodeChain chain, ITreeNode parentNode, IDataModelAttribute a, Integer aggregationType, IDataModelAttributeOp op, List<?> values, List<String> texts) {
            return ((AbstractComposerField)this.getOwner()).execCreateAttributeNode(parentNode, a, aggregationType, op, values, texts);
        }

        @Override
        public IDataModel execCreateDataModel(ComposerFieldChains.ComposerFieldCreateDataModelChain chain) {
            return ((AbstractComposerField)this.getOwner()).execCreateDataModel();
        }

        @Override
        public EitherOrNode execCreateEitherNode(ComposerFieldChains.ComposerFieldCreateEitherNodeChain chain, ITreeNode parentNode, boolean negated) {
            return ((AbstractComposerField)this.getOwner()).execCreateEitherNode(parentNode, negated);
        }

        @Override
        public void execResolveRootPathForTopLevelAttribute(ComposerFieldChains.ComposerFieldResolveRootPathForTopLevelAttributeChain chain, IDataModelAttribute a, List<IDataModelEntity> lifeList) {
            ((AbstractComposerField)this.getOwner()).execResolveRootPathForTopLevelAttribute(a, lifeList);
        }

        @Override
        public EitherOrNode execCreateAdditionalOrNode(ComposerFieldChains.ComposerFieldCreateAdditionalOrNodeChain chain, ITreeNode eitherOrNode, boolean negated) {
            return ((AbstractComposerField)this.getOwner()).execCreateAdditionalOrNode(eitherOrNode, negated);
        }

        @Override
        public EntityNode execCreateEntityNode(ComposerFieldChains.ComposerFieldCreateEntityNodeChain chain, ITreeNode parentNode, IDataModelEntity e, boolean negated, List<?> values, List<String> texts) {
            return ((AbstractComposerField)this.getOwner()).execCreateEntityNode(parentNode, e, negated, values, texts);
        }
    }

    protected class P_UIFacade
    implements IComposerFieldUIFacade {
        protected P_UIFacade() {
        }
    }

    @ClassId(value="2f9212f9-6c18-46dd-9d9b-d3bd590bd8fc")
    public class Tree
    extends AbstractTree {
        @Override
        protected boolean getConfiguredRootNodeVisible() {
            return true;
        }

        @Override
        protected void execDisposeTree() {
            super.execDisposeTree();
            DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

                public TreeVisitResult preVisit(ITreeNode node, int level, int index) {
                    if (node instanceof AbstractComposerNode) {
                        ((AbstractComposerNode)node).dispose();
                    }
                    return TreeVisitResult.CONTINUE;
                }
            };
            this.visitTree((IDepthFirstTreeVisitor<ITreeNode>)v);
        }

        @Override
        protected TreeNodeData exportTreeNodeData(ITreeNode node, AbstractTreeFieldData treeData) {
            if (node instanceof EntityNode) {
                EntityNode enode = (EntityNode)node;
                String externalId = DataModelUtility.entityPathToExternalId((IDataModel)AbstractComposerField.this.getDataModel(), (EntityPath)AbstractComposerField.this.interceptResolveEntityPath(enode));
                if (externalId == null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("could not find entity data for: {}", (Object)enode.getEntity());
                    }
                    return null;
                }
                ComposerEntityNodeData data = new ComposerEntityNodeData();
                data.setEntityExternalId(externalId);
                data.setNegative(enode.isNegative());
                return data;
            }
            if (node instanceof AttributeNode) {
                AttributeNode anode = (AttributeNode)node;
                String externalId = DataModelUtility.attributePathToExternalId((IDataModel)AbstractComposerField.this.getDataModel(), (AttributePath)AbstractComposerField.this.interceptResolveAttributePath(anode));
                if (externalId == null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("could not find attribute data for: {}", (Object)anode.getAttribute());
                    }
                    return null;
                }
                ComposerAttributeNodeData data = new ComposerAttributeNodeData();
                data.setAttributeExternalId(externalId);
                data.setNegative(false);
                data.setAggregationType(anode.getAggregationType());
                data.setOperator(anode.getOp().getOperator());
                data.setValues(anode.getValues());
                data.setTexts(anode.getTexts());
                return data;
            }
            if (node instanceof EitherOrNode) {
                EitherOrNode eonode = (EitherOrNode)node;
                ComposerEitherOrNodeData data = new ComposerEitherOrNodeData();
                data.setNegative(eonode.isNegative());
                data.setBeginOfEitherOr(eonode.isBeginOfEitherOr());
                return data;
            }
            return null;
        }

        @Override
        protected ITreeNode importTreeNodeData(ITreeNode parentNode, AbstractTreeFieldData treeData, TreeNodeData nodeData) {
            if (nodeData instanceof ComposerEntityNodeData) {
                IDataModelEntity e;
                ComposerEntityNodeData enodeData = (ComposerEntityNodeData)nodeData;
                String externalId = enodeData.getEntityExternalId();
                EntityPath entityPath = DataModelUtility.externalIdToEntityPath((IDataModel)AbstractComposerField.this.getDataModel(), (String)externalId);
                IDataModelEntity iDataModelEntity = e = entityPath != null ? entityPath.lastElement() : null;
                if (e == null) {
                    LOG.warn("could not find entity for: {}", (Object)enodeData.getEntityExternalId());
                    return null;
                }
                return AbstractComposerField.this.addEntityNode(parentNode, e, enodeData.isNegative(), null, enodeData.getTexts());
            }
            if (nodeData instanceof ComposerAttributeNodeData) {
                IDataModelAttributeOp op;
                IDataModelAttribute a;
                ComposerAttributeNodeData anodeData = (ComposerAttributeNodeData)nodeData;
                String externalId = anodeData.getAttributeExternalId();
                AttributePath attPath = DataModelUtility.externalIdToAttributePath((IDataModel)AbstractComposerField.this.getDataModel(), (String)externalId);
                IDataModelAttribute iDataModelAttribute = a = attPath != null ? attPath.getAttribute() : null;
                if (a == null) {
                    LOG.warn("could not find attribute for: {}", (Object)anodeData.getAttributeExternalId());
                    return null;
                }
                try {
                    op = a.getOperators().stream().filter(p -> p.getOperator() == anodeData.getOperator()).findFirst().orElseGet(() -> DataModelAttributeOp.create((int)anodeData.getOperator()));
                }
                catch (Exception e) {
                    LOG.warn("read op {}", (Object)anodeData.getOperator(), (Object)e);
                    return null;
                }
                return AbstractComposerField.this.addAttributeNode(parentNode, a, anodeData.getAggregationType(), op, anodeData.getValues(), anodeData.getTexts());
            }
            if (nodeData instanceof ComposerEitherOrNodeData) {
                ComposerEitherOrNodeData eonodeData = (ComposerEitherOrNodeData)nodeData;
                if (eonodeData.isBeginOfEitherOr()) {
                    return AbstractComposerField.this.addEitherNode(parentNode, eonodeData.isNegative());
                }
                ITreeNode eitherOrNode = parentNode.getChildNode(parentNode.getChildNodeCount() - 1);
                return AbstractComposerField.this.addAdditionalOrNode(eitherOrNode, eonodeData.isNegative());
            }
            return null;
        }

        @Override
        protected void execDecorateCell(ITreeNode node, Cell cell) {
            node.decorateCell();
        }
    }
}

