/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer;

import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.dto.FormData;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.composer.ComposerValueBoxChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.composer.IComposerValueBoxExtension;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.AbstractBigDecimalField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerValueBox;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerValueField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.AbstractDateField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.AbstractTimeField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.integerfield.AbstractIntegerField;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox;
import org.eclipse.scout.rt.client.ui.form.fields.longfield.AbstractLongField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.AbstractSequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.AbstractTreeBox;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.TriState;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="2d8065cf-eeb3-4d64-8753-adb36cf852b8")
public abstract class AbstractComposerValueBox
extends AbstractGroupBox
implements IComposerValueBox {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractComposerValueBox.class);
    private Map<Integer, Map<Integer, IComposerValueField>> m_operatorTypeToFieldMap;
    private IDataModelAttribute m_attribute;
    private IComposerValueField m_selectedField;
    private PropertyChangeListener m_valueChangedListener;

    public AbstractComposerValueBox() {
        this(true);
    }

    public AbstractComposerValueBox(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected boolean getConfiguredBorderVisible() {
        return false;
    }

    @Override
    protected int getConfiguredGridColumnCount() {
        return 1;
    }

    @Override
    protected int getConfiguredGridW() {
        return 1;
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execChangedValue() {
    }

    @Override
    protected void execAddSearchTerms(SearchFilter search) {
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        HashMap<Integer, Map<Integer, IComposerValueField>> operatorTypeToFieldMap = new HashMap<Integer, Map<Integer, IComposerValueField>>();
        this.interceptInitOperatorToFieldMap(operatorTypeToFieldMap);
        this.m_operatorTypeToFieldMap = operatorTypeToFieldMap;
        this.m_valueChangedListener = e -> {
            if ("value".equals(e.getPropertyName())) {
                try {
                    this.interceptChangedValue();
                }
                catch (Exception ex) {
                    LOG.error("fire value change on {}", e.getSource(), (Object)ex);
                }
            }
        };
        for (IFormField f : this.getFields()) {
            List<IFormField> sequenceBoxChildFields;
            f.setLabelVisible(false);
            f.setLabel(TEXTS.get((String)"Value"));
            f.setVisible(false);
            if (!(f instanceof ISequenceBox) || !CollectionUtility.hasElements(sequenceBoxChildFields = ((ICompositeField)f).getFields())) continue;
            IFormField firstField = (IFormField)CollectionUtility.firstElement(sequenceBoxChildFields);
            firstField.setLabelVisible(false);
            if (sequenceBoxChildFields.size() <= 1) continue;
            IFormField secondField = (IFormField)CollectionUtility.getElement(sequenceBoxChildFields, (int)1);
            secondField.setLabel(TEXTS.get((String)"and"));
        }
    }

    protected void execInitOperatorToFieldMap(Map<Integer, Map<Integer, IComposerValueField>> operatorTypeToFieldMap) {
        HashMap<Integer, IComposerValueField> betweenMap = new HashMap<Integer, IComposerValueField>();
        betweenMap.put(5, this.getFieldByClass(BetweenDateField.class));
        betweenMap.put(7, this.getFieldByClass(BetweenDateTimeField.class));
        betweenMap.put(10, this.getFieldByClass(BetweenBigDecimalField.class));
        betweenMap.put(17, this.getFieldByClass(BetweenIntegerField.class));
        betweenMap.put(8, this.getFieldByClass(BetweenIntegerField.class));
        betweenMap.put(9, this.getFieldByClass(BetweenLongField.class));
        betweenMap.put(14, this.getFieldByClass(BetweenBigDecimalField.class));
        betweenMap.put(13, this.getFieldByClass(BetweenBigDecimalField.class));
        betweenMap.put(11, this.getFieldByClass(BetweenIntegerField.class));
        betweenMap.put(12, this.getFieldByClass(BetweenLongField.class));
        betweenMap.put(6, this.getFieldByClass(BetweenTimeField.class));
        operatorTypeToFieldMap.put(45, betweenMap);
        operatorTypeToFieldMap.put(47, betweenMap);
        operatorTypeToFieldMap.put(48, betweenMap);
        HashMap<Integer, IComposerValueField> defaultMap = new HashMap<Integer, IComposerValueField>();
        defaultMap.put(5, this.getFieldByClass(DateField.class));
        defaultMap.put(7, this.getFieldByClass(DateTimeField.class));
        defaultMap.put(10, this.getFieldByClass(BigDecimalField.class));
        defaultMap.put(17, this.getFieldByClass(IntegerField.class));
        defaultMap.put(8, this.getFieldByClass(IntegerField.class));
        defaultMap.put(3, this.getFieldByClass(ListBoxField.class));
        defaultMap.put(4, this.getFieldByClass(TreeBoxField.class));
        defaultMap.put(9, this.getFieldByClass(LongField.class));
        defaultMap.put(14, this.getFieldByClass(BigDecimalField.class));
        defaultMap.put(13, this.getFieldByClass(BigDecimalField.class));
        defaultMap.put(11, this.getFieldByClass(IntegerField.class));
        defaultMap.put(12, this.getFieldByClass(LongField.class));
        defaultMap.put(15, this.getFieldByClass(StringField.class));
        defaultMap.put(18, this.getFieldByClass(StringField.class));
        defaultMap.put(19, this.getFieldByClass(StringField.class));
        defaultMap.put(20, this.getFieldByClass(StringField.class));
        defaultMap.put(16, this.getFieldByClass(SmartField.class));
        defaultMap.put(6, this.getFieldByClass(TimeField.class));
        operatorTypeToFieldMap.put(0, defaultMap);
    }

    public IComposerValueField getSelectedField() {
        return this.m_selectedField;
    }

    public void setSelectionContext(IDataModelAttribute attribute, IDataModelAttributeOp op, List<?> values) {
        Map<Integer, IComposerValueField> typeToFieldMap;
        if (op == null) {
            return;
        }
        this.m_attribute = attribute;
        int dataType = op.getType();
        if (dataType == -1) {
            dataType = attribute.getType();
        }
        if ((typeToFieldMap = this.m_operatorTypeToFieldMap.get(op.getOperator())) == null) {
            typeToFieldMap = this.m_operatorTypeToFieldMap.get(0);
        }
        IComposerValueField valueField = typeToFieldMap.get(dataType);
        if (values == null && this.m_selectedField != null && valueField != null && this.m_selectedField.getClass().equals(valueField.getClass())) {
            values = this.m_selectedField.getValues();
        }
        if (this.m_selectedField != null) {
            this.m_selectedField.removeValueChangeListenerFromTarget(this.m_valueChangedListener);
            this.m_selectedField.clearSelectionContext();
        }
        this.m_selectedField = valueField;
        if (this.m_selectedField != null) {
            this.m_selectedField.addValueChangeListenerToTarget(this.m_valueChangedListener);
            this.m_selectedField.setSelectionContext(this.m_attribute, dataType, op, values);
        }
        for (IFormField f : this.getFields()) {
            f.setVisible(f == this.m_selectedField);
        }
    }

    public void clearSelectionContext() {
        if (this.m_selectedField != null) {
            this.m_selectedField.clearSelectionContext();
        }
        this.m_selectedField = null;
        for (IFormField f : this.getFields()) {
            f.setVisible(false);
        }
    }

    protected final void interceptChangedValue() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerValueBoxChains.ComposerValueBoxChangedValueChain chain = new ComposerValueBoxChains.ComposerValueBoxChangedValueChain(extensions);
        chain.execChangedValue();
    }

    protected final void interceptInitOperatorToFieldMap(Map<Integer, Map<Integer, IComposerValueField>> operatorTypeToFieldMap) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerValueBoxChains.ComposerValueBoxInitOperatorToFieldMapChain chain = new ComposerValueBoxChains.ComposerValueBoxInitOperatorToFieldMapChain(extensions);
        chain.execInitOperatorToFieldMap(operatorTypeToFieldMap);
    }

    @Override
    protected IComposerValueBoxExtension<? extends AbstractComposerValueBox> createLocalExtension() {
        return new LocalComposerValueBoxExtension<AbstractComposerValueBox>(this);
    }

    @Order(value=10.0)
    @ClassId(value="1eb9aa40-936f-4cd0-b34c-c345c7486685")
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenBigDecimalField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.addPropertyChangeListener(listener);
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.removePropertyChangeListener(listener);
            }
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                this.getFieldByClass(BigDecimalFromField.class).setValue(null);
                this.getFieldByClass(BigDecimalToField.class).setValue(null);
                if (values != null && values.size() == 2) {
                    if (values.get(0) instanceof BigDecimal) {
                        this.getFieldByClass(BigDecimalFromField.class).setValue((BigDecimal)values.get(0));
                    }
                    if (values.get(1) instanceof BigDecimal) {
                        this.getFieldByClass(BigDecimalToField.class).setValue((BigDecimal)values.get(1));
                    }
                }
            }
            catch (Exception exception) {}
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(BigDecimalFromField.class).setValue(null);
            this.getFieldByClass(BigDecimalToField.class).setValue(null);
        }

        @Override
        public List<Object> getValues() {
            Object a = this.getFieldByClass(BigDecimalFromField.class).getValue();
            Object b = this.getFieldByClass(BigDecimalToField.class).getValue();
            if (a == null && b == null) {
                return null;
            }
            return CollectionUtility.arrayList((Object[])new Object[]{a, b});
        }

        @Override
        public List<String> getTexts() {
            String a = this.getFieldByClass(BigDecimalFromField.class).getDisplayText();
            String b = this.getFieldByClass(BigDecimalToField.class).getDisplayText();
            return CollectionUtility.arrayList((Object[])new String[]{a, b});
        }

        @Order(value=10.0)
        @ClassId(value="07c002ce-e3df-45d5-8f5e-5acdd4fb1ad1")
        public class BigDecimalFromField
        extends AbstractBigDecimalField {
        }

        @Order(value=20.0)
        @ClassId(value="3df14616-fdbc-4854-8b83-6feb08518047")
        public class BigDecimalToField
        extends AbstractBigDecimalField {
        }
    }

    @Order(value=10.0)
    @ClassId(value="83ead684-0cb1-43b3-8545-7815db2facb3")
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenDateField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.addPropertyChangeListener(listener);
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.removePropertyChangeListener(listener);
            }
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List<?> values) {
            try {
                this.getFieldByClass(DateFromField.class).setValue(null);
                this.getFieldByClass(DateToField.class).setValue(null);
                if (values != null && values.size() == 2) {
                    if (values.get(0) instanceof Date) {
                        this.getFieldByClass(DateFromField.class).setValue((Date)values.get(0));
                    }
                    if (values.get(1) instanceof Date) {
                        this.getFieldByClass(DateToField.class).setValue((Date)values.get(1));
                    }
                }
            }
            catch (Exception exception) {}
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(DateFromField.class).setValue(null);
            this.getFieldByClass(DateToField.class).setValue(null);
        }

        @Override
        public List<Object> getValues() {
            Object a = this.getFieldByClass(DateFromField.class).getValue();
            Object b = this.getFieldByClass(DateToField.class).getValue();
            if (a == null && b == null) {
                return null;
            }
            return CollectionUtility.arrayList((Object[])new Object[]{a, b});
        }

        @Override
        public List<String> getTexts() {
            String a = this.getFieldByClass(DateFromField.class).getDisplayText();
            String b = this.getFieldByClass(DateToField.class).getDisplayText();
            return CollectionUtility.arrayList((Object[])new String[]{a, b});
        }

        @Order(value=10.0)
        @ClassId(value="4be8320d-841e-46c7-990f-47dc66294f9e")
        public class DateFromField
        extends AbstractDateField {
        }

        @Order(value=20.0)
        @ClassId(value="5a031971-bb60-4366-bbfc-3ce906e022f9")
        public class DateToField
        extends AbstractDateField {
        }
    }

    @Order(value=10.0)
    @ClassId(value="cb94b834-2f10-4d81-b22b-c433bd065963")
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenDateTimeField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.addPropertyChangeListener(listener);
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.removePropertyChangeListener(listener);
            }
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                this.getFieldByClass(DateTimeFromField.class).setValue(null);
                this.getFieldByClass(DateTimeToField.class).setValue(null);
                if (values != null && values.size() == 2) {
                    if (values.get(0) instanceof Date) {
                        this.getFieldByClass(DateTimeFromField.class).setValue((Date)values.get(0));
                    }
                    if (values.get(1) instanceof Date) {
                        this.getFieldByClass(DateTimeToField.class).setValue((Date)values.get(1));
                    }
                }
            }
            catch (Exception exception) {}
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(DateTimeFromField.class).setValue(null);
            this.getFieldByClass(DateTimeToField.class).setValue(null);
        }

        @Override
        public List<Object> getValues() {
            Object a = this.getFieldByClass(DateTimeFromField.class).getValue();
            Object b = this.getFieldByClass(DateTimeToField.class).getValue();
            if (a == null && b == null) {
                return null;
            }
            return CollectionUtility.arrayList((Object[])new Object[]{a, b});
        }

        @Override
        public List<String> getTexts() {
            String a = this.getFieldByClass(DateTimeFromField.class).getDisplayText();
            String b = this.getFieldByClass(DateTimeToField.class).getDisplayText();
            return CollectionUtility.arrayList((Object[])new String[]{a, b});
        }

        @Order(value=10.0)
        @ClassId(value="c94de66d-5d6d-44f4-9418-0fc8fc7c679c")
        public class DateTimeFromField
        extends AbstractDateField {
            @Override
            protected boolean getConfiguredHasTime() {
                return true;
            }
        }

        @Order(value=20.0)
        @ClassId(value="6e1d5025-5e29-498f-8027-75c3843c1d9e")
        public class DateTimeToField
        extends AbstractDateField {
            @Override
            protected boolean getConfiguredHasTime() {
                return true;
            }
        }
    }

    @Order(value=10.0)
    @ClassId(value="4d0ae72b-dffd-4a09-945b-4e50d4037d16")
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenIntegerField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.addPropertyChangeListener(listener);
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.removePropertyChangeListener(listener);
            }
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                this.getFieldByClass(IntegerFromField.class).setValue(null);
                this.getFieldByClass(IntegerToField.class).setValue(null);
                if (values != null && values.size() == 2) {
                    if (values.get(0) instanceof Integer) {
                        this.getFieldByClass(IntegerFromField.class).setValue((Integer)values.get(0));
                    }
                    if (values.get(1) instanceof Integer) {
                        this.getFieldByClass(IntegerToField.class).setValue((Integer)values.get(1));
                    }
                }
            }
            catch (Exception exception) {}
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(IntegerFromField.class).setValue(null);
            this.getFieldByClass(IntegerToField.class).setValue(null);
        }

        @Override
        public List<Object> getValues() {
            Object a = this.getFieldByClass(IntegerFromField.class).getValue();
            Object b = this.getFieldByClass(IntegerToField.class).getValue();
            if (a == null && b == null) {
                return null;
            }
            return CollectionUtility.arrayList((Object[])new Object[]{a, b});
        }

        @Override
        public List<String> getTexts() {
            String a = this.getFieldByClass(IntegerFromField.class).getDisplayText();
            String b = this.getFieldByClass(IntegerToField.class).getDisplayText();
            return CollectionUtility.arrayList((Object[])new String[]{a, b});
        }

        @Order(value=10.0)
        @ClassId(value="f17a7e6d-1df2-484e-9e96-8b3d32c7d095")
        public class IntegerFromField
        extends AbstractIntegerField {
        }

        @Order(value=20.0)
        @ClassId(value="9cdddae5-de01-41d6-9cfc-5ae7c0ad3663")
        public class IntegerToField
        extends AbstractIntegerField {
        }
    }

    @Order(value=10.0)
    @ClassId(value="91376e0a-af80-4deb-b089-2675c3870dbc")
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenLongField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.addPropertyChangeListener(listener);
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.removePropertyChangeListener(listener);
            }
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                this.getFieldByClass(LongFromField.class).setValue(null);
                this.getFieldByClass(LongToField.class).setValue(null);
                if (values != null && values.size() == 2) {
                    if (values.get(0) instanceof Long) {
                        this.getFieldByClass(LongFromField.class).setValue((Long)values.get(0));
                    }
                    if (values.get(1) instanceof Long) {
                        this.getFieldByClass(LongToField.class).setValue((Long)values.get(1));
                    }
                }
            }
            catch (Exception exception) {}
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(LongFromField.class).setValue(null);
            this.getFieldByClass(LongToField.class).setValue(null);
        }

        @Override
        public List<Object> getValues() {
            Object a = this.getFieldByClass(LongFromField.class).getValue();
            Object b = this.getFieldByClass(LongToField.class).getValue();
            if (a == null && b == null) {
                return null;
            }
            return CollectionUtility.arrayList((Object[])new Object[]{a, b});
        }

        @Override
        public List<String> getTexts() {
            String a = this.getFieldByClass(LongFromField.class).getDisplayText();
            String b = this.getFieldByClass(LongToField.class).getDisplayText();
            return CollectionUtility.arrayList((Object[])new String[]{a, b});
        }

        @Order(value=10.0)
        @ClassId(value="c084e230-ccc8-4672-bcfd-09538630e9e7")
        public class LongFromField
        extends AbstractLongField {
        }

        @Order(value=20.0)
        @ClassId(value="e94e9352-4690-4dcd-8be4-d73135636d27")
        public class LongToField
        extends AbstractLongField {
        }
    }

    @Order(value=10.0)
    @ClassId(value="85010cb1-d6fa-4879-a5d2-7247685b95b7")
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenTimeField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.addPropertyChangeListener(listener);
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.removePropertyChangeListener(listener);
            }
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                this.getFieldByClass(TimeFromField.class).setValue(null);
                this.getFieldByClass(TimeToField.class).setValue(null);
                if (values != null && values.size() == 2) {
                    if (values.get(0) instanceof Double) {
                        this.getFieldByClass(TimeFromField.class).setTimeValue((Double)values.get(0));
                    } else if (values.get(0) instanceof Date) {
                        this.getFieldByClass(TimeFromField.class).setValue((Date)values.get(0));
                    }
                    if (values.get(1) instanceof Double) {
                        this.getFieldByClass(TimeToField.class).setTimeValue((Double)values.get(1));
                    } else if (values.get(1) instanceof Date) {
                        this.getFieldByClass(TimeToField.class).setValue((Date)values.get(1));
                    }
                }
            }
            catch (Exception exception) {}
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(TimeFromField.class).setValue(null);
            this.getFieldByClass(TimeToField.class).setValue(null);
        }

        @Override
        public List<Object> getValues() {
            Object a = this.getFieldByClass(TimeFromField.class).getValue();
            Object b = this.getFieldByClass(TimeToField.class).getValue();
            if (a == null && b == null) {
                return null;
            }
            return CollectionUtility.arrayList((Object[])new Object[]{a, b});
        }

        @Override
        public List<String> getTexts() {
            String a = this.getFieldByClass(TimeFromField.class).getDisplayText();
            String b = this.getFieldByClass(TimeToField.class).getDisplayText();
            return CollectionUtility.arrayList((Object[])new String[]{a, b});
        }

        @Order(value=10.0)
        @ClassId(value="0a86c867-8907-4395-bf67-79c117c9c54c")
        public class TimeFromField
        extends AbstractTimeField {
        }

        @Order(value=20.0)
        @ClassId(value="0fb0159c-c781-4243-b1f4-169eb489692b")
        public class TimeToField
        extends AbstractTimeField {
        }
    }

    @Order(value=10.0)
    @ClassId(value="6cd73fce-6b42-4e38-9f77-3cd1b73e799c")
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BigDecimalField
    extends AbstractBigDecimalField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            switch (dataType) {
                case 10: {
                    this.setGroupingUsed(true);
                    this.setPercent(false);
                    break;
                }
                case 14: {
                    this.setGroupingUsed(true);
                    this.setPercent(true);
                    break;
                }
                case 13: {
                    this.setGroupingUsed(false);
                    this.setPercent(false);
                }
            }
            try {
                Object firstElement = CollectionUtility.firstElement((List)values);
                if (firstElement instanceof BigDecimal) {
                    this.setValue((BigDecimal)firstElement);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception exception) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getValue() == null) {
                return null;
            }
            return Collections.singletonList(this.getValue());
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    @Order(value=10.0)
    @ClassId(value="5e26128b-2d65-4ed7-88cc-c23a466b6e88")
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class DateField
    extends AbstractDateField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                Object firstElement = CollectionUtility.firstElement((List)values);
                if (firstElement instanceof Date) {
                    this.setValue((Date)firstElement);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception exception) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getValue() != null) {
                return Collections.singletonList(this.getValue());
            }
            return null;
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    @Order(value=10.0)
    @ClassId(value="0e51fb86-c4f7-471d-8cb1-6329fc8c31a6")
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class DateTimeField
    extends AbstractDateField
    implements IComposerValueField {
        @Override
        protected boolean getConfiguredHasTime() {
            return true;
        }

        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                Object firstElement = CollectionUtility.firstElement((List)values);
                if (firstElement instanceof Date) {
                    this.setValue((Date)firstElement);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception exception) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getValue() == null) {
                return null;
            }
            return Collections.singletonList(this.getValue());
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    @Order(value=10.0)
    @ClassId(value="462688c6-9246-49be-adf6-2d21abbff066")
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class IntegerField
    extends AbstractIntegerField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            switch (dataType) {
                case 8: {
                    this.setGroupingUsed(true);
                    break;
                }
                case 11: {
                    this.setGroupingUsed(false);
                }
            }
            try {
                Object firstElement = CollectionUtility.firstElement((List)values);
                if (firstElement instanceof Integer) {
                    this.setValue((Integer)firstElement);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception exception) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getValue() == null) {
                return null;
            }
            return Collections.singletonList(this.getValue());
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    @Order(value=10.0)
    @ClassId(value="93c506dc-737d-4e12-89a2-2a3a21e49fbe")
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class ListBoxField
    extends AbstractListBox<Object>
    implements IComposerValueField {
        @Override
        protected boolean getConfiguredAutoLoad() {
            return false;
        }

        @Override
        protected int getConfiguredGridH() {
            return 4;
        }

        @Override
        protected void execPrepareLookup(ILookupCall<Object> call) {
            if (AbstractComposerValueBox.this.m_attribute != null) {
                call.setActive(this.isFilterActiveRows() ? null : TriState.TRUE);
                AbstractComposerValueBox.this.m_attribute.prepareLookup(call);
            }
        }

        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List<?> values) {
            this.setFilterActiveRowsValue(TriState.TRUE);
            this.setFilterActiveRows(attribute.isActiveFilterEnabled());
            ILookupCall newCall = attribute.getLookupCall();
            if (this.getLookupCall() != newCall) {
                this.setLookupCall(newCall);
                try {
                    this.loadListBoxData();
                }
                catch (Exception e) {
                    LOG.warn("Exception while loading list box data [{}]", (Object)this.getClass().getName(), (Object)e);
                }
            }
            try {
                Object firstElement = CollectionUtility.firstElement(values);
                if (firstElement instanceof Collection) {
                    this.setValue(CollectionUtility.hashSet((Collection)((Collection)firstElement)));
                } else if (firstElement instanceof Object[]) {
                    this.setValue(CollectionUtility.hashSet((Object[])((Object[])firstElement)));
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception exception) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getCheckedKeyCount() > 0) {
                return CollectionUtility.arrayList((Object)this.getValue());
            }
            return null;
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    protected static class LocalComposerValueBoxExtension<OWNER extends AbstractComposerValueBox>
    extends AbstractGroupBox.LocalGroupBoxExtension<OWNER>
    implements IComposerValueBoxExtension<OWNER> {
        public LocalComposerValueBoxExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execChangedValue(ComposerValueBoxChains.ComposerValueBoxChangedValueChain chain) {
            ((AbstractComposerValueBox)this.getOwner()).execChangedValue();
        }

        @Override
        public void execInitOperatorToFieldMap(ComposerValueBoxChains.ComposerValueBoxInitOperatorToFieldMapChain chain, Map<Integer, Map<Integer, IComposerValueField>> operatorTypeToFieldMap) {
            ((AbstractComposerValueBox)this.getOwner()).execInitOperatorToFieldMap(operatorTypeToFieldMap);
        }
    }

    @Order(value=10.0)
    @ClassId(value="c0b921cd-59f2-46cf-9108-533aa8612c8d")
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class LongField
    extends AbstractLongField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            switch (dataType) {
                case 9: {
                    this.setGroupingUsed(true);
                    break;
                }
                case 12: {
                    this.setGroupingUsed(false);
                }
            }
            try {
                Object firstElement = CollectionUtility.firstElement((List)values);
                if (firstElement instanceof Long) {
                    this.setValue((Long)firstElement);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception exception) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getValue() == null) {
                return null;
            }
            return Collections.singletonList(this.getValue());
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    @Order(value=10.0)
    @ClassId(value="4707c050-3f4b-4ce3-a8c9-0452522becdc")
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class SmartField
    extends AbstractSmartField<Object>
    implements IComposerValueField {
        @Override
        protected void execPrepareLookup(ILookupCall<Object> call) {
            if (AbstractComposerValueBox.this.m_attribute != null) {
                call.setActive(this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE);
                AbstractComposerValueBox.this.m_attribute.prepareLookup(call);
            }
        }

        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            this.setActiveFilterEnabled(attribute.isActiveFilterEnabled());
            ILookupCall newCall = op.getLookupCall();
            if (newCall == null) {
                newCall = attribute.getLookupCall();
            }
            if (this.getLookupCall() != newCall) {
                this.setLookupCall(newCall);
            }
            this.setSearchRequired(attribute.isSearchRequired());
            try {
                this.setValue(CollectionUtility.firstElement((List)values));
            }
            catch (Exception exception) {
                this.setValue(null);
            }
            this.setBrowseHierarchy();
        }

        protected void setBrowseHierarchy() {
            if (LocalLookupCall.class.isAssignableFrom(this.getLookupCall().getClass()) && ((LocalLookupCall)this.getLookupCall()).isHierarchicalLookup()) {
                this.setBrowseHierarchy(true);
            } else {
                this.setBrowseHierarchy(false);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getValue() == null) {
                return null;
            }
            return Collections.singletonList(this.getValue());
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    @Order(value=10.0)
    @ClassId(value="055381df-86e7-4971-95bb-8d9f1074e409")
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class StringField
    extends AbstractStringField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                Object firstElement = CollectionUtility.firstElement((List)values);
                if (firstElement instanceof String) {
                    this.setValue((String)firstElement);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception exception) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getValue() == null) {
                return null;
            }
            return Collections.singletonList(this.getValue());
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    @Order(value=10.0)
    @ClassId(value="0ea204ce-bc8b-472d-9535-d9de4d117acb")
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class TimeField
    extends AbstractTimeField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                if (values != null && values.size() == 1) {
                    Object firstElement = CollectionUtility.firstElement((List)values);
                    if (firstElement instanceof Double) {
                        this.setTimeValue((Double)firstElement);
                    } else if (firstElement instanceof Date) {
                        this.setValue((Date)firstElement);
                    } else {
                        this.setValue(null);
                    }
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception exception) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getValue() == null) {
                return null;
            }
            return Collections.singletonList(this.getValue());
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    @Order(value=10.0)
    @ClassId(value="32cf9165-ff77-46a5-afb2-1a2b1aff42c8")
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class TreeBoxField
    extends AbstractTreeBox<Object>
    implements IComposerValueField {
        @Override
        protected boolean getConfiguredAutoLoad() {
            return false;
        }

        @Override
        protected boolean getConfiguredAutoCheckChildNodes() {
            return true;
        }

        @Override
        protected int getConfiguredGridH() {
            return 4;
        }

        @Override
        protected void execPrepareLookup(ILookupCall<Object> call, ITreeNode parent) {
            if (AbstractComposerValueBox.this.m_attribute != null) {
                call.setActive(this.isFilterActiveNodes() ? null : TriState.TRUE);
                AbstractComposerValueBox.this.m_attribute.prepareLookup(call);
            }
        }

        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List<?> values0) {
            this.setFilterActiveNodesValue(TriState.TRUE);
            this.setFilterActiveNodes(attribute.isActiveFilterEnabled());
            ILookupCall newCall = attribute.getLookupCall();
            if (this.getLookupCall() != newCall) {
                this.setLookupCall(newCall);
                try {
                    this.loadRootNode();
                    this.getTree().setNodeExpanded(this.getTree().getRootNode(), true);
                }
                catch (Exception e) {
                    LOG.warn("Exception while loading and expanding root node [{}]", (Object)this.getClass().getName(), (Object)e);
                }
            }
            try {
                Object firstElement = CollectionUtility.firstElement(values0);
                if (firstElement instanceof Collection) {
                    this.setValue(CollectionUtility.hashSet((Collection)((Collection)firstElement)));
                } else if (firstElement instanceof Object[]) {
                    this.setValue(CollectionUtility.hashSet((Object[])((Object[])firstElement)));
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception exception) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            Object value = this.getValue();
            if (value == null) {
                return null;
            }
            return CollectionUtility.arrayList((Object)value);
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }
}

