/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AttributeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EitherOrNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EntityNode;

public class ComposerDisplayTextBuilder {
    public void build(ITreeNode node, StringBuilder buf, String prefix) {
        this.visitAndNodes(node.getChildNodes(), buf, prefix);
    }

    private void visitAndNodes(List<? extends ITreeNode> nodes, StringBuilder buf, String prefix) {
        Iterator<? extends ITreeNode> nodeIt = nodes.iterator();
        ITreeNode node = null;
        boolean skipDoNext = false;
        while (nodeIt.hasNext() || skipDoNext) {
            if (!skipDoNext) {
                node = nodeIt.next();
            }
            skipDoNext = false;
            if (node instanceof EntityNode) {
                this.visitEntityNode((EntityNode)node, buf, prefix);
                continue;
            }
            if (node instanceof AttributeNode) {
                this.visitAttributeNode((AttributeNode)node, buf, prefix);
                continue;
            }
            if (!(node instanceof EitherOrNode)) continue;
            ArrayList<EitherOrNode> eitherOrNodes = new ArrayList<EitherOrNode>();
            eitherOrNodes.add((EitherOrNode)node);
            while (nodeIt.hasNext()) {
                node = nodeIt.next();
                if (node instanceof EitherOrNode) {
                    eitherOrNodes.add((EitherOrNode)node);
                    continue;
                }
                skipDoNext = true;
                break;
            }
            this.visitOrNodes(eitherOrNodes, buf, prefix);
        }
    }

    private void visitOrNodes(List<? extends EitherOrNode> nodes, StringBuilder buf, String prefix) {
        for (EitherOrNode eitherOrNode : nodes) {
            buf.append(prefix);
            buf.append(eitherOrNode.getCell().toPlainText());
            buf.append("\n");
            this.visitAndNodes(eitherOrNode.getChildNodes(), buf, String.valueOf(prefix) + " ");
        }
    }

    private void visitEntityNode(EntityNode node, StringBuilder buf, String prefix) {
        buf.append(prefix);
        buf.append(node.getCell().toPlainText());
        buf.append("\n");
        this.visitAndNodes(node.getChildNodes(), buf, String.valueOf(prefix) + " ");
    }

    private void visitAttributeNode(AttributeNode node, StringBuilder buf, String prefix) {
        buf.append(prefix);
        buf.append(node.getCell().toPlainText());
        buf.append("\n");
        this.visitAndNodes(node.getChildNodes(), buf, String.valueOf(prefix) + " ");
    }
}

