/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.node;

import java.util.List;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.internal.ComposerAttributeForm;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EntityNode;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;

@ClassId(value="db83fd12-1690-4c31-8528-8f115fda496f")
public abstract class AbstractAddAttributeMenu
extends AbstractMenu {
    private final IComposerField m_field;
    private final ITreeNode m_parentNode;

    public AbstractAddAttributeMenu(IComposerField field, ITreeNode parentNode) {
        super(false);
        this.m_field = field;
        this.m_parentNode = parentNode;
        this.callInitializer();
    }

    @Override
    protected String getConfiguredText() {
        return TEXTS.get((String)"ExtendedSearchAddAttributeMenu");
    }

    @Override
    protected void execOwnerValueChanged(Object newOwnerValue) {
        EntityNode entityNode = null;
        ITreeNode treeNode = this.m_parentNode;
        while (treeNode != null) {
            if (treeNode instanceof EntityNode) {
                entityNode = (EntityNode)treeNode;
                break;
            }
            treeNode = treeNode.getParentNode();
        }
        List<IDataModelAttribute> attributes = entityNode != null ? entityNode.getEntity().getAttributes() : this.m_field.getAttributes();
        this.setVisible(!attributes.isEmpty());
    }

    @Override
    protected void execAction() {
        ComposerAttributeForm form = new ComposerAttributeForm();
        EntityNode eNode = null;
        ITreeNode n = this.m_parentNode;
        while (n != null) {
            if (n instanceof EntityNode) {
                eNode = (EntityNode)n;
                break;
            }
            n = n.getParentNode();
        }
        if (eNode != null) {
            form.setAvailableAttributes(eNode.getEntity().getAttributes());
        } else {
            form.setAvailableAttributes(this.m_field.getAttributes());
        }
        form.startNew();
        form.waitFor();
        if (form.isFormStored()) {
            IDataModelAttribute a = form.getSelectedAttribute();
            IDataModelAttributeOp op = form.getSelectedOp();
            List<Object> values = form.getSelectedValues();
            List<String> displayValues = form.getSelectedDisplayValues();
            this.m_field.addAttributeNode(this.m_parentNode, a, null, op, values, displayValues);
        }
    }
}

