/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.decimalfield;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.eclipse.scout.rt.client.extension.ui.form.fields.decimalfield.IDecimalFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.decimalfield.IDecimalField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.AbstractNumberField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.NumberFormatProvider;

@ClassId(value="f4ec575e-f572-418d-a49c-3d0811ea7540")
public abstract class AbstractDecimalField<T extends Number>
extends AbstractNumberField<T>
implements IDecimalField<T> {
    public AbstractDecimalField() {
        this(true);
    }

    public AbstractDecimalField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=290.0)
    protected int getConfiguredFractionDigits() {
        return 2;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=240.0)
    protected int getConfiguredMinFractionDigits() {
        return 2;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=250.0)
    protected int getConfiguredMaxFractionDigits() {
        return 2;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    protected boolean getConfiguredPercent() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=280.0)
    protected int getConfiguredMultiplier() {
        return 1;
    }

    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 1;
    }

    @Override
    protected RoundingMode getConfiguredRoundingMode() {
        return RoundingMode.HALF_UP;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMinFractionDigits(this.getConfiguredMinFractionDigits());
        this.setMaxFractionDigits(this.getConfiguredMaxFractionDigits());
        this.setGroupingUsed(this.getConfiguredGroupingUsed());
        this.setPercent(this.getConfiguredPercent());
        this.setFractionDigits(this.getConfiguredFractionDigits());
        this.setMultiplier(this.getConfiguredMultiplier());
    }

    @Override
    public void setMinFractionDigits(int i) {
        try {
            this.setFieldChanging(true);
            DecimalFormat format = this.getFormat();
            format.setMinimumFractionDigits(i);
            this.setFormat(format);
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public int getMinFractionDigits() {
        return this.getFormatInternal().getMinimumFractionDigits();
    }

    @Override
    public void setMaxFractionDigits(int i) {
        try {
            this.setFieldChanging(true);
            DecimalFormat format = this.getFormat();
            format.setMaximumFractionDigits(i);
            this.setFormat(format);
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public int getMaxFractionDigits() {
        return this.getFormatInternal().getMaximumFractionDigits();
    }

    @Override
    public void setPercent(boolean b) {
        try {
            DecimalFormat percentDF = ((NumberFormatProvider)BEANS.get(NumberFormatProvider.class)).getPercentInstance(NlsLocale.get());
            DecimalFormat format = this.getFormat();
            if (b) {
                format.setPositiveSuffix(percentDF.getPositiveSuffix());
                format.setNegativeSuffix(percentDF.getNegativeSuffix());
            } else if (this.isPercent()) {
                format.setPositiveSuffix("");
                format.setNegativeSuffix("");
            }
            this.setFormat(format);
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public boolean isPercent() {
        DecimalFormat percentDF = ((NumberFormatProvider)BEANS.get(NumberFormatProvider.class)).getPercentInstance(NlsLocale.get());
        DecimalFormat internalDF = this.getFormatInternal();
        return internalDF.getPositiveSuffix().equals(percentDF.getPositiveSuffix()) && internalDF.getNegativeSuffix().equals(percentDF.getNegativeSuffix());
    }

    @Override
    public void setFractionDigits(int i) {
        try {
            this.propertySupport.setPropertyInt("parsingFractionDigits", i);
            if (this.isInitConfigDone()) {
                this.setValue((Number)this.getValue());
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public int getFractionDigits() {
        return this.propertySupport.getPropertyInt("parsingFractionDigits");
    }

    @Override
    public void setMultiplier(int i) {
        try {
            DecimalFormat format = this.getFormat();
            format.setMultiplier(i);
            this.setFormat(format);
            if (this.isInitConfigDone()) {
                this.setValue((Number)this.getValue());
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public int getMultiplier() {
        return this.getFormatInternal().getMultiplier();
    }

    @Override
    protected BigDecimal roundParsedValue(BigDecimal valBeforeRounding) {
        int additionalFractionDigits = ("" + Math.abs(this.getMultiplier())).length() - 1;
        int precision = valBeforeRounding.toBigInteger().toString().length() + this.getFractionDigits() + additionalFractionDigits;
        return valBeforeRounding.round(new MathContext(precision, this.getRoundingMode()));
    }

    @Override
    protected IDecimalFieldExtension<T, ? extends AbstractDecimalField<T>> createLocalExtension() {
        return new LocalDecimalFieldExtension(this);
    }

    protected static class LocalDecimalFieldExtension<T extends Number, OWNER extends AbstractDecimalField<T>>
    extends AbstractNumberField.LocalNumberFieldExtension<T, OWNER>
    implements IDecimalFieldExtension<T, OWNER> {
        public LocalDecimalFieldExtension(OWNER owner) {
            super(owner);
        }
    }
}

