/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.groupbox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.extension.ui.form.fields.groupbox.IGroupBoxExtension;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.IFormFieldContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.FormFieldContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractCompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.LogicalGridLayoutConfig;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBoxBodyGrid;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBoxUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.GroupBoxProcessButtonGrid;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.VerticalSmartGroupBoxBodyGrid;
import org.eclipse.scout.rt.client.ui.notification.INotification;
import org.eclipse.scout.rt.client.ui.notification.NotificationEvent;
import org.eclipse.scout.rt.client.ui.notification.NotificationListener;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.TriState;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;

@ClassId(value="6a093505-c2b1-4df2-84d6-e799f91e6e7c")
public abstract class AbstractGroupBox
extends AbstractCompositeField
implements IGroupBox {
    private IGroupBoxUIFacade m_uiFacade;
    private boolean m_mainBoxFlag = false;
    private List<IFormField> m_controlFields;
    private List<IGroupBox> m_groupBoxes;
    private List<IButton> m_customButtons;
    private List<IButton> m_systemButtons;
    private IGroupBoxBodyGrid m_bodyGrid;
    private GroupBoxProcessButtonGrid m_customProcessButtonGrid;
    private GroupBoxProcessButtonGrid m_systemProcessButtonGrid;

    public AbstractGroupBox() {
        this(true);
    }

    public AbstractGroupBox(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected boolean getConfiguredGridUseUiHeight() {
        return true;
    }

    protected String getConfiguredSubLabel() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=200.0)
    protected int getConfiguredGridColumnCount() {
        return -1;
    }

    @ConfigProperty(value="GROUP_BOX_BODY_GRID")
    @Order(value=210.0)
    protected Class<? extends IGroupBoxBodyGrid> getConfiguredBodyGrid() {
        return VerticalSmartGroupBoxBodyGrid.class;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=215.0)
    protected LogicalGridLayoutConfig getConfiguredBodyLayoutConfig() {
        return new LogicalGridLayoutConfig();
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=230.0)
    protected boolean getConfiguredBorderVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=231.0)
    protected boolean getConfiguredExpandable() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=232.0)
    protected boolean getConfiguredExpanded() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=232.0)
    protected boolean getConfiguredCacheExpanded() {
        return false;
    }

    @ConfigProperty(value="BORDER_DECORATION")
    @Order(value=233.0)
    protected String getConfiguredBorderDecoration() {
        return "auto";
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=240.0)
    protected String getConfiguredBackgroundImageName() {
        return null;
    }

    @ConfigProperty(value="HORIZONTAL_ALIGNMENT")
    @Order(value=250.0)
    protected int getConfiguredBackgroundImageHorizontalAlignment() {
        return 0;
    }

    @ConfigProperty(value="VERTICAL_ALIGNMENT")
    @Order(value=260.0)
    protected int getConfiguredBackgroundImageVerticalAlignment() {
        return 0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    protected TriState getConfiguredScrollable() {
        return TriState.UNDEFINED;
    }

    @ConfigProperty(value="STRING")
    @Order(value=280.0)
    protected String getConfiguredSelectionKeyStroke() {
        return null;
    }

    @Override
    protected int getConfiguredGridW() {
        return 0;
    }

    @ConfigProperty(value="GROUP_BOX_MENU_BAR_POSITION")
    @Order(value=300.0)
    protected String getConfiguredMenuBarPosition() {
        return "auto";
    }

    @ConfigProperty(value="GROUP_BOX_MENU_BAR_ELLIPSIS_POSITION")
    @Order(value=310.0)
    protected String getConfiguredMenuBarEllipsisPosition() {
        return "right";
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=320.0)
    protected TriState getConfiguredResponsive() {
        return TriState.UNDEFINED;
    }

    @Override
    public String getPreferenceBaseKey() {
        return this.getClass().getName();
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        Class<? extends IGroupBoxBodyGrid> bodyGridClazz = this.getConfiguredBodyGrid();
        if (bodyGridClazz != null) {
            try {
                IGroupBoxBodyGrid bodyGrid = bodyGridClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.setBodyGrid(bodyGrid);
            }
            catch (Exception e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating instance of class '" + bodyGridClazz.getName() + "'.", new Object[]{e}));
            }
        }
        this.m_customProcessButtonGrid = new GroupBoxProcessButtonGrid(this, true, false);
        this.m_systemProcessButtonGrid = new GroupBoxProcessButtonGrid(this, false, true);
        super.initConfig();
        this.categorizeFields();
        this.setSubLabel(this.getConfiguredSubLabel());
        this.setExpandable(this.getConfiguredExpandable());
        this.setExpanded(this.getConfiguredExpanded());
        this.setCacheExpanded(this.getConfiguredCacheExpanded());
        this.setBorderVisible(this.getConfiguredBorderVisible());
        this.setBorderDecoration(this.getConfiguredBorderDecoration());
        this.setGridColumnCount(this.getConfiguredGridColumnCount());
        this.setBackgroundImageName(this.getConfiguredBackgroundImageName());
        this.setBackgroundImageHorizontalAlignment(this.getConfiguredBackgroundImageHorizontalAlignment());
        this.setBackgroundImageVerticalAlignment(this.getConfiguredBackgroundImageVerticalAlignment());
        this.setScrollable(this.getConfiguredScrollable());
        this.setSelectionKeyStroke(this.getConfiguredSelectionKeyStroke());
        this.setBodyLayoutConfig(this.getConfiguredBodyLayoutConfig());
        this.setMenuBarPosition(this.getConfiguredMenuBarPosition());
        this.setMenuBarEllipsisPosition(this.getConfiguredMenuBarEllipsisPosition());
        this.setResponsive(this.getConfiguredResponsive());
        this.initMenus();
        if (this.isCacheExpanded()) {
            Optional.ofNullable(ClientUIPreferences.getInstance().isFieldCollapsed(this)).ifPresent(b -> this.setExpanded(b == false));
        }
    }

    private void initMenus() {
        List<Class<? extends IMenu>> declaredMenus = this.getDeclaredMenus();
        List contributedMenus = this.m_contributionHolder.getContributionsByClass(IMenu.class);
        OrderedCollection menus = new OrderedCollection();
        for (Class<? extends IMenu> menuClazz : declaredMenus) {
            menus.addOrdered((IOrdered)((IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuClazz)));
        }
        menus.addAllOrdered((Collection)contributedMenus);
        this.injectMenusInternal((OrderedCollection<IMenu>)menus);
        new MoveActionNodesHandler(menus).moveModelObjects();
        this.setContextMenu(new FormFieldContextMenu<AbstractGroupBox>(this, menus.getOrderedList()));
    }

    @Override
    protected void disposeFieldInternal() {
        super.disposeFieldInternal();
        if (this.isCacheExpanded()) {
            ClientUIPreferences.getInstance().setFieldCollapsed(this, !this.isExpanded());
        }
    }

    private void categorizeFields() {
        ArrayList<IFormField> controlList = new ArrayList<IFormField>();
        ArrayList<IGroupBox> groupList = new ArrayList<IGroupBox>();
        ArrayList<IButton> customButtonList = new ArrayList<IButton>();
        ArrayList<IButton> systemButtonList = new ArrayList<IButton>();
        for (IFormField field : this.getFields()) {
            if (field instanceof IGroupBox) {
                groupList.add((IGroupBox)field);
                controlList.add(field);
                continue;
            }
            if (field instanceof IButton) {
                IButton b = (IButton)field;
                if (b.isProcessButton()) {
                    if (b.getSystemType() != 0) {
                        systemButtonList.add((IButton)field);
                        continue;
                    }
                    customButtonList.add((IButton)field);
                    continue;
                }
                controlList.add(field);
                continue;
            }
            controlList.add(field);
        }
        this.m_controlFields = controlList;
        this.m_groupBoxes = groupList;
        this.m_customButtons = customButtonList;
        this.m_systemButtons = systemButtonList;
    }

    private void ensureCategorized() {
        if (this.m_controlFields == null || this.m_groupBoxes == null || this.m_customButtons == null || this.m_systemButtons == null) {
            this.categorizeFields();
        }
    }

    private void clearCategorization() {
        this.m_controlFields = null;
        this.m_groupBoxes = null;
        this.m_customButtons = null;
        this.m_systemButtons = null;
    }

    protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), this.getMenus()});
    }

    protected void setContextMenu(IFormFieldContextMenu contextMenu) {
        this.propertySupport.setProperty("contextMenu", (Object)contextMenu);
    }

    @Override
    public IFormFieldContextMenu getContextMenu() {
        return (IFormFieldContextMenu)this.propertySupport.getProperty("contextMenu");
    }

    @Override
    public List<IMenu> getMenus() {
        return this.getContextMenu().getChildActions();
    }

    @Override
    public <T extends IMenu> T getMenuByClass(Class<T> menuType) {
        return MenuUtility.getMenuByClass(this, menuType);
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    @Override
    public void rebuildFieldGrid() {
        this.m_bodyGrid.validate(this);
        this.m_customProcessButtonGrid.validate();
        this.m_systemProcessButtonGrid.validate();
        if (this.isInitConfigDone() && this.getForm() != null) {
            this.getForm().structureChanged(this);
        }
    }

    @Override
    public String getSubLabel() {
        return this.propertySupport.getPropertyString("subLabel");
    }

    @Override
    public void setSubLabel(String subLabel) {
        this.propertySupport.setPropertyString("subLabel", subLabel);
    }

    @Override
    public boolean isMainBox() {
        return this.m_mainBoxFlag;
    }

    @Override
    public void setMainBox(boolean b) {
        this.m_mainBoxFlag = b;
    }

    @Override
    public int getGroupBoxIndex(IGroupBox groupBox) {
        return this.m_groupBoxes.indexOf(groupBox);
    }

    @Override
    public int getCustomProcessButtonCount() {
        return this.m_customButtons.size();
    }

    @Override
    public int getGroupBoxCount() {
        return this.m_groupBoxes.size();
    }

    @Override
    public int getSystemProcessButtonCount() {
        return this.m_systemButtons.size();
    }

    @Override
    public List<IGroupBox> getGroupBoxes() {
        this.ensureCategorized();
        return CollectionUtility.arrayList(this.m_groupBoxes);
    }

    @Override
    public List<IFormField> getControlFields() {
        this.ensureCategorized();
        return CollectionUtility.arrayList(this.m_controlFields);
    }

    @Override
    public List<IButton> getCustomProcessButtons() {
        this.ensureCategorized();
        return CollectionUtility.arrayList(this.m_customButtons);
    }

    @Override
    public List<IButton> getSystemProcessButtons() {
        this.ensureCategorized();
        return CollectionUtility.arrayList(this.m_systemButtons);
    }

    public void setBodyGrid(IGroupBoxBodyGrid bodyGrid) {
        this.m_bodyGrid = bodyGrid;
    }

    @Override
    public void addField(IFormField f) {
        super.addField(f);
        this.clearCategorization();
    }

    @Override
    public void removeField(IFormField f) {
        super.removeField(f);
        this.clearCategorization();
    }

    public IGroupBoxBodyGrid getFieldGrid() {
        return this.m_bodyGrid;
    }

    @Override
    public void setGridColumnCount(int c) {
        this.propertySupport.setPropertyInt("gridColumnCount", c);
        if (this.isInitConfigDone()) {
            this.rebuildFieldGrid();
        }
    }

    @Override
    public int getGridColumnCount() {
        return this.propertySupport.getPropertyInt("gridColumnCount");
    }

    @Override
    public LogicalGridLayoutConfig getBodyLayoutConfig() {
        return (LogicalGridLayoutConfig)this.propertySupport.getProperty("bodyLayoutConfig");
    }

    @Override
    public void setBodyLayoutConfig(LogicalGridLayoutConfig layoutConfig) {
        this.propertySupport.setProperty("bodyLayoutConfig", (Object)layoutConfig);
    }

    @Override
    public TriState isScrollable() {
        return (TriState)this.propertySupport.getProperty("scrollable");
    }

    @Override
    public void setScrollable(TriState scrollable) {
        if (scrollable == null) {
            scrollable = TriState.UNDEFINED;
        }
        if (scrollable.equals((Object)this.isScrollable())) {
            return;
        }
        this.propertySupport.setProperty("scrollable", (Object)scrollable);
        if (scrollable.isTrue()) {
            GridData gd = this.getGridDataHints();
            if (gd.weightY <= 0.0) {
                gd.weightY = 1.0;
                this.setGridDataHints(gd);
            }
        }
    }

    @Override
    public void setScrollable(boolean scrollable) {
        this.setScrollable(TriState.parse((Object)scrollable));
    }

    @Override
    protected void handleChildFieldVisibilityChanged() {
        super.handleChildFieldVisibilityChanged();
        if (this.isInitConfigDone()) {
            this.rebuildFieldGrid();
        }
    }

    @Override
    public boolean isBorderVisible() {
        return this.propertySupport.getPropertyBool("borderVisible");
    }

    @Override
    public void setBorderVisible(boolean b) {
        this.propertySupport.setPropertyBool("borderVisible", b);
    }

    @Override
    public String getBorderDecoration() {
        return this.propertySupport.getPropertyString("borderDecoration");
    }

    @Override
    public void setBorderDecoration(String s) {
        this.propertySupport.setPropertyString("borderDecoration", s);
    }

    @Override
    public boolean isExpandable() {
        return this.propertySupport.getPropertyBool("expandable");
    }

    @Override
    public void setExpandable(boolean b) {
        this.propertySupport.setPropertyBool("expandable", b);
    }

    @Override
    public boolean isExpanded() {
        return this.propertySupport.getPropertyBool("expanded");
    }

    @Override
    public void setExpanded(boolean b) {
        this.propertySupport.setPropertyBool("expanded", b);
    }

    @Override
    public boolean isCacheExpanded() {
        return this.propertySupport.getPropertyBool("cacheExpanded");
    }

    @Override
    public void setCacheExpanded(boolean b) {
        this.propertySupport.setPropertyBool("cacheExpanded", b);
    }

    @Override
    public String getSelectionKeyStroke() {
        return this.propertySupport.getPropertyString("selectionKeystroke");
    }

    @Override
    public void setSelectionKeyStroke(String keystroke) {
        this.propertySupport.setPropertyString("selectionKeystroke", keystroke);
    }

    @Override
    public IGroupBoxUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void setBackgroundImageName(String imageName) {
        this.propertySupport.setPropertyString("backgroundImageName", imageName);
    }

    @Override
    public String getBackgroundImageName() {
        return this.propertySupport.getPropertyString("backgroundImageName");
    }

    @Override
    public INotification getNotification() {
        return (INotification)this.propertySupport.getProperty("notification");
    }

    @Override
    public void setNotification(INotification notification) {
        if (notification != null) {
            notification.setParentInternal(this);
            notification.addNotificationListener(new NotificationListener(){

                @Override
                public void notificationChanged(NotificationEvent event) {
                    if (900 == event.getType()) {
                        if (event.getNotification() != null) {
                            event.getNotification().removeNotificationListener(this);
                        }
                        AbstractGroupBox.this.removeNotification();
                    }
                }
            });
        }
        this.propertySupport.setProperty("notification", (Object)notification);
    }

    @Override
    public void removeNotification() {
        this.propertySupport.setProperty("notification", null);
    }

    @Override
    public void setBackgroundImageVerticalAlignment(int a) {
        this.propertySupport.setPropertyInt("backgroundImageVerticalAlignment", a);
    }

    @Override
    public int getBackgroundImageVerticalAlignment() {
        return this.propertySupport.getPropertyInt("backgroundImageVerticalAlignment");
    }

    @Override
    public void setBackgroundImageHorizontalAlignment(int a) {
        this.propertySupport.setPropertyInt("backgroundImageHorizontalAlignment", a);
    }

    @Override
    public int getBackgroundImageHorizontalAlignment() {
        return this.propertySupport.getPropertyInt("backgroundImageHorizontalAlignment");
    }

    @Override
    public String getMenuBarPosition() {
        return this.propertySupport.getPropertyString("menuBarPosition");
    }

    @Override
    public void setMenuBarPosition(String menuBarPosition) {
        this.propertySupport.setPropertyString("menuBarPosition", menuBarPosition);
    }

    @Override
    public String getMenuBarEllipsisPosition() {
        return this.propertySupport.getPropertyString("menuBarEllipsisPosition");
    }

    @Override
    public void setMenuBarEllipsisPosition(String menuBarEllipsisPosition) {
        this.propertySupport.setPropertyString("menuBarEllipsisPosition", menuBarEllipsisPosition);
    }

    @Override
    public TriState isResponsive() {
        return (TriState)this.propertySupport.getProperty("responsive");
    }

    @Override
    public void setResponsive(TriState responsive) {
        if (responsive == null) {
            responsive = TriState.UNDEFINED;
        }
        this.propertySupport.setProperty("responsive", (Object)responsive);
    }

    @Override
    public void setResponsive(boolean responsive) {
        this.setResponsive(TriState.parse((Object)responsive));
    }

    @Override
    protected IGroupBoxExtension<? extends AbstractGroupBox> createLocalExtension() {
        return new LocalGroupBoxExtension<AbstractGroupBox>(this);
    }

    protected static class LocalGroupBoxExtension<OWNER extends AbstractGroupBox>
    extends AbstractCompositeField.LocalCompositeFieldExtension<OWNER>
    implements IGroupBoxExtension<OWNER> {
        public LocalGroupBoxExtension(OWNER owner) {
            super(owner);
        }
    }

    protected class P_UIFacade
    implements IGroupBoxUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void setExpandedFromUI(boolean expanded) {
            AbstractGroupBox.this.setExpanded(expanded);
        }
    }
}

