/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.listbox;

import java.beans.PropertyChangeListener;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractRadioButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.IListBox;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.AbstractRadioButtonGroup;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.TriState;
import org.eclipse.scout.rt.platform.util.concurrent.OptimisticLock;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;

@ClassId(value="ebca1411-044f-425f-b63c-4920cde6bb1b")
public abstract class AbstractListBoxFilterBox
extends AbstractGroupBox {
    private final OptimisticLock m_listBoxSyncLock = new OptimisticLock();
    private PropertyChangeListener m_listBoxPropertyListener;

    public AbstractListBoxFilterBox() {
        this(true);
    }

    public AbstractListBoxFilterBox(boolean callInitializer) {
        super(callInitializer);
    }

    protected abstract IListBox getListBox();

    @Override
    protected boolean getConfiguredBorderVisible() {
        return false;
    }

    @Override
    protected int getConfiguredGridColumnCount() {
        return 1;
    }

    @Override
    protected void execInitField() {
        if (this.m_listBoxPropertyListener == null) {
            this.m_listBoxPropertyListener = e -> {
                String name = e.getPropertyName();
                if ("filterCheckedRows".equals(name)) {
                    this.updateVisibilities();
                    return;
                }
                if ("filterActiveRows".equals(name)) {
                    this.updateVisibilities();
                    return;
                }
                if ("filterCheckedRowsValue".equals(name)) {
                    try {
                        if (!this.m_listBoxSyncLock.acquire()) return;
                        this.getCheckedStateRadioButtonGroup().setValue(this.getListBox().getFilterCheckedRowsValue());
                        return;
                    }
                    finally {
                        this.m_listBoxSyncLock.release();
                    }
                }
                if (!"filterActiveRowsValue".equals(name)) return;
                try {
                    if (!this.m_listBoxSyncLock.acquire()) return;
                    this.getActiveStateRadioButtonGroup().setValue(this.getListBox().getFilterActiveRowsValue());
                    return;
                }
                finally {
                    this.m_listBoxSyncLock.release();
                }
            };
            this.getListBox().addPropertyChangeListener(this.m_listBoxPropertyListener);
        }
        try {
            this.m_listBoxSyncLock.acquire();
            this.updateVisibilities();
            this.getCheckedStateRadioButtonGroup().setValue(this.getListBox().getFilterCheckedRowsValue());
            this.getActiveStateRadioButtonGroup().setValue(this.getListBox().getFilterActiveRowsValue());
        }
        finally {
            this.m_listBoxSyncLock.release();
        }
    }

    protected void updateVisibilities() {
        this.setVisible(this.getListBox().isFilterCheckedRows() || this.getListBox().isFilterActiveRows());
        this.getCheckedStateRadioButtonGroup().setVisible(this.getListBox().isFilterCheckedRows());
        this.getActiveStateRadioButtonGroup().setVisible(this.getListBox().isFilterActiveRows());
    }

    @Override
    protected void execDisposeField() {
        if (this.m_listBoxPropertyListener != null) {
            this.getListBox().removePropertyChangeListener(this.m_listBoxPropertyListener);
            this.m_listBoxPropertyListener = null;
        }
    }

    public ActiveStateRadioButtonGroup getActiveStateRadioButtonGroup() {
        return this.getFieldByClass(ActiveStateRadioButtonGroup.class);
    }

    public CheckedStateRadioButtonGroup getCheckedStateRadioButtonGroup() {
        return this.getFieldByClass(CheckedStateRadioButtonGroup.class);
    }

    @Order(value=20.0)
    @ClassId(value="2c4e4cf0-7bcf-46f1-a00f-19ecd2719fff")
    public class ActiveStateRadioButtonGroup
    extends AbstractRadioButtonGroup<TriState> {
        @Override
        protected boolean getConfiguredLabelVisible() {
            return false;
        }

        @Override
        protected boolean execIsEmpty() {
            return true;
        }

        @Override
        protected boolean execIsSaveNeeded() {
            return false;
        }

        @Override
        protected void execAddSearchTerms(SearchFilter search) {
        }

        @Override
        protected void execChangedValue() {
            try {
                if (AbstractListBoxFilterBox.this.m_listBoxSyncLock.acquire()) {
                    AbstractListBoxFilterBox.this.getListBox().setFilterActiveRowsValue((TriState)AbstractListBoxFilterBox.this.getActiveStateRadioButtonGroup().getValue());
                }
            }
            finally {
                AbstractListBoxFilterBox.this.m_listBoxSyncLock.release();
            }
        }

        @Order(value=30.0)
        @ClassId(value="526bc98f-9b10-4285-bf3a-3feb6d560e22")
        public class ActiveAndInactiveButton
        extends AbstractRadioButton<TriState> {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected String getConfiguredLabel() {
                return TEXTS.get((String)"ActiveAndInactiveStates");
            }

            @Override
            protected TriState getConfiguredRadioValue() {
                return TriState.UNDEFINED;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }

        @Order(value=10.0)
        @ClassId(value="ad7425e4-9fa6-4dd6-944b-1f138586eff2")
        public class ActiveButton
        extends AbstractRadioButton<TriState> {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected String getConfiguredLabel() {
                return TEXTS.get((String)"ActiveStates");
            }

            @Override
            protected TriState getConfiguredRadioValue() {
                return TriState.TRUE;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }

        @Order(value=20.0)
        @ClassId(value="dd6c5a35-ea0e-459d-919f-9155d46a63eb")
        public class InactiveButton
        extends AbstractRadioButton<TriState> {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected String getConfiguredLabel() {
                return TEXTS.get((String)"InactiveStates");
            }

            @Override
            protected TriState getConfiguredRadioValue() {
                return TriState.FALSE;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }
    }

    @Order(value=10.0)
    @ClassId(value="e62c300f-f49d-4318-95ce-44a60558cfbf")
    public class CheckedStateRadioButtonGroup
    extends AbstractRadioButtonGroup<Boolean> {
        @Override
        protected boolean getConfiguredLabelVisible() {
            return false;
        }

        @Override
        protected boolean execIsEmpty() {
            return true;
        }

        @Override
        protected boolean execIsSaveNeeded() {
            return false;
        }

        @Override
        protected void execAddSearchTerms(SearchFilter search) {
        }

        @Override
        protected void execChangedValue() {
            try {
                if (AbstractListBoxFilterBox.this.m_listBoxSyncLock.acquire()) {
                    Boolean b = (Boolean)AbstractListBoxFilterBox.this.getCheckedStateRadioButtonGroup().getValue();
                    AbstractListBoxFilterBox.this.getListBox().setFilterCheckedRowsValue(b != null && b != false);
                }
            }
            finally {
                AbstractListBoxFilterBox.this.m_listBoxSyncLock.release();
            }
        }

        @Order(value=20.0)
        @ClassId(value="b37f25c6-ab52-4ff2-a167-7980d0f4f71b")
        public class AllButton
        extends AbstractRadioButton<Boolean> {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected String getConfiguredLabel() {
                return TEXTS.get((String)"AllStates");
            }

            @Override
            protected Boolean getConfiguredRadioValue() {
                return false;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }

        @Order(value=10.0)
        @ClassId(value="3e47a9b5-aa90-4e2d-8901-23047d689a59")
        public class CheckedButton
        extends AbstractRadioButton<Boolean> {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected String getConfiguredLabel() {
                return TEXTS.get((String)"SelectedStates");
            }

            @Override
            protected Boolean getConfiguredRadioValue() {
                return true;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }
    }
}

