/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.numberfield;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.form.fields.numberfield.INumberFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractBasicField;
import org.eclipse.scout.rt.client.ui.form.fields.IBasicFieldUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.INumberField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.NumberFormatProvider;
import org.eclipse.scout.rt.platform.util.NumberUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;

@ClassId(value="05955664-a6c7-4b3a-8622-3e166fe8ff79")
public abstract class AbstractNumberField<NUMBER extends Number>
extends AbstractBasicField<NUMBER>
implements INumberField<NUMBER> {
    private IBasicFieldUIFacade m_uiFacade;

    public AbstractNumberField() {
        this(true);
    }

    public AbstractNumberField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=240.0)
    protected boolean getConfiguredGroupingUsed() {
        return true;
    }

    @ConfigProperty(value="ROUNDING_MODE")
    @Order(value=250.0)
    protected RoundingMode getConfiguredRoundingMode() {
        return RoundingMode.UNNECESSARY;
    }

    protected abstract NUMBER getConfiguredMinValue();

    protected abstract NUMBER getConfiguredMaxValue();

    @ConfigProperty(value="INTEGER")
    @Order(value=280.0)
    protected int getConfiguredMaxIntegerDigits() {
        return 309;
    }

    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 1;
    }

    protected Set<Character> getConfiguredLenientDecimalSeparators() {
        return CollectionUtility.hashSet((Object[])new Character[]{Character.valueOf(','), Character.valueOf('.')});
    }

    protected Set<Character> getConfiguredLenientGroupingSeparators() {
        return CollectionUtility.hashSet((Object[])new Character[]{Character.valueOf('\''), Character.valueOf('\u00b4'), Character.valueOf('`'), Character.valueOf('\u2019'), Character.valueOf(','), Character.valueOf('.'), Character.valueOf("\u00b7".charAt(0)), Character.valueOf(" ".charAt(0)), Character.valueOf("\u00a0".charAt(0)), Character.valueOf("\u2009".charAt(0)), Character.valueOf("\u202f".charAt(0))});
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new AbstractBasicField.P_UIFacade(this), ModelContextProxy.ModelContext.copyCurrent());
        super.initConfig();
        this.initFormat();
        this.setRoundingMode(this.getConfiguredRoundingMode());
        this.setGroupingUsed(this.getConfiguredGroupingUsed());
        this.setMinValue(this.getConfiguredMinValue());
        this.setMaxValue(this.getConfiguredMaxValue());
        this.setLenientDecimalSeparators(this.getConfiguredLenientDecimalSeparators());
        this.setLenientGroupingSeparators(this.getConfiguredLenientGroupingSeparators());
    }

    protected void initFormat() {
        DecimalFormat format = ((NumberFormatProvider)BEANS.get(NumberFormatProvider.class)).getNumberInstance(NlsLocale.get());
        format.setParseBigDecimal(true);
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(0);
        format.setMaximumIntegerDigits(this.getConfiguredMaxIntegerDigits());
        this.propertySupport.setProperty("decimalFormat", (Object)format);
    }

    @Override
    public void setRoundingMode(RoundingMode roundingMode) {
        try {
            DecimalFormat format = this.getFormat();
            format.setRoundingMode(roundingMode);
            this.setFormat(format);
            this.refreshDisplayText();
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public RoundingMode getRoundingMode() {
        return this.getFormatInternal().getRoundingMode();
    }

    @Override
    public void setFormat(DecimalFormat format) {
        Assertions.assertNotNull((Object)format);
        try {
            DecimalFormat newFormat = (DecimalFormat)format.clone();
            newFormat.setParseBigDecimal(true);
            this.propertySupport.setProperty("decimalFormat", (Object)newFormat);
            this.refreshDisplayText();
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public DecimalFormat getFormat() {
        return (DecimalFormat)this.getFormatInternal().clone();
    }

    protected DecimalFormat getFormatInternal() {
        return (DecimalFormat)this.propertySupport.getProperty("decimalFormat");
    }

    @Override
    public void setGroupingUsed(boolean b) {
        try {
            DecimalFormat format = this.getFormat();
            format.setGroupingUsed(b);
            this.setFormat(format);
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public boolean isGroupingUsed() {
        return this.getFormatInternal().isGroupingUsed();
    }

    @Override
    public void setMaxIntegerDigits(int maxIntegerDigits) {
        try {
            DecimalFormat format = this.getFormat();
            format.setMaximumIntegerDigits(maxIntegerDigits);
            this.setFormat(format);
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public int getMaxIntegerDigits() {
        return this.getFormatInternal().getMaximumIntegerDigits();
    }

    @Override
    public void setMinValue(NUMBER value) {
        NUMBER n = value == null ? this.getMinPossibleValue() : value;
        try {
            this.setFieldChanging(true);
            NUMBER max = this.getMaxValue();
            if (n != null && max != null && this.compareInternal(n, max) > 0) {
                this.propertySupport.setProperty("maxValue", n);
            }
            this.propertySupport.setProperty("minValue", n);
            if (this.isInitConfigDone()) {
                this.setValue((Number)this.getValue());
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public NUMBER getMinValue() {
        return (NUMBER)((Number)this.propertySupport.getProperty("minValue"));
    }

    @Override
    public void setMaxValue(NUMBER value) {
        NUMBER n = value == null ? this.getMaxPossibleValue() : value;
        try {
            this.setFieldChanging(true);
            NUMBER min = this.getMinValue();
            if (n != null && min != null && this.compareInternal(n, min) < 0) {
                this.propertySupport.setProperty("minValue", n);
            }
            this.propertySupport.setProperty("maxValue", n);
            if (this.isInitConfigDone()) {
                this.setValue((Number)this.getValue());
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public NUMBER getMaxValue() {
        return (NUMBER)((Number)this.propertySupport.getProperty("maxValue"));
    }

    @Override
    public void setLenientDecimalSeparators(Set<Character> lenientDecimalSeparators) {
        this.propertySupport.setProperty("lenientDecimalSeparators", lenientDecimalSeparators);
    }

    @Override
    public Set<Character> getLenientDecimalSeparators() {
        return (Set)this.propertySupport.getProperty("lenientDecimalSeparators");
    }

    @Override
    public void setLenientGroupingSeparators(Set<Character> lenientGroupingSeparators) {
        this.propertySupport.setProperty("lenientGroupingSeparators", lenientGroupingSeparators);
    }

    @Override
    public Set<Character> getLenientGroupingSeparators() {
        return (Set)this.propertySupport.getProperty("lenientGroupingSeparators");
    }

    private int compareInternal(NUMBER a, NUMBER b) {
        return ObjectUtility.compareTo((Comparable)NumberUtility.numberToBigDecimal(a), (Comparable)NumberUtility.numberToBigDecimal(b));
    }

    protected abstract NUMBER getMinPossibleValue();

    protected abstract NUMBER getMaxPossibleValue();

    @Override
    protected NUMBER validateValueInternal(NUMBER rawValue) {
        NUMBER validValue = null;
        if ((rawValue = (Number)super.validateValueInternal(rawValue)) == null) {
            validValue = null;
        } else {
            if (this.getMaxValue() != null && this.compareInternal(rawValue, this.getMaxValue()) > 0) {
                this.throwNumberTooLarge();
            }
            if (this.getMinValue() != null && this.compareInternal(rawValue, this.getMinValue()) < 0) {
                this.throwNumberTooSmall();
            }
            validValue = rawValue;
        }
        return validValue;
    }

    @Override
    protected String formatValueInternal(NUMBER validValue) {
        if (validValue == null) {
            return "";
        }
        String displayValue = this.getFormatInternal().format(validValue);
        return displayValue;
    }

    @Override
    public IBasicFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    protected abstract NUMBER parseValueInternal(String var1);

    protected BigDecimal parseToBigDecimalInternal(String text) {
        BigDecimal retVal = null;
        if (!(text = text == null ? "" : StringUtility.replace((String)text.trim(), (String)"\u066a", (String)"%")).isEmpty()) {
            text = this.ensureSuffix(text);
            ParsePosition p = new ParsePosition(0);
            BigDecimal valBeforeRounding = null;
            BigDecimal parsedVal = (BigDecimal)this.getFormatInternal().parse(text, p);
            if (p.getErrorIndex() == -1 && p.getIndex() == text.length()) {
                valBeforeRounding = parsedVal;
            }
            if (valBeforeRounding == null) {
                valBeforeRounding = this.parseLenient(text);
            }
            if (valBeforeRounding == null) {
                throw new ProcessingException(TEXTS.get((String)"InvalidNumberMessageX", (String[])new String[]{text}), new Object[0]);
            }
            try {
                retVal = this.roundParsedValue(valBeforeRounding);
            }
            catch (ArithmeticException arithmeticException) {
                throw new ProcessingException(TEXTS.get((String)"InvalidNumberMessageX", (String[])new String[]{text}), new Object[0]);
            }
            if (this.getMinPossibleValue() != null && retVal.compareTo(NumberUtility.numberToBigDecimal(this.getMinPossibleValue())) < 0) {
                this.throwNumberTooSmall();
            }
            if (this.getMaxPossibleValue() != null && retVal.compareTo(NumberUtility.numberToBigDecimal(this.getMaxPossibleValue())) > 0) {
                this.throwNumberTooLarge();
            }
        }
        return retVal;
    }

    protected BigDecimal parseLenient(String text) {
        DecimalFormat f = this.getFormat();
        DecimalFormatSymbols dfs = f.getDecimalFormatSymbols();
        Set<Character> decimalSeparators = this.getLenientDecimalSeparators();
        Set<Character> groupingSeparators = this.getLenientGroupingSeparators();
        for (char d : decimalSeparators) {
            int first = text.indexOf(d);
            int last = text.lastIndexOf(d);
            if (first <= -1 || first == last) continue;
            boolean isGrouping = true;
            int currPos = first + 1;
            while (currPos < text.length()) {
                int newPos = text.indexOf(d, currPos);
                if (newPos == -1) {
                    newPos = text.length();
                }
                if (newPos - currPos != 3) {
                    isGrouping = false;
                    break;
                }
                currPos = newPos + 1;
            }
            if (isGrouping) break;
            String simplifiedText = String.valueOf(text.substring(0, first)) + text.substring(first, last).replace(String.valueOf(d), "") + text.substring(last);
            ParsePosition p = new ParsePosition(0);
            dfs.setDecimalSeparator(d);
            f.setDecimalFormatSymbols(dfs);
            BigDecimal parsedVal = (BigDecimal)f.parse(simplifiedText, p);
            if (p.getErrorIndex() != -1 || p.getIndex() != simplifiedText.length()) continue;
            return parsedVal;
        }
        for (char d : decimalSeparators) {
            HashSet innerGroupingSeparators = CollectionUtility.hashSet(groupingSeparators);
            innerGroupingSeparators.remove(Character.valueOf(d));
            dfs.setDecimalSeparator(d);
            Iterator iterator = innerGroupingSeparators.iterator();
            while (iterator.hasNext()) {
                char g = ((Character)iterator.next()).charValue();
                dfs.setGroupingSeparator(g);
                ParsePosition p = new ParsePosition(0);
                f.setDecimalFormatSymbols(dfs);
                BigDecimal parsedVal = (BigDecimal)f.parse(text, p);
                if (p.getErrorIndex() != -1 || p.getIndex() != text.length()) continue;
                return parsedVal;
            }
        }
        return null;
    }

    private void throwNumberTooLarge() {
        if (this.getMinValue() == null || ObjectUtility.equals(this.getMinValue(), this.getMinPossibleValue())) {
            throw new VetoException(TEXTS.get((String)"NumberTooLargeMessageX", (String[])new String[]{this.formatValueInternal(this.getMaxValue())}), new Object[0]);
        }
        throw new VetoException(TEXTS.get((String)"NumberTooLargeMessageXY", (String[])new String[]{this.formatValueInternal(this.getMinValue()), this.formatValueInternal(this.getMaxValue())}), new Object[0]);
    }

    private void throwNumberTooSmall() {
        if (this.getMaxValue() == null || ObjectUtility.equals(this.getMaxValue(), this.getMaxPossibleValue())) {
            throw new VetoException(TEXTS.get((String)"NumberTooSmallMessageX", (String[])new String[]{this.formatValueInternal(this.getMinValue())}), new Object[0]);
        }
        throw new VetoException(TEXTS.get((String)"NumberTooSmallMessageXY", (String[])new String[]{this.formatValueInternal(this.getMinValue()), this.formatValueInternal(this.getMaxValue())}), new Object[0]);
    }

    protected BigDecimal roundParsedValue(BigDecimal valBeforeRounding) {
        int precision = valBeforeRounding.toBigInteger().toString().length();
        return valBeforeRounding.round(new MathContext(precision, this.getRoundingMode()));
    }

    private String ensureSuffix(String text) {
        String negativeSuffix;
        String positiveSuffix = this.getFormatInternal().getPositiveSuffix();
        if (positiveSuffix.equals(negativeSuffix = this.getFormatInternal().getNegativeSuffix())) {
            String trimmedSuffix = StringUtility.trim((String)positiveSuffix);
            if (text.endsWith(trimmedSuffix)) {
                text = StringUtility.trim((String)text.substring(0, text.length() - trimmedSuffix.length()));
            }
            text = StringUtility.concatenateTokens((String[])new String[]{text, positiveSuffix});
        }
        return text;
    }

    public static boolean isWithinNumberFormatLimits(DecimalFormat format, String curText, int offset, int replaceLen, String insertText) {
        if (insertText == null || insertText.length() < 1) {
            return true;
        }
        String futureText = null;
        if (curText == null) {
            futureText = insertText;
        } else {
            StringBuilder docTxt = new StringBuilder(curText.length() + insertText.length());
            docTxt.append(curText);
            docTxt.replace(offset, offset + replaceLen, insertText);
            futureText = docTxt.toString();
        }
        Pattern pat = Pattern.compile("[^1-9" + format.getDecimalFormatSymbols().getZeroDigit() + "]");
        String decimalSeparator = String.valueOf(format.getDecimalFormatSymbols().getDecimalSeparator());
        String[] parts = futureText.split(Pattern.quote(decimalSeparator));
        if (parts.length >= 1) {
            boolean intPartValid;
            String intPartDigits = pat.matcher(parts[0]).replaceAll("");
            boolean bl = intPartValid = StringUtility.length((CharSequence)intPartDigits) <= format.getMaximumIntegerDigits();
            if (!intPartValid) {
                return false;
            }
        }
        if (parts.length == 2) {
            boolean fracPartValid;
            String fracPartDigits = pat.matcher(parts[1]).replaceAll("");
            boolean bl = fracPartValid = StringUtility.length((CharSequence)fracPartDigits) <= format.getMaximumFractionDigits();
            if (!fracPartValid) {
                return false;
            }
        }
        return true;
    }

    public static String createNumberWithinFormatLimits(DecimalFormat format, String curText, int offset, int replaceLen, String insertText) {
        if (insertText == null || insertText.length() < 1) {
            insertText = "";
        }
        StringBuilder result = new StringBuilder();
        String futureText = null;
        if (curText == null) {
            futureText = insertText;
        } else {
            StringBuilder docTxt = new StringBuilder(curText.length() + insertText.length());
            docTxt.append(curText);
            docTxt.replace(offset, offset + replaceLen, insertText);
            futureText = docTxt.toString();
        }
        Pattern pat = Pattern.compile("[^1-9" + format.getDecimalFormatSymbols().getZeroDigit() + "]");
        String decimalSeparator = String.valueOf(format.getDecimalFormatSymbols().getDecimalSeparator());
        String[] parts = futureText.split(Pattern.quote(decimalSeparator));
        if (parts.length >= 1) {
            boolean intPartValid;
            String intPartDigits = pat.matcher(parts[0]).replaceAll("");
            boolean bl = intPartValid = StringUtility.length((CharSequence)intPartDigits) <= format.getMaximumIntegerDigits();
            if (intPartValid) {
                result.append(intPartDigits);
            } else {
                throw new ProcessingException("Do not truncate integer digits!", new Object[0]);
            }
        }
        if (parts.length == 2) {
            boolean fracPartValid;
            String fracPartDigits = pat.matcher(parts[1]).replaceAll("");
            boolean bl = fracPartValid = StringUtility.length((CharSequence)fracPartDigits) <= format.getMaximumFractionDigits();
            if (fracPartValid) {
                result.append(decimalSeparator).append(fracPartDigits);
            } else {
                result.append(decimalSeparator).append(fracPartDigits, 0, format.getMaximumFractionDigits());
            }
        }
        return result.toString();
    }

    @Override
    protected INumberFieldExtension<NUMBER, ? extends AbstractNumberField<NUMBER>> createLocalExtension() {
        return new LocalNumberFieldExtension(this);
    }

    protected static class LocalNumberFieldExtension<NUMBER extends Number, OWNER extends AbstractNumberField<NUMBER>>
    extends AbstractBasicField.LocalBasicFieldExtension<NUMBER, OWNER>
    implements INumberFieldExtension<NUMBER, OWNER> {
        public LocalNumberFieldExtension(OWNER owner) {
            super(owner);
        }
    }
}

