/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeFieldGrid;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.internal.GridDataBuilder;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup;
import org.eclipse.scout.rt.platform.util.NumberUtility;

public class RadioButtonGroupGrid
implements ICompositeFieldGrid<ICompositeField> {
    private IRadioButtonGroup<?> m_group = null;
    private List<IFormField> m_fields;
    private int m_gridColumns;
    private int m_gridRows;

    @Override
    public void validate(ICompositeField compositeField) {
        this.m_group = (IRadioButtonGroup)compositeField;
        this.m_gridColumns = 0;
        this.m_gridRows = 0;
        List fields = this.m_group.getFields();
        ArrayList<IFormField> list = new ArrayList<IFormField>(fields.size());
        for (IFormField f : fields) {
            if (f.isVisible()) {
                list.add(f);
                continue;
            }
            GridData data = GridDataBuilder.createFromHints(f, 1);
            f.setGridDataInternal(data);
        }
        this.m_fields = list;
        this.applyGridData();
    }

    protected void applyGridData() {
        int numVisibleFields = this.m_fields.size();
        this.m_gridColumns = Math.min(this.m_group.getGridColumnCount(), numVisibleFields);
        if (this.m_gridColumns <= 0) {
            this.m_gridColumns = this.calcDefaultGridColumnCount();
        }
        this.m_gridRows = NumberUtility.divideAndCeil((int)numVisibleFields, (int)this.m_gridColumns);
        int i = 0;
        int r = 0;
        while (r < this.m_gridRows) {
            int c = 0;
            while (c < this.m_gridColumns) {
                if (i >= numVisibleFields) break;
                GridData data = GridDataBuilder.createFromHints(this.m_fields.get(i), 1);
                data.x = c++;
                data.y = r;
                data.w = 1;
                data.h = 1;
                this.m_fields.get(i).setGridDataInternal(data);
                ++i;
            }
            ++r;
        }
    }

    protected int calcDefaultGridColumnCount() {
        GridData parentData = this.m_group.getGridData();
        if (parentData == null || parentData.h < 1) {
            return 1;
        }
        int numVisibleFields = this.m_fields.size();
        if (numVisibleFields < 1) {
            return 1;
        }
        int height = Math.min(numVisibleFields, parentData.h);
        if (height <= 1) {
            return numVisibleFields;
        }
        return NumberUtility.divideAndCeil((int)numVisibleFields, (int)height);
    }

    @Override
    public int getGridColumnCount() {
        return this.m_gridColumns;
    }

    @Override
    public int getGridRowCount() {
        return this.m_gridRows;
    }
}

