/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.smartfield.ISmartFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.smartfield.SmartFieldChains;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.services.lookup.FormFieldProvisioningContext;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallProvisioningService;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallResult;
import org.eclipse.scout.rt.client.services.lookup.IQueryParam;
import org.eclipse.scout.rt.client.services.lookup.QueryParam;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ColumnDescriptor;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.ValidationFailedStatus;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.HierarchicalLookupResultBuilder;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.HierarchicalSmartFieldDataFetcher;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ILookupRowProvider;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartFieldLookupRowFetcher;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartFieldUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.LookupRowHelper;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.SmartFieldDataFetcher;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.SmartFieldUIFacade;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.FinalValue;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;
import org.eclipse.scout.rt.platform.util.TriState;
import org.eclipse.scout.rt.platform.util.concurrent.FutureCancelledError;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRowFetchedCallback;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;

@ClassId(value="444e6fb6-3b0b-4917-933e-b6eb81345499")
public abstract class AbstractSmartField<VALUE>
extends AbstractValueField<VALUE>
implements ISmartField<VALUE> {
    private final ISmartFieldUIFacade<VALUE> m_uiFacade;
    private Class<? extends ICodeType<?, VALUE>> m_codeTypeClass;
    private ILookupCall<VALUE> m_lookupCall;
    private ISmartFieldLookupRowFetcher<VALUE> m_lookupRowFetcher;
    private String m_wildcard;
    private final String[] m_activeFilterLabels = new String[]{TEXTS.get((String)"ui.All"), TEXTS.get((String)"ui.Inactive"), TEXTS.get((String)"ui.Active")};
    private volatile IFuture<?> m_lookupFuture;
    private ProcessingException m_validationError;

    public AbstractSmartField() {
        this(true);
    }

    public AbstractSmartField(boolean callInitializer) {
        super(false);
        this.m_uiFacade = this.createUIFacade();
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected ISmartFieldUIFacade<VALUE> createUIFacade() {
        return ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new SmartFieldUIFacade(this), ModelContextProxy.ModelContext.copyCurrent());
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=270.0)
    protected String getConfiguredBrowseIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=290.0)
    protected boolean getConfiguredMultilineText() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    protected boolean getConfiguredBrowseAutoExpandAll() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=240.0)
    protected boolean getConfiguredBrowseLoadIncremental() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=240.0)
    protected boolean getConfiguredLoadParentNodes() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=310.0)
    protected boolean getConfiguredBrowseHierarchy() {
        return false;
    }

    @Order(value=315.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredSearchRequired() {
        return false;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=260.0)
    protected Class<? extends ICodeType<?, VALUE>> getConfiguredCodeType() {
        return null;
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=250.0)
    protected Class<? extends ILookupCall<VALUE>> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=265.0)
    protected int getConfiguredBrowseMaxRowCount() {
        return 100;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    protected boolean getConfiguredActiveFilterEnabled() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=280.0)
    protected int getConfiguredProposalFormHeight() {
        return 280;
    }

    @ConfigProperty(value="STRING")
    @Order(value=300.0)
    protected String getConfiguredWildcard() {
        return "*";
    }

    @ConfigProperty(value="STRING")
    @Order(value=310.0)
    protected ColumnDescriptor[] getConfiguredColumnDescriptors() {
        return null;
    }

    @ConfigProperty(value="OBJECT")
    @Order(value=320.0)
    protected String getConfiguredDisplayStyle() {
        return "default";
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=330.0)
    protected int getConfiguredMaxLength() {
        return 500;
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execPrepareLookup(ILookupCall<VALUE> call) {
    }

    @ConfigOperation
    @Order(value=240.0)
    protected void execPrepareKeyLookup(ILookupCall<VALUE> call, VALUE key) {
    }

    @ConfigOperation
    @Order(value=250.0)
    protected void execPrepareTextLookup(ILookupCall<VALUE> call, String text) {
    }

    @ConfigOperation
    @Order(value=260.0)
    protected void execPrepareBrowseLookup(ILookupCall<VALUE> call) {
    }

    @ConfigOperation
    @Order(value=270.0)
    protected void execPrepareRecLookup(ILookupCall<VALUE> call, VALUE parentKey) {
    }

    @ConfigOperation
    @Order(value=280.0)
    protected void execFilterLookupResult(ILookupCall<VALUE> call, List<ILookupRow<VALUE>> result) {
    }

    @ConfigOperation
    @Order(value=290.0)
    protected void execFilterKeyLookupResult(ILookupCall<VALUE> call, List<ILookupRow<VALUE>> result) {
    }

    @ConfigOperation
    @Order(value=300.0)
    protected void execFilterTextLookupResult(ILookupCall<VALUE> call, List<ILookupRow<VALUE>> result) {
    }

    @ConfigOperation
    @Order(value=310.0)
    protected void execFilterBrowseLookupResult(ILookupCall<VALUE> call, List<ILookupRow<VALUE>> result) {
    }

    @ConfigOperation
    @Order(value=320.0)
    protected void execFilterRecLookupResult(ILookupCall<VALUE> call, List<ILookupRow<VALUE>> result) {
    }

    @Override
    public boolean acceptBrowseHierarchySelection(VALUE value, int level, boolean leaf) {
        return true;
    }

    @Override
    protected void initConfig() {
        Class<ILookupCall<VALUE>> lookupCallClass;
        this.setResult(null);
        this.setActiveFilter(TriState.TRUE);
        super.initConfig();
        this.setActiveFilterEnabled(this.getConfiguredActiveFilterEnabled());
        this.setBrowseHierarchy(this.getConfiguredBrowseHierarchy());
        this.setBrowseAutoExpandAll(this.getConfiguredBrowseAutoExpandAll());
        this.setBrowseLoadIncremental(this.getConfiguredBrowseLoadIncremental());
        this.setSearchRequired(this.getConfiguredSearchRequired());
        this.setLoadParentNodes(this.getConfiguredLoadParentNodes());
        this.setMultilineText(this.getConfiguredMultilineText());
        this.setBrowseMaxRowCount(this.getConfiguredBrowseMaxRowCount());
        this.setColumnDescriptors(this.getConfiguredColumnDescriptors());
        this.setDisplayStyle(this.getConfiguredDisplayStyle());
        this.initLookupRowFetcher();
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        if ((lookupCallClass = this.getConfiguredLookupCall()) != null) {
            ILookupCall call = (ILookupCall)BEANS.get(lookupCallClass);
            this.setLookupCall(call);
        }
        this.setWildcard(this.getConfiguredWildcard());
        this.setMaxLength(this.getConfiguredMaxLength());
    }

    private void initLookupRowFetcher() {
        ISmartFieldLookupRowFetcher<VALUE> lookupRowFetcher = this.createLookupRowFetcher();
        lookupRowFetcher.addPropertyChangeListener(new P_LookupRowFetcherPropertyListener());
        this.setLookupRowFetcher(lookupRowFetcher);
    }

    @Override
    protected void execMarkSaved() {
        super.execMarkSaved();
        TriState activeFilter = this.getActiveFilter();
        this.setInitActiveFilter(activeFilter);
    }

    @Override
    public void resetValue() {
        super.resetValue();
        TriState activeFilter = this.getInitActiveFilter();
        this.setActiveFilter(activeFilter);
    }

    @Override
    public boolean isActiveFilterEnabled() {
        return this.propertySupport.getPropertyBool("activeFilterEnabled");
    }

    @Override
    public void setActiveFilterEnabled(boolean activeFilterEnabled) {
        this.propertySupport.setPropertyBool("activeFilterEnabled", activeFilterEnabled);
    }

    @Override
    public TriState getActiveFilter() {
        return (TriState)this.propertySupport.getProperty("activeFilter");
    }

    @Override
    public void setActiveFilter(TriState activeFilter) {
        if (activeFilter == null) {
            activeFilter = TriState.TRUE;
        }
        this.propertySupport.setProperty("activeFilter", (Object)activeFilter);
    }

    @Override
    public void setInitActiveFilter(TriState initActiveFilter) {
        this.propertySupport.setProperty("initActiveFilter", (Object)initActiveFilter);
    }

    @Override
    public TriState getInitActiveFilter() {
        return (TriState)this.propertySupport.getProperty("initActiveFilter");
    }

    @Override
    public void setActiveFilterLabel(TriState state, String label) {
        this.m_activeFilterLabels[this.getIndexForTriState((TriState)state)] = label;
    }

    @Override
    public String[] getActiveFilterLabels() {
        return Arrays.copyOf(this.m_activeFilterLabels, this.m_activeFilterLabels.length);
    }

    private int getIndexForTriState(TriState state) {
        if (state.isUndefined()) {
            return 0;
        }
        if (state.isFalse()) {
            return 1;
        }
        return 2;
    }

    @Override
    public ILookupCallResult getResult() {
        return (ILookupCallResult)this.propertySupport.getProperty("result");
    }

    protected void setResult(ILookupCallResult<VALUE> result) {
        this.propertySupport.setProperty("result", result);
    }

    @Override
    public void setMultilineText(boolean multilineText) {
        boolean changed;
        if (!multilineText & (changed = this.propertySupport.setPropertyBool("multilineText", multilineText)) && this.isInitConfigDone()) {
            this.setValue(this.getValue());
        }
    }

    @Override
    public boolean isMultilineText() {
        return this.propertySupport.getPropertyBool("multilineText");
    }

    @Override
    public boolean isBrowseAutoExpandAll() {
        return this.propertySupport.getPropertyBool("browseAutoExpandAll");
    }

    @Override
    public void setBrowseAutoExpandAll(boolean browseAutoExpandAll) {
        this.propertySupport.setPropertyBool("browseAutoExpandAll", browseAutoExpandAll);
    }

    @Override
    public boolean isBrowseLoadIncremental() {
        return this.propertySupport.getPropertyBool("browseLoadIncremental");
    }

    @Override
    public void setBrowseLoadIncremental(boolean browseLoadIncremental) {
        this.propertySupport.setPropertyBool("browseLoadIncremental", browseLoadIncremental);
    }

    @Override
    public boolean isLoadParentNodes() {
        return this.propertySupport.getPropertyBool("browseLoadParentNodes");
    }

    @Override
    public void setLoadParentNodes(boolean loadParentNodes) {
        this.propertySupport.setPropertyBool("browseLoadParentNodes", loadParentNodes);
    }

    @Override
    public boolean isBrowseHierarchy() {
        return this.propertySupport.getPropertyBool("browseHierarchy");
    }

    @Override
    public void setBrowseHierarchy(boolean browseHierarchy) {
        this.propertySupport.setPropertyBool("browseHierarchy", browseHierarchy);
        this.initLookupRowFetcher();
    }

    @Override
    public boolean isSearchRequired() {
        return this.propertySupport.getPropertyBool("searchRequired");
    }

    @Override
    public void setSearchRequired(boolean searchRequired) {
        this.propertySupport.setPropertyBool("searchRequired", searchRequired);
    }

    @Override
    public int getBrowseMaxRowCount() {
        return this.propertySupport.getPropertyInt("browseMaxRowCount");
    }

    @Override
    public void setBrowseMaxRowCount(int browseMaxRowCount) {
        this.propertySupport.setPropertyInt("browseMaxRowCount", browseMaxRowCount);
    }

    @Override
    public ColumnDescriptor[] getColumnDescriptors() {
        return (ColumnDescriptor[])this.getProperty("columnDescriptors");
    }

    @Override
    public void setColumnDescriptors(ColumnDescriptor[] columnDescriptors) {
        this.setProperty("columnDescriptors", columnDescriptors);
    }

    @Override
    public void setMaxLength(int maxLength) {
        boolean changed = this.propertySupport.setPropertyInt("maxLength", Math.max(0, maxLength));
        if (changed && this.isInitConfigDone()) {
            this.setValue(this.getValue());
        }
    }

    @Override
    public int getMaxLength() {
        return this.propertySupport.getPropertyInt("maxLength");
    }

    @Override
    public Class<? extends ICodeType<?, VALUE>> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    @Override
    public void setCodeTypeClass(Class<? extends ICodeType<?, VALUE>> codeType) {
        this.m_codeTypeClass = codeType;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            CodeLookupCall codeLookupCall;
            this.m_lookupCall = codeLookupCall = CodeLookupCall.newInstanceByService(this.m_codeTypeClass);
            ICodeType t = (ICodeType)BEANS.opt(this.m_codeTypeClass);
            if (t != null && !ConfigurationUtility.isMethodOverwrite(AbstractSmartField.class, (String)"getConfiguredBrowseHierarchy", (Class[])new Class[0], this.getClass())) {
                this.setBrowseHierarchy(t.isHierarchy());
            }
        }
    }

    @Override
    public ILookupCall<VALUE> getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setLookupCall(ILookupCall<VALUE> call) {
        this.m_lookupCall = call;
    }

    @Override
    public void setWildcard(String wildcard) {
        if (StringUtility.isNullOrEmpty((CharSequence)wildcard)) {
            throw new IllegalArgumentException("Wildcard must not be null nor empty!");
        }
        this.m_wildcard = wildcard;
        if (this.m_lookupCall != null) {
            this.m_lookupCall.setWildcard(wildcard);
        }
    }

    @Override
    public String getWildcard() {
        return this.m_wildcard;
    }

    public ISmartFieldLookupRowFetcher<VALUE> getLookupRowFetcher() {
        return this.m_lookupRowFetcher;
    }

    public void setLookupRowFetcher(ISmartFieldLookupRowFetcher<VALUE> fetcher) {
        this.m_lookupRowFetcher = fetcher;
    }

    protected boolean isCurrentLookupRowValid(VALUE validKey) {
        if (this.getLookupRow() == null) {
            return true;
        }
        return validKey == this.getLookupRow().getKey() || validKey != null && validKey.equals(this.getLookupRow().getKey());
    }

    @Override
    public void setLookupRow(ILookupRow<VALUE> lookupRow) {
        this.propertySupport.setProperty("lookupRow", lookupRow);
    }

    @Override
    public ILookupRow<VALUE> getLookupRow() {
        return (ILookupRow)this.propertySupport.getProperty("lookupRow");
    }

    @Override
    public void setValueByLookupRow(ILookupRow<VALUE> lookupRow) {
        this.m_validationError = null;
        ILookupRow<VALUE> oldRow = this.getLookupRow();
        try {
            if (lookupRow == null) {
                this.setLookupRow(null);
                this.setValue(null);
            } else if (lookupRow.isEnabled()) {
                this.setLookupRow(lookupRow);
                this.setValue(this.getValueFromLookupRow(lookupRow));
            }
        }
        finally {
            if (this.m_validationError != null) {
                this.setLookupRow(oldRow);
            }
        }
    }

    @Override
    protected void handleValidationFailed(ProcessingException e, VALUE rawValue) {
        this.addErrorStatus(new ValidationFailedStatus<VALUE>(e, rawValue));
        this.m_validationError = e;
    }

    protected VALUE getValueFromLookupRow(ILookupRow<VALUE> lookupRow) {
        return (VALUE)lookupRow.getKey();
    }

    @Override
    public void prepareKeyLookup(ILookupCall<VALUE> call, VALUE key) {
        call.setKey(key);
        call.setText(null);
        call.setAll(null);
        call.setRec(null);
        call.setActive(TriState.UNDEFINED);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
        this.interceptPrepareLookup(call);
        this.interceptPrepareKeyLookup(call, key);
    }

    @Override
    public void prepareTextLookup(ILookupCall<VALUE> call, String text) {
        String textPattern = text;
        if (textPattern == null) {
            textPattern = "";
        }
        textPattern = textPattern.toLowerCase();
        IDesktop desktop = ClientSessionProvider.currentSession().getDesktop();
        if (desktop != null && desktop.isAutoPrefixWildcardForTextSearch()) {
            textPattern = String.valueOf(this.getWildcard()) + textPattern;
        }
        if (!textPattern.endsWith(this.getWildcard())) {
            textPattern = String.valueOf(textPattern) + this.getWildcard();
        }
        if (call instanceof LocalLookupCall) {
            ((LocalLookupCall)call).setHierarchicalLookup(this.isBrowseHierarchy());
        }
        call.setKey(null);
        call.setText(textPattern);
        call.setAll(null);
        call.setRec(null);
        call.setActive(this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
        this.interceptPrepareLookup(call);
        this.interceptPrepareTextLookup(call, text);
    }

    @Override
    public void prepareBrowseLookup(ILookupCall<VALUE> call, TriState activeState) {
        call.setKey(null);
        call.setText(null);
        call.setAll(this.getWildcard());
        call.setRec(null);
        call.setActive(activeState);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
        this.interceptPrepareLookup(call);
        this.interceptPrepareBrowseLookup(call);
    }

    @Override
    public void prepareRecLookup(ILookupCall<VALUE> call, VALUE parentKey, TriState activeState) {
        call.setKey(null);
        call.setText(null);
        call.setAll(null);
        call.setRec(parentKey);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
        call.setActive(activeState);
        this.interceptPrepareLookup(call);
        this.interceptPrepareRecLookup(call, parentKey);
    }

    protected VALUE handleMissingLookupRow(String text) {
        this.lookupByTextInternal(text, true);
        ILookupCallResult<VALUE> fetchResult = this.getLookupRowFetcher().getResult();
        int numResults = 0;
        if (fetchResult != null && fetchResult.getLookupRows() != null && (numResults = fetchResult.getLookupRows().size()) == 1) {
            ILookupRow singleMatchLookupRow = (ILookupRow)CollectionUtility.firstElement(fetchResult.getLookupRows());
            this.setLookupRow(singleMatchLookupRow);
            return this.returnLookupRowAsValue(singleMatchLookupRow);
        }
        boolean notUnique = numResults > 1;
        VetoException veto = new VetoException(TEXTS.get((String)(notUnique ? "SmartFieldNotUnique" : "SmartFieldCannotComplete"), (String[])new String[]{text}), new Object[0]);
        veto.withCode(notUnique ? 1 : 2);
        throw veto;
    }

    protected VALUE returnLookupRowAsValue(ILookupRow<VALUE> lookupRow) {
        return (VALUE)lookupRow.getKey();
    }

    @Override
    protected VALUE parseValueInternal(String text) {
        ILookupRow<VALUE> currentLookupRow = this.getLookupRow();
        if (currentLookupRow == null) {
            return this.handleMissingLookupRow(text);
        }
        return this.returnLookupRowAsValue(this.getLookupRow());
    }

    @Override
    protected VALUE validateValueInternal(VALUE rawValue) {
        VALUE validatedValue = super.validateValueInternal(rawValue);
        if (validatedValue == null) {
            this.setLookupRow(null);
            return validatedValue;
        }
        ILookupRow<VALUE> currentLookupRow = this.getLookupRow();
        if (currentLookupRow != null && !this.lookupRowMatchesValue(currentLookupRow, validatedValue)) {
            this.setLookupRow(null);
        }
        return validatedValue;
    }

    protected boolean lookupRowMatchesValue(ILookupRow<VALUE> lookupRow, VALUE value) {
        return ObjectUtility.equals(this.getValueFromLookupRow(lookupRow), value);
    }

    @Override
    public void lookupByAll() {
        this.doSearch(QueryParam.createByAll(), false);
    }

    @Override
    public void lookupByText(String text) {
        this.lookupByTextInternal(text, false);
    }

    protected void lookupByTextInternal(String text, boolean synchronous) {
        text = StringUtility.substring((String)text, (int)0, (int)this.getMaxLength());
        this.doSearch(QueryParam.createByText(text), synchronous);
    }

    @Override
    public void lookupByRec(VALUE parentKey) {
        this.doSearch(QueryParam.createByRec(parentKey), false);
    }

    @Override
    public void lookupByKey(VALUE key) {
        this.doSearch(QueryParam.createByKey(key), false);
    }

    @Override
    public void doSearch(IQueryParam<VALUE> param, boolean synchronous) {
        this.getLookupRowFetcher().update(param, synchronous);
    }

    @Override
    public List<? extends ILookupRow<VALUE>> callKeyLookup(VALUE key) {
        LookupRowCollector collector = new LookupRowCollector();
        this.fetchLookupRows(this.newByKeyLookupRowProvider(key), collector, false, 1);
        return collector.get();
    }

    @Override
    public List<? extends ILookupRow<VALUE>> callTextLookup(String text, int maxRowCount) {
        LookupRowCollector collector = new LookupRowCollector();
        this.fetchLookupRows(this.newByTextLookupRowProvider(text), collector, false, maxRowCount);
        return collector.get();
    }

    @Override
    public List<? extends ILookupRow<VALUE>> callBrowseLookup(int maxRowCount) {
        return this.callBrowseLookup(maxRowCount, this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE);
    }

    @Override
    public List<? extends ILookupRow<VALUE>> callBrowseLookup(int maxRowCount, TriState activeState) {
        LookupRowCollector collector = new LookupRowCollector();
        this.fetchLookupRows(this.newByAllLookupRowProvider(activeState), collector, false, maxRowCount);
        return collector.get();
    }

    @Override
    public List<ILookupRow<VALUE>> callSubTreeLookup(VALUE parentKey) {
        return this.callSubTreeLookup(parentKey, this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE);
    }

    @Override
    public List<ILookupRow<VALUE>> callSubTreeLookup(VALUE parentKey, TriState activeState) {
        ILookupRowProvider<VALUE> provider = this.newByRecLookupRowProvider(parentKey, activeState);
        return ((LookupRowHelper)BEANS.get(LookupRowHelper.class)).lookup(provider, this.cloneLookupCall());
    }

    @Override
    public IFuture<List<ILookupRow<VALUE>>> callKeyLookupInBackground(VALUE key, boolean cancelRunningJobs) {
        ILookupRowProvider<VALUE> provider = this.newByKeyLookupRowProvider(key);
        return this.callInBackground(provider, cancelRunningJobs);
    }

    @Override
    public IFuture<List<ILookupRow<VALUE>>> callTextLookupInBackground(String text, boolean cancelRunningJobs) {
        ILookupRowProvider<VALUE> provider = this.newByTextLookupRowProvider(text);
        return this.callInBackground(provider, cancelRunningJobs);
    }

    @Override
    public IFuture<List<ILookupRow<VALUE>>> callBrowseLookupInBackground(boolean cancelRunningJobs) {
        TriState activeState = this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE;
        ILookupRowProvider<VALUE> provider = this.newByAllLookupRowProvider(activeState);
        return this.callInBackground(provider, cancelRunningJobs);
    }

    @Override
    public IFuture<List<ILookupRow<VALUE>>> callSubTreeLookupInBackground(VALUE parentKey, boolean cancelRunningJobs) {
        TriState activeState = this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE;
        return this.callSubTreeLookupInBackground(parentKey, activeState, cancelRunningJobs);
    }

    @Override
    public IFuture<List<ILookupRow<VALUE>>> callSubTreeLookupInBackground(VALUE parentKey, TriState activeState, boolean cancelRunningJobs) {
        ILookupRowProvider<VALUE> provider = this.newByRecLookupRowProvider(parentKey, activeState);
        return this.callInBackground(provider, cancelRunningJobs);
    }

    protected IFuture<List<ILookupRow<VALUE>>> callInBackground(ILookupRowProvider<VALUE> provider, boolean cancelRunningJobs) {
        if (cancelRunningJobs) {
            this.cancelPotentialLookup();
        }
        IFuture<List<ILookupRow<VALUE>>> futureResult = ((LookupRowHelper)BEANS.get(LookupRowHelper.class)).scheduleLookup(provider, this.cloneLookupCall());
        this.m_lookupFuture = futureResult;
        return futureResult;
    }

    protected ILookupCall<VALUE> cloneLookupCall() {
        return ((ILookupCallProvisioningService)BEANS.get(ILookupCallProvisioningService.class)).newClonedInstance(this.getLookupCall(), new FormFieldProvisioningContext(this));
    }

    @Override
    public IFuture<Void> callKeyLookupInBackground(VALUE key, ILookupRowFetchedCallback<VALUE> callback) {
        return this.fetchLookupRows(this.newByKeyLookupRowProvider(key), callback, true, 1);
    }

    @Override
    public IFuture<Void> callTextLookupInBackground(String text, int maxRowCount, ILookupRowFetchedCallback<VALUE> callback) {
        return this.fetchLookupRows(this.newByTextLookupRowProvider(text), callback, true, maxRowCount);
    }

    @Override
    public IFuture<Void> callBrowseLookupInBackground(int maxRowCount, ILookupRowFetchedCallback<VALUE> callback) {
        return this.callBrowseLookupInBackground(maxRowCount, this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE, callback);
    }

    @Override
    public IFuture<Void> callBrowseLookupInBackground(int maxRowCount, TriState activeState, ILookupRowFetchedCallback<VALUE> callback) {
        return this.fetchLookupRows(this.newByAllLookupRowProvider(activeState), callback, true, maxRowCount);
    }

    protected void cleanupResultList(List<ILookupRow<VALUE>> list) {
        list.removeIf(Objects::isNull);
    }

    protected void handleFetchResult(ILookupCallResult<VALUE> result) {
        if (result == null) {
            this.setResult(null);
        } else {
            if (this.isBrowseHierarchy()) {
                result = this.addHierarchicalResults(result);
            }
            this.setResult(result);
        }
    }

    protected ILookupCallResult<VALUE> addHierarchicalResults(ILookupCallResult<VALUE> result) {
        return new HierarchicalLookupResultBuilder<VALUE>(this).addParentLookupRows(result);
    }

    protected ISmartFieldLookupRowFetcher<VALUE> createLookupRowFetcher() {
        if (this.isBrowseHierarchy()) {
            return new HierarchicalSmartFieldDataFetcher(this);
        }
        return new SmartFieldDataFetcher(this);
    }

    @Override
    protected ISmartFieldExtension<VALUE, ? extends AbstractSmartField<VALUE>> createLocalExtension() {
        return new LocalSmartFieldExtension(this);
    }

    protected final void interceptFilterBrowseLookupResult(ILookupCall<VALUE> call, List<ILookupRow<VALUE>> result) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        SmartFieldChains.SmartFieldFilterBrowseLookupResultChain<VALUE> chain = new SmartFieldChains.SmartFieldFilterBrowseLookupResultChain<VALUE>(extensions);
        chain.execFilterBrowseLookupResult(call, result);
    }

    protected final void interceptFilterKeyLookupResult(ILookupCall<VALUE> call, List<ILookupRow<VALUE>> result) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        SmartFieldChains.SmartFieldFilterKeyLookupResultChain<VALUE> chain = new SmartFieldChains.SmartFieldFilterKeyLookupResultChain<VALUE>(extensions);
        chain.execFilterKeyLookupResult(call, result);
    }

    protected final void interceptPrepareLookup(ILookupCall<VALUE> call) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        SmartFieldChains.SmartFieldPrepareLookupChain<VALUE> chain = new SmartFieldChains.SmartFieldPrepareLookupChain<VALUE>(extensions);
        chain.execPrepareLookup(call);
    }

    protected final void interceptPrepareTextLookup(ILookupCall<VALUE> call, String text) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        SmartFieldChains.SmartFieldPrepareTextLookupChain<VALUE> chain = new SmartFieldChains.SmartFieldPrepareTextLookupChain<VALUE>(extensions);
        chain.execPrepareTextLookup(call, text);
    }

    protected final void interceptPrepareBrowseLookup(ILookupCall<VALUE> call) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        SmartFieldChains.SmartFieldPrepareBrowseLookupChain<VALUE> chain = new SmartFieldChains.SmartFieldPrepareBrowseLookupChain<VALUE>(extensions);
        chain.execPrepareBrowseLookup(call);
    }

    protected final void interceptFilterTextLookupResult(ILookupCall<VALUE> call, List<ILookupRow<VALUE>> result) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        SmartFieldChains.SmartFieldFilterTextLookupResultChain<VALUE> chain = new SmartFieldChains.SmartFieldFilterTextLookupResultChain<VALUE>(extensions);
        chain.execFilterTextLookupResult(call, result);
    }

    protected final void interceptPrepareRecLookup(ILookupCall<VALUE> call, VALUE parentKey) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        SmartFieldChains.SmartFieldPrepareRecLookupChain<VALUE> chain = new SmartFieldChains.SmartFieldPrepareRecLookupChain<VALUE>(extensions);
        chain.execPrepareRecLookup(call, parentKey);
    }

    protected final void interceptFilterLookupResult(ILookupCall<VALUE> call, List<ILookupRow<VALUE>> result) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        SmartFieldChains.SmartFieldFilterLookupResultChain<VALUE> chain = new SmartFieldChains.SmartFieldFilterLookupResultChain<VALUE>(extensions);
        chain.execFilterLookupResult(call, result);
    }

    protected final void interceptFilterRecLookupResult(ILookupCall<VALUE> call, List<ILookupRow<VALUE>> result) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        SmartFieldChains.SmartFieldFilterRecLookupResultChain<VALUE> chain = new SmartFieldChains.SmartFieldFilterRecLookupResultChain<VALUE>(extensions);
        chain.execFilterRecLookupResult(call, result);
    }

    protected final void interceptPrepareKeyLookup(ILookupCall<VALUE> call, VALUE key) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        SmartFieldChains.SmartFieldPrepareKeyLookupChain<VALUE> chain = new SmartFieldChains.SmartFieldPrepareKeyLookupChain<VALUE>(extensions);
        chain.execPrepareKeyLookup(call, key);
    }

    @Override
    public ISmartFieldUIFacade<VALUE> getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    protected String formatValueInternal(VALUE validKey) {
        if (validKey == null) {
            return "";
        }
        if (this.getLookupCall() == null) {
            return "";
        }
        ILookupRow<VALUE> currentLookupRow = this.getLookupRow();
        if (currentLookupRow == null || !this.lookupRowMatchesValue(currentLookupRow, validKey)) {
            try {
                List<ILookupRow<VALUE>> lookupRows = this.callKeyLookup(validKey);
                if (!lookupRows.isEmpty()) {
                    currentLookupRow = lookupRows.get(0);
                    this.setLookupRow(currentLookupRow);
                }
            }
            catch (RuntimeException | PlatformError e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
            }
        }
        if (currentLookupRow != null) {
            return this.lookupRowAsText(currentLookupRow);
        }
        return "";
    }

    private String lookupRowAsText(ILookupRow<VALUE> currentLookupRow) {
        String text = currentLookupRow.getText();
        if (!(text == null || this.isMultilineText() || this.getLookupCall() != null && this.getLookupCall().isMultilineText())) {
            text = text.replaceAll("[\\n\\r]+", " ");
        }
        return text;
    }

    @Override
    public void refreshDisplayText() {
        this.setLookupRow(null);
        this.setDisplayText(this.interceptFormatValue(this.getValue()));
    }

    @Override
    public String getDisplayStyle() {
        return this.propertySupport.getPropertyString("displayStyle");
    }

    @Override
    public void setDisplayStyle(String displayStlye) {
        this.propertySupport.setPropertyString("displayStyle", displayStlye);
    }

    protected ILookupRowProvider<VALUE> newByKeyLookupRowProvider(final VALUE key) {
        return new ILookupRowProvider<VALUE>(){

            @Override
            public void beforeProvide(ILookupCall<VALUE> lookupCall) {
                AbstractSmartField.this.prepareKeyLookup(lookupCall, key);
            }

            @Override
            public void afterProvide(ILookupCall<VALUE> lookupCall, List<ILookupRow<VALUE>> result) {
                AbstractSmartField.this.interceptFilterLookupResult(lookupCall, result);
                AbstractSmartField.this.interceptFilterKeyLookupResult(lookupCall, result);
                AbstractSmartField.this.cleanupResultList(result);
            }

            @Override
            public void provideSync(ILookupCall<VALUE> lookupCall, ILookupRowFetchedCallback<VALUE> callback) {
                callback.onSuccess(this.provide((ILookupCall<VALUE>)lookupCall));
            }

            @Override
            public IFuture<Void> provideAsync(ILookupCall<VALUE> lookupCall, ILookupRowFetchedCallback<VALUE> callback, ClientRunContext clientRunContext) {
                return lookupCall.getDataByKeyInBackground((RunContext)clientRunContext, callback);
            }

            @Override
            public List<ILookupRow<VALUE>> provide(ILookupCall<VALUE> lookupCall) {
                return lookupCall.getDataByKey();
            }

            public String toString() {
                ToStringBuilder sb = new ToStringBuilder((Object)this).attr((Object)"Key Lookup").attr("key", key);
                return sb.toString();
            }
        };
    }

    protected ILookupRowProvider<VALUE> newByAllLookupRowProvider(final TriState activeState) {
        return new ILookupRowProvider<VALUE>(){

            @Override
            public void beforeProvide(ILookupCall<VALUE> lookupCall) {
                AbstractSmartField.this.prepareBrowseLookup(lookupCall, activeState);
            }

            @Override
            public void afterProvide(ILookupCall<VALUE> lookupCall, List<ILookupRow<VALUE>> result) {
                AbstractSmartField.this.interceptFilterLookupResult(lookupCall, result);
                AbstractSmartField.this.interceptFilterBrowseLookupResult(lookupCall, result);
                AbstractSmartField.this.cleanupResultList(result);
            }

            @Override
            public void provideSync(ILookupCall<VALUE> lookupCall, ILookupRowFetchedCallback<VALUE> callback) {
                callback.onSuccess(this.provide((ILookupCall<VALUE>)lookupCall));
            }

            @Override
            public IFuture<Void> provideAsync(ILookupCall<VALUE> lookupCall, ILookupRowFetchedCallback<VALUE> callback, ClientRunContext clientRunContext) {
                return lookupCall.getDataByAllInBackground((RunContext)clientRunContext, callback);
            }

            @Override
            public List<ILookupRow<VALUE>> provide(ILookupCall<VALUE> lookupCall) {
                return lookupCall.getDataByAll();
            }

            public String toString() {
                return new ToStringBuilder((Object)this).attr((Object)"All Lookup").attr("activeState", (Object)activeState).toString();
            }
        };
    }

    protected ILookupRowProvider<VALUE> newByTextLookupRowProvider(final String text) {
        return new ILookupRowProvider<VALUE>(){

            @Override
            public void beforeProvide(ILookupCall<VALUE> lookupCall) {
                AbstractSmartField.this.prepareTextLookup(lookupCall, text);
            }

            @Override
            public void afterProvide(ILookupCall<VALUE> call, List<ILookupRow<VALUE>> result) {
                AbstractSmartField.this.interceptFilterLookupResult(call, result);
                AbstractSmartField.this.interceptFilterTextLookupResult(call, result);
                AbstractSmartField.this.cleanupResultList(result);
            }

            @Override
            public void provideSync(ILookupCall<VALUE> lookupCall, ILookupRowFetchedCallback<VALUE> callback) {
                callback.onSuccess(this.provide((ILookupCall<VALUE>)lookupCall));
            }

            @Override
            public IFuture<Void> provideAsync(ILookupCall<VALUE> lookupCall, ILookupRowFetchedCallback<VALUE> callback, ClientRunContext clientRunContext) {
                return lookupCall.getDataByTextInBackground((RunContext)clientRunContext, callback);
            }

            @Override
            public List<ILookupRow<VALUE>> provide(ILookupCall<VALUE> lookupCall) {
                return lookupCall.getDataByText();
            }

            public String toString() {
                ToStringBuilder sb = new ToStringBuilder((Object)this).attr((Object)"Text Lookup").attr("text", text);
                return sb.toString();
            }
        };
    }

    protected ILookupRowProvider<VALUE> newByRecLookupRowProvider(final VALUE parentKey, final TriState activeState) {
        return new ILookupRowProvider<VALUE>(){

            @Override
            public List<ILookupRow<VALUE>> provide(ILookupCall<VALUE> lookupCall) {
                return lookupCall.getDataByRec();
            }

            @Override
            public void beforeProvide(ILookupCall<VALUE> lookupCall) {
                AbstractSmartField.this.prepareRecLookup(lookupCall, parentKey, activeState);
            }

            @Override
            public void afterProvide(ILookupCall<VALUE> lookupCall, List<ILookupRow<VALUE>> result) {
                AbstractSmartField.this.interceptFilterLookupResult(lookupCall, result);
                AbstractSmartField.this.interceptFilterRecLookupResult(lookupCall, result);
                AbstractSmartField.this.cleanupResultList(result);
            }

            @Override
            public void provideSync(ILookupCall<VALUE> lookupCall, ILookupRowFetchedCallback<VALUE> callback) {
                throw new UnsupportedOperationException("Legacy calls not supported");
            }

            @Override
            public IFuture<Void> provideAsync(ILookupCall<VALUE> lookupCall, ILookupRowFetchedCallback<VALUE> callback, ClientRunContext clientRunContext) {
                throw new UnsupportedOperationException("Legacy calls not supported");
            }

            public String toString() {
                ToStringBuilder sb = new ToStringBuilder((Object)this).attr((Object)"Rec Lookup").attr("parentKey", parentKey).attr("activeState", (Object)activeState);
                return sb.toString();
            }
        };
    }

    private IFuture<Void> fetchLookupRows(final ILookupRowProvider<VALUE> dataProvider, final ILookupRowFetchedCallback<VALUE> callback, boolean asynchronousFetching, int maxRowCount) {
        this.cancelPotentialLookup();
        if (this.getLookupCall() == null) {
            callback.onSuccess(Collections.emptyList());
            return null;
        }
        final ILookupCall<VALUE> lookupCall = this.cloneLookupCall();
        lookupCall.setMaxRowCount(maxRowCount > 0 ? maxRowCount : this.getBrowseMaxRowCount());
        ILookupRowFetchedCallback internalCallback = new ILookupRowFetchedCallback<VALUE>(){

            public void onSuccess(List<? extends ILookupRow<VALUE>> rows) {
                this.joinModelThreadAndUpdateField(rows, null);
            }

            public void onFailure(RuntimeException e) {
                this.joinModelThreadAndUpdateField(null, e);
            }

            private void joinModelThreadAndUpdateField(List<? extends ILookupRow<VALUE>> rows, RuntimeException exception) {
                if (ModelJobs.isModelThread()) {
                    this.updateField(rows, exception);
                } else {
                    try {
                        ClientRunContext callerRunContext = ClientRunContexts.copyCurrent();
                        if (callerRunContext.getRunMonitor().isCancelled()) {
                            return;
                        }
                        ModelJobs.schedule(() -> this.updateField(rows, exception), ModelJobs.newInput(callerRunContext).withName("Updating {}", new Object[]{AbstractSmartField.this.getClass().getName()})).awaitDone();
                    }
                    catch (ThreadInterruptedError threadInterruptedError) {}
                }
            }

            private void updateField(List<? extends ILookupRow<VALUE>> rows, RuntimeException exception) {
                try {
                    if (exception != null) {
                        throw exception;
                    }
                    ArrayList result = new ArrayList(rows);
                    dataProvider.afterProvide(lookupCall, result);
                    callback.onSuccess(result);
                }
                catch (FutureCancelledError | ThreadInterruptedError throwable) {
                    callback.onSuccess(Collections.emptyList());
                }
                catch (RuntimeException e) {
                    callback.onFailure(e);
                }
            }
        };
        IFuture<Void> asyncLookupFuture = null;
        try {
            dataProvider.beforeProvide(lookupCall);
            if (asynchronousFetching) {
                asyncLookupFuture = dataProvider.provideAsync(lookupCall, internalCallback, ClientRunContexts.copyCurrent());
            } else {
                dataProvider.provideSync(lookupCall, internalCallback);
                asyncLookupFuture = null;
            }
        }
        catch (RuntimeException e) {
            internalCallback.onFailure(e);
            asyncLookupFuture = null;
        }
        this.m_lookupFuture = asyncLookupFuture;
        return asyncLookupFuture;
    }

    protected void cancelPotentialLookup() {
        if (this.m_lookupFuture == null) {
            return;
        }
        if (this.m_lookupFuture.containsExecutionHint("initialLookup")) {
            return;
        }
        this.m_lookupFuture.cancel(false);
    }

    protected static class LocalSmartFieldExtension<VALUE, OWNER extends AbstractSmartField<VALUE>>
    extends AbstractValueField.LocalValueFieldExtension<VALUE, OWNER>
    implements ISmartFieldExtension<VALUE, OWNER> {
        public LocalSmartFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execFilterBrowseLookupResult(SmartFieldChains.SmartFieldFilterBrowseLookupResultChain<VALUE> chain, ILookupCall<VALUE> call, List<ILookupRow<VALUE>> result) {
            ((AbstractSmartField)this.getOwner()).execFilterBrowseLookupResult(call, result);
        }

        @Override
        public void execFilterKeyLookupResult(SmartFieldChains.SmartFieldFilterKeyLookupResultChain<VALUE> chain, ILookupCall<VALUE> call, List<ILookupRow<VALUE>> result) {
            ((AbstractSmartField)this.getOwner()).execFilterKeyLookupResult(call, result);
        }

        @Override
        public void execPrepareLookup(SmartFieldChains.SmartFieldPrepareLookupChain<VALUE> chain, ILookupCall<VALUE> call) {
            ((AbstractSmartField)this.getOwner()).execPrepareLookup(call);
        }

        @Override
        public void execPrepareTextLookup(SmartFieldChains.SmartFieldPrepareTextLookupChain<VALUE> chain, ILookupCall<VALUE> call, String text) {
            ((AbstractSmartField)this.getOwner()).execPrepareTextLookup(call, text);
        }

        @Override
        public void execPrepareBrowseLookup(SmartFieldChains.SmartFieldPrepareBrowseLookupChain<VALUE> chain, ILookupCall<VALUE> call) {
            ((AbstractSmartField)this.getOwner()).execPrepareBrowseLookup(call);
        }

        @Override
        public void execFilterTextLookupResult(SmartFieldChains.SmartFieldFilterTextLookupResultChain<VALUE> chain, ILookupCall<VALUE> call, List<ILookupRow<VALUE>> result) {
            ((AbstractSmartField)this.getOwner()).execFilterTextLookupResult(call, result);
        }

        @Override
        public void execPrepareRecLookup(SmartFieldChains.SmartFieldPrepareRecLookupChain<VALUE> chain, ILookupCall<VALUE> call, VALUE parentKey) {
            ((AbstractSmartField)this.getOwner()).execPrepareRecLookup(call, parentKey);
        }

        @Override
        public void execFilterLookupResult(SmartFieldChains.SmartFieldFilterLookupResultChain<VALUE> chain, ILookupCall<VALUE> call, List<ILookupRow<VALUE>> result) {
            ((AbstractSmartField)this.getOwner()).execFilterLookupResult(call, result);
        }

        @Override
        public void execFilterRecLookupResult(SmartFieldChains.SmartFieldFilterRecLookupResultChain<VALUE> chain, ILookupCall<VALUE> call, List<ILookupRow<VALUE>> result) {
            ((AbstractSmartField)this.getOwner()).execFilterRecLookupResult(call, result);
        }

        @Override
        public void execPrepareKeyLookup(SmartFieldChains.SmartFieldPrepareKeyLookupChain<VALUE> chain, ILookupCall<VALUE> call, VALUE key) {
            ((AbstractSmartField)this.getOwner()).execPrepareKeyLookup(call, key);
        }
    }

    protected static class LookupRowCollector<VALUE>
    implements ILookupRowFetchedCallback<VALUE> {
        private final FinalValue<List<? extends ILookupRow<VALUE>>> m_rows = new FinalValue();
        private final FinalValue<RuntimeException> m_exception = new FinalValue();

        protected LookupRowCollector() {
        }

        public void onSuccess(List<? extends ILookupRow<VALUE>> rows) {
            this.m_rows.set(rows);
        }

        public void onFailure(RuntimeException e) {
            this.m_exception.set((Object)e);
        }

        public List<? extends ILookupRow<VALUE>> get() {
            if (this.m_rows.isSet()) {
                return (List)this.m_rows.get();
            }
            if (this.m_exception.isSet()) {
                throw (RuntimeException)this.m_exception.get();
            }
            throw new IllegalStateException("Lookup row fetching not completed yet");
        }
    }

    private class P_LookupRowFetcherPropertyListener
    implements PropertyChangeListener {
        private P_LookupRowFetcherPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("searchResult".equals(evt.getPropertyName())) {
                AbstractSmartField.this.handleFetchResult((ILookupCallResult)evt.getNewValue());
            }
        }
    }
}

