/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ILookupRowByKeyProvider;
import org.eclipse.scout.rt.platform.util.visitor.DepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.IDepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;

public class IncrementalTreeBuilder<LOOKUP_KEY> {
    private final ILookupRowByKeyProvider<LOOKUP_KEY> m_provider;
    private final Map<LOOKUP_KEY, ILookupRow<LOOKUP_KEY>> m_keyCache = new HashMap<LOOKUP_KEY, ILookupRow<LOOKUP_KEY>>();

    public IncrementalTreeBuilder(ILookupRowByKeyProvider<LOOKUP_KEY> provider) {
        this.m_provider = provider;
    }

    public List<ILookupRow<LOOKUP_KEY>> getRowsWithParents(List<ILookupRow<LOOKUP_KEY>> lookupRows, LOOKUP_KEY parent, ITree existingTree) {
        ArrayList<ILookupRow<LOOKUP_KEY>> res = new ArrayList<ILookupRow<LOOKUP_KEY>>();
        this.cacheKeys(lookupRows);
        HashSet<Object> allRows = new HashSet<Object>();
        List<List<ILookupRow<LOOKUP_KEY>>> paths = this.createPaths(lookupRows, existingTree);
        if (parent == null) {
            for (List<ILookupRow<LOOKUP_KEY>> path : paths) {
                for (ILookupRow<LOOKUP_KEY> row : path) {
                    if (allRows.contains(row.getKey())) continue;
                    allRows.add(row.getKey());
                    res.add(row);
                }
            }
        } else {
            for (List<ILookupRow<LOOKUP_KEY>> path : paths) {
                ILookupRow<LOOKUP_KEY> leaf;
                if (!this.contains(parent, path) || allRows.contains((leaf = path.get(path.size() - 1)).getKey())) continue;
                allRows.add(leaf.getKey());
                res.add(leaf);
            }
        }
        return res;
    }

    private boolean contains(LOOKUP_KEY key, List<ILookupRow<LOOKUP_KEY>> path) {
        for (ILookupRow<LOOKUP_KEY> row : path) {
            if (!key.equals(row.getKey())) continue;
            return true;
        }
        return false;
    }

    private ILookupRow<LOOKUP_KEY> getLookupRow(LOOKUP_KEY key) {
        if (!this.m_keyCache.containsKey(key)) {
            ILookupRow<LOOKUP_KEY> row = this.m_provider.getLookupRow(key);
            this.m_keyCache.put(key, row);
            return row;
        }
        return this.m_keyCache.get(key);
    }

    public List<List<ILookupRow<LOOKUP_KEY>>> createPaths(Collection<? extends ILookupRow<LOOKUP_KEY>> lookupRows, ITree existingTree) {
        Map<LOOKUP_KEY, ILookupRow<LOOKUP_KEY>> parentMap = this.createParentMap(existingTree);
        ArrayList<List<ILookupRow<LOOKUP_KEY>>> paths = new ArrayList<List<ILookupRow<LOOKUP_KEY>>>();
        for (ILookupRow<LOOKUP_KEY> row : lookupRows) {
            ArrayList<ILookupRow<LOOKUP_KEY>> path = new ArrayList<ILookupRow<LOOKUP_KEY>>();
            ILookupRow<LOOKUP_KEY> r = row;
            while (r != null) {
                path.add(0, r);
                Object parentKey = r.getParentKey();
                if (parentKey == null) break;
                if (!parentMap.containsKey(r.getKey())) {
                    ILookupRow<Object> parentRow = this.getLookupRow(parentKey);
                    parentMap.put(r.getKey(), parentRow);
                }
                r = parentMap.get(r.getKey());
            }
            paths.add(path);
        }
        return paths;
    }

    private void cacheKeys(Collection<? extends ILookupRow<LOOKUP_KEY>> lookupRows) {
        for (ILookupRow<LOOKUP_KEY> row : lookupRows) {
            this.m_keyCache.put(row.getKey(), row);
        }
    }

    private ILookupRow<LOOKUP_KEY> getLookupRow(ITreeNode treeNode) {
        return (ILookupRow)treeNode.getCell().getValue();
    }

    public Map<LOOKUP_KEY, ILookupRow<LOOKUP_KEY>> createParentMap(ITree tree) {
        final HashMap map = new HashMap();
        DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

            public TreeVisitResult preVisit(ITreeNode node, int level, int index) {
                ITreeNode parent = node.getParentNode();
                ILookupRow row = IncrementalTreeBuilder.this.getLookupRow(node);
                if (row != null) {
                    Object key = row.getKey();
                    IncrementalTreeBuilder.this.m_keyCache.put(key, row);
                    map.put(key, IncrementalTreeBuilder.this.getLookupRow(parent));
                }
                return TreeVisitResult.CONTINUE;
            }
        };
        tree.visitTree((IDepthFirstTreeVisitor<ITreeNode>)v);
        return map;
    }
}

