/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.tabbox.internal;

import java.util.ArrayList;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeFieldGrid;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.internal.GridDataBuilder;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;

public class TabBoxGrid
implements ICompositeFieldGrid<ITabBox> {
    private IFormField[] m_fields;
    private int m_gridColumns;
    private int m_gridRows;

    @Override
    public void validate(ITabBox tabBox) {
        this.m_gridColumns = 0;
        this.m_gridRows = 0;
        ArrayList<IFormField> list = new ArrayList<IFormField>();
        for (IFormField iFormField : tabBox.getGroupBoxes()) {
            if (iFormField.isVisible()) {
                list.add(iFormField);
                continue;
            }
            GridData data = GridDataBuilder.createFromHints(iFormField, 1);
            iFormField.setGridDataInternal(data);
        }
        this.m_fields = list.toArray(new IFormField[0]);
        this.layoutStatic();
    }

    private void layoutStatic() {
        GridData data;
        IFormField[] iFormFieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField m_field1 = iFormFieldArray[n2];
            data = GridDataBuilder.createFromHints(m_field1, 1);
            this.m_gridRows = Math.max(this.m_gridRows, data.h);
            this.m_gridColumns = Math.max(this.m_gridColumns, data.w);
            ++n2;
        }
        iFormFieldArray = this.m_fields;
        n = this.m_fields.length;
        n2 = 0;
        while (n2 < n) {
            IFormField m_field = iFormFieldArray[n2];
            data = GridDataBuilder.createFromHints(m_field, this.m_gridColumns);
            data.x = 0;
            data.y = 0;
            m_field.setGridDataInternal(data);
            ++n2;
        }
    }

    @Override
    public int getGridColumnCount() {
        return this.m_gridColumns;
    }

    @Override
    public int getGridRowCount() {
        return this.m_gridRows;
    }
}

