/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.treebox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.treebox.ITreeBoxExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.treebox.TreeBoxChains;
import org.eclipse.scout.rt.client.services.lookup.FormFieldProvisioningContext;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallProvisioningService;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNodeBuilder;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNodeFilter;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.CompositeFieldUtility;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeFieldGrid;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.AbstractTreeBoxFilterBox;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.ActiveOrCheckedNodesFilter;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.CheckedNodesFilter;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.ITreeBox;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.OrderedComparator;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.TriState;
import org.eclipse.scout.rt.platform.util.visitor.DepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.IDepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="5648579d-1968-47be-a0c9-a8c846d2caf4")
public abstract class AbstractTreeBox<T>
extends AbstractValueField<Set<T>>
implements ITreeBox<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTreeBox.class);
    private ITree m_tree;
    private ILookupCall<T> m_lookupCall;
    private Class<? extends ICodeType<?, T>> m_codeTypeClass;
    private boolean m_valueTreeSyncActive;
    private boolean m_autoExpandAll;
    private boolean m_loadIncremental;
    private ITreeNodeFilter m_activeNodesFilter;
    private ITreeNodeFilter m_checkedNodesFilter;
    private List<IFormField> m_fields;
    private Map<Class<? extends IFormField>, IFormField> m_movedFormFieldsByClass;

    public AbstractTreeBox() {
        this(true);
    }

    public AbstractTreeBox(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigOperation
    @Order(value=240.0)
    protected void execLoadChildNodes(ITreeNode parentNode) {
        List<ITreeNode> children = this.isLoadIncremental() ? this.callChildLookup(parentNode) : this.callCompleteTreeLookup();
        this.m_tree.removeAllChildNodes(parentNode);
        this.m_tree.addChildNodes(parentNode, children);
        parentNode.setChildrenLoaded(true);
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=240.0)
    protected Class<? extends ILookupCall<T>> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=250.0)
    protected Class<? extends ICodeType<?, T>> getConfiguredCodeType() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=230.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=260.0)
    protected boolean getConfiguredAutoLoad() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    protected boolean getConfiguredLoadIncremental() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    protected boolean getConfiguredAutoExpandAll() {
        return false;
    }

    @Override
    @Order(value=210.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredAutoAddDefaultMenus() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=290.0)
    protected boolean getConfiguredFilterActiveNodes() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=300.0)
    protected boolean getConfiguredFilterCheckedNodes() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=310.0)
    protected boolean getConfiguredAutoCheckChildNodes() {
        return false;
    }

    @Override
    protected double getConfiguredGridWeightY() {
        return 1.0;
    }

    @Override
    protected int getConfiguredGridH() {
        return 2;
    }

    private List<Class<? extends IFormField>> getConfiguredFields() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List fields = ConfigurationUtility.filterClasses((Class[])dca, IFormField.class);
        return ConfigurationUtility.removeReplacedClasses((List)fields);
    }

    @Override
    protected boolean execIsEmpty() {
        if (!this.areChildrenEmpty()) {
            return false;
        }
        return this.getValue().isEmpty();
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execPrepareLookup(ILookupCall<T> call, ITreeNode parent) {
    }

    @ConfigOperation
    @Order(value=240.0)
    protected void execFilterLookupResult(ILookupCall<T> call, List<ILookupRow<T>> result) {
    }

    @ConfigOperation
    @Order(value=250.0)
    protected void execFilterNewNode(ITreeNode newNode, int treeLevel) {
    }

    private Class<? extends ITree> getConfiguredTree() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List f = ConfigurationUtility.filterClasses((Class[])dca, ITree.class);
        if (f.size() == 1) {
            return (Class)CollectionUtility.firstElement((List)f);
        }
        for (Class c : f) {
            if (c.getDeclaringClass() == AbstractTreeBox.class) continue;
            return c;
        }
        return null;
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) {
        this.setValue(null);
        this.loadRootNode();
    }

    @Override
    protected void initConfig() {
        Class<ITree> configuredTree;
        this.m_fields = CollectionUtility.emptyArrayList();
        this.m_movedFormFieldsByClass = new HashMap<Class<? extends IFormField>, IFormField>();
        super.initConfig();
        this.setFilterActiveNodes(this.getConfiguredFilterActiveNodes());
        this.setFilterActiveNodesValue(TriState.TRUE);
        this.setFilterCheckedNodes(this.getConfiguredFilterCheckedNodes());
        this.setFilterCheckedNodesValue(this.getConfiguredFilterCheckedNodes());
        this.setAutoExpandAll(this.getConfiguredAutoExpandAll());
        this.setLoadIncremental(this.getConfiguredLoadIncremental());
        List contributedTrees = this.m_contributionHolder.getContributionsByClass(ITree.class);
        this.m_tree = (ITree)CollectionUtility.firstElement((List)contributedTrees);
        if (this.m_tree == null && (configuredTree = this.getConfiguredTree()) != null) {
            this.m_tree = (ITree)ConfigurationUtility.newInnerInstance((Object)this, configuredTree);
        }
        if (this.m_tree != null) {
            if (this.m_tree instanceof AbstractTree) {
                this.m_tree.setParentInternal(this);
            }
            this.m_tree.setRootNode(this.getTreeNodeBuilder().createTreeNode((ILookupRow<T>)new LookupRow(null, "Root"), 0, false));
            this.m_tree.setAutoDiscardOnDelete(false);
            this.updateActiveNodesFilter();
            this.updateCheckedNodesFilter();
            this.m_tree.addTreeListener(e -> {
                switch (e.getType()) {
                    case 40: {
                        if (this.getTree().isCheckable()) break;
                        this.syncTreeToValue();
                        break;
                    }
                    case 870: {
                        if (!this.getTree().isCheckable()) break;
                        this.syncTreeToValue();
                    }
                }
            }, 40, 870);
            if (this.getConfiguredIconId() != null) {
                this.m_tree.setDefaultIconId(this.getConfiguredIconId());
            }
        } else {
            LOG.warn("there is no inner class of type ITree in {}", (Object)this.getClass().getName());
        }
        this.getTree().setAutoCheckChildNodes(this.getConfiguredAutoCheckChildNodes());
        Class<ILookupCall<T>> lookupCallClass = this.getConfiguredLookupCall();
        if (lookupCallClass != null) {
            ILookupCall call = (ILookupCall)BEANS.get(lookupCallClass);
            this.setLookupCall(call);
        }
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        this.addPropertyChangeListener(e -> {
            if (this.m_tree == null) {
                return;
            }
            String name = e.getPropertyName();
            if ("filterCheckedNodesValue".equals(name)) {
                this.updateCheckedNodesFilter();
            } else if ("filterActiveNodesValue".equals(name)) {
                this.updateActiveNodesFilter();
            }
        });
        List<Class<IFormField>> configuredFields = this.getConfiguredFields();
        List contributedFields = this.m_contributionHolder.getContributionsByClass(IFormField.class);
        ArrayList<IFormField> fieldList = new ArrayList<IFormField>(configuredFields.size() + contributedFields.size());
        for (Class<IFormField> fieldClazz : configuredFields) {
            fieldList.add((IFormField)ConfigurationUtility.newInnerInstance((Object)this, fieldClazz));
        }
        fieldList.addAll(contributedFields);
        fieldList.sort((Comparator<IFormField>)new OrderedComparator());
        for (IFormField f : fieldList) {
            CompositeFieldUtility.connectFields(f, this);
        }
        this.m_fields = fieldList;
    }

    @Override
    public void addField(IFormField f) {
        CompositeFieldUtility.addField(f, this, this.m_fields);
    }

    @Override
    public void removeField(IFormField f) {
        CompositeFieldUtility.removeField(f, this, this.m_fields);
    }

    @Override
    public void setMandatory(boolean b, boolean recursive) {
        super.setMandatory(b, false);
    }

    @Override
    public void moveFieldTo(IFormField f, ICompositeField newContainer) {
        CompositeFieldUtility.moveFieldTo(f, this, newContainer);
        this.m_movedFormFieldsByClass.put(f.getClass(), f);
    }

    @Override
    public Map<Class<? extends IFormField>, IFormField> getMovedFields() {
        return Collections.unmodifiableMap(this.m_movedFormFieldsByClass);
    }

    @Override
    protected void initFieldInternal() {
        if (this.getConfiguredAutoLoad()) {
            try {
                this.setValueChangeTriggerEnabled(false);
                this.loadRootNode();
            }
            finally {
                this.setValueChangeTriggerEnabled(true);
            }
        }
        super.initFieldInternal();
    }

    public TreeBoxFilterBox getTreeBoxFilterBox() {
        return this.getFieldByClass((Class)TreeBoxFilterBox.class);
    }

    @Override
    public final ITree getTree() {
        return this.m_tree;
    }

    @Override
    public void loadRootNode() {
        this.loadChildNodes(this.m_tree.getRootNode());
    }

    @Override
    public final void loadChildNodes(ITreeNode parentNode) {
        if (this.m_tree != null) {
            try {
                this.m_valueTreeSyncActive = true;
                this.m_tree.setTreeChanging(true);
                this.interceptLoadChildNodes(parentNode);
                if (!this.isLoadIncremental()) {
                    DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

                        public TreeVisitResult preVisit(ITreeNode node, int level, int index) {
                            if (node.getChildNodeCount() == 0) {
                                node.setLeafInternal(true);
                            } else {
                                node.setLeafInternal(false);
                            }
                            return TreeVisitResult.CONTINUE;
                        }
                    };
                    this.getTree().visitNode(this.getTree().getRootNode(), (IDepthFirstTreeVisitor<ITreeNode>)v);
                }
                if (this.isAutoExpandAll()) {
                    this.m_tree.expandAll(parentNode);
                }
            }
            finally {
                this.m_tree.setTreeChanging(false);
                this.m_valueTreeSyncActive = false;
            }
            this.syncValueToTree();
        }
    }

    public AbstractTreeNodeBuilder<T> getTreeNodeBuilder() {
        return new P_TreeNodeBuilder();
    }

    private void prepareLookupCall(ILookupCall<T> call, ITreeNode parent) {
        this.prepareLookupCallInternal(call, parent);
        this.interceptPrepareLookup(call, parent);
    }

    private void prepareLookupCallInternal(ILookupCall<T> call, ITreeNode parent) {
        if (parent != null) {
            call.setRec(parent.getPrimaryKey());
        } else {
            call.setRec(null);
        }
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
    }

    @Override
    public final ILookupCall<T> getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setLookupCall(ILookupCall<T> call) {
        this.m_lookupCall = call;
    }

    @Override
    public Class<? extends ICodeType<?, T>> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    @Override
    public void setCodeTypeClass(Class<? extends ICodeType<?, T>> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = CodeLookupCall.newInstanceByService(this.m_codeTypeClass);
        }
    }

    @Override
    public List<ITreeNode> callChildLookup(ITreeNode parentNode) {
        List<ILookupRow<T>> data = null;
        ILookupCall<T> call = this.getLookupCall();
        if (call != null) {
            call = ((ILookupCallProvisioningService)BEANS.get(ILookupCallProvisioningService.class)).newClonedInstance(call, new FormFieldProvisioningContext(this));
            this.prepareLookupCall(call, parentNode);
            data = call.getDataByRec();
            data = this.filterLookupResult(call, data);
            ArrayList<ITreeNode> subTree = new ArrayList<ITreeNode>(this.getTreeNodeBuilder().createTreeNodes(data, 0, false));
            this.filterNewNodesRec(subTree, parentNode != null ? parentNode.getTreeLevel() + 1 : 0);
            return subTree;
        }
        return CollectionUtility.emptyArrayList();
    }

    @Override
    public List<ITreeNode> callCompleteTreeLookup() {
        List<ILookupRow<T>> data = null;
        ILookupCall<T> call = this.getLookupCall();
        if (call != null) {
            call = ((ILookupCallProvisioningService)BEANS.get(ILookupCallProvisioningService.class)).newClonedInstance(call, new FormFieldProvisioningContext(this));
            this.prepareLookupCall(call, null);
            data = call.getDataByAll();
            data = this.filterLookupResult(call, data);
            List<ITreeNode> subTree = this.getTreeNodeBuilder().createTreeNodes(data, 0, true);
            this.filterNewNodesRec(subTree, 0);
            return subTree;
        }
        return CollectionUtility.emptyArrayList();
    }

    private List<? extends ILookupRow<T>> filterLookupResult(ILookupCall<T> call, List<? extends ILookupRow<T>> data) {
        ArrayList result = CollectionUtility.arrayList(data);
        this.interceptFilterLookupResult(call, result);
        Iterator resultIt = result.iterator();
        while (resultIt.hasNext()) {
            ILookupRow row = (ILookupRow)resultIt.next();
            if (row == null) {
                resultIt.remove();
                continue;
            }
            if (row.getKey() != null) continue;
            LOG.warn("The key of a lookup row may not be null. Row has been removed for tree box '{}'.", (Object)this.getClass().getName());
            resultIt.remove();
        }
        return result;
    }

    private void filterNewNodesRec(List<ITreeNode> nodes, int level) {
        if (nodes != null) {
            for (ITreeNode node : nodes) {
                if (node == null) continue;
                this.interceptFilterNewNode(node, level);
                this.filterNewNodesRec(node.getChildNodes(), level + 1);
            }
        }
    }

    @Override
    protected void valueChangedInternal() {
        super.valueChangedInternal();
        this.syncValueToTree();
    }

    @Override
    protected String formatValueInternal(Set<T> validValue) {
        if (validValue == null || validValue.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        List<ITreeNode> nodes = this.getTree().findNodes(validValue);
        if (nodes != null && !nodes.isEmpty()) {
            Iterator nodeIt = nodes.iterator();
            b.append(((ITreeNode)nodeIt.next()).getCell().getText());
            while (nodeIt.hasNext()) {
                b.append(", ").append(((ITreeNode)nodeIt.next()).getCell().getText());
            }
        }
        return b.toString();
    }

    @Override
    protected final Set<T> validateValueInternal(Set<T> rawValue0) {
        HashSet rawValue = CollectionUtility.hashSet(rawValue0);
        return this.doValidateValueInternal(rawValue);
    }

    protected Set<T> doValidateValueInternal(Set<T> rawValue) {
        if (CollectionUtility.isEmpty(rawValue)) {
            return rawValue;
        }
        ITree tree = this.getTree();
        if (tree != null && (tree.isCheckable() && !tree.isMultiCheck() || !tree.isCheckable() && !tree.isMultiSelect()) && rawValue.size() > 1) {
            LOG.warn("{} only accepts a single value. Got {}. Using only first value.", (Object)this.getClass().getName(), rawValue);
            return CollectionUtility.hashSet((Object)CollectionUtility.firstElement(rawValue));
        }
        return rawValue;
    }

    @Override
    public boolean isContentValid() {
        boolean valid = super.isContentValid();
        if (valid && this.isMandatory() && this.getValue().isEmpty()) {
            return false;
        }
        return valid;
    }

    @Override
    public Set<T> getValue() {
        return CollectionUtility.hashSet((Collection)((Collection)super.getValue()));
    }

    @Override
    public Set<T> getInitValue() {
        return CollectionUtility.hashSet((Collection)((Collection)super.getInitValue()));
    }

    @Override
    public T getSingleValue() {
        return (T)CollectionUtility.firstElement((Collection)((Collection)super.getValue()));
    }

    @Override
    public void setSingleValue(T value) {
        HashSet<T> valueSet = new HashSet<T>();
        if (value != null) {
            valueSet.add(value);
        }
        this.setValue(valueSet);
    }

    @Override
    public int getCheckedKeyCount() {
        return this.getValue().size();
    }

    @Override
    public T getCheckedKey() {
        return (T)CollectionUtility.firstElement(this.getCheckedKeys());
    }

    @Override
    public Set<T> getCheckedKeys() {
        return this.getValue();
    }

    @Override
    public void checkKey(T key) {
        HashSet<T> keySet = new HashSet<T>();
        if (key != null) {
            keySet.add(key);
        }
        this.checkKeys(keySet);
    }

    @Override
    public void checkKeys(Set<T> keys) {
        this.setValue(CollectionUtility.hashSetWithoutNullElements(keys));
    }

    @Override
    public void uncheckAllKeys() {
        this.checkKeys(null);
    }

    @Override
    public Set<T> getUncheckedKeys() {
        HashSet<T> set = new HashSet<T>();
        Set<T> a = this.getInitValue();
        if (a != null) {
            set.addAll(a);
        }
        if ((a = this.getCheckedKeys()) != null) {
            set.removeAll(a);
        }
        return set;
    }

    @Override
    public void checkAllKeys() {
        final HashSet keySet = new HashSet();
        DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

            public TreeVisitResult preVisit(ITreeNode node, int level, int index) {
                if (node.getPrimaryKey() != null) {
                    keySet.add(node.getPrimaryKey());
                }
                return TreeVisitResult.CONTINUE;
            }
        };
        this.m_tree.visitNode(this.m_tree.getRootNode(), (IDepthFirstTreeVisitor<ITreeNode>)v);
        this.checkKeys(keySet);
    }

    @Override
    public void exportFormFieldData(AbstractFormFieldData target) {
        AbstractValueFieldData v = (AbstractValueFieldData)target;
        Object value = this.getValue();
        if (CollectionUtility.isEmpty((Collection)value)) {
            v.setValue(null);
        } else {
            v.setValue((Object)CollectionUtility.hashSet((Collection)this.getValue()));
        }
    }

    @Override
    public boolean isLoadIncremental() {
        return this.m_loadIncremental;
    }

    @Override
    public void setLoadIncremental(boolean b) {
        this.m_loadIncremental = b;
    }

    @Override
    public boolean isAutoExpandAll() {
        return this.m_autoExpandAll;
    }

    @Override
    public void setAutoExpandAll(boolean b) {
        this.m_autoExpandAll = b;
    }

    @Override
    public boolean isAutoCheckChildNodes() {
        return this.getTree().isAutoCheckChildNodes();
    }

    @Override
    public void setAutoCheckChildNodes(boolean b) {
        this.getTree().setAutoCheckChildNodes(b);
    }

    @Override
    public boolean isNodeActive(ITreeNode node) {
        if (node instanceof P_InternalTreeNode) {
            return ((P_InternalTreeNode)node).isActive();
        }
        return false;
    }

    @Override
    public boolean isFilterActiveNodes() {
        return this.propertySupport.getPropertyBool("filterActiveNodes");
    }

    @Override
    public void setFilterActiveNodes(boolean b) {
        this.propertySupport.setPropertyBool("filterActiveNodes", b);
    }

    @Override
    public boolean getFilterCheckedNodesValue() {
        return this.propertySupport.getPropertyBool("filterCheckedNodesValue");
    }

    @Override
    public void setFilterCheckedNodesValue(boolean b) {
        this.propertySupport.setPropertyBool("filterCheckedNodesValue", b);
    }

    @Override
    public boolean isFilterCheckedNodes() {
        return this.propertySupport.getPropertyBool("filterCheckedNodes");
    }

    @Override
    public void setFilterCheckedNodes(boolean b) {
        this.propertySupport.setPropertyBool("filterCheckedNodes", b);
    }

    @Override
    public TriState getFilterActiveNodesValue() {
        return (TriState)this.propertySupport.getProperty("filterActiveNodesValue");
    }

    @Override
    public void setFilterActiveNodesValue(TriState t) {
        if (t == null) {
            t = TriState.TRUE;
        }
        this.propertySupport.setProperty("filterActiveNodesValue", (Object)t);
    }

    private void updateActiveNodesFilter() {
        try {
            this.m_tree.setTreeChanging(true);
            if (this.m_activeNodesFilter != null) {
                this.m_tree.removeNodeFilter(this.m_activeNodesFilter);
                this.m_activeNodesFilter = null;
            }
            this.m_activeNodesFilter = new ActiveOrCheckedNodesFilter(this, this.getFilterActiveNodesValue());
            this.m_tree.addNodeFilter(this.m_activeNodesFilter);
        }
        finally {
            this.m_tree.setTreeChanging(false);
        }
    }

    private void updateCheckedNodesFilter() {
        try {
            this.m_tree.setTreeChanging(true);
            if (this.m_checkedNodesFilter != null) {
                this.m_tree.removeNodeFilter(this.m_checkedNodesFilter);
                this.m_checkedNodesFilter = null;
            }
            if (this.getFilterCheckedNodesValue()) {
                this.m_checkedNodesFilter = new CheckedNodesFilter();
                this.m_tree.addNodeFilter(this.m_checkedNodesFilter);
            }
        }
        finally {
            this.m_tree.setTreeChanging(false);
        }
    }

    private void syncValueToTree() {
        if (this.m_valueTreeSyncActive) {
            return;
        }
        try {
            this.m_valueTreeSyncActive = true;
            this.getTree().setTreeChanging(true);
            Set<T> checkedKeys = this.getCheckedKeys();
            List<ITreeNode> checkedNodes = this.m_tree.findNodes(checkedKeys);
            DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

                public TreeVisitResult preVisit(ITreeNode element, int level, int index) {
                    element.setChecked(false);
                    return TreeVisitResult.CONTINUE;
                }
            };
            this.getTree().visitTree((IDepthFirstTreeVisitor<ITreeNode>)v);
            boolean autoCheckChildNodes = this.getTree().isAutoCheckChildNodes();
            this.getTree().setAutoCheckChildNodes(false);
            for (ITreeNode node : checkedNodes) {
                node.setChecked(true);
            }
            this.getTree().setAutoCheckChildNodes(autoCheckChildNodes);
            if (!this.getTree().isCheckable()) {
                this.getTree().selectNodes(checkedNodes, false);
            }
            this.getTree().applyNodeFilters();
        }
        finally {
            this.getTree().setTreeChanging(false);
            this.m_valueTreeSyncActive = false;
        }
    }

    private void syncTreeToValue() {
        if (this.m_valueTreeSyncActive) {
            return;
        }
        boolean resync = false;
        try {
            this.m_valueTreeSyncActive = true;
            this.getTree().setTreeChanging(true);
            Set<ITreeNode> checkedNodes = this.getTree().isCheckable() ? this.m_tree.getCheckedNodes() : this.m_tree.getSelectedNodes();
            HashSet<Object> checkedKeys = new HashSet<Object>();
            for (ITreeNode checkedNode : checkedNodes) {
                checkedKeys.add(checkedNode.getPrimaryKey());
            }
            this.checkKeys(checkedKeys);
            Set<T> validatedCheckedKeys = this.getCheckedKeys();
            if (!CollectionUtility.equalsCollection(checkedKeys, validatedCheckedKeys)) {
                resync = true;
            }
            if (!this.getTree().isCheckable()) {
                DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

                    public TreeVisitResult preVisit(ITreeNode node, int level, int index) {
                        node.setChecked(node.isSelectedNode());
                        return TreeVisitResult.CONTINUE;
                    }
                };
                this.getTree().visitTree((IDepthFirstTreeVisitor<ITreeNode>)v);
            }
            this.getTree().applyNodeFilters();
        }
        finally {
            this.getTree().setTreeChanging(false);
            this.m_valueTreeSyncActive = false;
        }
        if (resync) {
            this.syncValueToTree();
        }
    }

    public <F extends IFormField> F getFieldByClass(Class<F> fieldToFind) {
        return (F)((IFormField)this.getWidgetByClass(fieldToFind));
    }

    @Override
    public IFormField getFieldById(String id) {
        return CompositeFieldUtility.getFieldById(this, id);
    }

    public <X extends IFormField> X getFieldById(String id, Class<X> type) {
        return CompositeFieldUtility.getFieldById(this, id, type);
    }

    @Override
    public int getFieldCount() {
        return this.m_fields.size();
    }

    @Override
    public int getFieldIndex(IFormField f) {
        return this.m_fields.indexOf(f);
    }

    @Override
    public void setFields(List<IFormField> fields) {
        this.m_fields = CollectionUtility.arrayList(fields);
    }

    @Override
    public List<IFormField> getFields() {
        return CollectionUtility.arrayList(this.m_fields);
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), this.m_fields, Collections.singletonList(this.getTree())});
    }

    @Override
    public void rebuildFieldGrid() {
    }

    @Override
    public ICompositeFieldGrid<? extends ICompositeField> getFieldGrid() {
        return null;
    }

    protected final void interceptFilterNewNode(ITreeNode newNode, int treeLevel) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TreeBoxChains.TreeBoxFilterNewNodeChain chain = new TreeBoxChains.TreeBoxFilterNewNodeChain(extensions);
        chain.execFilterNewNode(newNode, treeLevel);
    }

    protected final void interceptLoadChildNodes(ITreeNode parentNode) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TreeBoxChains.TreeBoxLoadChildNodesChain chain = new TreeBoxChains.TreeBoxLoadChildNodesChain(extensions);
        chain.execLoadChildNodes(parentNode);
    }

    protected final void interceptPrepareLookup(ILookupCall<T> call, ITreeNode parent) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TreeBoxChains.TreeBoxPrepareLookupChain<T> chain = new TreeBoxChains.TreeBoxPrepareLookupChain<T>(extensions);
        chain.execPrepareLookup(call, parent);
    }

    protected final void interceptFilterLookupResult(ILookupCall<T> call, List<ILookupRow<T>> result) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TreeBoxChains.TreeBoxFilterLookupResultChain<T> chain = new TreeBoxChains.TreeBoxFilterLookupResultChain<T>(extensions);
        chain.execFilterLookupResult(call, result);
    }

    @Override
    protected ITreeBoxExtension<T, ? extends AbstractTreeBox<T>> createLocalExtension() {
        return new LocalTreeBoxExtension(this);
    }

    @ClassId(value="abc77329-ab0d-484c-9027-d517de928b76")
    public class DefaultTreeBoxTree
    extends AbstractTree {
        @Override
        protected boolean getConfiguredCheckable() {
            return true;
        }

        @Override
        protected boolean getConfiguredRootNodeVisible() {
            return false;
        }
    }

    protected static class LocalTreeBoxExtension<T, OWNER extends AbstractTreeBox<T>>
    extends AbstractValueField.LocalValueFieldExtension<Set<T>, OWNER>
    implements ITreeBoxExtension<T, OWNER> {
        public LocalTreeBoxExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execFilterNewNode(TreeBoxChains.TreeBoxFilterNewNodeChain<T> chain, ITreeNode newNode, int treeLevel) {
            ((AbstractTreeBox)this.getOwner()).execFilterNewNode(newNode, treeLevel);
        }

        @Override
        public void execLoadChildNodes(TreeBoxChains.TreeBoxLoadChildNodesChain<T> chain, ITreeNode parentNode) {
            ((AbstractTreeBox)this.getOwner()).execLoadChildNodes(parentNode);
        }

        @Override
        public void execPrepareLookup(TreeBoxChains.TreeBoxPrepareLookupChain<T> chain, ILookupCall<T> call, ITreeNode parent) {
            ((AbstractTreeBox)this.getOwner()).execPrepareLookup(call, parent);
        }

        @Override
        public void execFilterLookupResult(TreeBoxChains.TreeBoxFilterLookupResultChain<T> chain, ILookupCall<T> call, List<ILookupRow<T>> result) {
            ((AbstractTreeBox)this.getOwner()).execFilterLookupResult(call, result);
        }
    }

    protected class P_InternalTreeNode
    extends AbstractTreeNode {
        private boolean m_active;

        protected P_InternalTreeNode() {
        }

        public boolean isActive() {
            return this.m_active;
        }

        public void setActive(boolean b) {
            this.m_active = b;
        }

        @Override
        public void loadChildren() {
            if (AbstractTreeBox.this.isLoadIncremental()) {
                AbstractTreeBox.this.loadChildNodes(this);
            } else {
                this.setChildrenLoaded(true);
            }
        }
    }

    protected class P_TreeNodeBuilder
    extends AbstractTreeNodeBuilder<T> {
        protected P_TreeNodeBuilder() {
        }

        @Override
        protected ITreeNode createEmptyTreeNode() {
            return new P_InternalTreeNode();
        }

        @Override
        public ITreeNode createTreeNode(ILookupRow<T> lookupRow, int nodeStatus, boolean markChildrenLoaded) {
            P_InternalTreeNode treeNode = (P_InternalTreeNode)super.createTreeNode(lookupRow, nodeStatus, markChildrenLoaded);
            treeNode.setActive(lookupRow.isActive());
            return treeNode;
        }
    }

    @Order(value=1.0)
    @ClassId(value="5cfd2944-5dfd-4b66-ae45-419bb1b71378")
    public class TreeBoxFilterBox
    extends AbstractTreeBoxFilterBox {
        @Override
        protected ITreeBox getTreeBox() {
            return AbstractTreeBox.this;
        }
    }
}

