/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.treefield;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.client.dto.FormData;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.treefield.ITreeFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.treefield.TreeFieldChains;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.treefield.ITreeField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.visitor.DepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.IDepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.AbstractTreeFieldData;

@ClassId(value="bfbf00d0-b70a-48d4-8481-4faff294f37f")
@FormData(value=AbstractTreeFieldData.class, sdkCommand=FormData.SdkCommand.USE, defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.CREATE)
public abstract class AbstractTreeField
extends AbstractFormField
implements ITreeField {
    private ITree m_tree;
    private boolean m_treeExternallyManaged;
    private boolean m_autoExpandAll;
    private TreeListener m_treeListener;

    public AbstractTreeField() {
        this(true);
    }

    public AbstractTreeField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=190.0)
    protected boolean getConfiguredAutoLoad() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    protected boolean getConfiguredAutoExpandAll() {
        return false;
    }

    @Override
    protected double getConfiguredGridWeightY() {
        return 1.0;
    }

    @Override
    protected int getConfiguredGridH() {
        return 3;
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Collections.singletonList(this.getTree())});
    }

    @ConfigOperation
    @Order(value=190.0)
    protected void execSave(Collection<? extends ITreeNode> insertedNodes, Collection<? extends ITreeNode> updatedNodes, Collection<? extends ITreeNode> deletedNodes) {
    }

    @ConfigOperation
    @Order(value=200.0)
    protected void execLoadChildNodes(ITreeNode parentNode) {
    }

    @ConfigOperation
    @Order(value=210.0)
    protected void execSaveDeletedNode(ITreeNode row) {
    }

    @ConfigOperation
    @Order(value=220.0)
    protected void execSaveInsertedNode(ITreeNode row) {
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execSaveUpdatedNode(ITreeNode row) {
    }

    private Class<? extends ITree> getConfiguredTree() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List f = ConfigurationUtility.filterClasses((Class[])dca, ITree.class);
        if (f.size() == 1) {
            return (Class)CollectionUtility.firstElement((List)f);
        }
        for (Class c : f) {
            if (c.getDeclaringClass() == AbstractTreeField.class) continue;
            return c;
        }
        return null;
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) {
        try {
            this.loadRootNode();
        }
        catch (RuntimeException | PlatformError e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
        }
    }

    @Override
    protected void initConfig() {
        Class<? extends ITree> configuredTree;
        super.initConfig();
        this.setAutoExpandAll(this.getConfiguredAutoExpandAll());
        List contributedTrees = this.m_contributionHolder.getContributionsByClass(ITree.class);
        ITree tree = (ITree)CollectionUtility.firstElement((List)contributedTrees);
        if (tree == null && (configuredTree = this.getConfiguredTree()) != null) {
            tree = (ITree)ConfigurationUtility.newInnerInstance((Object)this, configuredTree);
        }
        this.setTreeInternal(tree);
    }

    @Override
    protected void disposeChildren(List<? extends IWidget> widgetsToDispose) {
        if (this.m_treeExternallyManaged) {
            widgetsToDispose.remove(this.getTree());
        }
        super.disposeChildren(widgetsToDispose);
    }

    @Override
    protected void initChildren(List<? extends IWidget> widgets) {
        if (this.m_treeExternallyManaged) {
            widgets.remove(this.getTree());
        }
        super.initChildren(widgets);
    }

    @Override
    public void exportFormFieldData(AbstractFormFieldData target) {
        AbstractTreeFieldData treeFieldData = (AbstractTreeFieldData)target;
        if (this.m_tree != null) {
            this.m_tree.exportTreeData(treeFieldData);
        }
    }

    @Override
    public void importFormFieldData(AbstractFormFieldData source, boolean valueChangeTriggersEnabled) {
        Assertions.assertNotNull((Object)source);
        AbstractTreeFieldData treeFieldData = (AbstractTreeFieldData)source;
        if (treeFieldData.isValueSet() && this.m_tree != null) {
            try {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(false);
                }
                this.m_tree.importTreeData(treeFieldData);
            }
            finally {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(true);
                }
            }
        }
    }

    @Override
    public final ITree getTree() {
        return this.m_tree;
    }

    @Override
    public final void setTree(ITree tree, boolean externallyManaged) {
        this.m_treeExternallyManaged = externallyManaged;
        this.setTreeInternal(tree);
    }

    private void setTreeInternal(ITree tree) {
        boolean changed;
        if (this.m_tree == tree) {
            return;
        }
        if (this.m_tree instanceof AbstractTree) {
            ((AbstractTree)this.m_tree).setParentInternal(null);
        }
        if (this.m_tree != null && !this.m_treeExternallyManaged && this.m_treeListener != null) {
            this.m_tree.removeTreeListener(this.m_treeListener, new Integer[0]);
            this.m_treeListener = null;
        }
        this.m_tree = tree;
        if (this.m_tree instanceof AbstractTree) {
            ((AbstractTree)this.m_tree).setParentInternal(this);
        }
        if (this.m_tree != null && !this.m_treeExternallyManaged) {
            this.m_tree.setAutoDiscardOnDelete(false);
            this.m_treeListener = e -> {
                this.checkSaveNeeded();
                this.checkEmpty();
            };
            this.m_tree.addTreeListener(this.m_treeListener, 30, 10, 20, 870);
        }
        if ((changed = this.propertySupport.setProperty("tree", (Object)this.m_tree)) && this.getForm() != null) {
            this.getForm().structureChanged(this);
        }
    }

    public boolean isAutoExpandAll() {
        return this.m_autoExpandAll;
    }

    public void setAutoExpandAll(boolean b) {
        this.m_autoExpandAll = b;
    }

    @Override
    public boolean isContentValid() {
        ITree tree;
        boolean b = super.isContentValid();
        if (b && this.isMandatory() && ((tree = this.getTree()) == null || tree.getRootNode() == null)) {
            return false;
        }
        return b;
    }

    @Override
    public void loadRootNode() {
        if (this.m_tree != null && !this.m_treeExternallyManaged) {
            this.loadChildNodes(this.m_tree.getRootNode());
        }
    }

    @Override
    public void loadChildNodes(ITreeNode parentNode) {
        if (this.m_tree != null && !this.m_treeExternallyManaged) {
            try {
                this.m_tree.setTreeChanging(true);
                this.interceptLoadChildNodes(parentNode);
            }
            finally {
                this.m_tree.setTreeChanging(false);
            }
        }
    }

    public ITreeNode createTreeNode() {
        P_InternalTreeNode node = new P_InternalTreeNode();
        return node;
    }

    @Override
    protected boolean execIsSaveNeeded() {
        boolean saveNeeded = super.execIsSaveNeeded();
        if (saveNeeded) {
            return true;
        }
        if (this.m_tree == null) {
            return false;
        }
        return this.m_tree.getDeletedNodeCount() > 0 || this.m_tree.getInsertedNodeCount() > 0 || this.m_tree.getUpdatedNodeCount() > 0;
    }

    @Override
    protected void execMarkSaved() {
        if (this.m_tree != null && !this.m_treeExternallyManaged) {
            try {
                this.m_tree.setTreeChanging(true);
                DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

                    public TreeVisitResult preVisit(ITreeNode node, int level, int index) {
                        if (!node.isStatusNonchanged()) {
                            node.setStatusInternal(0);
                            AbstractTreeField.this.m_tree.updateNode(node);
                        }
                        return TreeVisitResult.CONTINUE;
                    }
                };
                this.m_tree.visitNode(this.m_tree.getRootNode(), (IDepthFirstTreeVisitor<ITreeNode>)v);
                this.m_tree.clearDeletedNodes();
            }
            finally {
                this.m_tree.setTreeChanging(false);
            }
        }
    }

    @Override
    protected boolean execIsEmpty() {
        if (!super.execIsEmpty()) {
            return false;
        }
        return this.m_tree == null || !(this.m_tree.isRootNodeVisible() ? this.m_tree.getRootNode() != null : this.m_tree.getRootNode() != null && this.m_tree.getRootNode().getChildNodeCount() > 0);
    }

    @Override
    public void doSave() {
        if (this.m_tree != null && !this.m_treeExternallyManaged) {
            try {
                this.m_tree.setTreeChanging(true);
                this.interceptSave(this.m_tree.getInsertedNodes(), this.m_tree.getUpdatedNodes(), this.m_tree.getDeletedNodes());
                for (ITreeNode iTreeNode : this.m_tree.getDeletedNodes()) {
                    this.interceptSaveDeletedNode(iTreeNode);
                }
                this.m_tree.clearDeletedNodes();
                for (ITreeNode insertedNode : this.m_tree.getInsertedNodes()) {
                    this.interceptSaveInsertedNode(insertedNode);
                    insertedNode.setStatusInternal(0);
                    this.m_tree.updateNode(insertedNode);
                }
                for (ITreeNode updatedNode : this.m_tree.getUpdatedNodes()) {
                    this.interceptSaveUpdatedNode(updatedNode);
                    updatedNode.setStatusInternal(0);
                    this.m_tree.updateNode(updatedNode);
                }
            }
            finally {
                this.m_tree.setTreeChanging(false);
            }
        }
        this.markSaved();
    }

    protected ITreeFieldExtension<? extends AbstractTreeField> createLocalExtension() {
        return new LocalTreeFieldExtension<AbstractTreeField>(this);
    }

    protected final void interceptSave(Collection<? extends ITreeNode> insertedNodes, Collection<? extends ITreeNode> updatedNodes, Collection<? extends ITreeNode> deletedNodes) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TreeFieldChains.TreeFieldSaveChain chain = new TreeFieldChains.TreeFieldSaveChain(extensions);
        chain.execSave(insertedNodes, updatedNodes, deletedNodes);
    }

    protected final void interceptSaveDeletedNode(ITreeNode row) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TreeFieldChains.TreeFieldSaveDeletedNodeChain chain = new TreeFieldChains.TreeFieldSaveDeletedNodeChain(extensions);
        chain.execSaveDeletedNode(row);
    }

    protected final void interceptSaveUpdatedNode(ITreeNode row) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TreeFieldChains.TreeFieldSaveUpdatedNodeChain chain = new TreeFieldChains.TreeFieldSaveUpdatedNodeChain(extensions);
        chain.execSaveUpdatedNode(row);
    }

    protected final void interceptLoadChildNodes(ITreeNode parentNode) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TreeFieldChains.TreeFieldLoadChildNodesChain chain = new TreeFieldChains.TreeFieldLoadChildNodesChain(extensions);
        chain.execLoadChildNodes(parentNode);
    }

    protected final void interceptSaveInsertedNode(ITreeNode row) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TreeFieldChains.TreeFieldSaveInsertedNodeChain chain = new TreeFieldChains.TreeFieldSaveInsertedNodeChain(extensions);
        chain.execSaveInsertedNode(row);
    }

    protected static class LocalTreeFieldExtension<OWNER extends AbstractTreeField>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements ITreeFieldExtension<OWNER> {
        public LocalTreeFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execSave(TreeFieldChains.TreeFieldSaveChain chain, Collection<? extends ITreeNode> insertedNodes, Collection<? extends ITreeNode> updatedNodes, Collection<? extends ITreeNode> deletedNodes) {
            ((AbstractTreeField)this.getOwner()).execSave(insertedNodes, updatedNodes, deletedNodes);
        }

        @Override
        public void execSaveDeletedNode(TreeFieldChains.TreeFieldSaveDeletedNodeChain chain, ITreeNode row) {
            ((AbstractTreeField)this.getOwner()).execSaveDeletedNode(row);
        }

        @Override
        public void execSaveUpdatedNode(TreeFieldChains.TreeFieldSaveUpdatedNodeChain chain, ITreeNode row) {
            ((AbstractTreeField)this.getOwner()).execSaveUpdatedNode(row);
        }

        @Override
        public void execLoadChildNodes(TreeFieldChains.TreeFieldLoadChildNodesChain chain, ITreeNode parentNode) {
            ((AbstractTreeField)this.getOwner()).execLoadChildNodes(parentNode);
        }

        @Override
        public void execSaveInsertedNode(TreeFieldChains.TreeFieldSaveInsertedNodeChain chain, ITreeNode row) {
            ((AbstractTreeField)this.getOwner()).execSaveInsertedNode(row);
        }
    }

    private class P_InternalTreeNode
    extends AbstractTreeNode {
        private P_InternalTreeNode() {
        }

        @Override
        public void loadChildren() {
            AbstractTreeField.this.loadChildNodes(this);
        }
    }
}

