/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.wrappedform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.wrappedform.IWrappedFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.wrappedform.WrappedFormFieldChains;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.wrappedform.IWrappedFormField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.w3c.dom.Element;

@ClassId(value="535cfd11-39cf-4804-beef-2bc1bc3d34cc")
public abstract class AbstractWrappedFormField<FORM extends IForm>
extends AbstractFormField
implements IWrappedFormField<FORM> {
    private FORM m_innerForm;
    private boolean m_manageInnerFormLifeCycle;
    private P_InnerFormPropertyChangeListener m_innerFormPropertyListener;
    private P_InnerFormSubtreePropertyChangeListener m_innerFormSubtreePropertyListener;
    private P_InnerFormListener m_innerFormListener;

    public AbstractWrappedFormField() {
        this(true);
    }

    public AbstractWrappedFormField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected boolean getConfiguredLabelVisible() {
        return false;
    }

    @Override
    protected boolean getConfiguredStatusVisible() {
        return false;
    }

    @Override
    protected void setFormOnChildren(IForm form) {
    }

    @ConfigProperty(value="FORM")
    @Order(value=200.0)
    protected Class<? extends IForm> getConfiguredInnerForm() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=210.0)
    protected boolean getConfiguredInitialFocusEnabled() {
        return false;
    }

    @Override
    protected double getConfiguredGridWeightY() {
        return 1.0;
    }

    @Override
    protected boolean getConfiguredGridUseUiHeight() {
        return true;
    }

    @Override
    protected boolean execIsSaveNeeded() {
        boolean saveNeeded = super.execIsSaveNeeded();
        if (saveNeeded) {
            return true;
        }
        return this.getInnerForm() != null && this.getInnerForm().isSaveNeeded();
    }

    @Override
    protected void execMarkSaved() {
        if (this.getInnerForm() != null) {
            this.getInnerForm().markSaved();
        }
    }

    @Override
    protected boolean execIsEmpty() {
        if (this.getInnerForm() != null) {
            return this.getInnerForm().isEmpty();
        }
        return super.execIsEmpty();
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_innerFormPropertyListener = new P_InnerFormPropertyChangeListener();
        this.m_innerFormSubtreePropertyListener = new P_InnerFormSubtreePropertyChangeListener();
        this.m_innerFormListener = new P_InnerFormListener();
        this.setInitialFocusEnabled(this.getConfiguredInitialFocusEnabled());
        if (this.getConfiguredInnerForm() != null) {
            try {
                this.setInnerForm((FORM)this.getConfiguredInnerForm().getConstructor(new Class[0]).newInstance(new Object[0]), true);
            }
            catch (Exception e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating instance of class '" + this.getConfiguredInnerForm().getName() + "'.", new Object[]{e}));
            }
        }
    }

    @Override
    protected void disposeChildren(List<? extends IWidget> widgetsToDispose) {
        widgetsToDispose.remove(this.getInnerForm());
        super.disposeChildren(widgetsToDispose);
    }

    @Override
    protected void initChildren(List<? extends IWidget> widgets) {
        widgets.remove(this.getInnerForm());
        super.initChildren(widgets);
    }

    @Override
    protected void disposeFieldInternal() {
        this.uninstallInnerForm();
        super.disposeFieldInternal();
    }

    @Override
    public final FORM getInnerForm() {
        return this.m_innerForm;
    }

    @Override
    public void setInnerForm(FORM form) {
        this.setInnerForm(form, true);
    }

    @Override
    public void setInnerForm(FORM form, boolean manageFormLifeCycle) {
        if (this.m_innerForm == form) {
            return;
        }
        FORM oldInnerForm = this.m_innerForm;
        this.uninstallInnerForm();
        this.m_innerForm = form;
        this.m_manageInnerFormLifeCycle = manageFormLifeCycle;
        this.installInnerForm();
        this.propertySupport.setProperty("innerForm", this.m_innerForm);
        this.calculateVisibleInternal();
        this.checkSaveNeeded();
        this.checkEmpty();
        if (this.m_innerForm != null) {
            this.fireSubtreePropertyChange(new PropertyChangeEvent(this.m_innerForm.getRootGroupBox(), "parentWidget", null, null));
            if (this.m_manageInnerFormLifeCycle && this.m_innerForm.isFormStartable()) {
                this.m_innerForm.start();
            }
        }
        if (this.getForm() != null) {
            this.getForm().structureChanged(this);
        }
        this.interceptInnerFormChanged(oldInnerForm, this.m_innerForm);
    }

    @Override
    public boolean isManageInnerFormLifeCycle() {
        return this.m_manageInnerFormLifeCycle;
    }

    @Override
    public boolean isInitialFocusEnabled() {
        return this.propertySupport.getPropertyBool("initialFocusEnabled");
    }

    @Override
    public void setInitialFocusEnabled(boolean initialFocusEnabled) {
        this.propertySupport.setPropertyBool("initialFocusEnabled", initialFocusEnabled);
    }

    protected void installInnerForm() {
        if (this.m_innerForm == null) {
            return;
        }
        this.m_innerForm.setShowOnStart(false);
        this.m_innerForm.setParentInternal(this);
        this.m_innerForm.getRootGroupBox().setBorderVisible(false);
        this.m_innerForm.getRootGroupBox().updateKeyStrokes();
        this.m_innerForm.addPropertyChangeListener((PropertyChangeListener)this.m_innerFormPropertyListener);
        this.m_innerForm.getRootGroupBox().addSubtreePropertyChangeListener(this.m_innerFormSubtreePropertyListener);
        this.m_innerForm.addFormListener(this.m_innerFormListener, new Integer[0]);
    }

    protected void uninstallInnerForm() {
        if (this.m_innerForm == null) {
            return;
        }
        this.fireSubtreePropertyChange(new PropertyChangeEvent(this.m_innerForm.getRootGroupBox(), "parentWidget", null, null));
        this.m_innerForm.removePropertyChangeListener((PropertyChangeListener)this.m_innerFormPropertyListener);
        this.m_innerForm.getRootGroupBox().removeSubtreePropertyChangeListener(this.m_innerFormSubtreePropertyListener);
        this.m_innerForm.removeFormListener(this.m_innerFormListener, new Integer[0]);
        this.m_innerForm.setParentInternal(null);
        if (this.m_manageInnerFormLifeCycle && !this.m_innerForm.isFormClosed()) {
            this.m_innerForm.doClose();
        }
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Collections.singletonList(this.getInnerForm())});
    }

    @Override
    public void loadFromXml(Element x) {
        super.loadFromXml(x);
        if (this.getInnerForm() != null) {
            this.getInnerForm().loadFromXml(x);
        }
    }

    @Override
    public void storeToXml(Element x) {
        super.storeToXml(x);
        if (this.getInnerForm() != null) {
            this.getInnerForm().storeToXml(x);
        }
    }

    protected void handleFieldVisibilityChanged() {
        this.calculateVisibleInternal();
    }

    @ConfigOperation
    protected void execInnerFormChanged(FORM oldInnerForm, FORM newInnerForm) {
    }

    protected final void interceptInnerFormChanged(FORM oldInnerForm, FORM newInnerForm) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        WrappedFormFieldChains.WrappedFormFieldInnerFormChangedChain<FORM> chain = new WrappedFormFieldChains.WrappedFormFieldInnerFormChangedChain<FORM>(extensions);
        chain.execInnerFormChanged(oldInnerForm, newInnerForm);
    }

    protected IWrappedFormFieldExtension<FORM, ? extends AbstractWrappedFormField<FORM>> createLocalExtension() {
        return new LocalWrappedFormFieldExtension(this);
    }

    protected static class LocalWrappedFormFieldExtension<FORM extends IForm, OWNER extends AbstractWrappedFormField<FORM>>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements IWrappedFormFieldExtension<FORM, OWNER> {
        public LocalWrappedFormFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execInnerFormChanged(WrappedFormFieldChains.WrappedFormFieldInnerFormChangedChain<FORM> chain, FORM oldInnerForm, FORM newInnerForm) {
            ((AbstractWrappedFormField)this.getOwner()).execInnerFormChanged(oldInnerForm, newInnerForm);
        }
    }

    private class P_InnerFormListener
    implements FormListener {
        private P_InnerFormListener() {
        }

        @Override
        public void formChanged(FormEvent e) {
            if (e.getType() == 3010 && AbstractWrappedFormField.this.m_manageInnerFormLifeCycle) {
                AbstractWrappedFormField.this.setInnerForm(null, true);
            } else if (e.getType() == 1020 && !AbstractWrappedFormField.this.m_manageInnerFormLifeCycle) {
                AbstractWrappedFormField.this.propertySupport.setPropertyAlwaysFire("innerForm", (Object)AbstractWrappedFormField.this.m_innerForm);
            }
        }
    }

    private class P_InnerFormPropertyChangeListener
    implements PropertyChangeListener {
        private P_InnerFormPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("visible")) {
                AbstractWrappedFormField.this.handleFieldVisibilityChanged();
            } else if (e.getPropertyName().equals("saveNeeded")) {
                AbstractWrappedFormField.this.checkSaveNeeded();
            } else if (e.getPropertyName().equals("empty")) {
                AbstractWrappedFormField.this.checkEmpty();
            }
        }
    }

    private class P_InnerFormSubtreePropertyChangeListener
    implements PropertyChangeListener {
        private P_InnerFormSubtreePropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            AbstractWrappedFormField.this.fireSubtreePropertyChange(e);
        }
    }
}

