/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.group;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.group.GroupChains;
import org.eclipse.scout.rt.client.extension.ui.group.IGroupExtension;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.group.IGroup;
import org.eclipse.scout.rt.client.ui.group.IGroupUIFacade;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.data.basic.NamedBitMaskHelper;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;

@ClassId(value="634c5f32-ca74-40a8-87cf-571e93ae3f64")
public abstract class AbstractGroup
extends AbstractWidget
implements IGroup {
    private static final NamedBitMaskHelper VISIBLE_BIT_HELPER = new NamedBitMaskHelper(new String[]{"VISIBLE", "VISIBLE_GRANTED"});
    private IGroupUIFacade m_uiFacade;
    private final ObjectExtensions<AbstractGroup, IGroupExtension<? extends AbstractGroup>> m_objectExtensions;
    protected ContributionComposite m_contributionHolder;
    private byte m_visible = (byte)-1;

    public AbstractGroup() {
        this(true);
    }

    public AbstractGroup(boolean callInitializer) {
        super(false);
        this.m_objectExtensions = new ObjectExtensions((Object)this, false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    protected void initConfigInternal() {
        this.m_objectExtensions.initConfigAndBackupExtensionContext(this.createLocalExtension(), this::initConfig);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        this.m_contributionHolder = new ContributionComposite((Object)this);
        this.setOrder(this.calculateViewOrder());
        this.setCollapsed(this.getConfiguredCollapsed());
        this.setCollapsible(this.getConfiguredCollapsible());
        this.setCollapseStyle(this.getConfiguredCollapseStyle());
        this.setTitle(this.getConfiguredTitle());
        this.setVisible(this.getConfiguredVisible());
        this.setHeader(this.createHeader());
        this.setHeaderFocusable(this.getConfiguredHeaderFocusable());
        this.setHeaderVisible(this.getConfiguredHeaderVisible());
        this.setBody(this.createBody());
    }

    @Override
    protected final void initInternal() {
        super.initInternal();
        try {
            this.initGroupInternal();
            this.interceptInitGroup();
        }
        catch (Exception e) {
            this.handleInitException(e);
        }
    }

    protected void initGroupInternal() {
        Assertions.assertNotNull((Object)this.getParent(), (String)"Group is not connected to a container", (Object[])new Object[0]);
    }

    protected void handleInitException(Exception exception) {
        throw new PlatformException("Exception occurred while initializing group", new Object[]{exception});
    }

    protected void execInitGroup() {
    }

    @Override
    protected final void disposeInternal() {
        this.interceptDisposeGroup();
        super.disposeInternal();
    }

    protected void execDisposeGroup() {
    }

    protected double calculateViewOrder() {
        double viewOrder = this.getConfiguredViewOrder();
        Class<?> cls = this.getClass();
        if (viewOrder == 9.876543212345678E16) {
            while (cls != null && IGroup.class.isAssignableFrom(cls)) {
                if (cls.isAnnotationPresent(Order.class)) {
                    Order order = cls.getAnnotation(Order.class);
                    return order.value();
                }
                cls = cls.getSuperclass();
            }
        }
        return viewOrder;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=80.0)
    protected double getConfiguredViewOrder() {
        return 9.876543212345678E16;
    }

    public double getOrder() {
        return this.propertySupport.getPropertyDouble("order");
    }

    public void setOrder(double order) {
        this.propertySupport.setPropertyDouble("order", order);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    protected boolean getConfiguredCollapsed() {
        return false;
    }

    @Override
    public void setCollapsed(boolean collapsed) {
        this.propertySupport.setPropertyBool("collapsed", collapsed);
    }

    @Override
    public boolean isCollapsed() {
        return this.propertySupport.getPropertyBool("collapsed");
    }

    @Override
    public void toggleCollapse() {
        this.setCollapsed(!this.isCollapsed());
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=82.0)
    protected boolean getConfiguredCollapsible() {
        return true;
    }

    @Override
    public void setCollapsible(boolean collapsible) {
        this.propertySupport.setPropertyBool("collapsible", collapsible);
    }

    @Override
    public boolean isCollapsible() {
        return this.propertySupport.getPropertyBool("collapsible");
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=85.0)
    protected String getConfiguredCollapseStyle() {
        return "left";
    }

    @Override
    public void setCollapseStyle(String collapseStyle) {
        this.propertySupport.setPropertyString("collapseStyle", collapseStyle);
    }

    @Override
    public String getCollapseStyle() {
        return this.propertySupport.getPropertyString("collapseStyle");
    }

    @ConfigProperty(value="STRING")
    @Order(value=90.0)
    protected String getConfiguredTitle() {
        return null;
    }

    @Override
    public void setTitle(String title) {
        this.propertySupport.setPropertyString("title", title);
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitleSuffix(String suffix) {
        this.propertySupport.setPropertyString("titleSuffix", suffix);
    }

    @Override
    public String getTitleSuffix() {
        return this.propertySupport.getPropertyString("titleSuffix");
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=95.0)
    protected boolean getConfiguredVisible() {
        return true;
    }

    @Override
    public boolean isVisibleGranted() {
        return this.isVisible("VISIBLE_GRANTED");
    }

    @Override
    public void setVisibleGranted(boolean visible) {
        this.setVisible(visible, "VISIBLE_GRANTED");
    }

    @Override
    public boolean isVisible() {
        return this.propertySupport.getPropertyBool("visible");
    }

    @Override
    public void setVisible(boolean b) {
        this.setVisible(b, "VISIBLE");
    }

    public void setVisible(boolean visible, String dimension) {
        this.m_visible = VISIBLE_BIT_HELPER.changeBit(dimension, visible, this.m_visible);
        this.calculateVisible();
    }

    public boolean isVisible(String dimension) {
        return VISIBLE_BIT_HELPER.isBitSet(dimension, this.m_visible);
    }

    private void calculateVisible() {
        this.propertySupport.setPropertyBool("visible", NamedBitMaskHelper.allBitsSet((byte)this.m_visible));
    }

    protected IWidget createHeader() {
        Class<? extends IWidget> configuredHeader = this.getConfiguredHeader();
        if (configuredHeader != null) {
            return (IWidget)ConfigurationUtility.newInnerInstance((Object)this, configuredHeader);
        }
        return null;
    }

    protected Class<? extends IWidget> getConfiguredHeader() {
        return null;
    }

    @Override
    public void setHeader(IWidget header) {
        this.propertySupport.setProperty("header", (Object)header);
    }

    @Override
    public IWidget getHeader() {
        return (IWidget)this.propertySupport.getProperty("header");
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=110.0)
    protected boolean getConfiguredHeaderFocusable() {
        return false;
    }

    @Override
    public void setHeaderFocusable(boolean headerFocusable) {
        this.propertySupport.setPropertyBool("headerFocusable", headerFocusable);
    }

    @Override
    public boolean isHeaderFocusable() {
        return this.propertySupport.getPropertyBool("headerFocusable");
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredHeaderVisible() {
        return true;
    }

    @Override
    public void setHeaderVisible(boolean headerVisible) {
        this.propertySupport.setPropertyBool("headerVisible", headerVisible);
    }

    @Override
    public boolean isHeaderVisible() {
        return this.propertySupport.getPropertyBool("headerVisible");
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Arrays.asList(this.getHeader(), this.getBody())});
    }

    protected IWidget createBody() {
        List contributedFields = this.m_contributionHolder.getContributionsByClass(IWidget.class);
        IWidget result = (IWidget)CollectionUtility.firstElement((List)contributedFields);
        if (result != null) {
            return result;
        }
        Class<? extends IWidget> configuredBody = this.getConfiguredBody();
        if (configuredBody != null) {
            return (IWidget)ConfigurationUtility.newInnerInstance((Object)this, configuredBody);
        }
        return null;
    }

    protected Class<? extends IWidget> getConfiguredBody() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClass((Class[])dca, IWidget.class);
    }

    @Override
    public void setBody(IWidget body) {
        this.propertySupport.setProperty("body", (Object)body);
    }

    @Override
    public IWidget getBody() {
        return (IWidget)this.propertySupport.getProperty("body");
    }

    @Override
    public Object getGroupId() {
        return this.propertySupport.getProperty("groupId");
    }

    @Override
    public void setGroupId(Object groupId) {
        this.propertySupport.setProperty("groupId", groupId);
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String iconId) {
        this.propertySupport.setPropertyString("iconId", iconId);
    }

    @Override
    public String classId() {
        String simpleClassId = ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass(), (boolean)true);
        return String.valueOf(this.getParent().classId()) + "_" + simpleClassId;
    }

    public final List<? extends IGroupExtension<? extends AbstractGroup>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    public final <T> T optContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.optContribution(contribution);
    }

    protected final void interceptDisposeGroup() {
        List<? extends IGroupExtension<? extends AbstractGroup>> extensions = this.getAllExtensions();
        GroupChains.GroupDisposeGroupChain chain = new GroupChains.GroupDisposeGroupChain(extensions);
        chain.execDisposeGroup();
    }

    protected final void interceptInitGroup() {
        List<? extends IGroupExtension<? extends AbstractGroup>> extensions = this.getAllExtensions();
        GroupChains.GroupInitGroupChain chain = new GroupChains.GroupInitGroupChain(extensions);
        chain.execInitGroup();
    }

    protected IGroupExtension<? extends AbstractGroup> createLocalExtension() {
        return new LocalGroupExtension<AbstractGroup>(this);
    }

    @Override
    public IGroupUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected static class LocalGroupExtension<OWNER extends AbstractGroup>
    extends AbstractExtension<OWNER>
    implements IGroupExtension<OWNER> {
        public LocalGroupExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execDisposeGroup(GroupChains.GroupDisposeGroupChain chain) {
            ((AbstractGroup)this.getOwner()).execDisposeGroup();
        }

        @Override
        public void execInitGroup(GroupChains.GroupInitGroupChain chain) {
            ((AbstractGroup)this.getOwner()).execInitGroup();
        }
    }

    protected class P_UIFacade
    implements IGroupUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void setCollapsedFromUI(boolean collapsed) {
            AbstractGroup.this.setCollapsed(collapsed);
        }
    }
}

