/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.messagebox;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.EventObject;
import org.eclipse.scout.rt.client.ui.IModelEvent;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;

public class MessageBoxEvent
extends EventObject
implements IModelEvent {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_CLOSED = 900;
    private final int m_type;

    public MessageBoxEvent(IMessageBox mb, int type) {
        super(mb);
        this.m_type = type;
    }

    public IMessageBox getMessageBox() {
        return (IMessageBox)this.getSource();
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("MessageBoxEvent[");
        try {
            Field[] f;
            Field[] fieldArray = f = this.getClass().getDeclaredFields();
            int n = f.length;
            int n2 = 0;
            while (n2 < n) {
                Field aF = fieldArray[n2];
                if (Modifier.isPublic(aF.getModifiers()) && Modifier.isStatic(aF.getModifiers()) && aF.getName().startsWith("TYPE_") && ((Number)aF.get(null)).intValue() == this.m_type) {
                    buf.append(aF.getName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            buf.append("#").append(this.m_type);
        }
        if (this.getMessageBox() != null) {
            buf.append(" ").append(this.getMessageBox().getHeader());
        }
        buf.append("]");
        return buf.toString();
    }
}

