/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.popup;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.form.FormUtility;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.popup.AbstractPopup;
import org.eclipse.scout.rt.client.ui.popup.IWidgetPopup;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ClassId(value="4ec758a3-178f-4de9-bc56-a4f28f801df1")
public abstract class AbstractWidgetPopup<T extends IWidget>
extends AbstractPopup
implements IWidgetPopup<T> {
    private T m_widget;

    public AbstractWidgetPopup() {
        this(true);
    }

    public AbstractWidgetPopup(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setClosable(this.getConfiguredClosable());
        this.setMovable(this.getConfiguredMovable());
        this.setResizable(this.getConfiguredResizable());
        this.setWidget(this.createWidget());
        if (this.getWidget() instanceof ICompositeField) {
            FormUtility.rebuildFieldGrid((ICompositeField)this.getWidget());
        }
    }

    protected boolean getConfiguredClosable() {
        return false;
    }

    @Override
    public void setClosable(boolean closable) {
        this.propertySupport.setPropertyBool("closable", closable);
    }

    @Override
    public boolean isClosable() {
        return this.propertySupport.getPropertyBool("closable");
    }

    protected boolean getConfiguredMovable() {
        return false;
    }

    @Override
    public void setMovable(boolean movable) {
        this.propertySupport.setPropertyBool("movable", movable);
    }

    @Override
    public boolean isMovable() {
        return this.propertySupport.getPropertyBool("movable");
    }

    protected boolean getConfiguredResizable() {
        return false;
    }

    @Override
    public void setResizable(boolean enabled) {
        this.propertySupport.setPropertyBool("resizable", enabled);
    }

    @Override
    public boolean isResizable() {
        return this.propertySupport.getPropertyBool("resizable");
    }

    protected Class<T> getConfiguredWidget() {
        return null;
    }

    protected T createWidget() {
        Class<T> configuredWidget = this.getConfiguredWidget();
        if (configuredWidget != null) {
            return (T)((IWidget)ConfigurationUtility.newInnerInstance((Object)this, configuredWidget));
        }
        return null;
    }

    @Override
    public T getWidget() {
        return this.m_widget;
    }

    public void setWidget(T widget) {
        this.m_widget = widget;
    }

    @Override
    protected boolean getConfiguredAnimateOpening() {
        return true;
    }

    @Override
    protected boolean getConfiguredAnimateResize() {
        return true;
    }

    @Override
    public void open() {
        this.init();
        super.open();
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Collections.singletonList(this.getWidget())});
    }
}

