/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.tile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.extension.ui.tile.ITileGridExtension;
import org.eclipse.scout.rt.client.extension.ui.tile.TileGridChains;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.MouseButton;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITileGridContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.TileGridContextMenu;
import org.eclipse.scout.rt.client.ui.tile.ITile;
import org.eclipse.scout.rt.client.ui.tile.ITileFilter;
import org.eclipse.scout.rt.client.ui.tile.ITileGrid;
import org.eclipse.scout.rt.client.ui.tile.ITileGridUIFacade;
import org.eclipse.scout.rt.client.ui.tile.TileDataLoadManager;
import org.eclipse.scout.rt.client.ui.tile.TileGridEvent;
import org.eclipse.scout.rt.client.ui.tile.TileGridLayoutConfig;
import org.eclipse.scout.rt.client.ui.tile.TileGridListener;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;

@ClassId(value="c04e6cf7-fda0-4146-afea-6a0ff0a50c4b")
public abstract class AbstractTileGrid<T extends ITile>
extends AbstractWidget
implements ITileGrid<T> {
    private ITileGridUIFacade m_uiFacade;
    private final ObjectExtensions<AbstractTileGrid, ITileGridExtension<T, ? extends AbstractTileGrid>> m_objectExtensions = new ObjectExtensions((Object)this, false);
    private ContributionComposite m_contributionHolder;
    private List<ITileFilter<T>> m_filters = new ArrayList<ITileFilter<T>>();
    private boolean m_filteredTilesDirty = false;
    private Comparator<T> m_comparator;
    private final FastListenerList<TileGridListener> m_listenerList = new FastListenerList();

    public AbstractTileGrid() {
        this(true);
    }

    public AbstractTileGrid(boolean callInitializer) {
        super(false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    protected void initConfigInternal() {
        this.m_objectExtensions.initConfigAndBackupExtensionContext(this.createLocalExtension(), this::initConfig);
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), this.getTilesInternal(), this.getMenus()});
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(this.createUIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        this.m_contributionHolder = new ContributionComposite((Object)this);
        this.setGridColumnCount(this.getConfiguredGridColumnCount());
        this.setLogicalGrid(this.getConfiguredLogicalGrid());
        this.setLayoutConfig(this.getConfiguredLayoutConfig());
        this.setMultiSelect(this.getConfiguredMultiSelect());
        this.setSelectable(this.getConfiguredSelectable());
        this.setScrollable(this.getConfiguredScrollable());
        this.setWithPlaceholders(this.getConfiguredWithPlaceholders());
        this.setVirtual(this.getConfiguredVirtual());
        this.setAnimateTileRemoval(this.getConfiguredAnimateTileRemoval());
        this.setAnimateTileInsertion(this.getConfiguredAnimateTileInsertion());
        OrderedCollection tiles = new OrderedCollection();
        this.injectTilesInternal(tiles);
        this.setSelectedTiles(new ArrayList());
        this.setFilteredTiles(new ArrayList());
        this.setTiles(tiles.getOrderedList());
        this.initMenus();
        this.addPropertyChangeListener(new P_PropertyChangeListener());
    }

    protected void initMenus() {
        List<Class<IMenu>> ma = this.getDeclaredMenus();
        OrderedCollection menus = new OrderedCollection();
        for (Class<IMenu> clazz : ma) {
            IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, clazz);
            menus.addOrdered((IOrdered)menu);
        }
        List contributedMenus = this.m_contributionHolder.getContributionsByClass(IMenu.class);
        menus.addAllOrdered((Collection)contributedMenus);
        this.injectMenusInternal((OrderedCollection<IMenu>)menus);
        new MoveActionNodesHandler(menus).moveModelObjects();
        this.setContextMenu(new TileGridContextMenu(this, (List<? extends IMenu>)menus.getOrderedList()));
    }

    protected void injectTilesInternal(OrderedCollection<T> tiles) {
        List<Class<ITile>> tileClasses = this.getConfiguredTiles();
        for (Class<ITile> tileClass : tileClasses) {
            T tile = this.createTileInternal(tileClass);
            if (tile == null) continue;
            tiles.addOrdered(tile);
        }
    }

    protected T createTileInternal(Class<? extends ITile> tileClass) {
        return (T)((ITile)ConfigurationUtility.newInnerInstance((Object)this, tileClass));
    }

    protected List<Class<? extends ITile>> getConfiguredTiles() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, ITile.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    @Override
    public void setMenus(List<? extends IMenu> menus) {
        this.getContextMenu().setChildActions(menus);
    }

    protected void setContextMenu(ITileGridContextMenu contextMenu) {
        this.propertySupport.setProperty("contextMenus", (Object)contextMenu);
    }

    @Override
    public ITileGridContextMenu getContextMenu() {
        return (ITileGridContextMenu)this.propertySupport.getProperty("contextMenus");
    }

    @Override
    public List<IMenu> getMenus() {
        return this.getContextMenu().getChildActions();
    }

    public <M extends IMenu> M getMenuByClass(Class<M> menuType) {
        return MenuUtility.getMenuByClass(this, menuType);
    }

    protected ITileGridUIFacade createUIFacade() {
        return new P_TileGridUIFacade();
    }

    @Override
    public ITileGridUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=5.0)
    protected int getConfiguredGridColumnCount() {
        return 4;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=8.0)
    protected String getConfiguredLogicalGrid() {
        return "HorizontalGrid";
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=10.0)
    protected TileGridLayoutConfig getConfiguredLayoutConfig() {
        return new TileGridLayoutConfig();
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    protected boolean getConfiguredWithPlaceholders() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=40.0)
    protected boolean getConfiguredSelectable() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=50.0)
    protected boolean getConfiguredMultiSelect() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=60.0)
    protected boolean getConfiguredScrollable() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=37.0)
    protected boolean getConfiguredVirtual() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    protected boolean getConfiguredAnimateTileRemoval() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    protected boolean getConfiguredAnimateTileInsertion() {
        return true;
    }

    @Override
    public void setComparator(Comparator<T> comparator) {
        this.setComparator(comparator, true);
    }

    @Override
    public void setComparator(Comparator<T> comparator, boolean sortNow) {
        if (this.m_comparator == comparator) {
            return;
        }
        this.m_comparator = comparator;
        if (sortNow) {
            this.sort();
        }
    }

    @Override
    public Comparator<T> getComparator() {
        return this.m_comparator;
    }

    @Override
    public void sort() {
        if (this.m_comparator == null) {
            return;
        }
        List<T> tiles = this.getTiles();
        this.sortInternal(tiles);
        this.setTilesInternal(tiles);
        this.m_filteredTilesDirty = true;
        this.applyFilters(new ArrayList());
    }

    public void sortInternal(List<T> tiles) {
        if (this.m_comparator == null) {
            return;
        }
        tiles.sort(this.m_comparator);
    }

    @Override
    public List<T> getTiles() {
        return CollectionUtility.arrayList((Collection)this.propertySupport.getPropertyList("tiles"));
    }

    @Override
    public int getTileCount() {
        return this.getTilesInternal().size();
    }

    public List<T> getTilesInternal() {
        return this.propertySupport.getPropertyList("tiles");
    }

    @Override
    public void setTiles(List<T> tiles) {
        if (CollectionUtility.equalsCollection(this.getTilesInternal(), tiles, (boolean)true)) {
            return;
        }
        List existingTiles = (List)ObjectUtility.nvl(this.getTilesInternal(), new ArrayList());
        tiles = (List)ObjectUtility.nvl(tiles, new ArrayList());
        ArrayList tilesToDelete = new ArrayList(existingTiles);
        tilesToDelete.removeAll(tiles);
        this.deleteTilesInternal(tilesToDelete);
        this.deselectTiles(tilesToDelete);
        ArrayList tilesToInsert = new ArrayList(tiles);
        tilesToInsert.removeAll(existingTiles);
        this.addTilesInternal(tilesToInsert);
        this.sortInternal(tiles);
        this.setTilesInternal(tiles);
        this.m_filteredTilesDirty = true;
        this.applyFilters(tilesToInsert);
    }

    protected void deleteTilesInternal(List<T> tilesToDelete) {
        for (ITile tile : tilesToDelete) {
            this.deleteTileInternal(tile);
        }
    }

    protected void deleteTileInternal(T tile) {
        tile.dispose();
    }

    protected void addTilesInternal(List<T> tilesToInsert) {
        for (ITile tile : tilesToInsert) {
            this.addTileInternal(tile);
        }
        if (this.isInitConfigDone()) {
            for (ITile tile : tilesToInsert) {
                tile.init();
            }
        }
    }

    protected void addTileInternal(T tile) {
        tile.setParentInternal(this);
        tile.setFilterAccepted(true);
    }

    protected void setTilesInternal(List<T> tiles) {
        this.propertySupport.setPropertyList("tiles", tiles);
    }

    @Override
    public void addTiles(List<T> tilesToAdd) {
        ArrayList<T> tiles = new ArrayList<T>(this.getTilesInternal());
        tiles.addAll(tilesToAdd);
        this.setTiles(tiles);
    }

    @Override
    public void addTile(T tile) {
        this.addTiles(CollectionUtility.arrayList(tile));
    }

    @Override
    public void deleteTiles(List<T> tilesToDelete) {
        ArrayList<T> tiles = new ArrayList<T>(this.getTilesInternal());
        tiles.removeAll(tilesToDelete);
        this.setTiles(tiles);
    }

    @Override
    public void deleteTile(T tile) {
        this.deleteTiles(CollectionUtility.arrayList(tile));
    }

    @Override
    public void deleteAllTiles() {
        this.setTiles(new ArrayList());
    }

    @Override
    public int getGridColumnCount() {
        return this.propertySupport.getPropertyInt("gridColumnCount");
    }

    @Override
    public void setGridColumnCount(int gridColumnCount) {
        this.propertySupport.setPropertyInt("gridColumnCount", gridColumnCount);
    }

    @Override
    public boolean isWithPlaceholders() {
        return this.propertySupport.getPropertyBool("withPlaceholders");
    }

    @Override
    public void setWithPlaceholders(boolean withPlaceholders) {
        this.propertySupport.setPropertyBool("withPlaceholders", withPlaceholders);
    }

    @Override
    public boolean isSelectable() {
        return this.propertySupport.getPropertyBool("selectable");
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.propertySupport.setPropertyBool("selectable", selectable);
    }

    @Override
    public boolean isMultiSelect() {
        return this.propertySupport.getPropertyBool("multiSelect");
    }

    @Override
    public void setMultiSelect(boolean multiSelect) {
        this.propertySupport.setPropertyBool("multiSelect", multiSelect);
    }

    @Override
    public boolean isScrollable() {
        return this.propertySupport.getPropertyBool("scrollable");
    }

    @Override
    public void setScrollable(boolean scrollable) {
        this.propertySupport.setPropertyBool("scrollable", scrollable);
    }

    @Override
    public String getLogicalGrid() {
        return this.propertySupport.getPropertyString("logicalGrid");
    }

    @Override
    public void setLogicalGrid(String logicalGrid) {
        this.propertySupport.setPropertyString("logicalGrid", logicalGrid);
    }

    @Override
    public TileGridLayoutConfig getLayoutConfig() {
        return (TileGridLayoutConfig)this.propertySupport.getProperty("layoutConfig");
    }

    @Override
    public void setLayoutConfig(TileGridLayoutConfig layoutConfig) {
        this.propertySupport.setProperty("layoutConfig", (Object)layoutConfig);
    }

    @Override
    public boolean isVirtual() {
        return this.propertySupport.getPropertyBool("virtual");
    }

    @Override
    public void setVirtual(boolean virtual) {
        this.propertySupport.setPropertyBool("virtual", virtual);
    }

    @Override
    public boolean isAnimateTileRemoval() {
        return this.propertySupport.getPropertyBool("animateTileRemoval");
    }

    @Override
    public void setAnimateTileRemoval(boolean animateTileRemoval) {
        this.propertySupport.setPropertyBool("animateTileRemoval", animateTileRemoval);
    }

    @Override
    public boolean isAnimateTileInsertion() {
        return this.propertySupport.getPropertyBool("animateTileInsertion");
    }

    @Override
    public void setAnimateTileInsertion(boolean animateTileInsertion) {
        this.propertySupport.setPropertyBool("animateTileInsertion", animateTileInsertion);
    }

    @ConfigOperation
    @Order(value=100.0)
    protected void execTilesSelected(List<T> tiles) {
    }

    @ConfigOperation
    @Order(value=110.0)
    protected void execTileClick(T tile, MouseButton mouseButton) {
    }

    @ConfigOperation
    @Order(value=120.0)
    protected void execTileAction(T tile) {
    }

    @Override
    public void selectTiles(List<T> tiles) {
        if (!this.isSelectable()) {
            this.setSelectedTiles(new ArrayList());
            return;
        }
        List<T> newSelection = this.filterTiles(tiles);
        if (newSelection.size() > 1 && !this.isMultiSelect()) {
            ITile first = (ITile)newSelection.get(0);
            newSelection.clear();
            newSelection.add(first);
        }
        if (!CollectionUtility.equalsCollection(this.getSelectedTilesInternal(), newSelection, (boolean)false)) {
            this.setSelectedTiles(newSelection);
        }
    }

    @Override
    public void selectTile(T tile) {
        this.selectTiles(CollectionUtility.arrayList(tile));
    }

    @Override
    public void selectAllTiles() {
        this.selectTiles(this.getTilesInternal());
    }

    @Override
    public void deselectTiles(List<T> tiles) {
        List<T> selectedTiles = this.getSelectedTiles();
        boolean selectionChanged = selectedTiles.removeAll(tiles);
        if (selectionChanged) {
            this.selectTiles(selectedTiles);
        }
    }

    @Override
    public void deselectTile(T tile) {
        this.deselectTiles(CollectionUtility.arrayList(tile));
    }

    @Override
    public void deselectAllTiles() {
        this.selectTiles(new ArrayList());
    }

    @Override
    public List<T> getSelectedTiles() {
        return CollectionUtility.arrayList((Collection)this.propertySupport.getPropertyList("selectedTiles"));
    }

    public List<T> getSelectedTilesInternal() {
        return this.propertySupport.getPropertyList("selectedTiles");
    }

    @Override
    public int getSelectedTileCount() {
        return this.getSelectedTilesInternal().size();
    }

    protected void setSelectedTiles(List<T> tiles) {
        this.propertySupport.setPropertyList("selectedTiles", tiles);
    }

    @Override
    public T getSelectedTile() {
        if (this.getSelectedTileCount() == 0) {
            return null;
        }
        return (T)((ITile)this.getSelectedTiles().get(0));
    }

    @Override
    public T getTileByClass(Class<T> tileClass) {
        ITile candidate = null;
        for (ITile tile : this.getTilesInternal()) {
            if (tile.getClass() == tileClass) {
                return (T)((ITile)tileClass.cast(tile));
            }
            if (candidate != null || !tileClass.isInstance(tile)) continue;
            candidate = (ITile)tileClass.cast(tile);
        }
        return (T)candidate;
    }

    protected String getAsyncLoadIdentifier() {
        return null;
    }

    protected String getWindowIdentifier() {
        return null;
    }

    @Override
    public JobInput createAsyncLoadJobInput(ITile tile) {
        return Jobs.newInput().withRunContext((RunContext)ClientRunContexts.copyCurrent().withProperty("tileDataLoadWindowsIdentifier", tile)).withName("tileAsyncDataLoadJob", new Object[0]).withExecutionHint("tileAsyncDataLoadIdentifier" + this.getAsyncLoadIdentifier()).withExecutionHint("tileDataLoadWindowsIdentifier" + this.getWindowIdentifier());
    }

    @Override
    public void ensureTileDataLoaded() {
        ((TileDataLoadManager)BEANS.get(TileDataLoadManager.class)).cancel(this.getAsyncLoadIdentifier(), this.getWindowIdentifier());
        for (ITile tile : this.getTilesInternal()) {
            tile.ensureDataLoaded();
        }
    }

    @Override
    public void loadTileData() {
        ((TileDataLoadManager)BEANS.get(TileDataLoadManager.class)).cancel(this.getAsyncLoadIdentifier(), this.getWindowIdentifier());
        this.getTilesInternal().forEach(ITile::loadData);
    }

    @Override
    public List<ITileFilter<T>> getFilters() {
        return CollectionUtility.arrayList(this.m_filters);
    }

    @Override
    public void addFilter(ITileFilter<T> filter, boolean applyFilters) {
        if (filter == null || this.m_filters.contains(filter)) {
            return;
        }
        this.m_filters.add(filter);
        if (applyFilters) {
            this.filter();
        }
    }

    @Override
    public void addFilter(ITileFilter<T> filter) {
        this.addFilter(filter, true);
    }

    @Override
    public void removeFilter(ITileFilter<T> filter, boolean applyFilters) {
        if (filter != null && this.m_filters.remove(filter) && applyFilters) {
            this.filter();
        }
    }

    @Override
    public void removeFilter(ITileFilter<T> filter) {
        this.removeFilter(filter, true);
    }

    @Override
    public void filter() {
        this.applyFilters(true);
    }

    protected boolean applyFilters() {
        return this.applyFilters(this.getTilesInternal(), false);
    }

    protected boolean applyFilters(boolean fullReset) {
        return this.applyFilters(this.getTilesInternal(), fullReset);
    }

    protected boolean applyFilters(List<T> tiles) {
        return this.applyFilters(tiles, false);
    }

    protected boolean applyFilters(List<T> tiles, boolean fullReset) {
        if (this.m_filters.size() == 0 && !fullReset) {
            this.setFilteredTiles(this.getTilesInternal());
            this.m_filteredTilesDirty = false;
            return false;
        }
        boolean filterChanged = false;
        ArrayList<ITile> newlyHiddenTiles = new ArrayList<ITile>();
        for (ITile tile : tiles) {
            boolean wasFilterAccepted = tile.isFilterAccepted();
            this.applyFilters(tile);
            if (tile.isFilterAccepted() != wasFilterAccepted) {
                filterChanged = true;
            }
            if (!filterChanged || tile.isFilterAccepted()) continue;
            newlyHiddenTiles.add(tile);
        }
        this.deselectTiles(newlyHiddenTiles);
        if (filterChanged || this.m_filteredTilesDirty) {
            this.setFilteredTiles(this.filterTiles(this.getTilesInternal()));
            this.m_filteredTilesDirty = false;
        }
        return filterChanged;
    }

    protected void applyFilters(T tile) {
        tile.setFilterAccepted(true);
        for (ITileFilter<T> filter : this.m_filters) {
            if (filter.accept(tile)) continue;
            tile.setFilterAccepted(false);
        }
    }

    @Override
    public List<T> getFilteredTiles() {
        return CollectionUtility.arrayList((Collection)this.propertySupport.getPropertyList("filteredTiles"));
    }

    public List<T> getFilteredTilesInternal() {
        return this.propertySupport.getPropertyList("filteredTiles");
    }

    protected void setFilteredTiles(List<T> tiles) {
        this.propertySupport.setPropertyList("filteredTiles", tiles);
    }

    @Override
    public int getFilteredTileCount() {
        return this.getFilteredTilesInternal().size();
    }

    protected List<T> filterTiles(List<T> tiles) {
        if (this.m_filters.isEmpty()) {
            return new ArrayList<T>(tiles);
        }
        return tiles.stream().filter(ITile::isFilterAccepted).collect(Collectors.toList());
    }

    protected void doTileClick(T tile, MouseButton mouseButton) {
        this.interceptTileClick(tile, mouseButton);
        this.fireTileClick((ITile)tile, mouseButton);
    }

    protected void doTileAction(T tile) {
        this.interceptTileAction(tile);
        this.fireTileAction((ITile)tile);
    }

    public final <C> C optContribution(Class<C> contribution) {
        return (C)this.m_contributionHolder.optContribution(contribution);
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <C> List<C> getContributionsByClass(Class<C> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <C> C getContribution(Class<C> contribution) {
        return (C)this.m_contributionHolder.getContribution(contribution);
    }

    public final List<ITileGridExtension<T, ? extends AbstractTileGrid>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <E extends IExtension<?>> E getExtension(Class<E> c) {
        return (E)this.m_objectExtensions.getExtension(c);
    }

    protected ITileGridExtension<T, ? extends AbstractTileGrid> createLocalExtension() {
        return new LocalTilesExtension(this);
    }

    protected final void interceptTilesSelected(List<T> tiles) {
        List<ITileGridExtension<T, AbstractTileGrid>> extensions = this.getAllExtensions();
        TileGridChains.TilesSelectedChain<T> chain = new TileGridChains.TilesSelectedChain<T>(extensions);
        chain.execTilesSelected(tiles);
    }

    protected final void interceptTileClick(T tile, MouseButton mouseButton) {
        List<ITileGridExtension<T, AbstractTileGrid>> extensions = this.getAllExtensions();
        TileGridChains.TileClickChain<T> chain = new TileGridChains.TileClickChain<T>(extensions);
        chain.execTileClick(tile, mouseButton);
    }

    protected final void interceptTileAction(T tile) {
        List<ITileGridExtension<T, AbstractTileGrid>> extensions = this.getAllExtensions();
        TileGridChains.TileActionChain<T> chain = new TileGridChains.TileActionChain<T>(extensions);
        chain.execTileAction(tile);
    }

    @Override
    public IFastListenerList<TileGridListener> tileGridListeners() {
        return this.m_listenerList;
    }

    protected void fireTileClick(ITile tile, MouseButton mouseButton) {
        TileGridEvent event = new TileGridEvent(this, 200, tile);
        event.setMouseButton(mouseButton);
        this.fireTileGridEventInternal(event);
    }

    protected void fireTileAction(ITile tile) {
        TileGridEvent event = new TileGridEvent(this, 100, tile);
        this.fireTileGridEventInternal(event);
    }

    protected void fireTileGridEventInternal(TileGridEvent e) {
        this.tileGridListeners().list().forEach(listener -> listener.tileGridChanged(e));
    }

    protected static class LocalTilesExtension<T extends ITile, TILES extends AbstractTileGrid<T>>
    extends AbstractExtension<TILES>
    implements ITileGridExtension<T, TILES> {
        public LocalTilesExtension(TILES owner) {
            super(owner);
        }

        @Override
        public void execTilesSelected(TileGridChains.TilesSelectedChain<T> chain, List<T> tiles) {
            ((AbstractTileGrid)this.getOwner()).execTilesSelected(tiles);
        }

        @Override
        public void execTileClick(TileGridChains.TileClickChain<T> chain, T tile, MouseButton mouseButton) {
            ((AbstractTileGrid)this.getOwner()).execTileClick(tile, mouseButton);
        }

        @Override
        public void execTileAction(TileGridChains.TileActionChain<T> chain, T tile) {
            ((AbstractTileGrid)this.getOwner()).execTileAction(tile);
        }
    }

    protected class P_PropertyChangeListener
    implements PropertyChangeListener {
        protected P_PropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("selectedTiles")) {
                List tiles = (List)event.getNewValue();
                try {
                    AbstractTileGrid.this.interceptTilesSelected(tiles);
                }
                catch (Exception t) {
                    ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)t);
                }
            }
        }
    }

    protected class P_TileGridUIFacade
    implements ITileGridUIFacade<T> {
        protected P_TileGridUIFacade() {
        }

        @Override
        public void setSelectedTilesFromUI(List<T> tiles) {
            AbstractTileGrid.this.selectTiles(tiles);
        }

        @Override
        public void handleTileClickFromUI(T tile, MouseButton mouseButton) {
            AbstractTileGrid.this.doTileClick(tile, mouseButton);
        }

        @Override
        public void handleTileActionFromUI(T tile) {
            AbstractTileGrid.this.doTileAction(tile);
        }
    }
}

