/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.tile;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.job.filter.future.ModelJobFutureFilter;
import org.eclipse.scout.rt.client.ui.tile.ITileLoadCancellable;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.AbstractPositiveIntegerConfigProperty;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.job.IExecutionSemaphore;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.JobState;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.job.listener.JobEventType;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.job.filter.future.SessionFutureFilter;

@ApplicationScoped
public class TileDataLoadManager {
    private static final String MANUAL_CANCELLATION_MARKER = "cancelledByTileDataLoadManager";
    private final IExecutionSemaphore m_tileExecutionSemaphore = Jobs.newExecutionSemaphore((int)((Integer)CONFIG.getPropertyValue(TileMaxConcurrentDataLoadThreadsProperty.class))).seal();

    public TileDataLoadManager() {
        Jobs.getJobManager().addListener(Jobs.newEventFilterBuilder().andMatchEventType(new JobEventType[]{JobEventType.JOB_STATE_CHANGED}).andMatchState(new JobState[]{JobState.DONE}).andMatchName(new String[]{"tileAsyncDataLoadJob"}).andMatchNotExecutionHint(MANUAL_CANCELLATION_MARKER).toFilter(), event -> {
            if (event.getData().getFuture().isCancelled()) {
                ClientRunContext runContext = (ClientRunContext)event.getData().getFuture().getJobInput().getRunContext();
                ModelJobs.schedule(() -> {
                    ITileLoadCancellable tileLoadCancellable = (ITileLoadCancellable)runContext.getProperty("tileDataLoadWindowsIdentifier");
                    tileLoadCancellable.onLoadDataCancel();
                }, ModelJobs.newInput(runContext.copy().withRunMonitor((RunMonitor)BEANS.get(RunMonitor.class))).withName("handling of cancelled tile data load jobs", new Object[0]));
            }
        });
    }

    public void schedule(IRunnable runnable, JobInput jobInput) {
        Jobs.schedule((IRunnable)runnable, (JobInput)jobInput.withExecutionSemaphore(this.m_tileExecutionSemaphore).withExpirationTime((long)((Integer)CONFIG.getPropertyValue(TileDataLoadQueueTimeoutSeconds.class)).intValue(), TimeUnit.SECONDS));
    }

    public void cancel(String excludeJobName, String windowIdentifier) {
        Set futures = Jobs.getJobManager().getFutures(Jobs.newFutureFilterBuilder().andMatchRunContext(ClientRunContext.class).andMatchNot(ModelJobFutureFilter.INSTANCE).andMatchNotState(new JobState[]{JobState.DONE}).andMatch((Predicate)new SessionFutureFilter((ISession)ISession.CURRENT.get())).andMatch((Predicate)new JobExcludeCurrentByIdentifierFilter(excludeJobName, windowIdentifier)).toFilter());
        for (IFuture future : futures) {
            future.addExecutionHint(MANUAL_CANCELLATION_MARKER);
        }
        Jobs.getJobManager().cancel(Jobs.newFutureFilterBuilder().andMatchFuture((Collection)futures).toFilter(), true);
    }

    public void runInModelJob(IRunnable r) {
        ModelJobs.schedule(r, ModelJobs.newInput(ClientRunContexts.copyCurrent().withRunMonitor((RunMonitor)BEANS.get(RunMonitor.class))).withName("setting tile data", new Object[0]));
    }

    public static class JobExcludeCurrentByIdentifierFilter
    implements Predicate<IFuture<?>> {
        private final String m_asyncLoadIdentifierName;
        private final String m_windowIdentifier;

        public JobExcludeCurrentByIdentifierFilter(String asyncLoadIdentifier, String windowIdentifier) {
            this.m_asyncLoadIdentifierName = asyncLoadIdentifier;
            this.m_windowIdentifier = windowIdentifier;
        }

        @Override
        public boolean test(IFuture<?> future) {
            JobInput jobInput = future.getJobInput();
            return jobInput != null && ObjectUtility.equals((Object)future.getJobInput().getName(), (Object)"tileAsyncDataLoadJob") && !jobInput.getExecutionHints().contains("tileAsyncDataLoadIdentifier" + this.m_asyncLoadIdentifierName) && jobInput.getExecutionHints().contains("tileDataLoadWindowsIdentifier" + this.m_windowIdentifier);
        }
    }

    public static class TileDataLoadQueueTimeoutSeconds
    extends AbstractPositiveIntegerConfigProperty {
        public String getKey() {
            return "scout.tiles.dataLoadQueueTimeoutSeconds";
        }

        public String description() {
            return "Maximum number of seconds a tile load job can execute until it is automatically cancelled. The default value is 2 minutes.";
        }

        public Integer getDefaultValue() {
            return 120;
        }
    }

    public static class TileMaxConcurrentDataLoadThreadsProperty
    extends AbstractPositiveIntegerConfigProperty {
        public String getKey() {
            return "scout.tiles.maxConcurrentDataLoadThreads";
        }

        public String description() {
            return "Maximum number of threads per server that can be created to load tiles. The default value is 25.";
        }

        public Integer getDefaultValue() {
            return 25;
        }
    }
}

