/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.AbstractHtmlField;
import org.eclipse.scout.rt.client.ui.wizard.DefaultWizardStatusHtmlProvider;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardContainerForm;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStatusHtmlProvider;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStep;
import org.eclipse.scout.rt.client.ui.wizard.WizardEvent;
import org.eclipse.scout.rt.client.ui.wizard.WizardListener;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.util.WeakEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="6936b8b8-6612-4efa-bf29-80a26f80b9da")
public abstract class AbstractWizardStatusField
extends AbstractHtmlField {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWizardStatusField.class);
    private IWizard m_wizard;
    private IWizardStatusHtmlProvider m_htmlProvider;
    private P_WizardListener m_scoutWizardListener;
    private P_WizardStepListener m_scoutWizardStepListener;
    private boolean m_dirty;
    public static final String STEP_ANCHOR_IDENTIFIER = "STEP_";

    public AbstractWizardStatusField() {
        this(true);
    }

    public AbstractWizardStatusField(boolean callInitializer) {
        super(callInitializer);
    }

    public IWizardStatusHtmlProvider getHtmlProvider() {
        return this.m_htmlProvider;
    }

    public void setHtmlProvider(IWizardStatusHtmlProvider htmlProvider) {
        this.m_htmlProvider = htmlProvider;
    }

    @Override
    protected boolean getConfiguredScrollBarEnabled() {
        return false;
    }

    @Override
    protected boolean getConfiguredLabelVisible() {
        return false;
    }

    @Override
    protected boolean getConfiguredStatusVisible() {
        return false;
    }

    @Override
    protected void execInitField() {
        IForm f = this.getForm();
        while (f != null) {
            if (f instanceof IWizardContainerForm) {
                this.setWizard(f.getWizard());
            }
            f = f.getOuterForm();
        }
    }

    public void setWizard(IWizard wizard) {
        if (this.m_wizard != null) {
            this.m_wizard.removeWizardListener(this.m_scoutWizardListener);
            this.m_wizard.removePropertyChangeListener(this.m_scoutWizardStepListener);
            this.m_scoutWizardListener = null;
            this.m_scoutWizardStepListener = null;
            this.m_wizard = null;
        }
        if (wizard != null) {
            this.m_wizard = wizard;
            this.m_scoutWizardListener = new P_WizardListener();
            this.m_wizard.addWizardListener(this.m_scoutWizardListener);
            this.m_wizard.addPropertyChangeListener(this.m_scoutWizardListener);
            this.m_scoutWizardStepListener = new P_WizardStepListener();
            for (IWizardStep<? extends IForm> step : this.m_wizard.getSteps()) {
                step.removePropertyChangeListener(this.m_scoutWizardStepListener);
                step.addPropertyChangeListener(this.m_scoutWizardStepListener);
            }
        }
        this.markDirty();
    }

    public IWizard getWizard() {
        return this.m_wizard;
    }

    @Override
    protected void execDisposeField() {
        this.m_dirty = false;
    }

    private void markDirty() {
        this.m_dirty = true;
        ModelJobs.schedule(() -> {
            if (this.m_dirty) {
                try {
                    this.refreshStatus();
                }
                catch (RuntimeException | PlatformError e) {
                    LOG.warn("Could not refresh status", e);
                }
            }
        }, ModelJobs.newInput(ClientRunContexts.copyCurrent()));
    }

    public void refreshStatus() {
        this.m_dirty = false;
        if (this.m_htmlProvider == null) {
            this.m_htmlProvider = new DefaultWizardStatusHtmlProvider();
            this.m_htmlProvider.initialize(this);
        }
        this.setValue(this.m_htmlProvider.createHtml(this.m_wizard));
        int index = 1;
        for (IWizardStep<? extends IForm> step : this.m_wizard.getSteps()) {
            if (step == this.m_wizard.getActiveStep()) {
                this.setScrollToAnchor(STEP_ANCHOR_IDENTIFIER + index);
                break;
            }
            ++index;
        }
    }

    private class P_WizardListener
    implements WizardListener,
    PropertyChangeListener,
    WeakEventListener {
        private P_WizardListener() {
        }

        @Override
        public void wizardChanged(WizardEvent e) {
            switch (e.getType()) {
                case 10: {
                    for (IWizardStep<? extends IForm> step : AbstractWizardStatusField.this.m_wizard.getSteps()) {
                        step.removePropertyChangeListener(AbstractWizardStatusField.this.m_scoutWizardStepListener);
                        step.addPropertyChangeListener(AbstractWizardStatusField.this.m_scoutWizardStepListener);
                    }
                    AbstractWizardStatusField.this.markDirty();
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("title".equals(e.getPropertyName()) || "subTitle".equals(e.getPropertyName())) {
                AbstractWizardStatusField.this.markDirty();
            }
        }
    }

    private class P_WizardStepListener
    implements PropertyChangeListener,
    WeakEventListener {
        private P_WizardStepListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("descriptionHtml".equals(e.getPropertyName()) || "title".equals(e.getPropertyName()) || "titleHtml".equals(e.getPropertyName()) || "tooltipText".equals(e.getPropertyName()) || "enabled".equals(e.getPropertyName())) {
                AbstractWizardStatusField.this.markDirty();
            }
        }
    }
}

