/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.wizard;

import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.rt.client.ResourceBase;
import org.eclipse.scout.rt.client.services.common.icon.IconLocator;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.wizard.AbstractWizardStatusField;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStatusHtmlProvider;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStep;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.html.HTML;
import org.eclipse.scout.rt.platform.html.IHtmlTableCell;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWizardStatusHtmlProvider
implements IWizardStatusHtmlProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultWizardStatusHtmlProvider.class);
    private String m_htmlTemplate;

    @Override
    public void initialize(AbstractWizardStatusField htmlField) {
        this.m_htmlTemplate = this.initHtmlTemplate();
        List<BinaryResource> attachments = this.collectAttachments();
        if (attachments != null && !attachments.isEmpty()) {
            htmlField.setAttachments(attachments);
        }
    }

    @Override
    public String initHtmlTemplate() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = ResourceBase.class.getResource("html/defaultWizardStatus.html").openStream();){
                return IOUtility.readString((InputStream)in, (String)"iso-8859-1");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception t) {
            throw new ProcessingException("Unexpected", new Object[]{t});
        }
    }

    protected String getHtmlTemplate() {
        return this.m_htmlTemplate;
    }

    @Override
    public String createHtml(IWizard w) {
        String html = this.m_htmlTemplate;
        String topPart = "";
        String bottomPart = "";
        StringBuilder listPart = new StringBuilder();
        if (w != null) {
            if (w.getSubTitle() != null) {
                topPart = HTML.div((CharSequence[])new CharSequence[]{w.getSubTitle()}).cssClass((CharSequence)"infoBox").toHtml();
            }
            if (w.getActiveStep() != null && (w.getActiveStep().getTooltipText() != null || w.getActiveStep().getSubTitle() != null)) {
                bottomPart = HTML.div((CharSequence[])new CharSequence[]{(CharSequence)ObjectUtility.nvl((Object)w.getActiveStep().getSubTitle(), (Object)w.getActiveStep().getTooltipText())}).cssClass((CharSequence)"infoBox").toHtml();
            }
            int index = 1;
            Iterator<IWizardStep<? extends IForm>> iterator = w.getSteps().iterator();
            while (iterator.hasNext()) {
                IWizardStep<? extends IForm> step;
                String s = this.createHtmlForStep(step, index, (step = iterator.next()) == w.getActiveStep());
                if (!StringUtility.hasText((CharSequence)s)) continue;
                listPart.append(s);
                ++index;
            }
        }
        html = html.replace("#FONT_SIZE_UNIT#", "px");
        html = html.replace("#TOP#", topPart);
        html = html.replace("#LIST#", listPart.toString());
        html = html.replace("#BOTTOM#", bottomPart);
        return html;
    }

    protected String createHtmlForStep(IWizardStep<?> step, int index, boolean selected) {
        String cssClass = selected ? "selected" : (step.isEnabled() ? "default" : "disabled");
        StringBuilder buf = new StringBuilder();
        String spacerCssClass = "selected".equals(cssClass) ? "spacerselected" : "spacer";
        this.appendHtmlForSpacerLine(buf, spacerCssClass, 7, "STEP_" + index);
        buf.append((CharSequence)HTML.tr((IHtmlTableCell[])new IHtmlTableCell[]{HTML.td((CharSequence[])new CharSequence[]{HTML.imgByBinaryResource((CharSequence)"empty.png").addAttribute("width", (CharSequence)"1").addAttribute("height", (CharSequence)"30")}).addAttribute("width", (CharSequence)"15"), HTML.td((CharSequence[])new CharSequence[]{String.valueOf(index)}).addAttribute("width", (CharSequence)"24").addAttribute("valign", (CharSequence)"top").cssClass((CharSequence)"bullet").style((CharSequence)"padding:0px;padding-top:5px;"), HTML.td((CharSequence[])new CharSequence[0]).addAttribute("width", (CharSequence)"17"), HTML.td((CharSequence[])new CharSequence[]{step.getTitle()}).style((CharSequence)"padding-top:2px;"), HTML.td((CharSequence[])new CharSequence[0]).addAttribute("width", (CharSequence)"15")}).cssClass((CharSequence)cssClass));
        this.appendHtmlForSpacerLine(buf, spacerCssClass, 11, null);
        this.appendHtmlForSpacerLine(buf, "line", 1, null);
        return buf.toString();
    }

    protected void appendHtmlForSpacerLine(StringBuilder buf, String cssClass, int height, String anchor) {
        buf.append((CharSequence)HTML.tr((IHtmlTableCell[])new IHtmlTableCell[]{HTML.td((CharSequence[])new CharSequence[]{StringUtility.isNullOrEmpty((CharSequence)anchor) ? null : buf.append("<a name=\"").append(anchor).append("\"/>"), HTML.imgByBinaryResource((CharSequence)"empty.png").addAttribute("width", (CharSequence)"1").addAttribute("height", (CharSequence)String.valueOf(height))}).addAttribute("colspan", (CharSequence)"5")}).cssClass((CharSequence)cssClass));
    }

    protected List<BinaryResource> collectAttachments() {
        LinkedList<BinaryResource> attachments = new LinkedList<BinaryResource>();
        return attachments;
    }

    protected void loadIcon(List<BinaryResource> attachments, String iconName) {
        if (attachments == null || iconName == null) {
            return;
        }
        String tempIconName = iconName;
        try {
            IconSpec iconSpec;
            int index = tempIconName.lastIndexOf(46);
            if (index > 0) {
                tempIconName = tempIconName.substring(0, index);
            }
            String baseIconName = tempIconName;
            index = tempIconName.lastIndexOf(95);
            if (index > 0) {
                baseIconName = tempIconName.substring(0, index);
            }
            if ((iconSpec = IconLocator.instance().getIconSpec(tempIconName)) == null && !tempIconName.equals(baseIconName)) {
                iconSpec = IconLocator.instance().getIconSpec(baseIconName);
            }
            if (iconSpec != null) {
                attachments.add(new BinaryResource(iconSpec.getName(), iconSpec.getContent()));
            }
        }
        catch (Exception t) {
            LOG.warn("Failed to load icon '{}'", (Object)tempIconName, (Object)t);
        }
    }
}

