/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.scout.rt.dataobject.AbstractDataObjectVisitor;
import org.eclipse.scout.rt.dataobject.DoCollection;
import org.eclipse.scout.rt.dataobject.DoSet;
import org.eclipse.scout.rt.dataobject.DoValue;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDataObjectMapper;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.IDoEntityContribution;
import org.eclipse.scout.rt.dataobject.IValueFormatConstants;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;

@ApplicationScoped
public class DataObjectHelper {
    protected IDataObjectMapper getDataObjectMapper() {
        return (IDataObjectMapper)BEANS.get(IDataObjectMapper.class);
    }

    public Integer getIntegerAttribute(IDoEntity entity, String attributeName) {
        return (Integer)TypeCastUtility.castValue((Object)entity.get(attributeName), Integer.class);
    }

    public Double getDoubleAttribute(IDoEntity entity, String attributeName) {
        return (Double)TypeCastUtility.castValue((Object)entity.get(attributeName), Double.class);
    }

    public BigInteger getBigIntegerAttribute(IDoEntity entity, String attributeName) {
        return (BigInteger)TypeCastUtility.castValue((Object)entity.get(attributeName), BigInteger.class);
    }

    public Date getDateAttribute(IDoEntity entity, String attributeName) {
        Object value = entity.get(attributeName);
        if (value instanceof String) {
            return IValueFormatConstants.parseDefaultDate.apply(value);
        }
        return (Date)TypeCastUtility.castValue((Object)value, Date.class);
    }

    public UUID getUuidAttribute(IDoEntity entity, String attributeName) {
        Object value = entity.get(attributeName);
        if (value == null) {
            return null;
        }
        if (value instanceof UUID) {
            return (UUID)value;
        }
        if (value instanceof String) {
            return UUID.fromString((String)value);
        }
        throw new IllegalArgumentException("Cannot convert value '" + value + "' to UUID");
    }

    public Locale getLocaleAttribute(IDoEntity entity, String attributeName) {
        Object value = entity.get(attributeName);
        if (value == null) {
            return null;
        }
        if (value instanceof Locale) {
            return (Locale)value;
        }
        if (value instanceof String) {
            return Locale.forLanguageTag((String)value);
        }
        throw new IllegalArgumentException("Cannot convert value '" + value + "' to Locale");
    }

    public IDoEntity getEntityAttribute(IDoEntity entity, String propertyName) {
        return entity.get(propertyName, IDoEntity.class);
    }

    public <T extends IDoEntity> T clone(T value) {
        if (value == null) {
            return null;
        }
        Class<?> valueType = value.getClass();
        IDataObjectMapper mapper = this.getDataObjectMapper();
        String clone = mapper.writeValue(value);
        return (T)((IDoEntity)mapper.readValue(clone, valueType));
    }

    public IDoEntity cloneRaw(IDoEntity value) {
        if (value == null) {
            return null;
        }
        IDataObjectMapper mapper = this.getDataObjectMapper();
        String clone = mapper.writeValue(value);
        return (IDoEntity)mapper.readValueRaw(clone);
    }

    public String toString(IDoEntity entity) {
        if (entity == null) {
            return Objects.toString(entity);
        }
        return this.getDataObjectMapper().writeValue(entity);
    }

    public byte[] toBytes(IDoEntity entity) {
        if (entity == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getDataObjectMapper().writeValue(out, entity);
        return out.toByteArray();
    }

    public <T> T assertValue(DoValue<T> doValue) {
        Assertions.assertNotNull(doValue);
        Assertions.assertTrue((boolean)doValue.exists(), (String)"Missing mandatory attribute '{}'", (Object[])new Object[]{doValue.getAttributeName()});
        return (T)Assertions.assertNotNull(doValue.get(), (String)"Value of property '{}' must not be null", (Object[])new Object[]{doValue.getAttributeName()});
    }

    public String assertValueHasText(DoValue<String> doValue) {
        String value = this.assertValue(doValue);
        Assertions.assertTrue((boolean)StringUtility.hasText((CharSequence)value), (String)"Value of property '{}' must have text", (Object[])new Object[]{doValue.getAttributeName()});
        return value;
    }

    public void normalize(IDataObject dataObject) {
        new P_NormalizationDataObjectVisitor().normalize(dataObject);
    }

    protected static class P_NormalizationDataObjectVisitor
    extends AbstractDataObjectVisitor {
        protected P_NormalizationDataObjectVisitor() {
        }

        public void normalize(IDataObject dataObject) {
            this.visit(dataObject);
        }

        @Override
        protected void caseDoSet(DoSet<?> doSet) {
            super.caseDoSet(doSet);
            if (doSet.exists()) {
                this.normalizeInternal((Collection)doSet.get());
            }
        }

        @Override
        protected void caseDoCollection(DoCollection<?> doCollection) {
            super.caseDoCollection(doCollection);
            if (doCollection.exists()) {
                this.normalizeInternal((Collection)doCollection.get());
            }
        }

        @Override
        protected void caseDoEntityContributions(Collection<IDoEntityContribution> contributions) {
            super.caseDoEntityContributions(contributions);
            this.normalizeInternal(contributions);
        }

        protected <V> void normalizeInternal(Collection<V> collection) {
            if (collection.isEmpty()) {
                return;
            }
            ArrayList<V> list = new ArrayList<V>(collection);
            boolean comparable = list.stream().allMatch(item -> item instanceof Comparable);
            if (comparable) {
                list.sort(null);
            } else {
                IDataObjectMapper mapper = (IDataObjectMapper)BEANS.get(IDataObjectMapper.class);
                IdentityHashMap jsons = new IdentityHashMap();
                list.sort((o1, o2) -> {
                    String o1Json = jsons.computeIfAbsent(o1, mapper::writeValue);
                    String o2Json = jsons.computeIfAbsent(o2, mapper::writeValue);
                    return ObjectUtility.compareTo((Comparable)((Object)o1Json), (Comparable)((Object)o2Json));
                });
            }
            collection.clear();
            collection.addAll(list);
        }
    }
}

