/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDataObjectMapper;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.holders.IHolder;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;

public class DataObjectHolder<T extends IDataObject>
implements IHolder<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient T m_value;
    private final Class<T> m_clazz;

    public DataObjectHolder() {
        this(null);
    }

    public DataObjectHolder(Class<T> clazz) {
        this(clazz, null);
    }

    public DataObjectHolder(Class<T> clazz, T value) {
        this.m_clazz = clazz;
        this.m_value = value;
    }

    public T getValue() {
        return this.m_value;
    }

    public void setValue(T value) {
        this.m_value = value;
    }

    public Class<T> getHolderType() {
        Class clazz = this.m_clazz;
        if (clazz == null) {
            clazz = TypeCastUtility.getGenericsParameterClass(this.getClass(), DataObjectHolder.class);
        }
        return clazz;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        String text = (String)stream.readObject();
        IDataObject value = ((IDataObjectMapper)BEANS.get(IDataObjectMapper.class)).readValue(text, IDataObject.class);
        this.setValue((T)value);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        String text = ((IDataObjectMapper)BEANS.get(IDataObjectMapper.class)).writeValue(this.getValue());
        stream.writeObject(text);
    }
}

