/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.scout.rt.dataobject.AbstractDoCollection;
import org.eclipse.scout.rt.dataobject.DoNode;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public final class DoCollection<V>
extends AbstractDoCollection<V, Collection<V>> {
    public DoCollection() {
        this(null, null);
    }

    DoCollection(String attributeName, Consumer<DoNode<Collection<V>>> lazyCreate) {
        super(attributeName, lazyCreate, new ArrayList());
    }

    public static <V> DoCollection<V> of(Collection<V> collection) {
        DoCollection<V> doCollection = new DoCollection<V>();
        doCollection.set(collection);
        return doCollection;
    }

    @Override
    public void set(Collection<V> newValue) {
        super.set(newValue != null ? newValue : new ArrayList());
    }

    @Override
    protected int valueHashCode() {
        if (!this.exists()) {
            return 0;
        }
        return CollectionUtility.hashCodeCollection((Collection)this.get(), (boolean)false);
    }

    @Override
    protected boolean valueEquals(DoNode other) {
        if (!this.exists() && !other.exists()) {
            return true;
        }
        return CollectionUtility.equalsCollection((Collection)this.get(), (Collection)((Collection)other.get()), (boolean)false);
    }

    public String toString() {
        return "DoCollection [m_collection=" + (this.exists() ? this.get() : "[]") + " exists=" + this.exists() + "]";
    }
}

