/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.scout.rt.dataobject.DataObjectHelper;
import org.eclipse.scout.rt.dataobject.DoCollection;
import org.eclipse.scout.rt.dataobject.DoList;
import org.eclipse.scout.rt.dataobject.DoNode;
import org.eclipse.scout.rt.dataobject.DoSet;
import org.eclipse.scout.rt.dataobject.DoValue;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.IDoEntityContribution;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StreamUtility;

public class DoEntity
implements IDoEntity {
    private final Map<String, DoNode<?>> m_attributes = new LinkedHashMap();
    private List<IDoEntityContribution> m_contributions;

    @Override
    public DoNode<?> getNode(String attributeName) {
        return this.m_attributes.get(attributeName);
    }

    @Override
    public boolean has(String attributeName) {
        return this.m_attributes.containsKey(attributeName);
    }

    @Override
    public void putNode(String attributeName, DoNode<?> attribute) {
        IDoEntity.super.putNode(attributeName, attribute);
        this.m_attributes.put(attributeName, attribute);
    }

    @Override
    public void put(String attributeName, Object value) {
        this.doValue(attributeName).set(value);
    }

    @Override
    public <V> void putList(String attributeName, List<V> value) {
        DoList<V> doList = this.doList(attributeName);
        doList.set(value);
    }

    @Override
    public <V> void putSet(String attributeName, Set<V> value) {
        DoSet<V> doSet = this.doSet(attributeName);
        doSet.set(value);
    }

    @Override
    public <V> void putCollection(String attributeName, Collection<V> value) {
        DoCollection<V> doCollection = this.doCollection(attributeName);
        doCollection.set(value);
    }

    @Override
    public boolean remove(String attributeName) {
        return this.m_attributes.remove(attributeName) != null;
    }

    @Override
    public boolean removeIf(Predicate<? super DoNode<?>> filter) {
        return this.m_attributes.values().removeIf(filter);
    }

    @Override
    public Map<String, DoNode<?>> allNodes() {
        return Collections.unmodifiableMap(this.m_attributes);
    }

    @Override
    public Map<String, ?> all() {
        return this.all(Function.identity());
    }

    protected <T> Map<String, T> all(Function<Object, T> mapper) {
        return (Map)this.allNodes().entrySet().stream().collect(StreamUtility.toLinkedHashMap(Map.Entry::getKey, entry -> mapper.apply(((DoNode)entry.getValue()).get())));
    }

    protected <V> DoValue<V> doValue(String attributeName) {
        return this.doNode(attributeName, DoValue.class, () -> new DoValue(attributeName, attribute -> this.putNode(attributeName, (DoNode<?>)attribute)));
    }

    protected <V> DoList<V> doList(String attributeName) {
        return this.doNode(attributeName, DoList.class, () -> new DoList(attributeName, attribute -> this.putNode(attributeName, (DoNode<?>)attribute)));
    }

    protected <V> DoSet<V> doSet(String attributeName) {
        return this.doNode(attributeName, DoSet.class, () -> new DoSet(attributeName, attribute -> this.putNode(attributeName, (DoNode<?>)attribute)));
    }

    protected <V> DoCollection<V> doCollection(String attributeName) {
        return this.doNode(attributeName, DoCollection.class, () -> new DoCollection(attributeName, attribute -> this.putNode(attributeName, (DoNode<?>)attribute)));
    }

    protected <NODE> NODE doNode(String attributeName, Class<NODE> clazz, Supplier<NODE> nodeSupplier) {
        Assertions.assertNotNull((Object)attributeName, (String)"attribute name cannot be null", (Object[])new Object[0]);
        DoNode<?> node = this.getNode(attributeName);
        if (node != null) {
            Assertions.assertInstance(node, clazz, (String)"Existing node {} is not of type {}, cannot change the node type!", (Object[])new Object[]{node, clazz});
            return (NODE)node;
        }
        return nodeSupplier.get();
    }

    @Override
    public boolean hasContributions() {
        return !CollectionUtility.isEmpty(this.m_contributions);
    }

    @Override
    public Collection<IDoEntityContribution> getContributions() {
        if (this.m_contributions == null) {
            this.m_contributions = new ArrayList<IDoEntityContribution>();
        }
        return this.m_contributions;
    }

    protected boolean nvl(Boolean value) {
        return value != null && value != false;
    }

    public boolean equals(Object o) {
        List<IDoEntityContribution> otherContributions;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoEntity doEntity = (DoEntity)o;
        if (!this.m_attributes.equals(doEntity.m_attributes)) {
            return false;
        }
        List<IDoEntityContribution> contributions = this.hasContributions() ? this.m_contributions : null;
        List<IDoEntityContribution> list = otherContributions = doEntity.hasContributions() ? doEntity.m_contributions : null;
        return CollectionUtility.equalsCollection(contributions, otherContributions, (boolean)false);
    }

    public int hashCode() {
        int result = this.m_attributes.hashCode();
        List<IDoEntityContribution> contributions = this.hasContributions() ? this.m_contributions : null;
        result = 31 * result + CollectionUtility.hashCodeCollection(contributions);
        return result;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + ((DataObjectHelper)BEANS.get(DataObjectHelper.class)).toString(this);
    }
}

