/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.scout.rt.dataobject.DoValue;
import org.eclipse.scout.rt.dataobject.IDoCollection;
import org.eclipse.scout.rt.platform.util.Assertions;

public final class DoPredicates {
    private DoPredicates() {
    }

    public static <VALUE, DO_NODE> Predicate<DO_NODE> eq(Function<DO_NODE, DoValue<VALUE>> accessor, VALUE value) {
        Assertions.assertNotNull(accessor, (String)"accessor must not be null", (Object[])new Object[0]);
        return n -> Objects.equals(((DoValue)accessor.apply(n)).get(), value);
    }

    public static <VALUE, DO_NODE> Predicate<DO_NODE> ne(Function<DO_NODE, DoValue<VALUE>> accessor, VALUE value) {
        return DoPredicates.eq(accessor, value).negate();
    }

    public static <VALUE, DO_NODE> Predicate<DO_NODE> in(Function<DO_NODE, DoValue<VALUE>> accessor, Collection<VALUE> values) {
        Assertions.assertNotNull(accessor, (String)"accessor must not be null", (Object[])new Object[0]);
        Assertions.assertNotNull(values, (String)"values must not be null", (Object[])new Object[0]);
        return n -> values.contains(((DoValue)accessor.apply(n)).get());
    }

    public static <VALUE, DO_NODE> Predicate<DO_NODE> notIn(Function<DO_NODE, DoValue<VALUE>> accessor, Collection<VALUE> values) {
        return DoPredicates.in(accessor, values).negate();
    }

    public static <DO_NODE, COLLECTION_ITEM> Predicate<DO_NODE> exists(Function<DO_NODE, IDoCollection<COLLECTION_ITEM, ?>> collectionAccessor, Predicate<COLLECTION_ITEM> predicate) {
        Assertions.assertNotNull(collectionAccessor, (String)"collection accessor must not be null", (Object[])new Object[0]);
        Assertions.assertNotNull(predicate, (String)"predicate must not be null", (Object[])new Object[0]);
        return n -> ((IDoCollection)collectionAccessor.apply(n)).findFirst(predicate) != null;
    }

    public static <DO_NODE, COLLECTION_ITEM> Predicate<DO_NODE> notExists(Function<DO_NODE, IDoCollection<COLLECTION_ITEM, ?>> collectionAccessor, Predicate<COLLECTION_ITEM> predicate) {
        return DoPredicates.exists(collectionAccessor, predicate).negate();
    }

    public static <DO_NODE, COLLECTION_ITEM> Predicate<DO_NODE> empty(Function<DO_NODE, IDoCollection<COLLECTION_ITEM, ?>> collectionAccessor) {
        Assertions.assertNotNull(collectionAccessor, (String)"collection accessor must not be null", (Object[])new Object[0]);
        return n -> ((Collection)((IDoCollection)collectionAccessor.apply(n)).get()).isEmpty();
    }

    public static <DO_NODE, COLLECTION_ITEM> Predicate<DO_NODE> notEmpty(Function<DO_NODE, IDoCollection<COLLECTION_ITEM, ?>> collectionAccessor) {
        return DoPredicates.empty(collectionAccessor).negate();
    }
}

