/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.migration;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationPassThroughLogger;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationStatsContextData;
import org.eclipse.scout.rt.dataobject.migration.IDoStructureMigrationGlobalContextData;
import org.eclipse.scout.rt.dataobject.migration.IDoStructureMigrationLocalContextData;
import org.eclipse.scout.rt.dataobject.migration.IDoStructureMigrationLogger;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.Assertions;

@Bean
public class DoStructureMigrationContext {
    protected final ConcurrentHashMap<Class<? extends IDoStructureMigrationGlobalContextData>, IDoStructureMigrationGlobalContextData> m_globalContextDataMap;
    protected final Map<Class<? extends IDoStructureMigrationLocalContextData>, Deque<IDoStructureMigrationLocalContextData>> m_localContextDataMap;

    public DoStructureMigrationContext() {
        this.m_globalContextDataMap = new ConcurrentHashMap();
        this.m_localContextDataMap = new HashMap<Class<? extends IDoStructureMigrationLocalContextData>, Deque<IDoStructureMigrationLocalContextData>>();
        this.initDefaults();
    }

    protected DoStructureMigrationContext(DoStructureMigrationContext other) {
        this.m_globalContextDataMap = other.m_globalContextDataMap;
        this.m_localContextDataMap = new HashMap<Class<? extends IDoStructureMigrationLocalContextData>, Deque<IDoStructureMigrationLocalContextData>>();
    }

    protected void initDefaults() {
        this.putGlobal((IDoStructureMigrationGlobalContextData)BEANS.get(DoStructureMigrationPassThroughLogger.class));
    }

    protected DoStructureMigrationContext copy() {
        return new DoStructureMigrationContext(this);
    }

    protected DoStructureMigrationContext initializedCopy(IDoStructureMigrationLocalContextData ... initialLocalContextDatas) {
        DoStructureMigrationContext copy = this.copy();
        if (initialLocalContextDatas != null) {
            Arrays.stream(initialLocalContextDatas).filter(Objects::nonNull).forEach(copy::push);
        }
        return copy;
    }

    public <T extends IDoStructureMigrationGlobalContextData> T getGlobal(Class<T> contextDataClass) {
        Assertions.assertNotNull(contextDataClass, (String)"contextDataClass is required", (Object[])new Object[0]);
        IDoStructureMigrationGlobalContextData contextData = this.m_globalContextDataMap.computeIfAbsent(contextDataClass, k -> {
            if (contextDataClass.getAnnotation(Bean.class) != null) {
                return (IDoStructureMigrationGlobalContextData)BEANS.get((Class)contextDataClass);
            }
            return null;
        });
        return (T)((IDoStructureMigrationGlobalContextData)contextDataClass.cast(contextData));
    }

    public DoStructureMigrationContext putGlobal(IDoStructureMigrationGlobalContextData contextData) {
        Assertions.assertNotNull((Object)contextData, (String)"contextData is required", (Object[])new Object[0]);
        this.m_globalContextDataMap.put(contextData.getIdentifierClass(), contextData);
        return this;
    }

    public <T extends IDoStructureMigrationLocalContextData> T get(Class<T> contextDataClass) {
        Assertions.assertNotNull(contextDataClass, (String)"contextDataClass is required", (Object[])new Object[0]);
        Deque<IDoStructureMigrationLocalContextData> deque = this.m_localContextDataMap.get(contextDataClass);
        if (deque == null || deque.isEmpty()) {
            return null;
        }
        return (T)((IDoStructureMigrationLocalContextData)contextDataClass.cast(deque.peek()));
    }

    protected DoStructureMigrationContext push(IDoStructureMigrationLocalContextData contextData) {
        Assertions.assertNotNull((Object)contextData, (String)"contextData is required", (Object[])new Object[0]);
        Deque deque = this.m_localContextDataMap.computeIfAbsent(contextData.getIdentifierClass(), k -> new ArrayDeque());
        deque.push(contextData);
        return this;
    }

    protected void remove(IDoStructureMigrationLocalContextData contextData) {
        Assertions.assertNotNull((Object)contextData, (String)"contextData is required", (Object[])new Object[0]);
        Deque<IDoStructureMigrationLocalContextData> deque = this.m_localContextDataMap.get(contextData.getIdentifierClass());
        Assertions.assertNotNull(deque, (String)"no context data found for {}", (Object[])new Object[]{contextData.getIdentifierClass()});
        IDoStructureMigrationLocalContextData dequeElement = deque.peek();
        Assertions.assertTrue((contextData == dequeElement ? 1 : 0) != 0, (String)"last element in deque is not element to remove: remove '{}', deque: '{}'", (Object[])new Object[]{contextData, dequeElement});
        deque.pop();
        if (deque.isEmpty()) {
            this.m_localContextDataMap.remove(contextData.getIdentifierClass());
        }
    }

    public IDoStructureMigrationLogger getLogger() {
        return this.getGlobal(IDoStructureMigrationLogger.class);
    }

    public DoStructureMigrationStatsContextData getStats() {
        return this.getGlobal(DoStructureMigrationStatsContextData.class);
    }
}

